class CustomDateTimePicker extends PDFViewCtrl.viewerui.IDateTimePicker {
    constructor(pdfViewer, format) {
        super(pdfViewer, format);
        this.isOpen = false;
        this.element = document.createElement('input'); // Creates a DOM element for the date-time picker
        this.element.type = 'datetime-local';
    }

    isOpen() {
        // Returns whether the date-time picker is open
        return this.isOpen;
    }

    open(option) {
        // Opens the date-time picker and applies the given options
        this.isOpen = true;
        // Implement opening logic
        console.log('open date time picker', option);
        option.container.appendChild(this.element);
        this.element.click();
    }

    onChange(callback) {
        // Registers a callback for value changes and returns a function to unregister it
        this.onChangeCallback = callback;
        // Return function to remove the callback
        return () => {
            this.onChangeCallback = null;
        };
    }

    close() {
        // Closes the date-time picker
        this.isOpen = false;
        // Implement closing logic
        console.log('close date time picker');
    }

    destroy() {
        // Destroys the date-time picker and releases resources 
        // Destruction timing is determined by the Web SDK
        // Implement destruction logic
        console.log('destroy date time picker');
    }

    containsElement(element) {
        // Checks if an element belongs to the date-time picker 
        // This method determines if user interactions should switch form field focus
        return this.element.contains(element);
    }
}