(window.webpackJsonp=window.webpackJsonp||[]).push([[129],{466:function(t,a,s){"use strict";s.r(a);var n=s(14),e=Object(n.a)({},(function(){var t=this,a=t._self._c;return a("ContentSlotsDistributor",{attrs:{"slot-key":t.$parent.slotKey}},[a("h1",{attrs:{id:"extensible-components-and-usage-guide"}},[a("a",{staticClass:"header-anchor",attrs:{href:"#extensible-components-and-usage-guide"}},[t._v("#")]),t._v(" Extensible Components and Usage Guide")]),t._v(" "),a("p",[t._v("This document provides detailed information and usage guide for extensible components, listing the methods to extend extensible components and helping developers understand and use the custom features of components better.\nIn the following document, we will first introduce the concept of extensible components and the methods to extend them using Component API and Fragment configuration. Then, we will provide a detailed list of extensible components, so that developers can have a clear understanding of which components can be modified.")]),t._v(" "),a("h2",{attrs:{id:"prerequisites"}},[a("a",{staticClass:"header-anchor",attrs:{href:"#prerequisites"}},[t._v("#")]),t._v(" Prerequisites")]),t._v(" "),a("p",[t._v("To better understand this document, you may need to be familiar with the following concepts:")]),t._v(" "),a("ol",[a("li",[t._v("For Fragment configuration: please refer to "),a("RouterLink",{attrs:{to:"/ui-extension/basics/fragments.html"}},[t._v("UI Fragments")]),t._v(" section.")],1),t._v(" "),a("li",[t._v("For Appearance usage: please refer to "),a("RouterLink",{attrs:{to:"/ui-extension/basics/appearance.html"}},[t._v("Appearance")]),t._v(" section.")],1),t._v(" "),a("li",[t._v("For layout templates: please refer to "),a("RouterLink",{attrs:{to:"/ui-extension/basics/layout-template.html"}},[t._v("Layout Template")]),t._v(" section.")],1),t._v(" "),a("li",[t._v("For component selector syntax: please refer to "),a("RouterLink",{attrs:{to:"/ui-extension/basics/selector.html"}},[t._v("Component Selector")]),t._v(" section.")],1),t._v(" "),a("li",[t._v("For Component API: please refer to the "),a("a",{attrs:{href:location.origin + "/docs/API_Reference/FoxitPDFSDK_API_Reference.html",target:"_blank",rel:"noopener noreferrer"}},[t._v("API Reference"),a("OutboundLink")],1),t._v(".")]),t._v(" "),a("li",[t._v("For the "),a("code",[t._v("@controller")]),t._v(" directive: please refer to the "),a("RouterLink",{attrs:{to:"/ui-extension/directives/controller.html"}},[t._v("@controller")]),t._v(" directive section.")],1),t._v(" "),a("li",[t._v("For the "),a("code",[t._v("@tooltip")]),t._v(" directive: please refer to the "),a("RouterLink",{attrs:{to:"/ui-extension/directives/tooltip.html"}},[t._v("@tooltip")]),t._v(" directive section.")],1),t._v(" "),a("li",[t._v("For the "),a("code",[t._v("@on")]),t._v(" directive: please refer to the "),a("RouterLink",{attrs:{to:"/ui-extension/directives/on.html"}},[t._v("@on")]),t._v(" directive section.")],1)]),t._v(" "),a("p",[t._v("The upcoming content will utilize the knowledge mentioned above. Please familiarize yourself with them before reading this document, as they will not be repeated here.")]),t._v(" "),a("h2",{attrs:{id:"overview-of-extensible-components"}},[a("a",{staticClass:"header-anchor",attrs:{href:"#overview-of-extensible-components"}},[t._v("#")]),t._v(" Overview of Extensible Components")]),t._v(" "),a("ol",[a("li",[t._v("What are extensible components: Components that can be customized and extended in terms of functionality and appearance through Fragment configuration or Component API.")]),t._v(" "),a("li",[t._v("What are non-extensible components: The opposite of extensible components, which cannot be modified. These components are deeply encapsulated within the SDK, so they cannot be broken down and combined at a granular level. However, some of them can be replaced as a whole (e.g., Annotation Property Dialog). More specific details will be provided in subsequent sections.")]),t._v(" "),a("li",[t._v("Note: Some components do not have unique name identifiers, so they cannot be directly targeted by name. In such cases, "),a("RouterLink",{attrs:{to:"/ui-extension/basics/selector.html"}},[t._v("component selector syntax")]),t._v(" can be used.")],1)]),t._v(" "),a("h2",{attrs:{id:"extensible-components"}},[a("a",{staticClass:"header-anchor",attrs:{href:"#extensible-components"}},[t._v("#")]),t._v(" Extensible Components")]),t._v(" "),a("h3",{attrs:{id:"header-area"}},[a("a",{staticClass:"header-anchor",attrs:{href:"#header-area"}},[t._v("#")]),t._v(" Header Area")]),t._v(" "),a("h4",{attrs:{id:"tab-component"}},[a("a",{staticClass:"header-anchor",attrs:{href:"#tab-component"}},[t._v("#")]),t._v(" Tab Component")]),t._v(" "),a("p",[t._v("The tab component is wrapped in a div container named "),a("code",[t._v("toolbar-tabs")]),t._v(", while the tab panel is wrapped in a div container named "),a("code",[t._v("toolbar-tab-bodies")]),t._v(". If you want to add or remove tabs, you need to modify both of these containers. Here is an example (click the "),a("code",[t._v("run")]),t._v(" button to see the effect):")]),t._v(" "),a("ol",[a("li",[a("p",[t._v("Add a tab at the end")]),t._v(" "),a("p",[t._v("In this example, we inserted a new tab called "),a("code",[t._v("custom-tab")]),t._v(" at the end of the tab bar, and also inserted a div component called "),a("code",[t._v("fv--custom-tab-body")]),t._v(".")]),t._v(" "),a("div",{staticClass:"vuepress-plugin-demo-block__wrapper",staticStyle:{display:"none"},attrs:{"data-config":"%7B%0A%20%20%20%20%22iframeOptions%22%3A%20%7B%0A%20%20%20%20%20%20%20%20%22style%22%3A%20%22height%3A%20300px%3B%22%0A%20%20%20%20%7D%0A%7D%0A","data-type":"vanilla","data-code":"%3Chtml%3E%0A%3C%2Fhtml%3E%0A%3Cscript%3E%0A%20%20%20%20var%20FRAGMENT_ACTION%20%3D%20UIExtension.UIConsts.FRAGMENT_ACTION%0A%20%20%20%20var%20CustomAppearance%20%3D%20UIExtension.appearances.adaptive.extend(%7B%0A%20%20%20%20%20%20%20%20getDefaultFragments%3A%20function()%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20return%20%5B%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20target%3A%20'toolbar-tabs'%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20action%3A%20FRAGMENT_ACTION.APPEND%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20template%3A%20'%3Cgtab%20name%3D%22custom-tab%22%20group%3D%22toolbar-tab%22%20body%3D%22fv--custom-tab-body%22%20text%3D%22Custom%20Tab%22%20%40aria%3Atoolbar.tab%3E%3C%2Fgtab%3E'%0A%20%20%20%20%20%20%20%20%20%20%20%20%7D%2C%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20target%3A%20'toolbar-tab-bodies'%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20action%3A%20FRAGMENT_ACTION.APPEND%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20template%3A%20'%3Cdiv%20name%3D%22fv--custom-tab-body%22%20style%3D%22padding%3A2em%201em%3B%22%3ECustom%20Tab%20Body%3C%2Fdiv%3E'%20%2F%2F%20The%20custom%20tab%20panel%20does%20not%20restrict%20the%20component%20type%2C%20but%20make%20sure%20that%20the%20name%20should%20be%20the%20same%20as%20the%20body%20property%20value%20specified%20in%20%60gtab%60.%0A%20%20%20%20%20%20%20%20%20%20%20%20%7D%5D%3B%0A%20%20%20%20%20%20%20%20%7D%0A%20%20%20%20%7D)%3B%0A%20%20%20%20var%20libPath%20%3D%20window.top.location.origin%20%2B%20'%2Flib'%3B%0A%20%20%20%20var%20pdfui%20%3D%20new%20UIExtension.PDFUI(%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20viewerOptions%3A%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20libPath%3A%20libPath%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20jr%3A%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20licenseSN%3A%20licenseSN%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20licenseKey%3A%20licenseKey%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%7D%0A%20%20%20%20%20%20%20%20%20%20%20%20%7D%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20renderTo%3A%20document.body%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20appearance%3A%20CustomAppearance%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20addons%3A%20%5B%5D%20%2F%2F%20No%20addon%20is%20loaded%0A%20%20%20%20%7D)%3B%0A%3C%2Fscript%3E%0A"}},[a("div",{staticClass:"vuepress-plugin-demo-block__display"},[a("div",{staticClass:"vuepress-plugin-demo-block__app"})]),t._v(" "),a("div",{staticClass:"vuepress-plugin-demo-block__code"},[a("div",{staticClass:"language-html extra-class"},[a("pre",{pre:!0,attrs:{class:"language-html"}},[a("code",[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("<")]),t._v("html")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("</")]),t._v("html")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("<")]),t._v("script")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),a("span",{pre:!0,attrs:{class:"token script"}},[a("span",{pre:!0,attrs:{class:"token language-javascript"}},[t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("FRAGMENT_ACTION")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" UIExtension"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("UIConsts"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("FRAGMENT_ACTION")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" CustomAppearance "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" UIExtension"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("appearances"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("adaptive"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("extend")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token function-variable function"}},[t._v("getDefaultFragments")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("function")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("return")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("[")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("target")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'toolbar-tabs'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("action")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("FRAGMENT_ACTION")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("APPEND")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("template")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v('\'<gtab name="custom-tab" group="toolbar-tab" body="fv--custom-tab-body" text="Custom Tab" @aria:toolbar.tab></gtab>\'')]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("target")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'toolbar-tab-bodies'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("action")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("FRAGMENT_ACTION")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("APPEND")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("template")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v('\'<div name="fv--custom-tab-body" style="padding:2em 1em;">Custom Tab Body</div>\'')]),t._v(" "),a("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// The custom tab panel does not restrict the component type, but make sure that the name should be the same as the body property value specified in `gtab`.")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("]")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" libPath "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" window"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("top"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("location"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("origin "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("+")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'/lib'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" pdfui "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("new")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token class-name"}},[t._v("UIExtension"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("PDFUI")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("viewerOptions")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("libPath")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" libPath"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("jr")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                    "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("licenseSN")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" licenseSN"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                    "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("licenseKey")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" licenseKey\n                "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("renderTo")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" document"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("body"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("appearance")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" CustomAppearance"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("addons")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("[")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("]")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// No addon is loaded")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n")])]),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("</")]),t._v("script")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n")])])]),a("div",{staticClass:"language-json extra-class"},[a("pre",{pre:!0,attrs:{class:"language-json"}},[a("code",[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v('"iframeOptions"')]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v('"style"')]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v('"height: 300px;"')]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n")])])])]),t._v(" "),a("div",{staticClass:"vuepress-plugin-demo-block__footer"})])]),t._v(" "),a("li",[a("p",[t._v("Remove a specific tab")]),t._v(" "),a("p",[t._v("In this example, we remove both the "),a("code",[t._v("edit-tab")]),t._v(" and "),a("code",[t._v("fv--edit-tab-paddle")]),t._v(" components, and then the "),a("code",[t._v("edit")]),t._v(" tab will not be visible in the view.")]),t._v(" "),a("div",{staticClass:"vuepress-plugin-demo-block__wrapper",staticStyle:{display:"none"},attrs:{"data-config":"%7B%0A%20%20%20%20%22iframeOptions%22%3A%20%7B%0A%20%20%20%20%20%20%20%20%22style%22%3A%20%22height%3A%20300px%3B%22%0A%20%20%20%20%7D%0A%7D%0A","data-type":"vanilla","data-code":"%3Chtml%3E%0A%3C%2Fhtml%3E%0A%3Cscript%3E%0A%20%20%20%20var%20FRAGMENT_ACTION%20%3D%20UIExtension.UIConsts.FRAGMENT_ACTION%0A%20%20%20%20var%20CustomAppearance%20%3D%20UIExtension.appearances.adaptive.extend(%7B%0A%20%20%20%20%20%20%20%20getDefaultFragments%3A%20function()%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20return%20%5B%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20target%3A%20'edit-tab%2Cfv--edit-tab-paddle'%2C%20%2F%2F%20Multiple%20component%20names%20can%20be%20separated%20by%20commas%2C%20and%20these%20components%20will%20be%20removed%20together.%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20action%3A%20FRAGMENT_ACTION.REMOVE%0A%20%20%20%20%20%20%20%20%20%20%20%20%7D%5D%3B%0A%20%20%20%20%20%20%20%20%7D%0A%20%20%20%20%7D)%3B%0A%20%20%20%20var%20libPath%20%3D%20window.top.location.origin%20%2B%20'%2Flib'%3B%0A%20%20%20%20var%20pdfui%20%3D%20new%20UIExtension.PDFUI(%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20viewerOptions%3A%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20libPath%3A%20libPath%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20jr%3A%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20licenseSN%3A%20licenseSN%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20licenseKey%3A%20licenseKey%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%7D%0A%20%20%20%20%20%20%20%20%20%20%20%20%7D%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20renderTo%3A%20document.body%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20appearance%3A%20CustomAppearance%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20addons%3A%20%5B%5D%20%2F%2F%20No%20addon%20is%20loaded%0A%20%20%20%20%7D)%3B%0A%3C%2Fscript%3E%0A"}},[a("div",{staticClass:"vuepress-plugin-demo-block__display"},[a("div",{staticClass:"vuepress-plugin-demo-block__app"})]),t._v(" "),a("div",{staticClass:"vuepress-plugin-demo-block__code"},[a("div",{staticClass:"language-html extra-class"},[a("pre",{pre:!0,attrs:{class:"language-html"}},[a("code",[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("<")]),t._v("html")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("</")]),t._v("html")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("<")]),t._v("script")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),a("span",{pre:!0,attrs:{class:"token script"}},[a("span",{pre:!0,attrs:{class:"token language-javascript"}},[t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("FRAGMENT_ACTION")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" UIExtension"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("UIConsts"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("FRAGMENT_ACTION")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" CustomAppearance "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" UIExtension"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("appearances"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("adaptive"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("extend")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token function-variable function"}},[t._v("getDefaultFragments")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("function")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("return")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("[")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("target")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'edit-tab,fv--edit-tab-paddle'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Multiple component names can be separated by commas, and these components will be removed together.")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("action")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("FRAGMENT_ACTION")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("REMOVE")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("]")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" libPath "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" window"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("top"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("location"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("origin "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("+")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'/lib'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" pdfui "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("new")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token class-name"}},[t._v("UIExtension"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("PDFUI")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("viewerOptions")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("libPath")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" libPath"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("jr")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                    "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("licenseSN")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" licenseSN"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                    "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("licenseKey")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" licenseKey\n                "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("renderTo")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" document"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("body"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("appearance")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" CustomAppearance"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("addons")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("[")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("]")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// No addon is loaded")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n")])]),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("</")]),t._v("script")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n")])])]),a("div",{staticClass:"language-json extra-class"},[a("pre",{pre:!0,attrs:{class:"language-json"}},[a("code",[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v('"iframeOptions"')]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v('"style"')]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v('"height: 300px;"')]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n")])])])]),t._v(" "),a("div",{staticClass:"vuepress-plugin-demo-block__footer"})])]),t._v(" "),a("li",[a("p",[t._v("Replace a specific tab")]),t._v(" "),a("p",[t._v("In this example, the "),a("code",[t._v("edit-tab")]),t._v(" tab is replaced with a custom tab.")]),t._v(" "),a("div",{staticClass:"vuepress-plugin-demo-block__wrapper",staticStyle:{display:"none"},attrs:{"data-config":"%7B%0A%20%20%20%20%22iframeOptions%22%3A%20%7B%0A%20%20%20%20%20%20%20%20%22style%22%3A%20%22height%3A%20300px%3B%22%0A%20%20%20%20%7D%0A%7D%0A","data-type":"vanilla","data-code":"%3Chtml%3E%0A%3C%2Fhtml%3E%0A%3Cscript%3E%0A%20%20%20%20var%20FRAGMENT_ACTION%20%3D%20UIExtension.UIConsts.FRAGMENT_ACTION%0A%20%20%20%20var%20CustomAppearance%20%3D%20UIExtension.appearances.adaptive.extend(%7B%0A%20%20%20%20%20%20%20%20getDefaultFragments%3A%20function()%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20return%20%5B%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20target%3A%20'edit-tab'%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20action%3A%20FRAGMENT_ACTION.REPLACE%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20template%3A%20'%3Cgtab%20name%3D%22custom-tab%22%20group%3D%22toolbar-tab%22%20body%3D%22fv--edit-tab-paddle%22%20text%3D%22Custom%20Tab%22%20%40aria%3Atoolbar.tab%3E%3C%2Fgtab%3E'%0A%20%20%20%20%20%20%20%20%20%20%20%20%7D%2C%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20target%3A%20'fv--edit-tab-paddle'%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20action%3A%20FRAGMENT_ACTION.REPLACE%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20template%3A%20'%3Cdiv%20style%3D%22padding%3A2em%201em%3B%22%3ECustom%20Tab%20Body%3C%2Fdiv%3E'%0A%20%20%20%20%20%20%20%20%20%20%20%20%7D%5D%3B%0A%20%20%20%20%20%20%20%20%7D%0A%20%20%20%20%7D)%3B%0A%20%20%20%20var%20libPath%20%3D%20window.top.location.origin%20%2B%20'%2Flib'%3B%0A%20%20%20%20var%20pdfui%20%3D%20new%20UIExtension.PDFUI(%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20viewerOptions%3A%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20libPath%3A%20libPath%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20jr%3A%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20licenseSN%3A%20licenseSN%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20licenseKey%3A%20licenseKey%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%7D%0A%20%20%20%20%20%20%20%20%20%20%20%20%7D%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20renderTo%3A%20document.body%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20appearance%3A%20CustomAppearance%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20addons%3A%20%5B%5D%20%2F%2F%20No%20addon%20is%20loaded%0A%20%20%20%20%7D)%3B%0A%3C%2Fscript%3E%0A"}},[a("div",{staticClass:"vuepress-plugin-demo-block__display"},[a("div",{staticClass:"vuepress-plugin-demo-block__app"})]),t._v(" "),a("div",{staticClass:"vuepress-plugin-demo-block__code"},[a("div",{staticClass:"language-html extra-class"},[a("pre",{pre:!0,attrs:{class:"language-html"}},[a("code",[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("<")]),t._v("html")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("</")]),t._v("html")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("<")]),t._v("script")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),a("span",{pre:!0,attrs:{class:"token script"}},[a("span",{pre:!0,attrs:{class:"token language-javascript"}},[t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("FRAGMENT_ACTION")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" UIExtension"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("UIConsts"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("FRAGMENT_ACTION")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" CustomAppearance "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" UIExtension"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("appearances"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("adaptive"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("extend")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token function-variable function"}},[t._v("getDefaultFragments")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("function")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("return")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("[")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("target")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'edit-tab'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("action")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("FRAGMENT_ACTION")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("REPLACE")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("template")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v('\'<gtab name="custom-tab" group="toolbar-tab" body="fv--edit-tab-paddle" text="Custom Tab" @aria:toolbar.tab></gtab>\'')]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("target")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'fv--edit-tab-paddle'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("action")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("FRAGMENT_ACTION")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("REPLACE")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("template")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'<div style=\"padding:2em 1em;\">Custom Tab Body</div>'")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("]")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" libPath "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" window"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("top"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("location"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("origin "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("+")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'/lib'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" pdfui "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("new")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token class-name"}},[t._v("UIExtension"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("PDFUI")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("viewerOptions")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("libPath")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" libPath"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("jr")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                    "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("licenseSN")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" licenseSN"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                    "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("licenseKey")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" licenseKey\n                "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("renderTo")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" document"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("body"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("appearance")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" CustomAppearance"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("addons")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("[")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("]")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// No addon is loaded")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n")])]),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("</")]),t._v("script")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n")])])]),a("div",{staticClass:"language-json extra-class"},[a("pre",{pre:!0,attrs:{class:"language-json"}},[a("code",[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v('"iframeOptions"')]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v('"style"')]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v('"height: 300px;"')]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n")])])])]),t._v(" "),a("div",{staticClass:"vuepress-plugin-demo-block__footer"})])]),t._v(" "),a("li",[a("p",[t._v("Insert a tab at a specified position")]),t._v(" "),a("p",[t._v("The following example inserts a custom tab after a specified position. Similarly, there is a "),a("code",[t._v("FRAGMENT_ACTION.BEFORE")]),t._v(" operation, which means that the component is inserted before the specified target component.")]),t._v(" "),a("div",{staticClass:"vuepress-plugin-demo-block__wrapper",staticStyle:{display:"none"},attrs:{"data-config":"%7B%0A%20%20%20%20%22iframeOptions%22%3A%20%7B%0A%20%20%20%20%20%20%20%20%22style%22%3A%20%22height%3A%20300px%3B%22%0A%20%20%20%20%7D%0A%7D%0A","data-type":"vanilla","data-code":"%3Chtml%3E%0A%3C%2Fhtml%3E%0A%3Cscript%3E%0A%20%20%20%20var%20FRAGMENT_ACTION%20%3D%20UIExtension.UIConsts.FRAGMENT_ACTION%0A%20%20%20%20var%20CustomAppearance%20%3D%20UIExtension.appearances.adaptive.extend(%7B%0A%20%20%20%20%20%20%20%20getDefaultFragments%3A%20function()%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20return%20%5B%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20target%3A%20'edit-tab'%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20action%3A%20FRAGMENT_ACTION.AFTER%2C%20%2F%2F%20Insert%20the%20custom%20tab%20after%20fv--edit-tab.%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20template%3A%20'%3Cgtab%20name%3D%22custom-tab%22%20group%3D%22toolbar-tab%22%20body%3D%22fv--custom-tab-body%22%20text%3D%22Custom%20Tab%22%20%40aria%3Atoolbar.tab%3E%3C%2Fgtab%3E'%0A%20%20%20%20%20%20%20%20%20%20%20%20%7D%2C%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20target%3A%20'fv--edit-tab-paddle'%2C%20%2F%2F%20Note%20that%20the%20order%20is%20not%20important%20here%20because%20only%20one%20tab%20panel%20is%20displayed%20at%20a%20time%2C%20this%20operation%20is%20just%20for%20demonstration%20purposes.%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20action%3A%20FRAGMENT_ACTION.AFTER%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20template%3A%20'%3Cdiv%20name%3D%22fv--custom-tab-body%22%20style%3D%22padding%3A2em%201em%3B%22%3ECustom%20Tab%20Body%3C%2Fdiv%3E'%0A%20%20%20%20%20%20%20%20%20%20%20%20%7D%5D%3B%0A%20%20%20%20%20%20%20%20%7D%0A%20%20%20%20%7D)%3B%0A%20%20%20%20var%20libPath%20%3D%20window.top.location.origin%20%2B%20'%2Flib'%3B%0A%20%20%20%20var%20pdfui%20%3D%20new%20UIExtension.PDFUI(%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20viewerOptions%3A%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20libPath%3A%20libPath%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20jr%3A%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20licenseSN%3A%20licenseSN%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20licenseKey%3A%20licenseKey%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%7D%0A%20%20%20%20%20%20%20%20%20%20%20%20%7D%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20renderTo%3A%20document.body%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20appearance%3A%20CustomAppearance%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20addons%3A%20%5B%5D%20%2F%2F%20No%20addon%20is%20loaded%0A%20%20%20%20%7D)%3B%0A%3C%2Fscript%3E%0A"}},[a("div",{staticClass:"vuepress-plugin-demo-block__display"},[a("div",{staticClass:"vuepress-plugin-demo-block__app"})]),t._v(" "),a("div",{staticClass:"vuepress-plugin-demo-block__code"},[a("div",{staticClass:"language-html extra-class"},[a("pre",{pre:!0,attrs:{class:"language-html"}},[a("code",[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("<")]),t._v("html")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("</")]),t._v("html")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("<")]),t._v("script")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),a("span",{pre:!0,attrs:{class:"token script"}},[a("span",{pre:!0,attrs:{class:"token language-javascript"}},[t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("FRAGMENT_ACTION")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" UIExtension"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("UIConsts"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("FRAGMENT_ACTION")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" CustomAppearance "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" UIExtension"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("appearances"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("adaptive"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("extend")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token function-variable function"}},[t._v("getDefaultFragments")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("function")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("return")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("[")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("target")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'edit-tab'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("action")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("FRAGMENT_ACTION")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("AFTER")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Insert the custom tab after fv--edit-tab.")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("template")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v('\'<gtab name="custom-tab" group="toolbar-tab" body="fv--custom-tab-body" text="Custom Tab" @aria:toolbar.tab></gtab>\'')]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("target")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'fv--edit-tab-paddle'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Note that the order is not important here because only one tab panel is displayed at a time, this operation is just for demonstration purposes.")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("action")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("FRAGMENT_ACTION")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("AFTER")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("template")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v('\'<div name="fv--custom-tab-body" style="padding:2em 1em;">Custom Tab Body</div>\'')]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("]")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" libPath "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" window"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("top"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("location"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("origin "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("+")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'/lib'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" pdfui "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("new")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token class-name"}},[t._v("UIExtension"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("PDFUI")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("viewerOptions")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("libPath")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" libPath"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("jr")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                    "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("licenseSN")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" licenseSN"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                    "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("licenseKey")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" licenseKey\n                "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("renderTo")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" document"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("body"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("appearance")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" CustomAppearance"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("addons")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("[")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("]")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// No addon is loaded")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n")])]),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("</")]),t._v("script")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n")])])]),a("div",{staticClass:"language-json extra-class"},[a("pre",{pre:!0,attrs:{class:"language-json"}},[a("code",[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v('"iframeOptions"')]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v('"style"')]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v('"height: 300px;"')]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n")])])])]),t._v(" "),a("div",{staticClass:"vuepress-plugin-demo-block__footer"})])]),t._v(" "),a("li",[a("p",[t._v("Use Component API")]),t._v(" "),a("p",[t._v("The following example uses selector syntax and the "),a("code",[t._v("Component.after")]),t._v(" method to insert more tab components into the page.")]),t._v(" "),a("div",{staticClass:"vuepress-plugin-demo-block__wrapper",staticStyle:{display:"none"},attrs:{"data-config":"%7B%0A%20%20%20%20%22iframeOptions%22%3A%20%7B%0A%20%20%20%20%20%20%20%20%22style%22%3A%20%22height%3A%20300px%3B%22%0A%20%20%20%20%7D%0A%7D%0A","data-type":"vanilla","data-code":"%3Chtml%3E%0A%3C%2Fhtml%3E%0A%3Cscript%3E%0A%20%20%20%20var%20libPath%20%3D%20window.top.location.origin%20%2B%20'%2Flib'%3B%0A%20%20%20%20var%20pdfui%20%3D%20new%20UIExtension.PDFUI(%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20viewerOptions%3A%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20libPath%3A%20libPath%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20jr%3A%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20licenseSN%3A%20licenseSN%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20licenseKey%3A%20licenseKey%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%7D%0A%20%20%20%20%20%20%20%20%20%20%20%20%7D%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20renderTo%3A%20document.body%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20appearance%3A%20UIExtension.appearances.adaptive%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20addons%3A%20%5B%5D%20%2F%2F%20No%20addon%20is%20loaded%0A%20%20%20%20%7D)%3B%0A%20%20%20%20pdfui.getRootComponent().then(function(root)%7B%0A%20%20%20%20%20%20%20%20var%20editTab%20%3D%20root.querySelector('edit-tab')%0A%20%20%20%20%20%20%20%20var%20editTabBody%20%3D%20root.querySelector('fv--edit-tab-paddle')%3B%0A%20%20%20%20%20%20%20%20editTab.after('%3Cgtab%20name%3D%22custom-tab%22%20group%3D%22toolbar-tab%22%20body%3D%22fv--custom-tab-body%22%20text%3D%22Custom%20Tab%22%20%40aria%3Atoolbar.tab%3E%3C%2Fgtab%3E')%3B%0A%20%20%20%20%20%20%20%20editTabBody.after('%3Cdiv%20name%3D%22fv--custom-tab-body%22%20style%3D%22padding%3A2em%201em%3B%22%3ECustom%20Tab%20Body%3C%2Fdiv%3E')%0A%20%20%20%20%7D)%3B%0A%3C%2Fscript%3E%0A"}},[a("div",{staticClass:"vuepress-plugin-demo-block__display"},[a("div",{staticClass:"vuepress-plugin-demo-block__app"})]),t._v(" "),a("div",{staticClass:"vuepress-plugin-demo-block__code"},[a("div",{staticClass:"language-html extra-class"},[a("pre",{pre:!0,attrs:{class:"language-html"}},[a("code",[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("<")]),t._v("html")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("</")]),t._v("html")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("<")]),t._v("script")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),a("span",{pre:!0,attrs:{class:"token script"}},[a("span",{pre:!0,attrs:{class:"token language-javascript"}},[t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" libPath "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" window"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("top"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("location"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("origin "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("+")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'/lib'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" pdfui "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("new")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token class-name"}},[t._v("UIExtension"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("PDFUI")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("viewerOptions")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("libPath")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" libPath"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("jr")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                    "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("licenseSN")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" licenseSN"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                    "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("licenseKey")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" licenseKey\n                "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("renderTo")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" document"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("body"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("appearance")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" UIExtension"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("appearances"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("adaptive"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("addons")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("[")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("]")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// No addon is loaded")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    pdfui"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("getRootComponent")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("then")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("function")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token parameter"}},[t._v("root")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" editTab "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" root"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("querySelector")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'edit-tab'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" editTabBody "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" root"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("querySelector")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'fv--edit-tab-paddle'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n        editTab"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("after")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token string"}},[t._v('\'<gtab name="custom-tab" group="toolbar-tab" body="fv--custom-tab-body" text="Custom Tab" @aria:toolbar.tab></gtab>\'')]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n        editTabBody"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("after")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token string"}},[t._v('\'<div name="fv--custom-tab-body" style="padding:2em 1em;">Custom Tab Body</div>\'')]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n")])]),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("</")]),t._v("script")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n")])])]),a("div",{staticClass:"language-json extra-class"},[a("pre",{pre:!0,attrs:{class:"language-json"}},[a("code",[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v('"iframeOptions"')]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v('"style"')]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v('"height: 300px;"')]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n")])])])]),t._v(" "),a("div",{staticClass:"vuepress-plugin-demo-block__footer"})]),t._v(" "),a("p",[t._v("Compared to editing components with the Fragment configuration, which can only be done during initialization, using the Component API allows you to dynamically edit components at any time after PDFUI initialization.")])])]),t._v(" "),a("h4",{attrs:{id:"tab-panel-components"}},[a("a",{staticClass:"header-anchor",attrs:{href:"#tab-panel-components"}},[t._v("#")]),t._v(" Tab Panel Components")]),t._v(" "),a("p",[t._v("The tab panel component is the panel displayed after selecting a tab. Currently, the default layout template used by the SDK uses the "),a("code",[t._v("paddle")]),t._v(" component as the tab panel component. The purpose of using this component is to display buttons on the left and right sides when the browser view width is small, which can be used to scroll the components within the panel.")]),t._v(" "),a("p",[t._v("The paddle component can be seen as a normal  "),a("code",[t._v("ContainerComponent")]),t._v(". You can use the Fragment configuration to insert child components into it using the "),a("code",[t._v("FRAGMENT_ACTION.APPEND")]),t._v(" operation, or you can use the Component API to insert child components. The following examples will illustrate this.")]),t._v(" "),a("ol",[a("li",[a("p",[t._v("Insert components using the Fragment Configuration")]),t._v(" "),a("p",[t._v("This example uses the Fragment configuration to insert a hand button into the paddle component by default.")]),t._v(" "),a("div",{staticClass:"vuepress-plugin-demo-block__wrapper",staticStyle:{display:"none"},attrs:{"data-config":"%7B%0A%20%20%20%20%22iframeOptions%22%3A%20%7B%0A%20%20%20%20%20%20%20%20%22style%22%3A%20%22height%3A%20300px%3B%22%0A%20%20%20%20%7D%0A%7D%0A","data-type":"vanilla","data-code":"%3Chtml%3E%0A%3C%2Fhtml%3E%0A%3Cscript%3E%0A%20%20%20%20var%20FRAGMENT_ACTION%20%3D%20UIExtension.UIConsts.FRAGMENT_ACTION%0A%20%20%20%20var%20CustomAppearance%20%3D%20UIExtension.appearances.adaptive.extend(%7B%0A%20%20%20%20%20%20%20%20getDefaultFragments%3A%20function()%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20return%20%5B%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20target%3A%20'fv--edit-tab-paddle'%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20action%3A%20FRAGMENT_ACTION.APPEND%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20template%3A%20'%3Cribbon-button%20text%3D%22toolbar.tooltip.hand.title%22%20name%3D%22hand-tool%22%20icon-class%3D%22fv__icon-toolbar-hand%22%20%40controller%3D%22states%3AHandController%22%3E%3C%2Fribbon-button%3E'%0A%20%20%20%20%20%20%20%20%20%20%20%20%7D%5D%3B%0A%20%20%20%20%20%20%20%20%7D%0A%20%20%20%20%7D)%3B%0A%20%20%20%20var%20libPath%20%3D%20window.top.location.origin%20%2B%20'%2Flib'%3B%0A%20%20%20%20var%20pdfui%20%3D%20new%20UIExtension.PDFUI(%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20viewerOptions%3A%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20libPath%3A%20libPath%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20jr%3A%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20licenseSN%3A%20licenseSN%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20licenseKey%3A%20licenseKey%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%7D%0A%20%20%20%20%20%20%20%20%20%20%20%20%7D%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20renderTo%3A%20document.body%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20appearance%3A%20CustomAppearance%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20addons%3A%20%5B%5D%20%2F%2F%20No%20addon%20is%20loaded%0A%20%20%20%20%7D)%3B%0A%3C%2Fscript%3E%0A"}},[a("div",{staticClass:"vuepress-plugin-demo-block__display"},[a("div",{staticClass:"vuepress-plugin-demo-block__app"})]),t._v(" "),a("div",{staticClass:"vuepress-plugin-demo-block__code"},[a("div",{staticClass:"language-html extra-class"},[a("pre",{pre:!0,attrs:{class:"language-html"}},[a("code",[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("<")]),t._v("html")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("</")]),t._v("html")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("<")]),t._v("script")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),a("span",{pre:!0,attrs:{class:"token script"}},[a("span",{pre:!0,attrs:{class:"token language-javascript"}},[t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("FRAGMENT_ACTION")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" UIExtension"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("UIConsts"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("FRAGMENT_ACTION")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" CustomAppearance "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" UIExtension"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("appearances"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("adaptive"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("extend")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token function-variable function"}},[t._v("getDefaultFragments")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("function")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("return")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("[")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("target")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'fv--edit-tab-paddle'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("action")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("FRAGMENT_ACTION")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("APPEND")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("template")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v('\'<ribbon-button text="toolbar.tooltip.hand.title" name="hand-tool" icon-class="fv__icon-toolbar-hand" @controller="states:HandController"></ribbon-button>\'')]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("]")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" libPath "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" window"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("top"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("location"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("origin "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("+")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'/lib'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" pdfui "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("new")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token class-name"}},[t._v("UIExtension"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("PDFUI")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("viewerOptions")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("libPath")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" libPath"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("jr")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                    "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("licenseSN")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" licenseSN"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                    "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("licenseKey")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" licenseKey\n                "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("renderTo")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" document"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("body"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("appearance")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" CustomAppearance"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("addons")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("[")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("]")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// No addon is loaded")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n")])]),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("</")]),t._v("script")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n")])])]),a("div",{staticClass:"language-json extra-class"},[a("pre",{pre:!0,attrs:{class:"language-json"}},[a("code",[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v('"iframeOptions"')]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v('"style"')]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v('"height: 300px;"')]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n")])])])]),t._v(" "),a("div",{staticClass:"vuepress-plugin-demo-block__footer"})])]),t._v(" "),a("li",[a("p",[t._v("Insert components using the Component API")]),t._v(" "),a("p",[t._v("This example uses the Component API to insert a hand button. The effect will be the same as the previous example.")]),t._v(" "),a("div",{staticClass:"vuepress-plugin-demo-block__wrapper",staticStyle:{display:"none"},attrs:{"data-config":"%7B%0A%20%20%20%20%22iframeOptions%22%3A%20%7B%0A%20%20%20%20%20%20%20%20%22style%22%3A%20%22height%3A%20300px%3B%22%0A%20%20%20%20%7D%0A%7D%0A","data-type":"vanilla","data-code":"%3Chtml%3E%0A%3C%2Fhtml%3E%0A%3Cscript%3E%0A%20%20%20%20var%20libPath%20%3D%20window.top.location.origin%20%2B%20'%2Flib'%3B%0A%20%20%20%20var%20pdfui%20%3D%20new%20UIExtension.PDFUI(%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20viewerOptions%3A%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20libPath%3A%20libPath%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20jr%3A%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20licenseSN%3A%20licenseSN%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20licenseKey%3A%20licenseKey%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%7D%0A%20%20%20%20%20%20%20%20%20%20%20%20%7D%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20renderTo%3A%20document.body%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20appearance%3A%20UIExtension.appearances.adaptive%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20addons%3A%20%5B%5D%20%2F%2F%20No%20addon%20is%20loaded%0A%20%20%20%20%7D)%3B%0A%20%20%20%20pdfui.getRootComponent().then(function(root)%20%7B%0A%20%20%20%20%20%20%20%20var%20editTabBody%20%3D%20root.querySelector('fv--edit-tab-paddle')%0A%20%20%20%20%20%20%20%20editTabBody.append('%3Cribbon-button%20text%3D%22toolbar.tooltip.hand.title%22%20name%3D%22hand-tool%22%20icon-class%3D%22fv__icon-toolbar-hand%22%20%40controller%3D%22states%3AHandController%22%3E%3C%2Fribbon-button%3E')%0A%20%20%20%20%7D)%0A%3C%2Fscript%3E%0A"}},[a("div",{staticClass:"vuepress-plugin-demo-block__display"},[a("div",{staticClass:"vuepress-plugin-demo-block__app"})]),t._v(" "),a("div",{staticClass:"vuepress-plugin-demo-block__code"},[a("div",{staticClass:"language-html extra-class"},[a("pre",{pre:!0,attrs:{class:"language-html"}},[a("code",[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("<")]),t._v("html")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("</")]),t._v("html")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("<")]),t._v("script")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),a("span",{pre:!0,attrs:{class:"token script"}},[a("span",{pre:!0,attrs:{class:"token language-javascript"}},[t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" libPath "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" window"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("top"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("location"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("origin "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("+")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'/lib'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" pdfui "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("new")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token class-name"}},[t._v("UIExtension"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("PDFUI")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("viewerOptions")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("libPath")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" libPath"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("jr")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                    "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("licenseSN")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" licenseSN"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                    "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("licenseKey")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" licenseKey\n                "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("renderTo")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" document"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("body"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("appearance")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" UIExtension"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("appearances"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("adaptive"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("addons")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("[")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("]")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// No addon is loaded")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    pdfui"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("getRootComponent")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("then")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("function")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token parameter"}},[t._v("root")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" editTabBody "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" root"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("querySelector")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'fv--edit-tab-paddle'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v("\n        editTabBody"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("append")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token string"}},[t._v('\'<ribbon-button text="toolbar.tooltip.hand.title" name="hand-tool" icon-class="fv__icon-toolbar-hand" @controller="states:HandController"></ribbon-button>\'')]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v("\n")])]),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("</")]),t._v("script")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n")])])]),a("div",{staticClass:"language-json extra-class"},[a("pre",{pre:!0,attrs:{class:"language-json"}},[a("code",[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v('"iframeOptions"')]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v('"style"')]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v('"height: 300px;"')]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n")])])])]),t._v(" "),a("div",{staticClass:"vuepress-plugin-demo-block__footer"})])])]),t._v(" "),a("p",[t._v("In the default layout template, we use the "),a("code",[t._v("group-list")]),t._v(" component to group the child components within the "),a("code",[t._v("paddle")]),t._v(" component. In practice, it is more common to edit the "),a("code",[t._v("group-list")]),t._v(" component. The following example will use "),a("code",[t._v("group-list")]),t._v(" and "),a("code",[t._v("group")]),t._v(" to illustrate:")]),t._v(" "),a("div",{staticClass:"vuepress-plugin-demo-block__wrapper",staticStyle:{display:"none"},attrs:{"data-config":"%7B%0A%20%20%20%20%22iframeOptions%22%3A%20%7B%0A%20%20%20%20%20%20%20%20%22style%22%3A%20%22height%3A%20300px%3B%22%0A%20%20%20%20%7D%0A%7D%0A","data-type":"vanilla","data-code":"%3Chtml%3E%0A%3C%2Fhtml%3E%0A%3Cscript%3E%0A%20%20%20%20var%20libPath%20%3D%20window.top.location.origin%20%2B%20'%2Flib'%3B%0A%20%20%20%20var%20pdfui%20%3D%20new%20UIExtension.PDFUI(%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20viewerOptions%3A%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20libPath%3A%20libPath%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20jr%3A%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20licenseSN%3A%20licenseSN%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20licenseKey%3A%20licenseKey%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%7D%0A%20%20%20%20%20%20%20%20%20%20%20%20%7D%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20renderTo%3A%20document.body%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20appearance%3A%20UIExtension.appearances.adaptive%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20addons%3A%20%5B%5D%20%2F%2F%20No%20addon%20is%20loaded%0A%20%20%20%20%7D)%3B%0A%20%20%20%20pdfui.getRootComponent().then(function(root)%20%7B%0A%20%20%20%20%20%20%20%20var%20editTabBody%20%3D%20root.querySelector('fv--edit-tab-paddle%3E%40group-list')%0A%20%20%20%20%20%20%20%20editTabBody.append('%3Cgroup%20name%3D%22custom-group%22%20retain-count%3D%221%22%3E%3Cribbon-button%20text%3D%22toolbar.tooltip.hand.title%22%20name%3D%22hand-tool%22%20icon-class%3D%22fv__icon-toolbar-hand%22%20%40controller%3D%22states%3AHandController%22%3E%3Cribbon-button%20text%3D%22toolbar.tooltip.hand.title%22%20name%3D%22hand-tool%22%20icon-class%3D%22fv__icon-toolbar-hand%22%20%40controller%3D%22states%3AHandController%22%3E%3C%2Fribbon-button%3E%3C%2Fgroup%3E')%0A%20%20%20%20%7D)%0A%3C%2Fscript%3E%0A"}},[a("div",{staticClass:"vuepress-plugin-demo-block__display"},[a("div",{staticClass:"vuepress-plugin-demo-block__app"})]),t._v(" "),a("div",{staticClass:"vuepress-plugin-demo-block__code"},[a("div",{staticClass:"language-html extra-class"},[a("pre",{pre:!0,attrs:{class:"language-html"}},[a("code",[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("<")]),t._v("html")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("</")]),t._v("html")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("<")]),t._v("script")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),a("span",{pre:!0,attrs:{class:"token script"}},[a("span",{pre:!0,attrs:{class:"token language-javascript"}},[t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" libPath "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" window"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("top"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("location"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("origin "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("+")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'/lib'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" pdfui "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("new")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token class-name"}},[t._v("UIExtension"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("PDFUI")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("viewerOptions")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("libPath")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" libPath"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("jr")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                    "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("licenseSN")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" licenseSN"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                    "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("licenseKey")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" licenseKey\n                "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("renderTo")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" document"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("body"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("appearance")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" UIExtension"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("appearances"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("adaptive"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("addons")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("[")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("]")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// No addon is loaded")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    pdfui"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("getRootComponent")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("then")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("function")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token parameter"}},[t._v("root")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" editTabBody "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" root"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("querySelector")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'fv--edit-tab-paddle>@group-list'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v("\n        editTabBody"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("append")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token string"}},[t._v('\'<group name="custom-group" retain-count="1"><ribbon-button text="toolbar.tooltip.hand.title" name="hand-tool" icon-class="fv__icon-toolbar-hand" @controller="states:HandController"><ribbon-button text="toolbar.tooltip.hand.title" name="hand-tool" icon-class="fv__icon-toolbar-hand" @controller="states:HandController"></ribbon-button></group>\'')]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v("\n")])]),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("</")]),t._v("script")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n")])])]),a("div",{staticClass:"language-json extra-class"},[a("pre",{pre:!0,attrs:{class:"language-json"}},[a("code",[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v('"iframeOptions"')]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v('"style"')]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v('"height: 300px;"')]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n")])])])]),t._v(" "),a("div",{staticClass:"vuepress-plugin-demo-block__footer"})]),t._v(" "),a("p",[t._v("In this example, we insert a new "),a("code",[t._v("custom-group")]),t._v(" where the group contains two hand button components, and set it to only display one component when collapsed.")]),t._v(" "),a("h4",{attrs:{id:"button-components-in-tab-panels-ribbon-button"}},[a("a",{staticClass:"header-anchor",attrs:{href:"#button-components-in-tab-panels-ribbon-button"}},[t._v("#")]),t._v(" Button Components in Tab Panels (ribbon-button)")]),t._v(" "),a("p",[t._v("The "),a("code",[t._v("ribbon-button")]),t._v(" is a powerful component that can be used as a regular button or as a dropdown component. Let's first explore the custom methods for using ribbon-button as a regular button.")]),t._v(" "),a("p",[t._v("As a regular button, the "),a("code",[t._v("ribbon-button")]),t._v(" component can be customized with the following:")]),t._v(" "),a("ol",[a("li",[a("p",[t._v("Text Content: the text displayed on the button.")])]),t._v(" "),a("li",[a("p",[t._v("Icon: the button icon, specified through the "),a("code",[t._v("icon-class")]),t._v(" attribute, which requires additional CSS styles.")])]),t._v(" "),a("li",[a("p",[t._v("Tooltips: the floating tooltip content displayed when the mouse hovers over the button, implemented through the "),a("code",[t._v("@tooltip")]),t._v(" directive and "),a("code",[t._v("tooltip-title")]),t._v(" attribute.")])]),t._v(" "),a("li",[a("p",[t._v("Controller: usually used for business implementation, and generally used to reuse internal SDK implementation logic on custom buttons.")])])]),t._v(" "),a("p",[t._v("The following is an example of a custom button that reuses business logic using the SDK's built-in controller:")]),t._v(" "),a("div",{staticClass:"vuepress-plugin-demo-block__wrapper",staticStyle:{display:"none"},attrs:{"data-config":"%7B%0A%20%20%20%20%22iframeOptions%22%3A%20%7B%0A%20%20%20%20%20%20%20%20%22style%22%3A%20%22height%3A%20300px%3B%22%0A%20%20%20%20%7D%0A%7D%0A","data-type":"vanilla","data-code":"%3Chtml%3E%0A%3C%2Fhtml%3E%0A%3Cscript%3E%0A%20%20%20%20var%20FRAGMENT_ACTION%20%3D%20UIExtension.UIConsts.FRAGMENT_ACTION%0A%20%20%20%20var%20CustomAppearance%20%3D%20UIExtension.appearances.adaptive.extend(%7B%0A%20%20%20%20%20%20%20%20getDefaultFragments%3A%20function()%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20return%20%5B%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20target%3A%20'fv--edit-tab-paddle'%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20action%3A%20FRAGMENT_ACTION.APPEND%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20template%3A%20'%3Cribbon-button%20text%3D%22Hand%20button%22%20name%3D%22custom-hand-tool%22%20icon-class%3D%22fv__icon-toolbar-hand%22%20%40controller%3D%22states%3AHandController%22%3E%3C%2Fribbon-button%3E'%20%2F%2F%20Reuse%20states%3AHandController%0A%20%20%20%20%20%20%20%20%20%20%20%20%7D%5D%3B%0A%20%20%20%20%20%20%20%20%7D%0A%20%20%20%20%7D)%3B%0A%20%20%20%20var%20libPath%20%3D%20window.top.location.origin%20%2B%20'%2Flib'%3B%0A%20%20%20%20var%20pdfui%20%3D%20new%20UIExtension.PDFUI(%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20viewerOptions%3A%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20libPath%3A%20libPath%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20jr%3A%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20licenseSN%3A%20licenseSN%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20licenseKey%3A%20licenseKey%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%7D%0A%20%20%20%20%20%20%20%20%20%20%20%20%7D%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20renderTo%3A%20document.body%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20appearance%3A%20CustomAppearance%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20addons%3A%20%5B%5D%20%2F%2F%20No%20addon%20is%20loaded%0A%20%20%20%20%7D)%3B%0A%3C%2Fscript%3E%0A"}},[a("div",{staticClass:"vuepress-plugin-demo-block__display"},[a("div",{staticClass:"vuepress-plugin-demo-block__app"})]),t._v(" "),a("div",{staticClass:"vuepress-plugin-demo-block__code"},[a("div",{staticClass:"language-html extra-class"},[a("pre",{pre:!0,attrs:{class:"language-html"}},[a("code",[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("<")]),t._v("html")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("</")]),t._v("html")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("<")]),t._v("script")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),a("span",{pre:!0,attrs:{class:"token script"}},[a("span",{pre:!0,attrs:{class:"token language-javascript"}},[t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("FRAGMENT_ACTION")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" UIExtension"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("UIConsts"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("FRAGMENT_ACTION")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" CustomAppearance "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" UIExtension"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("appearances"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("adaptive"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("extend")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token function-variable function"}},[t._v("getDefaultFragments")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("function")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("return")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("[")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("target")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'fv--edit-tab-paddle'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("action")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("FRAGMENT_ACTION")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("APPEND")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("template")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v('\'<ribbon-button text="Hand button" name="custom-hand-tool" icon-class="fv__icon-toolbar-hand" @controller="states:HandController"></ribbon-button>\'')]),t._v(" "),a("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Reuse states:HandController")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("]")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" libPath "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" window"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("top"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("location"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("origin "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("+")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'/lib'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" pdfui "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("new")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token class-name"}},[t._v("UIExtension"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("PDFUI")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("viewerOptions")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("libPath")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" libPath"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("jr")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                    "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("licenseSN")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" licenseSN"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                    "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("licenseKey")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" licenseKey\n                "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("renderTo")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" document"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("body"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("appearance")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" CustomAppearance"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("addons")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("[")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("]")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// No addon is loaded")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n")])]),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("</")]),t._v("script")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n")])])]),a("div",{staticClass:"language-json extra-class"},[a("pre",{pre:!0,attrs:{class:"language-json"}},[a("code",[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v('"iframeOptions"')]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v('"style"')]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v('"height: 300px;"')]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n")])])])]),t._v(" "),a("div",{staticClass:"vuepress-plugin-demo-block__footer"})]),t._v(" "),a("p",[t._v("From this example, we can see that when reusing a controller, the "),a("code",[t._v('@controller=""')]),t._v(" directive can be used to specify the "),a("code",[t._v("Controller")]),t._v(" that needs to be reused. Apart from "),a("code",[t._v("states:HandController")]),t._v(", there are many other controllers that can be reused. For more details, please refer to the "),a("a",{attrs:{href:"#controller-reusability"}},[t._v("Controllers")]),t._v(" section.")]),t._v(" "),a("p",[t._v("In addition to reusing logic with custom buttons, you can also directly modify the built-in components of the SDK. The main way to do this is through configuring Fragments. For example, the following example fully demonstrates how to customize the content of the "),a("code",[t._v("hand-tool")]),t._v(" (ribbon-button):")]),t._v(" "),a("div",{staticClass:"vuepress-plugin-demo-block__wrapper",staticStyle:{display:"none"},attrs:{"data-config":"%7B%0A%20%20%20%20%22iframeOptions%22%3A%20%7B%0A%20%20%20%20%20%20%20%20%22style%22%3A%20%22height%3A%20300px%3B%22%0A%20%20%20%20%7D%0A%7D%0A","data-type":"vanilla","data-code":"%3Chtml%3E%0A%3C%2Fhtml%3E%0A%3Cstyle%3E%0A%20%20%20%20.custom-hand-icon%20%7B%0A%20%20%20%20%20%20%20%20background-image%3A%20linear-gradient(180deg%2C%20rgba(0%2C245%2C12%2C1)%200%25%2C%20rgba(0%2C212%2C255%2C1)%20100%25)%3B%0A%20%20%20%20%7D%0A%3C%2Fstyle%3E%0A%3Cscript%3E%0A%20%20%20%20var%20FRAGMENT_ACTION%20%3D%20UIExtension.UIConsts.FRAGMENT_ACTION%0A%20%20%20%20var%20CustomAppearance%20%3D%20UIExtension.appearances.adaptive.extend(%7B%0A%20%20%20%20%20%20%20%20getDefaultFragments%3A%20function()%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20return%20%5B%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20target%3A%20'hand-tool'%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20action%3A%20FRAGMENT_ACTION.EXT%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20config%3A%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20'icon-class'%3A%20'custom-hand-icon'%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20text%3A%20'Custom%20Button%20Text'%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20attrs%3A%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20'%40tooltip'%3A%20''%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20'tooltip-title'%3A%20'Custom%20Tooltip%20Title'%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%7D%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%7D%0A%20%20%20%20%20%20%20%20%20%20%20%20%7D%5D%3B%0A%20%20%20%20%20%20%20%20%7D%0A%20%20%20%20%7D)%3B%0A%20%20%20%20var%20libPath%20%3D%20window.top.location.origin%20%2B%20'%2Flib'%3B%0A%20%20%20%20var%20pdfui%20%3D%20new%20UIExtension.PDFUI(%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20viewerOptions%3A%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20libPath%3A%20libPath%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20jr%3A%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20licenseSN%3A%20licenseSN%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20licenseKey%3A%20licenseKey%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%7D%0A%20%20%20%20%20%20%20%20%20%20%20%20%7D%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20renderTo%3A%20document.body%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20appearance%3A%20CustomAppearance%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20addons%3A%20%5B%5D%20%2F%2F%20No%20addon%20is%20loaded%0A%20%20%20%20%7D)%3B%0A%3C%2Fscript%3E%0A"}},[a("div",{staticClass:"vuepress-plugin-demo-block__display"},[a("div",{staticClass:"vuepress-plugin-demo-block__app"})]),t._v(" "),a("div",{staticClass:"vuepress-plugin-demo-block__code"},[a("div",{staticClass:"language-html extra-class"},[a("pre",{pre:!0,attrs:{class:"language-html"}},[a("code",[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("<")]),t._v("html")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("</")]),t._v("html")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("<")]),t._v("style")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),a("span",{pre:!0,attrs:{class:"token style"}},[a("span",{pre:!0,attrs:{class:"token language-css"}},[t._v("\n    "),a("span",{pre:!0,attrs:{class:"token selector"}},[t._v(".custom-hand-icon")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v("background-image")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("linear-gradient")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),t._v("180deg"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("rgba")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),t._v("0"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("245"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("12"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("1"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" 0%"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("rgba")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),t._v("0"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("212"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("255"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("1"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" 100%"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n")])]),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("</")]),t._v("style")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("<")]),t._v("script")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),a("span",{pre:!0,attrs:{class:"token script"}},[a("span",{pre:!0,attrs:{class:"token language-javascript"}},[t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("FRAGMENT_ACTION")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" UIExtension"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("UIConsts"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("FRAGMENT_ACTION")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" CustomAppearance "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" UIExtension"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("appearances"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("adaptive"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("extend")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token function-variable function"}},[t._v("getDefaultFragments")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("function")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("return")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("[")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("target")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'hand-tool'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("action")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("FRAGMENT_ACTION")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("EXT")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("config")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                    "),a("span",{pre:!0,attrs:{class:"token string-property property"}},[t._v("'icon-class'")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'custom-hand-icon'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                    "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("text")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'Custom Button Text'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                    "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("attrs")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                        "),a("span",{pre:!0,attrs:{class:"token string-property property"}},[t._v("'@tooltip'")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("''")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                        "),a("span",{pre:!0,attrs:{class:"token string-property property"}},[t._v("'tooltip-title'")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'Custom Tooltip Title'")]),t._v("\n                    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("]")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" libPath "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" window"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("top"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("location"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("origin "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("+")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'/lib'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" pdfui "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("new")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token class-name"}},[t._v("UIExtension"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("PDFUI")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("viewerOptions")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("libPath")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" libPath"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("jr")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                    "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("licenseSN")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" licenseSN"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                    "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("licenseKey")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" licenseKey\n                "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("renderTo")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" document"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("body"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("appearance")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" CustomAppearance"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("addons")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("[")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("]")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// No addon is loaded")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n")])]),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("</")]),t._v("script")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n")])])]),a("div",{staticClass:"language-json extra-class"},[a("pre",{pre:!0,attrs:{class:"language-json"}},[a("code",[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v('"iframeOptions"')]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v('"style"')]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v('"height: 300px;"')]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n")])])])]),t._v(" "),a("div",{staticClass:"vuepress-plugin-demo-block__footer"})]),t._v(" "),a("h4",{attrs:{id:"dropdown-components-in-the-toolbar-tab-panel"}},[a("a",{staticClass:"header-anchor",attrs:{href:"#dropdown-components-in-the-toolbar-tab-panel"}},[t._v("#")]),t._v(" Dropdown Components in the Toolbar Tab Panel")]),t._v(" "),a("p",[t._v("On the toolbar, the "),a("code",[t._v("dropdown")]),t._v(" component is usually used in conjunction with the "),a("code",[t._v("ribbon-button")]),t._v(" component. However, you can also use it separately. The only difference between these two usage methods is the display effect. The following is an example of using "),a("code",[t._v("ribbon-button")]),t._v(" and "),a("code",[t._v("dropdown")]),t._v(" together:")]),t._v(" "),a("div",{staticClass:"vuepress-plugin-demo-block__wrapper",staticStyle:{display:"none"},attrs:{"data-config":"%7B%0A%20%20%20%20%22iframeOptions%22%3A%20%7B%0A%20%20%20%20%20%20%20%20%22style%22%3A%20%22height%3A%20300px%3B%22%0A%20%20%20%20%7D%0A%7D%0A","data-type":"vanilla","data-code":"%3Chtml%3E%0A%3C%2Fhtml%3E%0A%3Cscript%3E%0A%20%20%20%20var%20FRAGMENT_ACTION%20%3D%20UIExtension.UIConsts.FRAGMENT_ACTION%0A%20%20%20%20var%20CustomAppearance%20%3D%20UIExtension.appearances.adaptive.extend(%7B%0A%20%20%20%20%20%20%20%20getDefaultFragments%3A%20function()%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20return%20%5B%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20target%3A%20'hand-tool'%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20action%3A%20FRAGMENT_ACTION.AFTER%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20template%3A%20%60%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%3Cribbon-button%20name%3D%22dropdown-zoom%22%20%40var.self%3D%22%24component%22%20%40tooltip%20%3E%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%3Cdropdown%20name%3D%22fv--inner-zoom-ribbon-dropdown%22%20%40aria%3Alabel.list%3D%22aria%3Alabels.setzoom%22%20icon-class%3D%22fv__icon-toolbar-zoom-in%22%20class%3D%22fv__ui-dropdown-hide-text%22%20selected%3D%220%22%20%40on.selected%3D%22self.select(%24args%5B0%5D)%22%3E%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%3Cdropdown-button%20name%3D%22dropdown-zoom-in%22%20action%3D%22zoomin%22%20%40controller%3D%22zoom%3ADropdownZoomInAndOutController%22%20icon-class%3D%22fv__icon-toolbar-zoom-in%22%20ribbon-icon%3D%22fx-icon-ribbon_home_zoomin-32%22%20tooltip-title%3D%22toolbar.buttons.zoomin%22%20tabindex%3D%220%22%3Etoolbar.buttons.zoomin%3C%2Fdropdown-button%3E%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%3Cdropdown-button%20name%3D%22dropdown-zoom-out%22%20action%3D%22zoomout%22%20%40controller%3D%22zoom%3ADropdownZoomInAndOutController%22%20icon-class%3D%22fv__icon-toolbar-zoom-out%22%20ribbon-icon%3D%22fx-icon-ribbon_home_zoomout-32%22%20tooltip-title%3D%22toolbar.buttons.zoomout%22%20tabindex%3D%220%22%3Etoolbar.buttons.zoomout%3C%2Fdropdown-button%3E%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%3C%2Fdropdown%3E%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%3C%2Fribbon-button%3E%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%60%0A%20%20%20%20%20%20%20%20%20%20%20%20%7D%5D%3B%0A%20%20%20%20%20%20%20%20%7D%0A%20%20%20%20%7D)%3B%0A%20%20%20%20var%20libPath%20%3D%20window.top.location.origin%20%2B%20'%2Flib'%3B%0A%20%20%20%20var%20pdfui%20%3D%20new%20UIExtension.PDFUI(%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20viewerOptions%3A%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20libPath%3A%20libPath%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20jr%3A%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20licenseSN%3A%20licenseSN%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20licenseKey%3A%20licenseKey%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%7D%0A%20%20%20%20%20%20%20%20%20%20%20%20%7D%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20renderTo%3A%20document.body%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20appearance%3A%20CustomAppearance%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20addons%3A%20%5B%5D%20%2F%2F%20No%20addon%20is%20loaded%0A%20%20%20%20%7D)%3B%0A%3C%2Fscript%3E%0A"}},[a("div",{staticClass:"vuepress-plugin-demo-block__display"},[a("div",{staticClass:"vuepress-plugin-demo-block__app"})]),t._v(" "),a("div",{staticClass:"vuepress-plugin-demo-block__code"},[a("div",{staticClass:"language-html extra-class"},[a("pre",{pre:!0,attrs:{class:"language-html"}},[a("code",[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("<")]),t._v("html")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("</")]),t._v("html")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("<")]),t._v("script")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),a("span",{pre:!0,attrs:{class:"token script"}},[a("span",{pre:!0,attrs:{class:"token language-javascript"}},[t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("FRAGMENT_ACTION")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" UIExtension"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("UIConsts"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("FRAGMENT_ACTION")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" CustomAppearance "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" UIExtension"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("appearances"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("adaptive"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("extend")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token function-variable function"}},[t._v("getDefaultFragments")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("function")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("return")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("[")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("target")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'hand-tool'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("action")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("FRAGMENT_ACTION")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("AFTER")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("template")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token template-string"}},[a("span",{pre:!0,attrs:{class:"token template-punctuation string"}},[t._v("`")]),a("span",{pre:!0,attrs:{class:"token string"}},[t._v('\n                <ribbon-button name="dropdown-zoom" @var.self="$component" @tooltip >\n                    <dropdown name="fv--inner-zoom-ribbon-dropdown" @aria:label.list="aria:labels.setzoom" icon-class="fv__icon-toolbar-zoom-in" class="fv__ui-dropdown-hide-text" selected="0" @on.selected="self.select($args[0])">\n                        <dropdown-button name="dropdown-zoom-in" action="zoomin" @controller="zoom:DropdownZoomInAndOutController" icon-class="fv__icon-toolbar-zoom-in" ribbon-icon="fx-icon-ribbon_home_zoomin-32" tooltip-title="toolbar.buttons.zoomin" tabindex="0">toolbar.buttons.zoomin</dropdown-button>\n                        <dropdown-button name="dropdown-zoom-out" action="zoomout" @controller="zoom:DropdownZoomInAndOutController" icon-class="fv__icon-toolbar-zoom-out" ribbon-icon="fx-icon-ribbon_home_zoomout-32" tooltip-title="toolbar.buttons.zoomout" tabindex="0">toolbar.buttons.zoomout</dropdown-button>\n                    </dropdown>\n                </ribbon-button>\n                ')]),a("span",{pre:!0,attrs:{class:"token template-punctuation string"}},[t._v("`")])]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("]")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" libPath "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" window"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("top"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("location"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("origin "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("+")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'/lib'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" pdfui "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("new")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token class-name"}},[t._v("UIExtension"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("PDFUI")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("viewerOptions")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("libPath")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" libPath"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("jr")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                    "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("licenseSN")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" licenseSN"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                    "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("licenseKey")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" licenseKey\n                "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("renderTo")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" document"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("body"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("appearance")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" CustomAppearance"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("addons")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("[")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("]")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// No addon is loaded")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n")])]),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("</")]),t._v("script")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n")])])]),a("div",{staticClass:"language-json extra-class"},[a("pre",{pre:!0,attrs:{class:"language-json"}},[a("code",[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v('"iframeOptions"')]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v('"style"')]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v('"height: 300px;"')]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n")])])])]),t._v(" "),a("div",{staticClass:"vuepress-plugin-demo-block__footer"})]),t._v(" "),a("p",[t._v("For more business components, you can refer to the "),a("RouterLink",{attrs:{to:"/ui-extension/business-components/pre-configured-components.html"}},[t._v("pre-configured components")]),t._v(" section. This section describes the default configurations of multiple business components, and we can adjust them using Fragment configuration based on these configuration options.")],1),t._v(" "),a("h3",{attrs:{id:"left-panel"}},[a("a",{staticClass:"header-anchor",attrs:{href:"#left-panel"}},[t._v("#")]),t._v(" Left Panel")]),t._v(" "),a("p",[t._v("In the default layout, the left panel is constructed using the "),a("code",[t._v("sidebar")]),t._v(" component, and its child components correspond to different business modules encapsulated in the "),a("code",[t._v("sidebar-panel")]),t._v(" component.")]),t._v(" "),a("p",[t._v("In this section, we will learn about some customization methods and details of the left panel.")]),t._v(" "),a("h4",{attrs:{id:"create-a-sidebar-panel"}},[a("a",{staticClass:"header-anchor",attrs:{href:"#create-a-sidebar-panel"}},[t._v("#")]),t._v(" Create a "),a("code",[t._v("sidebar-panel")])]),t._v(" "),a("p",[t._v("Here is a template for the "),a("code",[t._v("sidebar-panel")]),t._v(" component that includes basic properties:")]),t._v(" "),a("div",{staticClass:"language-html extra-class"},[a("pre",{pre:!0,attrs:{class:"language-html"}},[a("code",[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("<")]),t._v("sidebar-panel")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token attr-name"}},[t._v("class")]),a("span",{pre:!0,attrs:{class:"token attr-value"}},[a("span",{pre:!0,attrs:{class:"token punctuation attr-equals"}},[t._v("=")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v('"')]),t._v("custom-sidebar-panel"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v('"')])]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token attr-name"}},[t._v("icon-class")]),a("span",{pre:!0,attrs:{class:"token attr-value"}},[a("span",{pre:!0,attrs:{class:"token punctuation attr-equals"}},[t._v("=")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v('"')]),t._v("custom-sidebar-icon"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v('"')])]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token attr-name"}},[t._v("title")]),a("span",{pre:!0,attrs:{class:"token attr-value"}},[a("span",{pre:!0,attrs:{class:"token punctuation attr-equals"}},[t._v("=")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v('"')]),t._v("Custom"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v('"')])]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("</")]),t._v("sidebar-panel")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n")])])]),a("p",[t._v("If needed, you can add directives to it, such as the "),a("code",[t._v("@tooltip")]),t._v(" directive:")]),t._v(" "),a("div",{staticClass:"language-html extra-class"},[a("pre",{pre:!0,attrs:{class:"language-html"}},[a("code",[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("<")]),t._v("sidebar-panel")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token attr-name"}},[t._v("class")]),a("span",{pre:!0,attrs:{class:"token attr-value"}},[a("span",{pre:!0,attrs:{class:"token punctuation attr-equals"}},[t._v("=")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v('"')]),t._v("custom-sidebar-panel"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v('"')])]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token attr-name"}},[t._v("icon-class")]),a("span",{pre:!0,attrs:{class:"token attr-value"}},[a("span",{pre:!0,attrs:{class:"token punctuation attr-equals"}},[t._v("=")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v('"')]),t._v("custom-sidebar-icon"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v('"')])]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token attr-name"}},[t._v("title")]),a("span",{pre:!0,attrs:{class:"token attr-value"}},[a("span",{pre:!0,attrs:{class:"token punctuation attr-equals"}},[t._v("=")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v('"')]),t._v("Custom"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v('"')])]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token attr-name"}},[t._v("@tooltip")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token attr-name"}},[t._v("tooltip-placement")]),a("span",{pre:!0,attrs:{class:"token attr-value"}},[a("span",{pre:!0,attrs:{class:"token punctuation attr-equals"}},[t._v("=")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v('"')]),t._v("right"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v('"')])]),t._v(" \n    "),a("span",{pre:!0,attrs:{class:"token attr-name"}},[t._v("tooltip-title")]),a("span",{pre:!0,attrs:{class:"token attr-value"}},[a("span",{pre:!0,attrs:{class:"token punctuation attr-equals"}},[t._v("=")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v('"')]),t._v("Custom Sidebar"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v('"')])]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("</")]),t._v("sidebar-panel")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n")])])]),a("p",[t._v("If you need to listen to the "),a("code",[t._v("active")]),t._v(" event (when the sidebar-panel is expanded), you can use the "),a("code",[t._v("@on.active")]),t._v(" directive to listen to it. Please refer to the following example:")]),t._v(" "),a("div",{staticClass:"language-js extra-class"},[a("pre",{pre:!0,attrs:{class:"language-js"}},[a("code",[a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("class")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token class-name"}},[t._v("CustomSidebarPanel")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("extends")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token class-name"}},[t._v("SeniorComponentFactory"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("createSuperClass")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("template")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token template-string"}},[a("span",{pre:!0,attrs:{class:"token template-punctuation string"}},[t._v("`")]),a("span",{pre:!0,attrs:{class:"token string"}},[t._v('\n    <sidebar-panel\n        class="custom-sidebar-panel"\n        icon-class="custom-sidebar-icon"\n        title="Custom"\n        @tooltip\n        tooltip-placement="right" \n        tooltip-title="Custom Sidebar"\n        @on.active="$component.handleActiveEvent()"\n    >\n    </sidebar-panel>\n    ')]),a("span",{pre:!0,attrs:{class:"token template-punctuation string"}},[t._v("`")])]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("static")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("getName")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("return")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'custom-sidebar-panel'")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("handleActiveEvent")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        console"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("log")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'hello world'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n")])])]),a("p",[t._v("Finally, let's take a look at a runnable example:")]),t._v(" "),a("div",{staticClass:"vuepress-plugin-demo-block__wrapper",staticStyle:{display:"none"},attrs:{"data-config":"%7B%0A%20%20%20%20%22iframeOptions%22%3A%20%7B%0A%20%20%20%20%20%20%20%20%22style%22%3A%20%22height%3A%20600px%3B%22%0A%20%20%20%20%7D%0A%7D%0A","data-type":"vanilla","data-code":"%3Chtml%3E%0A%3C%2Fhtml%3E%0A%3Cstyle%3E%0A%20%20%20%20.custom-sidebar-icon%20%7B%0A%20%20%20%20%20%20%20%20background-image%3A%20linear-gradient(180deg%2C%20rgba(0%2C245%2C12%2C1)%200%25%2C%20rgba(0%2C212%2C255%2C1)%20100%25)%3B%0A%20%20%20%20%20%20%20%20width%3A%2024px%3B%0A%20%20%20%20%20%20%20%20height%3A%2024px%3B%0A%20%20%20%20%20%20%20%20margin-top%3A%2012px%3B%0A%20%20%20%20%20%20%20%20margin-left%3A%204px%3B%0A%20%20%20%20%7D%0A%3C%2Fstyle%3E%0A%3Cscript%3E%0A%20%20%20%20const%20%7B%20modular%2C%20SeniorComponentFactory%20%7D%20%3D%20UIExtension%3B%0A%0A%20%20%20%20class%20CustomSidebarPanel%20extends%20SeniorComponentFactory.createSuperClass(%7B%0A%20%20%20%20%20%20%20%20template%3A%20%60%0A%20%20%20%20%20%20%20%20%3Csidebar-panel%0A%20%20%20%20%20%20%20%20%20%20%20%20class%3D%22custom-sidebar-panel%22%0A%20%20%20%20%20%20%20%20%20%20%20%20icon-class%3D%22custom-sidebar-icon%22%0A%20%20%20%20%20%20%20%20%20%20%20%20title%3D%22Custom%22%0A%20%20%20%20%20%20%20%20%20%20%20%20%40tooltip%0A%20%20%20%20%20%20%20%20%20%20%20%20tooltip-placement%3D%22right%22%20%0A%20%20%20%20%20%20%20%20%20%20%20%20tooltip-title%3D%22Custom%20Sidebar%22%0A%20%20%20%20%20%20%20%20%20%20%20%20%40on.active%3D%22%24component.handleActiveEvent()%22%0A%20%20%20%20%20%20%20%20%3E%0A%20%20%20%20%20%20%20%20%20%20%20%20%3Cdiv%3ECustom%20Sidebar%20Panel%20Body%3C%2Fdiv%3E%0A%20%20%20%20%20%20%20%20%3C%2Fsidebar-panel%3E%0A%20%20%20%20%20%20%20%20%60%0A%20%20%20%20%7D)%20%7B%0A%20%20%20%20%20%20%20%20static%20getName()%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20return%20'custom-sidebar-panel'%0A%20%20%20%20%20%20%20%20%7D%0A%20%20%20%20%20%20%20%20handleActiveEvent()%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20console.log('hello%20world')%0A%20%20%20%20%20%20%20%20%7D%0A%20%20%20%20%7D%0A%20%20%20%20modular.module('custom'%2C%20%5B%5D).registerComponent(CustomSidebarPanel)%3B%0A%0A%20%20%20%20var%20FRAGMENT_ACTION%20%3D%20UIExtension.UIConsts.FRAGMENT_ACTION%0A%20%20%20%20var%20CustomAppearance%20%3D%20UIExtension.appearances.adaptive.extend(%7B%0A%20%20%20%20%20%20%20%20getDefaultFragments%3A%20function()%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20return%20%5B%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20target%3A%20'%40sidebar'%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20action%3A%20FRAGMENT_ACTION.APPEND%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20template%3A%20%60%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%3Ccustom%3Acustom-sidebar-panel%3E%3C%2Fcustom%3Acustom-sidebar-panel%3E%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%60%0A%20%20%20%20%20%20%20%20%20%20%20%20%7D%5D%3B%0A%20%20%20%20%20%20%20%20%7D%0A%20%20%20%20%7D)%3B%0A%20%20%20%20var%20libPath%20%3D%20window.top.location.origin%20%2B%20'%2Flib'%3B%0A%20%20%20%20var%20pdfui%20%3D%20new%20UIExtension.PDFUI(%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20viewerOptions%3A%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20libPath%3A%20libPath%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20jr%3A%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20licenseSN%3A%20licenseSN%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20licenseKey%3A%20licenseKey%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%7D%0A%20%20%20%20%20%20%20%20%20%20%20%20%7D%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20renderTo%3A%20document.body%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20appearance%3A%20CustomAppearance%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20addons%3A%20%5B%5D%20%2F%2F%20No%20addon%20is%20loaded%0A%20%20%20%20%7D)%3B%0A%3C%2Fscript%3E%0A"}},[a("div",{staticClass:"vuepress-plugin-demo-block__display"},[a("div",{staticClass:"vuepress-plugin-demo-block__app"})]),t._v(" "),a("div",{staticClass:"vuepress-plugin-demo-block__code"},[a("div",{staticClass:"language-html extra-class"},[a("pre",{pre:!0,attrs:{class:"language-html"}},[a("code",[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("<")]),t._v("html")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("</")]),t._v("html")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("<")]),t._v("style")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),a("span",{pre:!0,attrs:{class:"token style"}},[a("span",{pre:!0,attrs:{class:"token language-css"}},[t._v("\n    "),a("span",{pre:!0,attrs:{class:"token selector"}},[t._v(".custom-sidebar-icon")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v("background-image")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("linear-gradient")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),t._v("180deg"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("rgba")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),t._v("0"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("245"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("12"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("1"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" 0%"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("rgba")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),t._v("0"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("212"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("255"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("1"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" 100%"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v("width")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(":")]),t._v(" 24px"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v("height")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(":")]),t._v(" 24px"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v("margin-top")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(":")]),t._v(" 12px"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v("margin-left")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(":")]),t._v(" 4px"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n")])]),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("</")]),t._v("style")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("<")]),t._v("script")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),a("span",{pre:!0,attrs:{class:"token script"}},[a("span",{pre:!0,attrs:{class:"token language-javascript"}},[t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v(" modular"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" SeniorComponentFactory "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" UIExtension"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("class")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token class-name"}},[t._v("CustomSidebarPanel")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("extends")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token class-name"}},[t._v("SeniorComponentFactory"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("createSuperClass")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("template")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token template-string"}},[a("span",{pre:!0,attrs:{class:"token template-punctuation string"}},[t._v("`")]),a("span",{pre:!0,attrs:{class:"token string"}},[t._v('\n        <sidebar-panel\n            class="custom-sidebar-panel"\n            icon-class="custom-sidebar-icon"\n            title="Custom"\n            @tooltip\n            tooltip-placement="right" \n            tooltip-title="Custom Sidebar"\n            @on.active="$component.handleActiveEvent()"\n        >\n            <div>Custom Sidebar Panel Body</div>\n        </sidebar-panel>\n        ')]),a("span",{pre:!0,attrs:{class:"token template-punctuation string"}},[t._v("`")])]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("static")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("getName")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("return")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'custom-sidebar-panel'")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("handleActiveEvent")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n            console"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("log")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'hello world'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n    modular"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("module")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'custom'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("[")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("]")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("registerComponent")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),t._v("CustomSidebarPanel"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("FRAGMENT_ACTION")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" UIExtension"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("UIConsts"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("FRAGMENT_ACTION")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" CustomAppearance "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" UIExtension"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("appearances"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("adaptive"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("extend")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token function-variable function"}},[t._v("getDefaultFragments")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("function")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("return")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("[")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("target")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'@sidebar'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("action")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("FRAGMENT_ACTION")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("APPEND")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("template")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token template-string"}},[a("span",{pre:!0,attrs:{class:"token template-punctuation string"}},[t._v("`")]),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("\n                    <custom:custom-sidebar-panel></custom:custom-sidebar-panel>\n                ")]),a("span",{pre:!0,attrs:{class:"token template-punctuation string"}},[t._v("`")])]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("]")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" libPath "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" window"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("top"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("location"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("origin "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("+")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'/lib'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" pdfui "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("new")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token class-name"}},[t._v("UIExtension"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("PDFUI")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("viewerOptions")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("libPath")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" libPath"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("jr")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                    "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("licenseSN")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" licenseSN"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                    "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("licenseKey")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" licenseKey\n                "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("renderTo")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" document"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("body"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("appearance")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" CustomAppearance"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("addons")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("[")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("]")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// No addon is loaded")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n")])]),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("</")]),t._v("script")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n")])])]),a("div",{staticClass:"language-json extra-class"},[a("pre",{pre:!0,attrs:{class:"language-json"}},[a("code",[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v('"iframeOptions"')]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v('"style"')]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v('"height: 600px;"')]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n")])])])]),t._v(" "),a("div",{staticClass:"vuepress-plugin-demo-block__footer"})]),t._v(" "),a("h4",{attrs:{id:"delete-a-sidebar-panel"}},[a("a",{staticClass:"header-anchor",attrs:{href:"#delete-a-sidebar-panel"}},[t._v("#")]),t._v(" Delete a "),a("code",[t._v("sidebar-panel")])]),t._v(" "),a("p",[t._v("If you want to delete the built-in "),a("code",[t._v("sidebar-panel")]),t._v(" component in the SDK, we recommend using Fragment configuration instead of the Component API to delete it, unless it is necessary. This is because initializing a "),a("code",[t._v("sidebar-panel")]),t._v(" component may require a significant amount of resources, and deleting it through Fragment configuration can avoid unnecessary initialization.")]),t._v(" "),a("div",{staticClass:"language-js extra-class"},[a("pre",{pre:!0,attrs:{class:"language-js"}},[a("code",[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("target")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'@layer-sidebar-panel'")]),t._v("，\n    "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("action")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" UIExtension"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("UIConsts"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("FRAGMENT_ACTION")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("REMOVE")]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n")])])]),a("h4",{attrs:{id:"customize-the-internal-components-of-the-built-in-sidebar-panel-in-the-sdk"}},[a("a",{staticClass:"header-anchor",attrs:{href:"#customize-the-internal-components-of-the-built-in-sidebar-panel-in-the-sdk"}},[t._v("#")]),t._v(" Customize the internal components of the built-in "),a("code",[t._v("sidebar-panel")]),t._v(" in the SDK")]),t._v(" "),a("h5",{attrs:{id:"_1-commentlist-sidebar-panel"}},[a("a",{staticClass:"header-anchor",attrs:{href:"#_1-commentlist-sidebar-panel"}},[t._v("#")]),t._v(" 1. commentlist-sidebar-panel")]),t._v(" "),a("p",[t._v("In the commentlist sidebar panel, the CommentCardComponent and ReplyCardComponent can be customized. However, unlike other components, they are dynamically generated based on the current type and number of comments in the document, and their details cannot be modified through Fragment configuration. But we provide events that allow you to obtain the component objects when they are created or deleted, and then modify the details of these components using the Component API.")]),t._v(" "),a("p",[t._v("Here are the descriptions of the relevant events:")]),t._v(" "),a("p",[t._v("1). "),a("code",[t._v("UIExtension.UIEvents.appendCommentListComment")]),t._v(": Triggered when the CommentCardComponent component is inserted. The event callback can obtain the "),a("code",[t._v("commentCardComponent")]),t._v(" and "),a("code",[t._v("annot")]),t._v(" parameters.")]),t._v(" "),a("p",[t._v("2). "),a("code",[t._v("UIExtension.UIEvents.destroyCommentListComment")]),t._v(": Triggered when the CommentCardComponent component is destroyed. The callback parameters are the same as those of the "),a("code",[t._v("appendCommentListComment")]),t._v(" event.")]),t._v(" "),a("p",[t._v("3). "),a("code",[t._v("UIExtension.UIEvents.appendCommentListReply")]),t._v(": Triggered when the ReplyCardComponent component is inserted. The event callback can obtain the "),a("code",[t._v("replyCardComponent")]),t._v(" and "),a("code",[t._v("replyAnnot")]),t._v(" parameters.")]),t._v(" "),a("p",[t._v("4). "),a("code",[t._v("UIExtension.UIEvents.destroyCommentListReply")]),t._v(": Triggered when the ReplyCardComponent component is destroyed. The callback parameters are the same as those of the "),a("code",[t._v("appendCommentListReply")]),t._v(" event.")]),t._v(" "),a("p",[t._v("You can refer to the API Reference for usage information:")]),t._v(" "),a("blockquote",[a("p",[t._v("1). "),a("a",{attrs:{href:"https://developers.foxit.com/resources/pdf-sdk-web/api_reference/class_comment_card_component.html",target:"_blank",rel:"noopener noreferrer"}},[t._v("CommentCardComponent"),a("OutboundLink")],1)]),t._v(" "),a("p",[t._v("2). "),a("a",{attrs:{href:"https://developers.foxit.com/resources/pdf-sdk-web/api_reference/class_reply_card_component.html",target:"_blank",rel:"noopener noreferrer"}},[t._v("ReplyCardComponent"),a("OutboundLink")],1)])]),t._v(" "),a("h5",{attrs:{id:"_2-thumbnail-sidebar-panel"}},[a("a",{staticClass:"header-anchor",attrs:{href:"#_2-thumbnail-sidebar-panel"}},[t._v("#")]),t._v(" 2. thumbnail-sidebar-panel")]),t._v(" "),a("p",[t._v("You can refer to the section: "),a("RouterLink",{attrs:{to:"/ui-extension/customization/customize-thumbnail-list.html"}},[t._v("Customize Thumbnail")])],1),t._v(" "),a("h5",{attrs:{id:"_3-bookmark-sidebar-panel"}},[a("a",{staticClass:"header-anchor",attrs:{href:"#_3-bookmark-sidebar-panel"}},[t._v("#")]),t._v(" 3. bookmark-sidebar-panel")]),t._v(" "),a("p",[t._v("You can refer to the section: "),a("RouterLink",{attrs:{to:"/ui-extension/customization/custom-bookmark.html"}},[t._v("Custom Bookmark")])],1),t._v(" "),a("h5",{attrs:{id:"_4-others"}},[a("a",{staticClass:"header-anchor",attrs:{href:"#_4-others"}},[t._v("#")]),t._v(" 4. Others")]),t._v(" "),a("p",[t._v("Apart from the three mentioned above, "),a("code",[t._v("layer-sidebar-panel")]),t._v(", "),a("code",[t._v("attachment-sidebar-panel")]),t._v(", and "),a("code",[t._v("field-sidebar-panel")]),t._v(" currently do not provide customization capabilities.")]),t._v(" "),a("h3",{attrs:{id:"context-menu"}},[a("a",{staticClass:"header-anchor",attrs:{href:"#context-menu"}},[t._v("#")]),t._v(" Context Menu")]),t._v(" "),a("p",[t._v("The context menu refers to the component implemented based on "),a("a",{attrs:{href:"https://developers.foxit.com/resources/pdf-sdk-web/api_reference/class_context_menu_component.html",target:"_blank",rel:"noopener noreferrer"}},[a("code",[t._v("ContextMenuComponent")]),a("OutboundLink")],1),t._v(". All customizable context menus are implemented based on the same principle:")]),t._v(" "),a("ol",[a("li",[a("p",[t._v("Each context menu for a specific functionality has a fixed name, and replacing a context menu requires specifying the name. After replacement, the name cannot be changed, as it may cause the context menu to not be displayed or overwrite other context menus, affecting the display of other functionalities.")])]),t._v(" "),a("li",[a("p",[t._v("Context menu items can be added, deleted, and replaced through Fragment configuration and the Component API.")])]),t._v(" "),a("li",[a("p",[t._v("The "),a("code",[t._v("contextmenu-separator")]),t._v(" separators at the beginning, end, or in a continuous sequence will be automatically hidden and generally do not need to be specifically controlled for showing or hiding.")])])]),t._v(" "),a("p",[t._v("Next, the context menus for each functional module will be introduced one by one.")]),t._v(" "),a("h4",{attrs:{id:"_1-pdf-page-context-menu"}},[a("a",{staticClass:"header-anchor",attrs:{href:"#_1-pdf-page-context-menu"}},[t._v("#")]),t._v(" 1. PDF Page Context Menu")]),t._v(" "),a("p",[t._v("Please refer to the section "),a("RouterLink",{attrs:{to:"/ui-extension/customization/Page-contextmenu-customization.html"}},[t._v("Customizing Page Context Menu")]),t._v(".")],1),t._v(" "),a("h4",{attrs:{id:"_2-annotation-context-menu"}},[a("a",{staticClass:"header-anchor",attrs:{href:"#_2-annotation-context-menu"}},[t._v("#")]),t._v(" 2. Annotation Context Menu")]),t._v(" "),a("p",[t._v("Please refer to the section "),a("RouterLink",{attrs:{to:"/ui-extension/customization/Annot-contextmenu-customization.html"}},[t._v("Customizing Annotation Context Menu")]),t._v(".")],1),t._v(" "),a("p",[t._v("It should be noted that since the Annotation property dialog does not support customization, when implementing a custom property dialog, the implementation of "),a("code",[t._v("<contextmenu-item-properties>")]),t._v(" needs to be replaced. You can refer to the following example:")]),t._v(" "),a("div",{staticClass:"vuepress-plugin-demo-block__wrapper",staticStyle:{display:"none"},attrs:{"data-config":"%7B%0A%20%20%20%20%22iframeOptions%22%3A%20%7B%0A%20%20%20%20%20%20%20%20%22style%22%3A%20%22height%3A%20600px%3B%22%0A%20%20%20%20%7D%0A%7D%0A","data-type":"vanilla","data-code":"%3Chtml%3E%0A%3C%2Fhtml%3E%0A%3Cstyle%3E%0A%20%20%20%20.custom-sidebar-icon%20%7B%0A%20%20%20%20%20%20%20%20background-image%3A%20linear-gradient(180deg%2C%20rgba(0%2C245%2C12%2C1)%200%25%2C%20rgba(0%2C212%2C255%2C1)%20100%25)%3B%0A%20%20%20%20%20%20%20%20width%3A%2024px%3B%0A%20%20%20%20%20%20%20%20height%3A%2024px%3B%0A%20%20%20%20%20%20%20%20margin-top%3A%2012px%3B%0A%20%20%20%20%20%20%20%20margin-left%3A%204px%3B%0A%20%20%20%20%7D%0A%3C%2Fstyle%3E%0A%3Cscript%3E%0A%20%20%20%20const%20%7B%20modular%2C%20SeniorComponentFactory%20%7D%20%3D%20UIExtension%3B%0A%0A%20%20%20%20class%20CustomAnnotationPropertiesDialog%20extends%20SeniorComponentFactory.createSuperClass(%7B%0A%20%20%20%20%20%20%20%20template%3A%20%60%0A%20%20%20%20%20%20%20%20%20%20%20%20%3Clayer%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20class%3D%22center%22%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%40var.self%3D%22%24component%22%0A%20%20%20%20%20%20%20%20%20%20%20%20%3E%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%3Clayer-header%20%40draggable%3D%22%7B'type'%3A%20'parent'%7D%22%20title%3D%22Annotation%20Properties%22%3E%3C%2Flayer-header%3E%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%3Clayer-view%20style%3D%22padding%3A%201em%22%3E%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%3Cform-group%20label%3D%22Opacity%22%3E%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%3Cslider%20%40model%3D%22self.properties.opacity%22%20min%3D%220%22%20max%3D%22100%22%20step%3D%221%22%20%40on.change%3D%22self.updateOpacity(%24args%5B2%5D)%22%3E%3C%2Fslider%3E%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%3C%2Fform-group%3E%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%3C%2Flayer-view%3E%0A%20%20%20%20%20%20%20%20%20%20%20%20%3C%2Flayer%3E%0A%20%20%20%20%20%20%20%20%60%0A%20%20%20%20%7D)%20%7B%0A%20%20%20%20%20%20%20%20static%20getName()%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20return%20'annotation-properties-dialog'%0A%20%20%20%20%20%20%20%20%7D%0A%20%20%20%20%20%20%20%20init()%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20super.init()%3B%0A%20%20%20%20%20%20%20%20%20%20%20%20this.properties%20%3D%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20opacity%3A%20100%0A%20%20%20%20%20%20%20%20%20%20%20%20%7D%3B%0A%20%20%20%20%20%20%20%20%7D%0A%20%20%20%20%20%20%20%20updateOpacity(newOpacity)%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20this.getPDFUI().getAllActivatedElements().then((%5Belement%5D)%20%3D%3E%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20element.annot.setOpacity(newOpacity%20%2F%20100)%3B%0A%20%20%20%20%20%20%20%20%20%20%20%20%7D)%0A%20%20%20%20%20%20%20%20%7D%0A%20%20%20%20%20%20%20%20doShown()%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20super.doShown()%3B%0A%20%20%20%20%20%20%20%20%20%20%20%20this.getPDFUI().getAllActivatedElements().then((%5Belement%5D)%20%3D%3E%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20this.properties.opacity%20%3D%20element.annot.getOpacity()%20*%20100%3B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20this.digest()%3B%0A%20%20%20%20%20%20%20%20%20%20%20%20%7D)%3B%0A%20%20%20%20%20%20%20%20%7D%0A%20%20%20%20%7D%0A%20%20%20%20class%20CustomAnnotationPropertiesContextmenuItem%20extends%20SeniorComponentFactory.createSuperClass(%7B%0A%20%20%20%20%20%20%20%20template%3A%20%60%3Ccontextmenu-item%20%40on.click%3D%22%24component.showPropertiesDialog()%22%3EShow%20Properties%3C%2Fcontextmenu-item%3E%60%0A%20%20%20%20%7D)%20%7B%0A%20%20%20%20%20%20%20%20static%20getName()%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20return%20'contextmenu-item-show-properties'%0A%20%20%20%20%20%20%20%20%7D%0A%20%20%20%20%20%20%20%20showPropertiesDialog()%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20const%20dialog%20%3D%20this.getRoot().querySelector('%40custom%3Aannotation-properties-dialog')%3B%0A%20%20%20%20%20%20%20%20%20%20%20%20if(dialog)%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20dialog.show()%3B%0A%20%20%20%20%20%20%20%20%20%20%20%20%7D%0A%20%20%20%20%20%20%20%20%7D%0A%20%20%20%20%7D%0A%20%20%20%20modular.module('custom'%2C%20%5B%5D)%0A%20%20%20%20%20%20%20%20.registerComponent(CustomAnnotationPropertiesDialog)%0A%20%20%20%20%20%20%20%20.registerComponent(CustomAnnotationPropertiesContextmenuItem)%0A%20%20%20%20%20%20%20%20%3B%0A%0A%20%20%20%20var%20FRAGMENT_ACTION%20%3D%20UIExtension.UIConsts.FRAGMENT_ACTION%0A%20%20%20%20var%20CustomAppearance%20%3D%20UIExtension.appearances.adaptive.extend(%7B%0A%20%20%20%20%20%20%20%20getDefaultFragments%3A%20function()%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20return%20%5B%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20target%3A%20'template-container'%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20action%3A%20FRAGMENT_ACTION.APPEND%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20template%3A%20%60%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%3Ccustom%3Aannotation-properties-dialog%3E%3C%2Fcustom%3Aannotation-properties-dialog%3E%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%60%0A%20%20%20%20%20%20%20%20%20%20%20%20%7D%2C%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20target%3A%20'%40contextmenu-item-properties'%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20action%3A%20FRAGMENT_ACTION.REPLACE%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20template%3A%20%60%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%3Ccustom%3Acontextmenu-item-show-properties%3E%3C%2Fcustom%3Acontextmenu-item-show-properties%3E%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%60%0A%20%20%20%20%20%20%20%20%20%20%20%20%7D%5D%3B%0A%20%20%20%20%20%20%20%20%7D%0A%20%20%20%20%7D)%3B%0A%20%20%20%20var%20libPath%20%3D%20window.top.location.origin%20%2B%20'%2Flib'%3B%0A%20%20%20%20var%20pdfui%20%3D%20new%20UIExtension.PDFUI(%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20viewerOptions%3A%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20libPath%3A%20libPath%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20jr%3A%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20licenseSN%3A%20licenseSN%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20licenseKey%3A%20licenseKey%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%7D%0A%20%20%20%20%20%20%20%20%20%20%20%20%7D%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20renderTo%3A%20document.body%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20appearance%3A%20CustomAppearance%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20addons%3A%20%5B%5D%20%2F%2F%20No%20addon%20is%20loaded%0A%20%20%20%20%7D)%3B%0A%3C%2Fscript%3E%0A"}},[a("div",{staticClass:"vuepress-plugin-demo-block__display"},[a("div",{staticClass:"vuepress-plugin-demo-block__app"})]),t._v(" "),a("div",{staticClass:"vuepress-plugin-demo-block__code"},[a("div",{staticClass:"language-html extra-class"},[a("pre",{pre:!0,attrs:{class:"language-html"}},[a("code",[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("<")]),t._v("html")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("</")]),t._v("html")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("<")]),t._v("style")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),a("span",{pre:!0,attrs:{class:"token style"}},[a("span",{pre:!0,attrs:{class:"token language-css"}},[t._v("\n    "),a("span",{pre:!0,attrs:{class:"token selector"}},[t._v(".custom-sidebar-icon")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v("background-image")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("linear-gradient")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),t._v("180deg"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("rgba")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),t._v("0"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("245"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("12"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("1"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" 0%"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("rgba")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),t._v("0"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("212"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("255"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("1"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" 100%"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v("width")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(":")]),t._v(" 24px"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v("height")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(":")]),t._v(" 24px"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v("margin-top")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(":")]),t._v(" 12px"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v("margin-left")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(":")]),t._v(" 4px"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n")])]),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("</")]),t._v("style")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("<")]),t._v("script")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),a("span",{pre:!0,attrs:{class:"token script"}},[a("span",{pre:!0,attrs:{class:"token language-javascript"}},[t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v(" modular"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" SeniorComponentFactory "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" UIExtension"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("class")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token class-name"}},[t._v("CustomAnnotationPropertiesDialog")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("extends")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token class-name"}},[t._v("SeniorComponentFactory"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("createSuperClass")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("template")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token template-string"}},[a("span",{pre:!0,attrs:{class:"token template-punctuation string"}},[t._v("`")]),a("span",{pre:!0,attrs:{class:"token string"}},[t._v('\n            <layer\n                class="center"\n                @var.self="$component"\n            >\n                <layer-header @draggable="{\'type\': \'parent\'}" title="Annotation Properties"></layer-header>\n                <layer-view style="padding: 1em">\n                    <form-group label="Opacity">\n                        <slider @model="self.properties.opacity" min="0" max="100" step="1" @on.change="self.updateOpacity($args[2])"></slider>\n                    </form-group>\n                </layer-view>\n            </layer>\n        ')]),a("span",{pre:!0,attrs:{class:"token template-punctuation string"}},[t._v("`")])]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("static")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("getName")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("return")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'annotation-properties-dialog'")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("init")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("super")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("init")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("this")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("properties "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("opacity")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token number"}},[t._v("100")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("updateOpacity")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token parameter"}},[t._v("newOpacity")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("this")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("getPDFUI")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("getAllActivatedElements")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("then")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token parameter"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("[")]),t._v("element"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("]")])]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=>")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                element"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("annot"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("setOpacity")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),t._v("newOpacity "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("/")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token number"}},[t._v("100")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("doShown")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("super")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("doShown")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("this")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("getPDFUI")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("getAllActivatedElements")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("then")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token parameter"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("[")]),t._v("element"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("]")])]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=>")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("this")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("properties"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("opacity "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" element"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("annot"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("getOpacity")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("*")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token number"}},[t._v("100")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("this")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("digest")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("class")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token class-name"}},[t._v("CustomAnnotationPropertiesContextmenuItem")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("extends")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token class-name"}},[t._v("SeniorComponentFactory"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("createSuperClass")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("template")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token template-string"}},[a("span",{pre:!0,attrs:{class:"token template-punctuation string"}},[t._v("`")]),a("span",{pre:!0,attrs:{class:"token string"}},[t._v('<contextmenu-item @on.click="$component.showPropertiesDialog()">Show Properties</contextmenu-item>')]),a("span",{pre:!0,attrs:{class:"token template-punctuation string"}},[t._v("`")])]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("static")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("getName")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("return")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'contextmenu-item-show-properties'")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("showPropertiesDialog")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" dialog "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("this")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("getRoot")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("querySelector")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'@custom:annotation-properties-dialog'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("if")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),t._v("dialog"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                dialog"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("show")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n    modular"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("module")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'custom'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("[")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("]")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("registerComponent")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),t._v("CustomAnnotationPropertiesDialog"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("registerComponent")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),t._v("CustomAnnotationPropertiesContextmenuItem"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("FRAGMENT_ACTION")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" UIExtension"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("UIConsts"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("FRAGMENT_ACTION")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" CustomAppearance "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" UIExtension"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("appearances"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("adaptive"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("extend")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token function-variable function"}},[t._v("getDefaultFragments")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("function")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("return")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("[")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("target")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'template-container'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("action")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("FRAGMENT_ACTION")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("APPEND")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("template")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token template-string"}},[a("span",{pre:!0,attrs:{class:"token template-punctuation string"}},[t._v("`")]),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("\n                    <custom:annotation-properties-dialog></custom:annotation-properties-dialog>\n                ")]),a("span",{pre:!0,attrs:{class:"token template-punctuation string"}},[t._v("`")])]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("target")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'@contextmenu-item-properties'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("action")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("FRAGMENT_ACTION")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("REPLACE")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("template")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token template-string"}},[a("span",{pre:!0,attrs:{class:"token template-punctuation string"}},[t._v("`")]),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("\n                    <custom:contextmenu-item-show-properties></custom:contextmenu-item-show-properties>\n                ")]),a("span",{pre:!0,attrs:{class:"token template-punctuation string"}},[t._v("`")])]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("]")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" libPath "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" window"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("top"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("location"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("origin "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("+")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'/lib'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" pdfui "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("new")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token class-name"}},[t._v("UIExtension"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("PDFUI")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("viewerOptions")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("libPath")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" libPath"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("jr")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                    "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("licenseSN")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" licenseSN"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                    "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("licenseKey")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" licenseKey\n                "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("renderTo")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" document"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("body"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("appearance")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" CustomAppearance"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("addons")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("[")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("]")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// No addon is loaded")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n")])]),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("</")]),t._v("script")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n")])])]),a("div",{staticClass:"language-json extra-class"},[a("pre",{pre:!0,attrs:{class:"language-json"}},[a("code",[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v('"iframeOptions"')]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v('"style"')]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v('"height: 600px;"')]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n")])])])]),t._v(" "),a("div",{staticClass:"vuepress-plugin-demo-block__footer"})]),t._v(" "),a("h4",{attrs:{id:"_3-other-context-menus"}},[a("a",{staticClass:"header-anchor",attrs:{href:"#_3-other-context-menus"}},[t._v("#")]),t._v(" 3. Other Context Menus")]),t._v(" "),a("p",[t._v("Customizing other context menus is similar to the Page context menu and Annotation context menu described above. You can refer to these documents for self-expansion. The templates for relevant menu components can be found in the section "),a("RouterLink",{attrs:{to:"/ui-extension/business-components/pre-configured-components.html#right-click-menu-components"}},[t._v("Pre-configured Components")]),t._v(".")],1),t._v(" "),a("h3",{attrs:{id:"modals"}},[a("a",{staticClass:"header-anchor",attrs:{href:"#modals"}},[t._v("#")]),t._v(" Modals")]),t._v(" "),a("p",[t._v("If it is a pop-up within the SDK, including alert, prompt, confirm, and loading overlay, we can define these components triggered by the SDK internally through Viewer UI. For specific usage, please refer to the section "),a("RouterLink",{attrs:{to:"/main/features/viewer-ui.html"}},[t._v("Viewer UI")]),t._v(".")],1),t._v(" "),a("h2",{attrs:{id:"controller-reusability"}},[a("a",{staticClass:"header-anchor",attrs:{href:"#controller-reusability"}},[t._v("#")]),t._v(" Controller Reusability")]),t._v(" "),a("p",[t._v("Below is a list utilizing the "),a("code",[t._v("@controller")]),t._v(" directive syntax, enumerating the currently reusable controller implementations within the SDK. Module names are listed before the colon, and controller names are listed after the colon.")]),t._v(" "),a("h3",{attrs:{id:"built-in-controllers-in-uiextension"}},[a("a",{staticClass:"header-anchor",attrs:{href:"#built-in-controllers-in-uiextension"}},[t._v("#")]),t._v(" Built-in Controllers in UIExtension")]),t._v(" "),a("p",[t._v("Built-in controllers can be directly accessed using "),a("code",[t._v("UIExtension.modular.module('module name').getController('controller name')")]),t._v(" to retrieve the class.")]),t._v(" "),a("ol",[a("li",[a("code",[t._v("states:HandController")]),t._v(": Switches the current StateHandler to "),a("code",[t._v("STATE_HANDLER_NAMES.STATE_HANDLER_HAND")]),t._v(".")]),t._v(" "),a("li",[a("code",[t._v("marquee:MarqueeToolController")]),t._v(": Switches the current StateHandler to "),a("code",[t._v("STATE_HANDLER_NAMES.STATE_HANDLER_MARQUEE")]),t._v(".")]),t._v(" "),a("li",[a("code",[t._v("loupe:LoupeController")]),t._v(": Switches the current StateHandler to "),a("code",[t._v("STATE_HANDLER_NAMES.STATE_HANDLER_LOUPE")]),t._v(".")]),t._v(" "),a("li",[a("code",[t._v("states:SnapshotToolController")]),t._v(": Switches the current StateHandler to "),a("code",[t._v("STATE_HANDLER_NAMES.STATE_HANDLER_SNAPSHOT_TOOL")]),t._v(".")]),t._v(" "),a("li",[a("code",[t._v("file:DownloadFileController")]),t._v(": Used to download the currently open document.")]),t._v(" "),a("li",[a("code",[t._v("zoom:ZoomInAndOutController")]),t._v(": Controls document view zooming, and needs to be used with the "),a("code",[t._v("action")]),t._v(" attribute. Optional values are: "),a("code",[t._v('action="zoomin"')]),t._v(" and "),a("code",[t._v('action="zoomout"')]),t._v(".")]),t._v(" "),a("li",[a("code",[t._v("pagemode:SinglePageModeController")]),t._v(": Switches page mode to single page mode.")]),t._v(" "),a("li",[a("code",[t._v("pagemode:ContinuousPageModeController")]),t._v(": Switches page mode to continuous page mode.")]),t._v(" "),a("li",[a("code",[t._v("pagemode:FacingPageModeController")]),t._v(": Switches page mode to facing page mode.")]),t._v(" "),a("li",[a("code",[t._v("pagemode:ContinuousFacingPageModeController")]),t._v(": Switches page mode to continuous facing page mode.")]),t._v(" "),a("li",[a("code",[t._v("states:CreateTextController")]),t._v(": Switches the current StateHandler to "),a("code",[t._v("STATE_HANDLER_NAMES.STATE_HANDLER.STATE_HANDLER_CREATE_TEXT")]),t._v(".")]),t._v(" "),a("li",[a("code",[t._v("states:CreateFileAttachmentController")]),t._v(": Switches the current StateHandler to "),a("code",[t._v("STATE_HANDLER_NAMES.STATE_HANDLER.STATE_HANDLER_CREATE_FILE_ATTACHMENT")]),t._v(".")]),t._v(" "),a("li",[a("code",[t._v("states:CreateHighlightController")]),t._v(": Switches the current StateHandler to "),a("code",[t._v("STATE_HANDLER_NAMES.STATE_HANDLER.STATE_HANDLER_CREATE_HIGHLIGHT")]),t._v(".")]),t._v(" "),a("li",[a("code",[t._v("states:CreateStrikeoutController")]),t._v(": Switches the current StateHandler to "),a("code",[t._v("STATE_HANDLER_NAMES.STATE_HANDLER.STATE_HANDLER_CREATE_STRIKE_OUT")]),t._v(".")]),t._v(" "),a("li",[a("code",[t._v("states:CreateUnderlineController")]),t._v(": Switches the current StateHandler to "),a("code",[t._v("STATE_HANDLER_NAMES.STATE_HANDLER.STATE_HANDLER_CREATE_UNDERLINE")]),t._v(".")]),t._v(" "),a("li",[a("code",[t._v("states:CreateSquigglyController")]),t._v(": Switches the current StateHandler to "),a("code",[t._v("STATE_HANDLER_NAMES.STATE_HANDLER.STATE_HANDLER_CREATE_SQUIGGLY")]),t._v(".")]),t._v(" "),a("li",[a("code",[t._v("states:CreateReplaceController")]),t._v(": Switches the current StateHandler to "),a("code",[t._v("STATE_HANDLER_NAMES.STATE_HANDLER.STATE_HANDLER_CREATE_REPLACE")]),t._v(".")]),t._v(" "),a("li",[a("code",[t._v("states:CreateCaretController")]),t._v(": Switches the current StateHandler to "),a("code",[t._v("STATE_HANDLER_NAMES.STATE_HANDLER.STATE_HANDLER_CREATE_CARET")]),t._v(".")]),t._v(" "),a("li",[a("code",[t._v("states:CreateTypewriterController")]),t._v(": Switches the current StateHandler to "),a("code",[t._v("STATE_HANDLER_NAMES.STATE_HANDLER.STATE_HANDLER_CREATE_TYPEWRITER")]),t._v(".")]),t._v(" "),a("li",[a("code",[t._v("states:CreateCalloutController")]),t._v(": Switches the current StateHandler to "),a("code",[t._v("STATE_HANDLER_NAMES.STATE_HANDLER.STATE_HANDLER_CREATE_FREETEXT_CALLOUT")]),t._v(".")]),t._v(" "),a("li",[a("code",[t._v("states:CreateTextboxController")]),t._v(": Switches the current StateHandler to "),a("code",[t._v("STATE_HANDLER_NAMES.STATE_HANDLER.STATE_HANDLER_CREATE_FREETEXT_BOX")]),t._v(".")]),t._v(" "),a("li",[a("code",[t._v("states:CreateAreaHighlightController")]),t._v(": Switches the current StateHandler to "),a("code",[t._v("STATE_HANDLER_NAMES.STATE_HANDLER.STATE_HANDLER_CREATE_AREA_HIGHLIGHT")]),t._v(".")]),t._v(" "),a("li",[a("code",[t._v("states:CreatePencilController")]),t._v(": Switches the current StateHandler to "),a("code",[t._v("STATE_HANDLER_NAMES.STATE_HANDLER.PENCIL")]),t._v(".")]),t._v(" "),a("li",[a("code",[t._v("states:EraserController")]),t._v(": Switches the current StateHandler to "),a("code",[t._v("STATE_HANDLER_NAMES.STATE_HANDLER.STATE_HANDLER_ERASER")]),t._v(".")]),t._v(" "),a("li",[a("code",[t._v("states:CreateLinkController")]),t._v(": Switches the current StateHandler to "),a("code",[t._v("STATE_HANDLER_NAMES.STATE_HANDLER.STATE_HANDLER_CREATE_LINK")]),t._v(".")]),t._v(" "),a("li",[a("code",[t._v("states:CreateImageController")]),t._v(": Switches the current StateHandler to "),a("code",[t._v("STATE_HANDLER_NAMES.STATE_HANDLER.STATE_HANDLER_CREATE_IMAGE")]),t._v(".")]),t._v(" "),a("li",[a("code",[t._v("zoom:DropdownZoomInAndOutController")]),t._v(": Same as "),a("code",[t._v("zoom:ZoomInAndOutController")]),t._v(", but can only be used in dropdown subcomponents.")]),t._v(" "),a("li",[a("code",[t._v("zoom:ZoomActionController")]),t._v(": Controls document view zooming, and is different from "),a("code",[t._v("zoom:ZoomInAndOutController")]),t._v(" in that it needs to specify the target zoom level (non-numeric): "),a("code",[t._v("action='fitHeight'")]),t._v(", "),a("code",[t._v("action='fitWidth'")]),t._v(", "),a("code",[t._v("action='fitVisible'")]),t._v(".")]),t._v(" "),a("li",[a("code",[t._v("gotoview:GotoFirstPageController")]),t._v(": Jumps to the first page.")]),t._v(" "),a("li",[a("code",[t._v("gotoview:GotoPrevPageController")]),t._v(": Jumps to the previous page.")]),t._v(" "),a("li",[a("code",[t._v("gotoview:GotoNextPageController")]),t._v(": Jumps to the next page.")]),t._v(" "),a("li",[a("code",[t._v("gotoview:GotoLastPageController")]),t._v(": Jumps to the last page.")]),t._v(" "),a("li",[a("code",[t._v("states:CreateSquareController")]),t._v(": Switches the current StateHandler to "),a("code",[t._v("STATE_HANDLER_NAMES.STATE_HANDLER.STATE_HANDLER_CREATE_SQUARE")]),t._v(".")]),t._v(" "),a("li",[a("code",[t._v("states:CreateCircleController")]),t._v(": Switches the current StateHandler to "),a("code",[t._v("STATE_HANDLER_NAMES.STATE_HANDLER.STATE_HANDLER_CREATE_CIRCLE")]),t._v(".")]),t._v(" "),a("li",[a("code",[t._v("states:CreatePolygonController")]),t._v(": Switches the current StateHandler to "),a("code",[t._v("STATE_HANDLER_NAMES.STATE_HANDLER.STATE_HANDLER_CREATE_POLYGON")]),t._v(".")]),t._v(" "),a("li",[a("code",[t._v("states:CreatePolygonCloudController")]),t._v(": Switches the current StateHandler to "),a("code",[t._v("STATE_HANDLER_NAMES.STATE_HANDLER.STATE_HANDLER_CREATE_POLYGON_CLOUD")]),t._v(".")]),t._v(" "),a("li",[a("code",[t._v("states:CreateArrowController")]),t._v(": Switches the current StateHandler to "),a("code",[t._v("STATE_HANDLER_NAMES.STATE_HANDLER.STATE_HANDLER_CREATE_ARROW")]),t._v(".")]),t._v(" "),a("li",[a("code",[t._v("states:CreateLineController")]),t._v(": Switches the current StateHandler to "),a("code",[t._v("STATE_HANDLER_NAMES.STATE_HANDLER.STATE_HANDLER_CREATE_LINE")]),t._v(".")]),t._v(" "),a("li",[a("code",[t._v("states:CreatePolylineController")]),t._v(": Switches the current StateHandler to "),a("code",[t._v("STATE_HANDLER_NAMES.STATE_HANDLER.STATE_HANDLER_CREATE_POLYLINE")]),t._v(".")]),t._v(" "),a("li",[a("code",[t._v("distance:CreateDistanceController")]),t._v(": Switches the current StateHandler to "),a("code",[t._v("STATE_HANDLER_NAMES.STATE_HANDLER.STATE_HANDLER_CREATE_DISTANCE")]),t._v(".")]),t._v(" "),a("li",[a("code",[t._v("distance:CreatePerimeterController")]),t._v(": Switches the current StateHandler to "),a("code",[t._v("STATE_HANDLER_NAMES.STATE_HANDLER.STATE_HANDLER_CREATE_PERIMETER")]),t._v(".")]),t._v(" "),a("li",[a("code",[t._v("distance:CreateAreaController")]),t._v(": Switches the current StateHandler to "),a("code",[t._v("STATE_HANDLER_NAMES.STATE_HANDLER.STATE_HANDLER_CREATE_AREA")]),t._v(".")]),t._v(" "),a("li",[a("code",[t._v("distance:CreateCircleAreaController")]),t._v(": Switches the current StateHandler to "),a("code",[t._v("STATE_HANDLER_NAMES.STATE_HANDLER.STATE_HANDLER_CREATE_CIRCLE_AREA")]),t._v(".")]),t._v(" "),a("li",[a("code",[t._v("comment-list:ExportCommentController")]),t._v(": Exports the comments of the current document in a specified format, with the format specified by the format attribute: "),a("code",[t._v('format="XFDF"')]),t._v(", which supports XFDF, FDF, and JSON formats.")]),t._v(" "),a("li",[a("code",[t._v("text-sel:CopySelectedTextController")]),t._v(": Copies the selected text.")]),t._v(" "),a("li",[a("code",[t._v("text-sel:CreateTextHighlightOnSelectedTextController")]),t._v(":  Creates a text highlight annotation within the selected text range.")]),t._v(" "),a("li",[a("code",[t._v("text-sel:CreateStrikeoutOnSelectedTextController")]),t._v(": Creates a Strikeout annotation within the selected text range.")]),t._v(" "),a("li",[a("code",[t._v("text-sel:CreateUnderlineOnSelectedTextController")]),t._v(": Creates a Underline annotation within the selected text range.")]),t._v(" "),a("li",[a("code",[t._v("text-sel:CreateBookmarkOnSelectedTextController")]),t._v(": Adds the selected text to the bookmark list.")]),t._v(" "),a("li",[a("code",[t._v("states:RibbonSelectTextImageController")]),t._v(": Switches the current StateHandler to "),a("code",[t._v("STATE_HANDLER_NAMES.STATE_HANDLER_SELECT_TEXT_IMAGE")]),t._v(".")]),t._v(" "),a("li",[a("code",[t._v("states:RibbonSelectTextAnnotationController")]),t._v(": Switches the current StateHandler to "),a("code",[t._v("STATE_HANDLER_NAMES.STATE_HANDLER_SELECT_ANNOTATION")]),t._v(".")]),t._v(" "),a("li",[a("code",[t._v("change-color:ChangeColorController")]),t._v(": Used to change the document background color.")]),t._v(" "),a("li",[a("code",[t._v("comment-list:ImportCommentButtonController")]),t._v(": Used to import comment data into the document.")]),t._v(" "),a("li",[a("code",[t._v("states:SelectTextImageController")]),t._v(": Switches the current StateHandler to "),a("code",[t._v("STATE_HANDLER_NAMES.STATE_HANDLER_SELECT_TEXT_IMAGE")]),t._v(".")]),t._v(" "),a("li",[a("code",[t._v("states:SelectAnnotationController")]),t._v(": Switches the current StateHandler to "),a("code",[t._v("STATE_HANDLER_NAMES.STATE_HANDLER_SELECT_ANNOTATION")]),t._v(".")]),t._v(" "),a("li",[a("code",[t._v("zoom:ContextMenuZoomActionController")]),t._v(": Controls document view zooming, and needs to specify the "),a("code",[t._v("action")]),t._v(" attribute. Available values are: "),a("code",[t._v("fitWidth")]),t._v(", "),a("code",[t._v("fitHeight")]),t._v(", "),a("code",[t._v("fitVisible")]),t._v(", and numeric values.")]),t._v(" "),a("li",[a("code",[t._v("ui-rotation:RotateRightController")]),t._v(": Controls document view rotation to the right by 90 degrees.")]),t._v(" "),a("li",[a("code",[t._v("ui-rotation:RotateLeftController")]),t._v(": Controls document view rotation to the left by 90 degrees.")]),t._v(" "),a("li",[a("code",[t._v("annot-opr:ShowAnnotReplyController")]),t._v(": Used to open the commentlist on the left panel, locate the selected annotation, and focus on the reply input box.")]),t._v(" "),a("li",[a("code",[t._v("annot-opr:DeleteAnnotController")]),t._v(": Deletes the selected annotation.")]),t._v(" "),a("li",[a("code",[t._v("annot-opr:ShowAnnotPropertiesController")]),t._v(": Displays the annotation properties dialog.")]),t._v(" "),a("li",[a("code",[t._v("annot-opr:SetPropsDefault")]),t._v(": Sets the current annotation properties as default, which will be used for creating annotations next time.")])]),t._v(" "),a("h3",{attrs:{id:"controllers-in-uiextension-addons"}},[a("a",{staticClass:"header-anchor",attrs:{href:"#controllers-in-uiextension-addons"}},[t._v("#")]),t._v(" Controllers in UIExtension Addons")]),t._v(" "),a("p",[t._v("To retrieve the controller classes in Addons, use the same method as retrieving the built-in controller classes in UIExtensions, but make sure that the Addons have been loaded before retrieval.")]),t._v(" "),a("ol",[a("li",[t._v("page-template addon:\n"),a("ol",[a("li",[a("code",[t._v("page-template:ShowPageTemplateDialogController")]),t._v(": Switches the current StateHandler to "),a("code",[t._v("STATE_HANDLER_NAMES.STATE_HANDLER")]),t._v(".")])])]),t._v(" "),a("li",[t._v("form-designer addon:\n"),a("ol",[a("li",[a("code",[t._v("form-designer:CreatePushButtonController")]),t._v(": Switches the current StateHandler to "),a("code",[t._v("STATE_HANDLER_NAMES.STATE_HANDLER_CREATE_FIELD_PUSH_BUTTON")]),t._v(".")]),t._v(" "),a("li",[a("code",[t._v("form-designer:CreateCheckBoxController")]),t._v(": Switches the current StateHandler to "),a("code",[t._v("STATE_HANDLER_NAMES.STATE_HANDLER_CREATE_FIELD_CHECK_BOX")]),t._v(".")]),t._v(" "),a("li",[a("code",[t._v("form-designer:CreateRadioButtonController")]),t._v(": Switches the current StateHandler to "),a("code",[t._v("STATE_HANDLER_NAMES.STATE_HANDLER_CREATE_RADIO_BUTTON")]),t._v(".")]),t._v(" "),a("li",[a("code",[t._v("form-designer:CreateComboBoxController")]),t._v(": Switches the current StateHandler to "),a("code",[t._v("STATE_HANDLER_NAMES.STATE_HANDLER_CREATE_FIELD_COMBO_BOX")]),t._v(".")]),t._v(" "),a("li",[a("code",[t._v("form-designer:CreateListBoxController")]),t._v(": Switches the current StateHandler to "),a("code",[t._v("STATE_HANDLER_NAMES.STATE_HANDLER_CREATE_FIELD_LIST_BOX")]),t._v(".")]),t._v(" "),a("li",[a("code",[t._v("form-designer:CreateTextController")]),t._v(": Switches the current StateHandler to "),a("code",[t._v("STATE_HANDLER_NAMES.STATE_HANDLER_CREATE_FIELD_TEXT")]),t._v(".")]),t._v(" "),a("li",[a("code",[t._v("form-designer:CreateSignController")]),t._v(": Switches the current StateHandler to "),a("code",[t._v("STATE_HANDLER_NAMES.STATE_HANDLER_CREATE_FIELD_SIGNATURE")]),t._v(".")]),t._v(" "),a("li",[a("code",[t._v("form-designer:CreateImageController")]),t._v(": Switches the current StateHandler to "),a("code",[t._v("STATE_HANDLER_NAMES.STATE_HANDLER_CREATE_FIELD_IMAGE")]),t._v(".")]),t._v(" "),a("li",[a("code",[t._v("form-designer:CreateDateController")]),t._v(": Switches the current StateHandler to "),a("code",[t._v("STATE_HANDLER_NAMES.STATE_HANDLER_CREATE_FIELD_DATE")]),t._v(".")])])]),t._v(" "),a("li",[t._v("page-editor addon:\n"),a("ol",[a("li",[a("code",[t._v("page-editor:EditObjectController")]),t._v(': Switches the current StateHandler to "Page Object Editing" tool, including text, image, shape, and gradient objects.')]),t._v(" "),a("li",[a("code",[t._v("page-editor:AddImageAdvController")]),t._v(': Switches the current StateHandler to "Add Image from File" tool.')]),t._v(" "),a("li",[a("code",[t._v("page-editor:AddShapesController")]),t._v(': Switches the current StateHandler to "Create Shape" tool.')]),t._v(" "),a("li",[a("code",[t._v("page-editor:AddTextController")]),t._v(': Switches the current StateHandler to "Add Text" tool.')])])]),t._v(" "),a("li",[t._v("fullscreen addon:\n"),a("ol",[a("li",[a("code",[t._v("full-screen:FullscreenController")]),t._v(": Toggles the full screen mode.")])])]),t._v(" "),a("li",[t._v("print addon:\n"),a("ol",[a("li",[a("code",[t._v("print:ShowPrintDialogController")]),t._v(": Displays the print dialog.")])])]),t._v(" "),a("li",[t._v("file-property addon:\n"),a("ol",[a("li",[a("code",[t._v("fpmodule:FileInfoCallbackController")]),t._v(": Displays the document property dialog.")])])]),t._v(" "),a("li",[t._v("h-continuous addon:\n"),a("ol",[a("li",[a("code",[t._v("h-continuous:HContinuousViewModeController")]),t._v(": Switches the page mode to horizontal continuous page mode.")])])]),t._v(" "),a("li",[t._v("export-form addon:\n"),a("ol",[a("li",[a("code",[t._v("export-form-module:ExportToXMLController")]),t._v(": Exports the form of the current document to an XML format file.")]),t._v(" "),a("li",[a("code",[t._v("export-form-module:ExportToFDFController")]),t._v(": Exports the form of the current document to an FDF format file.")]),t._v(" "),a("li",[a("code",[t._v("export-form-module:ExportToXFDFController")]),t._v(": Exports the form of the current document to an XFDF format file.")]),t._v(" "),a("li",[a("code",[t._v("export-form-module:ExportToCSVController")]),t._v(": Exports the form of the current document to a CSV format file.")]),t._v(" "),a("li",[a("code",[t._v("export-form-module:ExportToTXTController")]),t._v(": Exports the form of the current document to a TXT format file.")])])]),t._v(" "),a("li",[t._v("comparison addon:\n"),a("ol",[a("li",[a("code",[t._v("comparison:ShowCompareFileDialogButtonController")]),t._v(": Displays the document comparison dialog.")])])]),t._v(" "),a("li",[t._v("redaction addon:\n"),a("ol",[a("li",[a("code",[t._v("redaction:RedactionTextAndImageController")]),t._v(": Switches the current StateHandler to the Redaction tool for creating marked text and images.")]),t._v(" "),a("li",[a("code",[t._v("redaction:RedactionController")]),t._v(": Switches the current StateHandler to the Redaction tool for creating marked areas.")]),t._v(" "),a("li",[a("code",[t._v("redaction:RedactionPageController")]),t._v(": Switches the current StateHandler to the Redaction tool for creating marked pages.")])])])]),t._v(" "),a("p",[t._v("With these controllers, we can rewrite the components while reusing the built-in implementation logic of the SDK. Let's take an example of "),a("code",[t._v("states:HandController")]),t._v(", which can switch the current StateHandler tool to the Hand tool and can determine whether the current tool is the hand tool to activate/deactivate the component:")]),t._v(" "),a("div",{staticClass:"vuepress-plugin-demo-block__wrapper",staticStyle:{display:"none"},attrs:{"data-config":"%7B%0A%20%20%20%20%22iframeOptions%22%3A%20%7B%0A%20%20%20%20%20%20%20%20%22style%22%3A%20%22height%3A%20600px%3B%22%0A%20%20%20%20%7D%0A%7D%0A","data-type":"vanilla","data-code":"%3Chtml%3E%0A%3C%2Fhtml%3E%0A%3Cstyle%3E%0A%20%20%20%20.custom-hand-icon%20%7B%0A%20%20%20%20%20%20%20%20background-image%3A%20linear-gradient(180deg%2C%20rgba(0%2C245%2C12%2C1)%200%25%2C%20rgba(0%2C212%2C255%2C1)%20100%25)%3B%0A%20%20%20%20%7D%0A%3C%2Fstyle%3E%0A%3Cscript%3E%0A%20%20%20%20var%20FRAGMENT_ACTION%20%3D%20UIExtension.UIConsts.FRAGMENT_ACTION%0A%20%20%20%20var%20CustomAppearance%20%3D%20UIExtension.appearances.adaptive.extend(%7B%0A%20%20%20%20%20%20%20%20getDefaultFragments%3A%20function()%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20return%20%5B%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20target%3A%20'hand-tool'%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20action%3A%20FRAGMENT_ACTION.REPLACE%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20template%3A%20%60%3Cxbutton%20%40tooltip%20tooltip-title%3D%22toolbar.tooltip.hand.title%22%20name%3D%22hand-tool%22%20icon-class%3D%22fv__icon-toolbar-hand%22%20%40controller%3D%22states%3AHandController%22%3E%3C%2Fxbutton%3E%60%0A%20%20%20%20%20%20%20%20%20%20%20%20%7D%5D%3B%0A%20%20%20%20%20%20%20%20%7D%0A%20%20%20%20%7D)%3B%0A%20%20%20%20var%20libPath%20%3D%20window.top.location.origin%20%2B%20'%2Flib'%3B%0A%20%20%20%20var%20pdfui%20%3D%20new%20UIExtension.PDFUI(%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20viewerOptions%3A%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20libPath%3A%20libPath%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20jr%3A%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20licenseSN%3A%20licenseSN%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20licenseKey%3A%20licenseKey%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%7D%0A%20%20%20%20%20%20%20%20%20%20%20%20%7D%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20renderTo%3A%20document.body%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20appearance%3A%20CustomAppearance%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20addons%3A%20%5B%5D%20%2F%2F%20No%20addon%20is%20loaded%0A%20%20%20%20%7D)%3B%0A%3C%2Fscript%3E%0A"}},[a("div",{staticClass:"vuepress-plugin-demo-block__display"},[a("div",{staticClass:"vuepress-plugin-demo-block__app"})]),t._v(" "),a("div",{staticClass:"vuepress-plugin-demo-block__code"},[a("div",{staticClass:"language-html extra-class"},[a("pre",{pre:!0,attrs:{class:"language-html"}},[a("code",[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("<")]),t._v("html")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("</")]),t._v("html")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("<")]),t._v("style")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),a("span",{pre:!0,attrs:{class:"token style"}},[a("span",{pre:!0,attrs:{class:"token language-css"}},[t._v("\n    "),a("span",{pre:!0,attrs:{class:"token selector"}},[t._v(".custom-hand-icon")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v("background-image")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("linear-gradient")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),t._v("180deg"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("rgba")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),t._v("0"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("245"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("12"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("1"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" 0%"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("rgba")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),t._v("0"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("212"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("255"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("1"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" 100%"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n")])]),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("</")]),t._v("style")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("<")]),t._v("script")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),a("span",{pre:!0,attrs:{class:"token script"}},[a("span",{pre:!0,attrs:{class:"token language-javascript"}},[t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("FRAGMENT_ACTION")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" UIExtension"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("UIConsts"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("FRAGMENT_ACTION")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" CustomAppearance "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" UIExtension"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("appearances"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("adaptive"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("extend")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token function-variable function"}},[t._v("getDefaultFragments")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("function")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("return")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("[")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("target")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'hand-tool'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("action")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("FRAGMENT_ACTION")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("REPLACE")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("template")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token template-string"}},[a("span",{pre:!0,attrs:{class:"token template-punctuation string"}},[t._v("`")]),a("span",{pre:!0,attrs:{class:"token string"}},[t._v('<xbutton @tooltip tooltip-title="toolbar.tooltip.hand.title" name="hand-tool" icon-class="fv__icon-toolbar-hand" @controller="states:HandController"></xbutton>')]),a("span",{pre:!0,attrs:{class:"token template-punctuation string"}},[t._v("`")])]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("]")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" libPath "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" window"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("top"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("location"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("origin "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("+")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'/lib'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" pdfui "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("new")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token class-name"}},[t._v("UIExtension"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("PDFUI")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("viewerOptions")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("libPath")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" libPath"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("jr")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                    "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("licenseSN")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" licenseSN"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                    "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("licenseKey")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" licenseKey\n                "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("renderTo")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" document"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("body"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("appearance")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" CustomAppearance"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("addons")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("[")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("]")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// No addon is loaded")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n")])]),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("</")]),t._v("script")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n")])])]),a("div",{staticClass:"language-json extra-class"},[a("pre",{pre:!0,attrs:{class:"language-json"}},[a("code",[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v('"iframeOptions"')]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v('"style"')]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v('"height: 600px;"')]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n")])])])]),t._v(" "),a("div",{staticClass:"vuepress-plugin-demo-block__footer"})]),t._v(" "),a("p",[t._v("Of course, some controllers are not as simple as "),a("code",[t._v("states:HandController")]),t._v(". Here are some of the more special controllers. When using them, we need to follow the methods provided in the examples:")]),t._v(" "),a("div",{staticClass:"vuepress-plugin-demo-block__wrapper",staticStyle:{display:"none"},attrs:{"data-config":"%7B%0A%20%20%20%20%22iframeOptions%22%3A%20%7B%0A%20%20%20%20%20%20%20%20%22style%22%3A%20%22height%3A%20600px%3B%22%0A%20%20%20%20%7D%0A%7D%0A","data-type":"vanilla","data-code":"%3Cstyle%3E%0A%20%20%20%20.fv__ui-paddle-horizontal%20.fv__ui-paddle-content%20%7B%0A%20%20%20%20%20%20%20%20display%3A%20flex%3B%0A%20%20%20%20%20%20%20%20align-items%3A%20center%3B%0A%20%20%20%20%7D%0A%20%20%20%20.custom-change-color-panel%20%7B%0A%20%20%20%20%20%20%20%20display%3A%20inline-flex%3B%0A%20%20%20%20%20%20%20%20align-items%3A%20center%3B%0A%20%20%20%20%7D%0A%3C%2Fstyle%3E%0A%3Cscript%3E%0A%20%20%20%20var%20FRAGMENT_ACTION%20%3D%20UIExtension.UIConsts.FRAGMENT_ACTION%0A%20%20%20%20var%20CustomAppearance%20%3D%20UIExtension.appearances.adaptive.extend(%7B%0A%20%20%20%20%20%20%20%20getDefaultFragments%3A%20function()%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20return%20%5B%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20target%3A%20'fv--view-tab-paddle'%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20action%3A%20FRAGMENT_ACTION.APPEND%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20template%3A%20'%3Cgroup-list%20name%3D%22custom-component-group-list%22%3E%3C%2Fgroup-list%3E'%0A%20%20%20%20%20%20%20%20%20%20%20%20%7D%2C%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20target%3A%20'custom-component-group-list'%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20action%3A%20FRAGMENT_ACTION.APPEND%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20template%3A%20%60%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%3Cgroup%3E%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%3Cdiv%20class%3D%22custom-change-color-panel%22%20name%3D%22change-color-panel%22%20%40controller%3D%22change-color%3AChangeColorController%20as%20ctrl%22%20%40var.self%3D%22%24component%22%20%3E%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%3Cxbutton%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%40foreach%3D%22color%20in%20colors%20track%20by%20background%22%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%40class%3D%22%7B'fv__ui-change-color-dropdown-color-round'%3A%20true%2C%20'moon'%3A%20!!color.type%2C%20'selected'%3A%20selectedIndex%20%3D%3D%3D%20%24index%7D%22%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%40sync.attr.style%3D%22color.type%20%3D%3D%3D%20'moon'%20%3F%20''%20%3A%20('background-color%3A'%20%2B%20color.background)%22%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%40on.click%3D%22ctrl.changeColor(color%2C%20%24index)%22%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%40tooltip%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20tooltip-title%3D%22%40%7Bcolor%7Cjson%7D%22%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%3E%3C%2Fxbutton%3E%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%3C%2Fdiv%3E%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%3C%2Fgroup%3E%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%60%0A%20%20%20%20%20%20%20%20%20%20%20%20%7D%2C%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20target%3A%20'custom-component-group-list'%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20action%3A%20FRAGMENT_ACTION.APPEND%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20template%3A%20%60%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%3Cgroup%3E%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%3Cxbutton%20%40controller%3D%22zoom%3AZoomInAndOutController%22%20action%3D%22zoomin%22%20icon-class%3D%22fv__icon-toolbar-zoom-in%22%3E%3C%2Fxbutton%3E%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%3C%2Fgroup%3E%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%60%0A%20%20%20%20%20%20%20%20%20%20%20%20%7D%2C%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20target%3A%20'custom-component-group-list'%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20action%3A%20FRAGMENT_ACTION.APPEND%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20template%3A%20%60%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%3Cgroup%3E%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%3Cdropdown%20name%3D%22fv--inner-zoom-ribbon-dropdown%22%20%40aria%3Alabel.list%3D%22aria%3Alabels.setzoom%22%20icon-class%3D%22fv__icon-toolbar-zoom-in%22%20class%3D%22fv__ui-dropdown-hide-text%22%20selected%3D%220%22%20%40on.selected%3D%22self.select(%24args%5B0%5D)%22%3E%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%3Cxbutton%20name%3D%22dropdown-zoom-in%22%20action%3D%22zoomin%22%20%40controller%3D%22zoom%3ADropdownZoomInAndOutController%22%20icon-class%3D%22fv__icon-toolbar-zoom-in%22%20ribbon-icon%3D%22fx-icon-ribbon_home_zoomin-32%22%20tooltip-title%3D%22toolbar.buttons.zoomin%22%3Etoolbar.buttons.zoomin%3C%2Fxbutton%3E%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%3Cxbutton%20name%3D%22dropdown-zoom-out%22%20action%3D%22zoomout%22%20%40controller%3D%22zoom%3ADropdownZoomInAndOutController%22%20icon-class%3D%22fv__icon-toolbar-zoom-out%22%20ribbon-icon%3D%22fx-icon-ribbon_home_zoomout-32%22%20tooltip-title%3D%22toolbar.buttons.zoomout%22%3Etoolbar.buttons.zoomout%3C%2Fxbutton%3E%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%3Cxbutton%20name%3D%22dropdown-zoom-fitpage%22%20action%3D%22fitHeight%22%20%40controller%3D%22zoom%3AZoomActionController%22%20icon-class%3D%22fv__icon-toolbar-fit-page%22%20ribbon-icon%3D%22fx-icon-ribbon_home_fitpage-32%22%20tooltip-title%3D%22toolbar.buttons.fitHeight%22%3Etoolbar.buttons.fitHeight%3C%2Fxbutton%3E%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%3Cxbutton%20name%3D%22dropdown-zoom-fitwidth%22%20action%3D%22fitWidth%22%20%40controller%3D%22zoom%3AZoomActionController%22%20icon-class%3D%22fv__icon-toolbar-fit-width%22%20ribbon-icon%3D%22fx-icon-ribbon_home_fitwidth-32%22%20tooltip-title%3D%22toolbar.buttons.fitWidth%22%3Etoolbar.buttons.fitWidth%3C%2Fxbutton%3E%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%3Cxbutton%20name%3D%22dropdown-zoom-fitvisible%22%20action%3D%22fitVisible%22%20%40controller%3D%22zoom%3AZoomActionController%22%20icon-class%3D%22fv__icon-toolbar-fit-visible%22%20ribbon-icon%3D%22fx-icon-ribbon_home_visible-32%22%20tooltip-title%3D%22toolbar.buttons.fitVisible%22%3Etoolbar.buttons.fitVisible%3C%2Fxbutton%3E%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%3Cli%20class%3D%22fv__ui-dropdown-separator%22%3E%3C%2Fli%3E%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%3Cxbutton%20%40foreach%3D%22scale%20in%20%24pdfui.customScalingValues%22%20%40setter.text%3D%22scale%7Cpercent%22%20%40controller%3D%22zoom%3AZoomToScaleValueController%22%3E%3C%2Fxbutton%3E%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%3C%2Fdropdown%3E%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%3C%2Fgroup%3E%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%60%0A%20%20%20%20%20%20%20%20%20%20%20%20%7D%2C%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20target%3A%20'custom-component-group-list'%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20action%3A%20FRAGMENT_ACTION.APPEND%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%2F%2F%20Note%20that%20comment-list%3AImportCommentButtonController%20must%20be%20used%20together%20with%20the%20file-selector%20component.%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20template%3A%20%60%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%3Cgroup%3E%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%3Cfile-selector%20%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%40controller%3D%22comment-list%3AImportCommentButtonController%22%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20name%3D%22commentlist-import-comment%22%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20icon-class%3D%22fv__icon-sidebar-import-comment%22%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%40trigon.close.disable%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%40trigon.open.enable%20accept%3D%22.fdf%2C.xfdf%2C.json%22%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%3Esidebar.commentlist.dropdown.import-comment%3C%2Ffile-selector%3E%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%3C%2Fgroup%3E%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%60%0A%20%20%20%20%20%20%20%20%20%20%20%20%7D%5D%3B%0A%20%20%20%20%20%20%20%20%7D%0A%20%20%20%20%7D)%3B%0A%20%20%20%20var%20libPath%20%3D%20window.top.location.origin%20%2B%20'%2Flib'%3B%0A%20%20%20%20var%20pdfui%20%3D%20new%20UIExtension.PDFUI(%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20viewerOptions%3A%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20libPath%3A%20libPath%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20jr%3A%20%7B%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20licenseSN%3A%20licenseSN%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20licenseKey%3A%20licenseKey%0A%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%20%7D%0A%20%20%20%20%20%20%20%20%20%20%20%20%7D%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20renderTo%3A%20document.body%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20appearance%3A%20CustomAppearance%2C%0A%20%20%20%20%20%20%20%20%20%20%20%20addons%3A%20%5B%5D%20%2F%2F%20No%20addon%20is%20loaded%0A%20%20%20%20%7D)%3B%0A%3C%2Fscript%3E%0A"}},[a("div",{staticClass:"vuepress-plugin-demo-block__display"},[a("div",{staticClass:"vuepress-plugin-demo-block__app"})]),t._v(" "),a("div",{staticClass:"vuepress-plugin-demo-block__code"},[a("div",{staticClass:"language-html extra-class"},[a("pre",{pre:!0,attrs:{class:"language-html"}},[a("code",[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("<")]),t._v("style")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),a("span",{pre:!0,attrs:{class:"token style"}},[a("span",{pre:!0,attrs:{class:"token language-css"}},[t._v("\n    "),a("span",{pre:!0,attrs:{class:"token selector"}},[t._v(".fv__ui-paddle-horizontal .fv__ui-paddle-content")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v("display")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(":")]),t._v(" flex"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v("align-items")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(":")]),t._v(" center"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token selector"}},[t._v(".custom-change-color-panel")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v("display")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(":")]),t._v(" inline-flex"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v("align-items")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(":")]),t._v(" center"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n")])]),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("</")]),t._v("style")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("<")]),t._v("script")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),a("span",{pre:!0,attrs:{class:"token script"}},[a("span",{pre:!0,attrs:{class:"token language-javascript"}},[t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("FRAGMENT_ACTION")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" UIExtension"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("UIConsts"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("FRAGMENT_ACTION")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" CustomAppearance "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" UIExtension"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("appearances"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("adaptive"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token function"}},[t._v("extend")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token function-variable function"}},[t._v("getDefaultFragments")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("function")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("return")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("[")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("target")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'fv--view-tab-paddle'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("action")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("FRAGMENT_ACTION")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("APPEND")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("template")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'<group-list name=\"custom-component-group-list\"></group-list>'")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("target")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'custom-component-group-list'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("action")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("FRAGMENT_ACTION")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("APPEND")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("template")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token template-string"}},[a("span",{pre:!0,attrs:{class:"token template-punctuation string"}},[t._v("`")]),a("span",{pre:!0,attrs:{class:"token string"}},[t._v('\n                    <group>\n                        <div class="custom-change-color-panel" name="change-color-panel" @controller="change-color:ChangeColorController as ctrl" @var.self="$component" >\n                            <xbutton\n                                @foreach="color in colors track by background"\n                                @class="{\'fv__ui-change-color-dropdown-color-round\': true, \'moon\': !!color.type, \'selected\': selectedIndex === $index}"\n                                @sync.attr.style="color.type === \'moon\' ? \'\' : (\'background-color:\' + color.background)"\n                                @on.click="ctrl.changeColor(color, $index)"\n                                @tooltip\n                                tooltip-title="@{color|json}"\n                            ></xbutton>\n                        </div>\n                    </group>\n                ')]),a("span",{pre:!0,attrs:{class:"token template-punctuation string"}},[t._v("`")])]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("target")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'custom-component-group-list'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("action")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("FRAGMENT_ACTION")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("APPEND")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("template")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token template-string"}},[a("span",{pre:!0,attrs:{class:"token template-punctuation string"}},[t._v("`")]),a("span",{pre:!0,attrs:{class:"token string"}},[t._v('\n                    <group>\n                    <xbutton @controller="zoom:ZoomInAndOutController" action="zoomin" icon-class="fv__icon-toolbar-zoom-in"></xbutton>\n                    </group>\n                ')]),a("span",{pre:!0,attrs:{class:"token template-punctuation string"}},[t._v("`")])]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("target")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'custom-component-group-list'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("action")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("FRAGMENT_ACTION")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("APPEND")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("template")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token template-string"}},[a("span",{pre:!0,attrs:{class:"token template-punctuation string"}},[t._v("`")]),a("span",{pre:!0,attrs:{class:"token string"}},[t._v('\n                    <group>\n                        <dropdown name="fv--inner-zoom-ribbon-dropdown" @aria:label.list="aria:labels.setzoom" icon-class="fv__icon-toolbar-zoom-in" class="fv__ui-dropdown-hide-text" selected="0" @on.selected="self.select($args[0])">\n                            <xbutton name="dropdown-zoom-in" action="zoomin" @controller="zoom:DropdownZoomInAndOutController" icon-class="fv__icon-toolbar-zoom-in" ribbon-icon="fx-icon-ribbon_home_zoomin-32" tooltip-title="toolbar.buttons.zoomin">toolbar.buttons.zoomin</xbutton>\n                            <xbutton name="dropdown-zoom-out" action="zoomout" @controller="zoom:DropdownZoomInAndOutController" icon-class="fv__icon-toolbar-zoom-out" ribbon-icon="fx-icon-ribbon_home_zoomout-32" tooltip-title="toolbar.buttons.zoomout">toolbar.buttons.zoomout</xbutton>\n                            <xbutton name="dropdown-zoom-fitpage" action="fitHeight" @controller="zoom:ZoomActionController" icon-class="fv__icon-toolbar-fit-page" ribbon-icon="fx-icon-ribbon_home_fitpage-32" tooltip-title="toolbar.buttons.fitHeight">toolbar.buttons.fitHeight</xbutton>\n                            <xbutton name="dropdown-zoom-fitwidth" action="fitWidth" @controller="zoom:ZoomActionController" icon-class="fv__icon-toolbar-fit-width" ribbon-icon="fx-icon-ribbon_home_fitwidth-32" tooltip-title="toolbar.buttons.fitWidth">toolbar.buttons.fitWidth</xbutton>\n                            <xbutton name="dropdown-zoom-fitvisible" action="fitVisible" @controller="zoom:ZoomActionController" icon-class="fv__icon-toolbar-fit-visible" ribbon-icon="fx-icon-ribbon_home_visible-32" tooltip-title="toolbar.buttons.fitVisible">toolbar.buttons.fitVisible</xbutton>\n                            <li class="fv__ui-dropdown-separator"></li>\n                            <xbutton @foreach="scale in $pdfui.customScalingValues" @setter.text="scale|percent" @controller="zoom:ZoomToScaleValueController"></xbutton>\n                        </dropdown>\n                    </group>\n                ')]),a("span",{pre:!0,attrs:{class:"token template-punctuation string"}},[t._v("`")])]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("target")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'custom-component-group-list'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("action")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("FRAGMENT_ACTION")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),a("span",{pre:!0,attrs:{class:"token constant"}},[t._v("APPEND")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Note that comment-list:ImportCommentButtonController must be used together with the file-selector component.")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("template")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token template-string"}},[a("span",{pre:!0,attrs:{class:"token template-punctuation string"}},[t._v("`")]),a("span",{pre:!0,attrs:{class:"token string"}},[t._v('\n                    <group>\n                        <file-selector \n                            @controller="comment-list:ImportCommentButtonController"\n                            name="commentlist-import-comment"\n                            icon-class="fv__icon-sidebar-import-comment"\n                            @trigon.close.disable\n                            @trigon.open.enable accept=".fdf,.xfdf,.json"\n                        >sidebar.commentlist.dropdown.import-comment</file-selector>\n                    </group>\n                ')]),a("span",{pre:!0,attrs:{class:"token template-punctuation string"}},[t._v("`")])]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("]")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" libPath "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" window"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("top"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("location"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("origin "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("+")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v("'/lib'")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("var")]),t._v(" pdfui "),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("new")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token class-name"}},[t._v("UIExtension"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("PDFUI")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("viewerOptions")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("libPath")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" libPath"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("jr")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n                    "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("licenseSN")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" licenseSN"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n                    "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("licenseKey")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" licenseKey\n                "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("renderTo")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" document"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("body"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("appearance")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" CustomAppearance"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n            "),a("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("addons")]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("[")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("]")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// No addon is loaded")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n")])]),a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token tag"}},[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("</")]),t._v("script")]),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(">")])]),t._v("\n")])])]),a("div",{staticClass:"language-json extra-class"},[a("pre",{pre:!0,attrs:{class:"language-json"}},[a("code",[a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v('"iframeOptions"')]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),a("span",{pre:!0,attrs:{class:"token property"}},[t._v('"style"')]),a("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),a("span",{pre:!0,attrs:{class:"token string"}},[t._v('"height: 600px;"')]),t._v("\n    "),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n"),a("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n")])])])]),t._v(" "),a("div",{staticClass:"vuepress-plugin-demo-block__footer"})])])}),[],!1,null,null,null);a.default=e.exports}}]);