import React from "react";
import DownOutlined from '@ant-design/icons/DownOutlined';
import { Icon, IconSize } from "./Icon";
import CompareSVG from '../../assets/compare.svg';
import MinusCircleSVG from '../../assets/minus-circle.svg';
import PlusCircleSVG from '../../assets/plus-circle.svg';
import CollapseSVG from '../../assets/floating-toolbar/collapse.svg';
import ExpandSVG from '../../assets/floating-toolbar/expand.svg';
import MinusOutlineSVG from '../../assets/floating-toolbar/minus-outline.svg';
import PlusOutlineSVG from '../../assets/floating-toolbar/plus-outline.svg';
import RotateLeftSVG from '../../assets/floating-toolbar/rotate-left.svg';
import RotateRightSVG from '../../assets/floating-toolbar/rotate-right.svg';
import TranslateDownSVG from '../../assets/floating-toolbar/translate-down.svg';
import TranslateLeftSVG from '../../assets/floating-toolbar/translate-left.svg';
import TranslateRightSVG from '../../assets/floating-toolbar/translate-right.svg';
import TranslateUpSVG from '../../assets/floating-toolbar/translate-up.svg';
import TransferSVG from '../../assets/select-file-dialog/transfer.svg';
import BlankSVG from '../../assets/blank.svg';
import PrevPageSVG from '../../assets/floating-toolbar/prev-page.svg';
import NextPageSVG from '../../assets/floating-toolbar/next-page.svg';

export const wrapSVG = (SVG: string) => () => <img src={SVG} alt="icon" />;

export function createIcon(size: IconSize, SVG: React.FunctionComponent | (() => JSX.Element)) {
    return <Icon size={size} component={<SVG />} />;
}

export const CompareIcon = () => createIcon(IconSize.MEDIUN, wrapSVG(CompareSVG));
export const MinusCircleIcon = () => createIcon(IconSize.MEDIUN, wrapSVG(MinusCircleSVG));
export const PlusCircleIcon = () => createIcon(IconSize.MEDIUN, wrapSVG(PlusCircleSVG));
export const CollapseIcon = () => createIcon(IconSize.SMALL, wrapSVG(CollapseSVG));
export const ExpandIcon = () => createIcon(IconSize.SMALL, wrapSVG(ExpandSVG));
export const MinusOutlineIcon = () => createIcon(IconSize.XS, wrapSVG(MinusOutlineSVG));
export const PlusOutlineIcon = () => createIcon(IconSize.XS, wrapSVG(PlusOutlineSVG));
export const RotateLeftIcon = () => createIcon(IconSize.SMALL, wrapSVG(RotateLeftSVG));
export const RotateRightIcon = () => createIcon(IconSize.SMALL, wrapSVG(RotateRightSVG));
export const TranslateDownIcon = () => createIcon(IconSize.SMALL, wrapSVG(TranslateDownSVG));
export const TranslateLeftIcon = () => createIcon(IconSize.SMALL, wrapSVG(TranslateLeftSVG));
export const TranslateRightIcon = () => createIcon(IconSize.SMALL, wrapSVG(TranslateRightSVG));
export const TranslateUpIcon = () => createIcon(IconSize.SMALL, wrapSVG(TranslateUpSVG));
export const PrevPageIcon = () => createIcon(IconSize.SMALL, wrapSVG(PrevPageSVG));
export const NextPageIcon = () => createIcon(IconSize.SMALL, wrapSVG(NextPageSVG));
export const TransferIcon = () => createIcon(IconSize.HUGE, wrapSVG(TransferSVG));
export const BlankIcon = () => createIcon(IconSize.LARGE, wrapSVG(BlankSVG));

export const ArrowIcon = () => createIcon(IconSize.EM, DownOutlined);