(window.webpackJsonp=window.webpackJsonp||[]).push([[82],{411:function(t,e,s){"use strict";s.r(e);var n=s(14),a=Object(n.a)({},(function(){var t=this,e=t._self._c;return e("ContentSlotsDistributor",{attrs:{"slot-key":t.$parent.slotKey}},[e("h1",{attrs:{id:"enter-and-exit-browser-fullscreen-mode"}},[e("a",{staticClass:"header-anchor",attrs:{href:"#enter-and-exit-browser-fullscreen-mode"}},[t._v("#")]),t._v(" Enter and Exit Browser Fullscreen Mode")]),t._v(" "),e("p",[t._v("Most browsers have implemented the fullscreen feature for web pages and provide keyboard shortcuts, usually F11 and Esc keys. In addition to keyboard shortcuts, W3C has also defined two APIs for fullscreen. With these APIs, we can control the fullscreen display of web pages using JavaScript.")]),t._v(" "),e("h2",{attrs:{id:"fullscreen-api"}},[e("a",{staticClass:"header-anchor",attrs:{href:"#fullscreen-api"}},[t._v("#")]),t._v(" Fullscreen API")]),t._v(" "),e("p",[t._v("In the W3C standard, the methods are as follows:")]),t._v(" "),e("p",[t._v("Enter fullscreen: "),e("a",{attrs:{href:"https://developer.mozilla.org/en-US/docs/Web/API/Element/requestFullscreen",target:"_blank",rel:"noopener noreferrer"}},[t._v("Element.requestFullscreen"),e("OutboundLink")],1)]),t._v(" "),e("p",[t._v("Exit fullscreen: "),e("a",{attrs:{href:"https://developer.mozilla.org/en-US/docs/Web/API/Document/exitFullscreen",target:"_blank",rel:"noopener noreferrer"}},[t._v("Document.exitFullscreen"),e("OutboundLink")],1)]),t._v(" "),e("p",[t._v("Element in current fullscreen mode: "),e("a",{attrs:{href:"https://developer.mozilla.org/en-US/docs/Web/API/Document/fullscreenElement",target:"_blank",rel:"noopener noreferrer"}},[t._v("Document.fullscreenElement"),e("OutboundLink")],1)]),t._v(" "),e("p",[t._v("However, the methods required to be used in some versions of browsers are different. Refer to the table below:")]),t._v(" "),e("table",[e("thead",[e("tr",[e("th",{staticStyle:{"text-align":"left"}},[t._v("Feature")]),t._v(" "),e("th",{staticStyle:{"text-align":"left"}},[t._v("webkit")]),t._v(" "),e("th",{staticStyle:{"text-align":"left"}},[t._v("Gecko(Firefox)")]),t._v(" "),e("th",{staticStyle:{"text-align":"left"}},[t._v("IE11")])])]),t._v(" "),e("tbody",[e("tr",[e("td",{staticStyle:{"text-align":"left"}},[t._v("Enter fullscreen")]),t._v(" "),e("td",{staticStyle:{"text-align":"left"}},[t._v("webkitRequestFullScreen")]),t._v(" "),e("td",{staticStyle:{"text-align":"left"}},[t._v("mozRequestFullScreen")]),t._v(" "),e("td",{staticStyle:{"text-align":"left"}},[t._v("msRequestFullScreen")])]),t._v(" "),e("tr",[e("td",{staticStyle:{"text-align":"left"}},[t._v("Exit fullscreen")]),t._v(" "),e("td",{staticStyle:{"text-align":"left"}},[t._v("webkitExitFullscreen")]),t._v(" "),e("td",{staticStyle:{"text-align":"left"}},[t._v("mozCancelFullScreen")]),t._v(" "),e("td",{staticStyle:{"text-align":"left"}},[t._v("msExitFullscreen")])]),t._v(" "),e("tr",[e("td",{staticStyle:{"text-align":"left"}},[t._v("Element in current fullscreen mode")]),t._v(" "),e("td",{staticStyle:{"text-align":"left"}},[t._v("webkitFullscreenElement or (webkitCurrentFullScreenElement, mobile safari)")]),t._v(" "),e("td",{staticStyle:{"text-align":"left"}},[t._v("mozFullScreenElement")]),t._v(" "),e("td",{staticStyle:{"text-align":"left"}},[t._v("msFullscreenElement")])])])]),t._v(" "),e("p",[t._v("Although W3C has defined the standard for the fullscreen API, it is not well supported in various browsers. Therefore, it is necessary to perform compatibility processing when using it.")]),t._v(" "),e("h2",{attrs:{id:"compatibility-encapsulation"}},[e("a",{staticClass:"header-anchor",attrs:{href:"#compatibility-encapsulation"}},[t._v("#")]),t._v(" Compatibility Encapsulation")]),t._v(" "),e("ol",[e("li",[e("p",[t._v("Enter fullscreen")]),t._v(" "),e("div",{staticClass:"language-js extra-class"},[e("pre",{pre:!0,attrs:{class:"language-js"}},[e("code",[e("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("function")]),t._v(" "),e("span",{pre:!0,attrs:{class:"token function"}},[t._v("requestFullscreen")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n    "),e("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" html "),e("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" document"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("documentElement"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),e("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" rfs "),e("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" html"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("requestFullscreen "),e("span",{pre:!0,attrs:{class:"token operator"}},[t._v("||")]),t._v(" html"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("mozRequestFullScreen "),e("span",{pre:!0,attrs:{class:"token operator"}},[t._v("||")]),t._v(" html"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("webkitRequestFullScreen "),e("span",{pre:!0,attrs:{class:"token operator"}},[t._v("||")]),t._v(" html"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("msRequestFullscreen"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),e("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("return")]),t._v(" "),e("span",{pre:!0,attrs:{class:"token function"}},[t._v("rfs")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),e("span",{pre:!0,attrs:{class:"token function"}},[t._v("call")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),t._v("html"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n")])])])]),t._v(" "),e("li",[e("p",[t._v("Exit fullscreen")]),t._v(" "),e("div",{staticClass:"language-js extra-class"},[e("pre",{pre:!0,attrs:{class:"language-js"}},[e("code",[e("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("function")]),t._v(" "),e("span",{pre:!0,attrs:{class:"token function"}},[t._v("exitFullscreen")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n    "),e("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" efs "),e("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" document"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("exitFullscreen "),e("span",{pre:!0,attrs:{class:"token operator"}},[t._v("||")]),t._v(" document"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("mozCancelFullScreen "),e("span",{pre:!0,attrs:{class:"token operator"}},[t._v("||")]),t._v(" document"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("webkitExitFullscreen "),e("span",{pre:!0,attrs:{class:"token operator"}},[t._v("||")]),t._v(" document"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("msExitFullscreen"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),e("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("return")]),t._v(" "),e("span",{pre:!0,attrs:{class:"token function"}},[t._v("efs")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),e("span",{pre:!0,attrs:{class:"token function"}},[t._v("call")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),t._v("document"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n")])])])]),t._v(" "),e("li",[e("p",[t._v("Get the element in current fullscreen mode")]),t._v(" "),e("div",{staticClass:"language-js extra-class"},[e("pre",{pre:!0,attrs:{class:"language-js"}},[e("code",[e("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("function")]),t._v(" "),e("span",{pre:!0,attrs:{class:"token function"}},[t._v("getFullscreenElement")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n    "),e("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("return")]),t._v(" document"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("fullscreenElement "),e("span",{pre:!0,attrs:{class:"token operator"}},[t._v("||")]),t._v(" document"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("webkitFullscreenElement "),e("span",{pre:!0,attrs:{class:"token operator"}},[t._v("||")]),t._v(" document"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("webkitCurrentFullScreenElement "),e("span",{pre:!0,attrs:{class:"token operator"}},[t._v("||")]),t._v(" document"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("mozFullScreenElement "),e("span",{pre:!0,attrs:{class:"token operator"}},[t._v("||")]),t._v(" document"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("msFullscreenElement"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n")])])])])]),t._v(" "),e("h2",{attrs:{id:"check-if-it-is-in-fullscreen-mode"}},[e("a",{staticClass:"header-anchor",attrs:{href:"#check-if-it-is-in-fullscreen-mode"}},[t._v("#")]),t._v(" Check if it is in fullscreen mode")]),t._v(" "),e("p",[t._v("Since the "),e("a",{attrs:{href:"https://developer.mozilla.org/en-US/docs/Web/API/Document/fullscreen",target:"_blank",rel:"noopener noreferrer"}},[e("code",[t._v("Document.fullscreen")]),e("OutboundLink")],1),t._v(" property has been deprecated, according to the MDN documentation, we can determine if it is in fullscreen mode by checking if "),e("code",[t._v("Document.fullscreenElement")]),t._v(" is equal to "),e("code",[t._v("null")]),t._v(".")]),t._v(" "),e("div",{staticClass:"language-js extra-class"},[e("pre",{pre:!0,attrs:{class:"language-js"}},[e("code",[e("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("function")]),t._v(" "),e("span",{pre:!0,attrs:{class:"token function"}},[t._v("isFullscreen")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n    "),e("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("return")]),t._v(" "),e("span",{pre:!0,attrs:{class:"token function"}},[t._v("getFullscreenElement")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),e("span",{pre:!0,attrs:{class:"token operator"}},[t._v("!==")]),t._v(" "),e("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("null")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n")])])]),e("p",[t._v("However, according to "),e("a",{attrs:{href:"https://caniuse.com/mdn-api_document_fullscreenelement",target:"_blank",rel:"noopener noreferrer"}},[t._v("can I use"),e("OutboundLink")],1),t._v(", although "),e("code",[t._v("fullscreenElement")]),t._v(" can be obtained with different prefixes, its compatibility is still not satisfactory. In scenarios with higher compatibility requirements, the "),e("a",{attrs:{href:"https://developer.mozilla.org/en-US/docs/Web/API/Screen",target:"_blank",rel:"noopener noreferrer"}},[t._v("Screen API"),e("OutboundLink")],1),t._v(" can be used as an additional means to determine if it is in fullscreen mode.")]),t._v(" "),e("div",{staticClass:"language-js extra-class"},[e("pre",{pre:!0,attrs:{class:"language-js"}},[e("code",[e("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("function")]),t._v(" "),e("span",{pre:!0,attrs:{class:"token function"}},[t._v("isFullscreen")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n    "),e("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" fullscreenElement "),e("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" "),e("span",{pre:!0,attrs:{class:"token function"}},[t._v("getFullscreenElement")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),e("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("if")]),t._v(" "),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),t._v("fullscreenElement "),e("span",{pre:!0,attrs:{class:"token operator"}},[t._v("===")]),t._v(" "),e("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("undefined")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),e("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("return")]),t._v(" window"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("innerWidth "),e("span",{pre:!0,attrs:{class:"token operator"}},[t._v("===")]),t._v(" screen"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("availWidth "),e("span",{pre:!0,attrs:{class:"token operator"}},[t._v("&&")]),t._v(" window"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("innerHeight "),e("span",{pre:!0,attrs:{class:"token operator"}},[t._v("===")]),t._v(" screen"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("availHeight"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n    "),e("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("return")]),t._v(" fullscreenElement "),e("span",{pre:!0,attrs:{class:"token operator"}},[t._v("!==")]),t._v(" "),e("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("null")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n")])])]),e("h2",{attrs:{id:"event-listening"}},[e("a",{staticClass:"header-anchor",attrs:{href:"#event-listening"}},[t._v("#")]),t._v(" Event Listening")]),t._v(" "),e("p",[t._v("After entering and exiting fullscreen mode, the browser will trigger the "),e("a",{attrs:{href:"https://developer.mozilla.org/en-US/docs/Web/API/Document/fullscreenchange_event",target:"_blank",rel:"noopener noreferrer"}},[e("code",[t._v("fullscreenchange")]),e("OutboundLink")],1),t._v(" event. Related non-standard events include:")]),t._v(" "),e("ul",[e("li",[e("code",[t._v("webkitfullscreenchange")])]),t._v(" "),e("li",[e("code",[t._v("mozfullscreenchange")])]),t._v(" "),e("li",[e("code",[t._v("MSFullscreenChange")])])]),t._v(" "),e("p",[t._v("According to the information provided on "),e("a",{attrs:{href:"https://caniuse.com/mdn-api_document_fullscreenchange_event",target:"_blank",rel:"noopener noreferrer"}},[t._v("can I use"),e("OutboundLink")],1),t._v(", the compatibility of the "),e("code",[t._v("fullscreenchange")]),t._v(" event is not very good. For improved compatibility across various browsers and devices, Foxit PDF SDK for Web offers the "),e("a",{attrs:{href:"https://developers.foxit.com/resources/pdf-sdk-web/api_reference/group___u_i_extension.html#gga6a3ae6ca8238b9e9707c675968e61dd1a0271841553a77b2d1352eecf36f82d20",target:"_blank",rel:"noopener noreferrer"}},[e("code",[t._v("UIEvents.fullscreenchange")]),e("OutboundLink")],1),t._v(" event.")]),t._v(" "),e("p",[t._v("Here's an example of how to listen for the "),e("code",[t._v("fullscreenchange")]),t._v(" event using the "),e("code",[t._v("addUIEventListener")]),t._v(" function provided by the PDFUI library:")]),t._v(" "),e("div",{staticClass:"language-js extra-class"},[e("pre",{pre:!0,attrs:{class:"language-js"}},[e("code",[t._v("pdfui"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),e("span",{pre:!0,attrs:{class:"token function"}},[t._v("addUIEventListener")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),t._v("UIExtension"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("UIEvents"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("fullscreenchange"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" "),e("span",{pre:!0,attrs:{class:"token parameter"}},[t._v("isFullscreen")]),t._v(" "),e("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=>")]),t._v(" "),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n    "),e("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// do something here")]),t._v("\n"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v("\n")])])]),e("p",[t._v("Note that before using the "),e("code",[t._v("UIEvents.fullscreenchange")]),t._v(" event, you need to make sure that the "),e("code",[t._v("full-screen")]),t._v(" addon is loaded during the PDFUI initialization, or use AllInOne.js or AllInOne.mobile.js. For more details, please refer to the "),e("RouterLink",{attrs:{to:"/ui-extension/addons/introduction.html"}},[t._v("Addon Introduction")]),t._v(" section.")],1),t._v(" "),e("p",[t._v("Alternatively, you can choose not to use the provided event and instead use the "),e("code",[t._v("resize")]),t._v(" event to achieve the same result as "),e("code",[t._v("fullscreenchange")]),t._v(". The specific approach is as follows:")]),t._v(" "),e("div",{staticClass:"language-js extra-class"},[e("pre",{pre:!0,attrs:{class:"language-js"}},[e("code",[e("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("let")]),t._v(" _isFullscreen "),e("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" "),e("span",{pre:!0,attrs:{class:"token function"}},[t._v("isFullscreen")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v(" "),e("span",{pre:!0,attrs:{class:"token comment"}},[t._v('// Refer to the "Check if it is in fullscreen mode" section')]),t._v("\nwindow"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),e("span",{pre:!0,attrs:{class:"token function"}},[t._v("addEventListener")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),e("span",{pre:!0,attrs:{class:"token string"}},[t._v("'resize'")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" "),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),e("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=>")]),t._v(" "),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n    "),e("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" currentIsFullscreen "),e("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" "),e("span",{pre:!0,attrs:{class:"token function"}},[t._v("isFullscreen")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n    "),e("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("if")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),t._v("currentIsFullscreen "),e("span",{pre:!0,attrs:{class:"token operator"}},[t._v("!==")]),t._v(" _isFullscreen"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v(" "),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),e("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// This code block is executed when the fullscreen mode changes, which is equivalent to fullscreenchange")]),t._v("\n    "),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n    _isFullscreen "),e("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" currentIsFullscreen"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),t._v("\n")])])]),e("p",[t._v("Both approaches allow you to perform certain actions when the fullscreen mode changes in the browser. Choose the one that suits your needs and browser compatibility requirements.")])])}),[],!1,null,null,null);e.default=a.exports}}]);