(window.webpackJsonp=window.webpackJsonp||[]).push([[193],{527:function(e,t,r){"use strict";r.r(t);var s=r(14),a=Object(s.a)({},(function(){var e=this,t=e._self._c;return t("ContentSlotsDistributor",{attrs:{"slot-key":e.$parent.slotKey}},[t("h1",{attrs:{id:"整合-serviceworker"}},[t("a",{staticClass:"header-anchor",attrs:{href:"#整合-serviceworker"}},[e._v("#")]),e._v(" 整合 ServiceWorker")]),e._v(" "),t("h2",{attrs:{id:"目的"}},[t("a",{staticClass:"header-anchor",attrs:{href:"#目的"}},[e._v("#")]),e._v(" 目的")]),e._v(" "),t("p",[e._v("本节旨在为开发者提供一个全面的指南，用于在应用层集成和整合 SDK 内置的 ServiceWorker 功能。并解决 ServiceWorker 冲突问题和常见问题。")]),e._v(" "),t("p",[e._v("虽然浏览器允许在同一个域中注册多个 ServiceWorker, 但这些 ServiceWorker 必须拥有不同的作用域 (scope)。这样，每个 ServiceWorker 才可以独立控制不同作用域下的资源。然而，"),t("code",[e._v("MessageWorker.js")]),e._v(" 占用了一个作用域（默认为 '/'）, 这将导致应用层的 ServiceWorker 无法在相同的作用域下注册成功。因此，当应用层的 ServiceWorker 需要与 SDK 内置的 "),t("code",[e._v("MessageWorker.js")]),e._v(" 共享同一个作用域时，就必须将其合并为同一个文件。")]),e._v(" "),t("p",[e._v("本节将介绍如何合并和自定义与 ServiceWorker 配置相关的参数。")]),e._v(" "),t("h2",{attrs:{id:"serviceworker-简介"}},[t("a",{staticClass:"header-anchor",attrs:{href:"#serviceworker-简介"}},[e._v("#")]),e._v(" ServiceWorker 简介")]),e._v(" "),t("p",[e._v("ServiceWorker 是在浏览器后台运行的脚本，可以用来实现离线功能、推送通知、后台同步等功能。在网页完全加载后，其在后台运作，可以拦截网络请求、缓存资源，并提供其他功能。")]),e._v(" "),t("p",[t("strong",[e._v("ServiceWorker 的主要功能：")])]),e._v(" "),t("ul",[t("li",[t("strong",[e._v("离线功能")]),e._v(": ServiceWorker 可以缓存资源，使用户在断网时仍能访问网站。")]),e._v(" "),t("li",[t("strong",[e._v("推送通知")]),e._v(": ServiceWorker 可以从服务器接收推送通知并向用户展示消息。")]),e._v(" "),t("li",[t("strong",[e._v("后台同步")]),e._v(": ServiceWorker 可以在后台执行任务，如上传数据或更新数据。")]),e._v(" "),t("li",[t("strong",[e._v("网络拦截")]),e._v(": ServiceWorker 可以拦截网络请求并按需处理，例如缓存数据或修改请求头。")])]),e._v(" "),t("h2",{attrs:{id:"messageworker-js-概述"}},[t("a",{staticClass:"header-anchor",attrs:{href:"#messageworker-js-概述"}},[e._v("#")]),e._v(" MessageWorker.js 概述")]),e._v(" "),t("p",[t("code",[e._v("MessageWorker.js")]),e._v(" 是 SDK 提供的一个 ServiceWorker 脚本，用于在 Web Worker 层实现同步通信。由于 "),t("code",[e._v("MessageWorker.js")]),e._v(" 占用了独立的作用域，当应用层的 ServiceWorker 需要与其使用同一个作用域时，就需要将两者合并到一个文件中。")]),e._v(" "),t("h2",{attrs:{id:"环境设置"}},[t("a",{staticClass:"header-anchor",attrs:{href:"#环境设置"}},[e._v("#")]),e._v(" 环境设置")]),e._v(" "),t("p",[e._v("在开始集成 ServiceWorker 之前，请确保您的开发环境满足以下要求：")]),e._v(" "),t("ul",[t("li",[t("p",[e._v("支持 ServiceWorker 的浏览器: 确保您的目标浏览器支持 ServiceWorker，例如 Chrome，Firefox 和 Edge。如需更具体的信息，可以参考 "),t("a",{attrs:{href:"https://caniuse.com/serviceworkers",target:"_blank",rel:"noopener noreferrer"}},[e._v("Can I use"),t("OutboundLink")],1),e._v("。")])]),e._v(" "),t("li",[t("p",[t("code",[e._v("@foxitsoftware/foxit-pdf-sdk-for-web-library")]),e._v(": 版本必须是 "),t("code",[e._v("10.0.0")]),e._v(" 或更高，且 "),t("code",[e._v("lib")]),e._v(" 目录应包含 "),t("code",[e._v("MessageWorker.js")]),e._v(" 文件。")])]),e._v(" "),t("li",[t("p",[e._v("HTTPS 支持: 您的网站必须通过 HTTPS 访问才能使用 ServiceWorker，当然，开发环境例外。"),t("code",[e._v("localhost")]),e._v(" 和 "),t("code",[e._v("127.0.0.1")]),e._v(" 可以在不启用 HTTPS 访问的情况下使用 ServiceWorker。")])])]),e._v(" "),t("h2",{attrs:{id:"serviceworker-注册和配置"}},[t("a",{staticClass:"header-anchor",attrs:{href:"#serviceworker-注册和配置"}},[e._v("#")]),e._v(" ServiceWorker 注册和配置")]),e._v(" "),t("p",[e._v("从 "),t("code",[e._v("10.0.0")]),e._v(" 版本开始， "),t("code",[e._v("PDFViewer")]),e._v(" 构造函数参数中新增了 "),t("a",{attrs:{href:"" + location.origin + "/docs/API_Reference/html/"+"/class_p_d_f_viewer.html",target:"_blank",rel:"noopener noreferrer"}},[t("code",[e._v("messageSyncServiceWorker")]),t("OutboundLink")],1),e._v(" 参数， 用于指定 ServiceWorker 的注册方式。")]),e._v(" "),t("p",[t("code",[e._v("messageSyncServiceWorker")]),e._v(" 有两种用法：")]),e._v(" "),t("ol",[t("li",[t("p",[e._v("方法 1: 指定 "),t("code",[e._v("url")]),e._v(" 和 "),t("code",[e._v("options")]),e._v(":")]),e._v(" "),t("ul",[t("li",[t("code",[e._v("url")]),e._v(" 为 ServiceWorker 的注册路径；")]),e._v(" "),t("li",[t("code",[e._v("options")]),e._v(" 为 ServiceWorker 的注册选项，可以参考 "),t("a",{attrs:{href:"https://developer.mozilla.org/en-US/docs/Web/API/ServiceWorkerContainer/register#options",target:"_blank",rel:"noopener noreferrer"}},[e._v("MDN"),t("OutboundLink")],1),e._v(" 中的具体描述。")])]),e._v(" "),t("div",{staticClass:"language-js extra-class"},[t("pre",{pre:!0,attrs:{class:"language-js"}},[t("code",[t("span",{pre:!0,attrs:{class:"token keyword"}},[e._v("const")]),e._v(" viewer "),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v("=")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token keyword"}},[e._v("new")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token class-name"}},[e._v("PDFViewer")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("(")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("{")]),e._v("\n    "),t("span",{pre:!0,attrs:{class:"token literal-property property"}},[e._v("messageSyncServiceWorker")]),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v(":")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("{")]),e._v("\n        "),t("span",{pre:!0,attrs:{class:"token literal-property property"}},[e._v("url")]),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v(":")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token string"}},[e._v('"/your-service-worker.js"')]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(",")]),e._v("\n        "),t("span",{pre:!0,attrs:{class:"token literal-property property"}},[e._v("options")]),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v(":")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("{")]),e._v("\n            "),t("span",{pre:!0,attrs:{class:"token comment"}},[e._v("// Optional")]),e._v("\n            "),t("span",{pre:!0,attrs:{class:"token literal-property property"}},[e._v("scope")]),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v(":")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token string"}},[e._v('"/foxit-lib/"')]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(",")]),e._v("\n        "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("}")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(",")]),e._v("\n    "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("}")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(",")]),e._v("\n    "),t("span",{pre:!0,attrs:{class:"token comment"}},[e._v("// ... Other parameters")]),e._v("\n"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("}")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(")")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(";")]),e._v("\n")])])])]),e._v(" "),t("li",[t("p",[e._v("方法 2: 指定 "),t("code",[e._v("registration")]),e._v(":")]),e._v(" "),t("ul",[t("li",[t("code",[e._v("registration")]),e._v(" 为 "),t("code",[e._v("navigator.serviceWorker.register()")]),e._v(" 方法返回的 "),t("code",[e._v("Promise<ServiceWorkerRegistration>")]),e._v(" 对象。")])]),e._v(" "),t("div",{staticClass:"language-js extra-class"},[t("pre",{pre:!0,attrs:{class:"language-js"}},[t("code",[t("span",{pre:!0,attrs:{class:"token keyword"}},[e._v("const")]),e._v(" viewer "),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v("=")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token keyword"}},[e._v("new")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token class-name"}},[e._v("PDFViewer")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("(")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("{")]),e._v("\n    "),t("span",{pre:!0,attrs:{class:"token literal-property property"}},[e._v("messageSyncServiceWorker")]),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v(":")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("{")]),e._v("\n        "),t("span",{pre:!0,attrs:{class:"token literal-property property"}},[e._v("registration")]),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v(":")]),e._v(" navigator"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(".")]),e._v("serviceWorker"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(".")]),t("span",{pre:!0,attrs:{class:"token function"}},[e._v("register")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("(")]),e._v("\n            "),t("span",{pre:!0,attrs:{class:"token string"}},[e._v('"/your-service-worker.js"')]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(",")]),e._v("\n            "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("{")]),e._v("\n                "),t("span",{pre:!0,attrs:{class:"token literal-property property"}},[e._v("scope")]),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v(":")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token string"}},[e._v('"/foxit-lib/"')]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(",")]),e._v("\n            "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("}")]),e._v("\n        "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(")")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(",")]),e._v("\n    "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("}")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(",")]),e._v("\n    "),t("span",{pre:!0,attrs:{class:"token comment"}},[e._v("// ... Other parameters")]),e._v("\n"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("}")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(")")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(";")]),e._v("\n")])])])])]),e._v(" "),t("p",[e._v("方法 1 将由 SDK 内部决定何时注册 ServiceWorker。如果您需要手动控制 ServiceWorker 的注册，必须使用方法 2。")]),e._v(" "),t("p",[e._v("在 SDK 发布包中，我们提供了一个完整的示例 ("),t("code",[e._v("/examples/PDFViewCtrl/integrate-service-worker")]),e._v(")。您可以直接参考其实现，并根据 README.md 文档运行和查看效果。")]),e._v(" "),t("h2",{attrs:{id:"service-worker-allowed-响应头"}},[t("a",{staticClass:"header-anchor",attrs:{href:"#service-worker-allowed-响应头"}},[e._v("#")]),e._v(" "),t("code",[e._v("Service-Worker-Allowed")]),e._v(" 响应头")]),e._v(" "),t("p",[e._v("默认情况下，ServiceWorker 允许的最大作用范围由其脚本位置决定。具体来说，ServiceWorker 的作用范围只能覆盖其脚本所在的目录及其子目录。例如，如果 ServiceWorker 脚本位于 "),t("code",[e._v("https://example.com/sub/worker.js")]),e._v("，则默认情况下，它只能控制 "),t("code",[e._v("https://example.com/sub/")]),e._v(" 及其子路径下的资源。如果将 scope 参数强行指定为更大作用范围，将导致 ServiceWorker 注册失败，并且报错: "),t("code",[e._v("The path of the provided scope ('/') is not under the max scope allowed ('/sub/')")]),e._v("。")]),e._v(" "),t("p",[e._v("然而，在某些情况下，您可能希望扩大 ServiceWorker 的作用范围，以便其能够控制更大范围内的资源。这时候，"),t("code",[e._v("Service-Worker-Allowed")]),e._v(" 响应头就显得尤为重要。通过配置此响应头，您可以指定更广泛的路径，允许 ServiceWorker 在更大的范围内生效。")]),e._v(" "),t("h3",{attrs:{id:"配置-service-worker-allowed-响应头"}},[t("a",{staticClass:"header-anchor",attrs:{href:"#配置-service-worker-allowed-响应头"}},[e._v("#")]),e._v(" 配置 "),t("code",[e._v("Service-Worker-Allowed")]),e._v(" 响应头")]),e._v(" "),t("p",[e._v("要使用 "),t("code",[e._v("Service-Worker-Allowed")]),e._v(" 响应头，您需要在 ServiceWorker 脚本的 HTTP 响应头中添加以下字段。其值为允许的最大作用范围路径：")]),e._v(" "),t("div",{staticClass:"language-http extra-class"},[t("pre",{pre:!0,attrs:{class:"language-http"}},[t("code",[e._v("Service-Worker-Allowed /;\n")])])]),t("h4",{attrs:{id:"nginx-配置示例"}},[t("a",{staticClass:"header-anchor",attrs:{href:"#nginx-配置示例"}},[e._v("#")]),e._v(" Nginx 配置示例")]),e._v(" "),t("p",[e._v("如果您使用 Nginx 作为服务器，可以通过修改 Nginx 配置文件来添加 "),t("code",[e._v("Service-Worker-Allowed")]),e._v(" 响应头。以下是一个配置示例：")]),e._v(" "),t("div",{staticClass:"language-nginx extra-class"},[t("pre",{pre:!0,attrs:{class:"language-nginx"}},[t("code",[t("span",{pre:!0,attrs:{class:"token directive"}},[t("span",{pre:!0,attrs:{class:"token keyword"}},[e._v("server")])]),e._v(" "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("{")]),e._v("\n    "),t("span",{pre:!0,attrs:{class:"token directive"}},[t("span",{pre:!0,attrs:{class:"token keyword"}},[e._v("location")]),e._v(" /sw.js")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("{")]),e._v("\n        "),t("span",{pre:!0,attrs:{class:"token directive"}},[t("span",{pre:!0,attrs:{class:"token keyword"}},[e._v("add_header")]),e._v(" Service-Worker-Allowed /")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(";")]),e._v("\n    "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("}")]),e._v("\n"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("}")]),e._v("\n")])])]),t("h4",{attrs:{id:"webpack-dev-server-配置示例"}},[t("a",{staticClass:"header-anchor",attrs:{href:"#webpack-dev-server-配置示例"}},[e._v("#")]),e._v(" Webpack Dev Server 配置示例")]),e._v(" "),t("p",[e._v("如果您使用 Webpack Dev Server 进行本地开发，可以通过配置 devServer 添加 "),t("code",[e._v("Service-Worker-Allowed")]),e._v(" 响应头。以下是一个配置示例：")]),e._v(" "),t("div",{staticClass:"language-js extra-class"},[t("pre",{pre:!0,attrs:{class:"language-js"}},[t("code",[t("span",{pre:!0,attrs:{class:"token comment"}},[e._v("// webpack.config.js")]),e._v("\nmodule"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(".")]),e._v("exports "),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v("=")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("{")]),e._v("\n    "),t("span",{pre:!0,attrs:{class:"token comment"}},[e._v("//  Other configurations")]),e._v("\n    "),t("span",{pre:!0,attrs:{class:"token literal-property property"}},[e._v("devServer")]),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v(":")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("{")]),e._v("\n        "),t("span",{pre:!0,attrs:{class:"token literal-property property"}},[e._v("headers")]),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v(":")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("{")]),e._v("\n            "),t("span",{pre:!0,attrs:{class:"token string-property property"}},[e._v('"Service-Worker-Allowed"')]),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v(":")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token string"}},[e._v('"/"')]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(",")]),e._v("\n        "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("}")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(",")]),e._v("\n    "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("}")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(",")]),e._v("\n"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("}")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(";")]),e._v("\n")])])]),t("h4",{attrs:{id:"vue-config-js-配置示例"}},[t("a",{staticClass:"header-anchor",attrs:{href:"#vue-config-js-配置示例"}},[e._v("#")]),e._v(" vue.config.js 配置示例")]),e._v(" "),t("p",[e._v("如果您使用 Vue CLI，可以通过修改 "),t("code",[e._v("vue.config.js")]),e._v(" 来调整 Webpack Dev Server。以下是一个配置示例：")]),e._v(" "),t("div",{staticClass:"language-js extra-class"},[t("pre",{pre:!0,attrs:{class:"language-js"}},[t("code",[t("span",{pre:!0,attrs:{class:"token comment"}},[e._v("// vue.config.js")]),e._v("\nmodule"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(".")]),e._v("exports "),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v("=")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("{")]),e._v("\n    "),t("span",{pre:!0,attrs:{class:"token literal-property property"}},[e._v("devServer")]),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v(":")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("{")]),e._v("\n        "),t("span",{pre:!0,attrs:{class:"token literal-property property"}},[e._v("headers")]),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v(":")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("{")]),e._v("\n            "),t("span",{pre:!0,attrs:{class:"token string-property property"}},[e._v('"Service-Worker-Allowed"')]),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v(":")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token string"}},[e._v('"/"')]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(",")]),e._v("\n        "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("}")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(",")]),e._v("\n    "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("}")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(",")]),e._v("\n"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("}")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(";")]),e._v("\n")])])]),t("h2",{attrs:{id:"特殊的请求地址"}},[t("a",{staticClass:"header-anchor",attrs:{href:"#特殊的请求地址"}},[e._v("#")]),e._v(" 特殊的请求地址")]),e._v(" "),t("p",[e._v("在应用层的 ServiceWorker 监听的 "),t("code",[e._v("fetch")]),e._v(" 事件中，如果请求地址匹配 "),t("code",[e._v("__foxitwebsdk-syncmsg__")]),e._v("，请直接忽略此请求。这也在我们的示例代码中有提到（"),t("code",[e._v("examples/PDFViewCtrl/integrate-service-worker/src/service-worker.js")]),e._v("）。")]),e._v(" "),t("h2",{attrs:{id:"常见问题和故障排查"}},[t("a",{staticClass:"header-anchor",attrs:{href:"#常见问题和故障排查"}},[e._v("#")]),e._v(" 常见问题和故障排查")]),e._v(" "),t("ol",[t("li",[t("p",[e._v("ServiceWorker 未注册")]),e._v(" "),t("ul",[t("li",[t("p",[e._v("问题描述: 在开发者工具中无法找到 ServiceWorker 的注册结果。")])]),e._v(" "),t("li",[t("p",[e._v("可能原因:")]),e._v(" "),t("ol",[t("li",[e._v("路径设置不正确，ServiceWorker js 请求返回 404 或其他错误。")]),e._v(" "),t("li",[e._v("浏览器不支持 ServiceWorker。")]),e._v(" "),t("li",[e._v("出于安全考虑，ServiceWorker 只能在 HTTPS 协议下使用。这里有个例外，localhost 和 127.0.0.1 不需要 HTTPS。")])])]),e._v(" "),t("li",[t("p",[e._v("解决方法:")]),e._v(" "),t("ol",[t("li",[e._v("检查 ServiceWorker 的注册代码和路径设置。")]),e._v(" "),t("li",[e._v("检查浏览器兼容性，ServiceWorker 兼容性请参考 "),t("a",{attrs:{href:"https://caniuse.com/serviceworkers",target:"_blank",rel:"noopener noreferrer"}},[e._v("Can I use"),t("OutboundLink")],1),e._v("。")]),e._v(" "),t("li",[e._v("开启 HTTPS 协议。")])])])])]),e._v(" "),t("li",[t("p",[e._v("ServiceWorker 注册失败")]),e._v(" "),t("ul",[t("li",[e._v("问题描述：注册时提示作用域超出最大允许范围。错误信息示例：")])]),e._v(" "),t("div",{staticClass:"language-log extra-class"},[t("pre",{pre:!0,attrs:{class:"language-log"}},[t("code",[e._v("    register a ServiceWorker for scope "),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v("(")]),t("span",{pre:!0,attrs:{class:"token string"}},[e._v("'http://localhost:9899/'")]),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v(")")]),e._v(" with script "),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v("(")]),t("span",{pre:!0,attrs:{class:"token string"}},[e._v("'http://localhost:9899/lib/MessageWorker.js?b=http://localhost:9899/__foxitwebsdk-syncmsg__'")]),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v(")")]),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v(":")]),e._v(" The path of the provided scope "),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v("(")]),t("span",{pre:!0,attrs:{class:"token string"}},[e._v("'/'")]),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v(")")]),e._v(" is not under the max scope allowed "),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v("(")]),t("span",{pre:!0,attrs:{class:"token string"}},[e._v("'/lib/'")]),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v(")")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(".")]),e._v(" Adjust the scope"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(",")]),e._v(" move the Service Worker script"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(",")]),e._v(" or use the Service"),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v("-")]),e._v("Worker"),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v("-")]),e._v("Allowed HTTP header to allow the scope"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(".")]),e._v("\n")])])]),t("ul",[t("li",[t("p",[e._v("可能原因: ServiceWorker 的注册路径或作用域设置不正确。需要注意的是，ServiceWorker 允许的最大作用范围取决于 ServiceWorker 脚本本身的位置 (参考: "),t("a",{attrs:{href:"https://developer.mozilla.org/en-US/docs/Web/API/Service_Worker_API/Using_Service_Workers#why_is_my_service_worker_failing_to_register",target:"_blank",rel:"noopener noreferrer"}},[e._v("MDN"),t("OutboundLink")],1),e._v(")。")])]),e._v(" "),t("li",[t("p",[e._v("解决方法:")]),e._v(" "),t("ol",[t("li",[e._v("理解 ServiceWorker 的作用域规则。")]),e._v(" "),t("li",[e._v("检查 ServiceWorker 的注册代码和作用域设置。")]),e._v(" "),t("li",[e._v("调整 ServiceWorker 的作用域，即修改 "),t("a",{attrs:{href:"https://developer.mozilla.org/en-US/docs/Web/API/ServiceWorkerContainer/register#scope",target:"_blank",rel:"noopener noreferrer"}},[e._v("scope"),t("OutboundLink")],1),e._v(" 参数。")]),e._v(" "),t("li",[e._v("调整 "),t("code",[e._v("Service-Worker-Allowed")]),e._v(" HTTP 响应头以允许更大的作用域。")]),e._v(" "),t("li",[e._v("检查 ServiceWorker 脚本的路径和服务器配置。")])])])])]),e._v(" "),t("li",[t("p",[e._v("ServiceWorker 注册提示 MIME 不支持")]),e._v(" "),t("ul",[t("li",[e._v("问题描述: 注册时提示 unsupported MIME type ('"),t("strong",[t("em",[e._v("/")])]),e._v("')。错误信息示例：")])]),e._v(" "),t("div",{staticClass:"language-log extra-class"},[t("pre",{pre:!0,attrs:{class:"language-log"}},[t("code",[e._v("Failed to register a ServiceWorker for scope "),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v("(")]),t("span",{pre:!0,attrs:{class:"token string"}},[e._v("'http://localhost:5173/assets/'")]),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v(")")]),e._v(" with script "),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v("(")]),t("span",{pre:!0,attrs:{class:"token string"}},[e._v("'http://localhost:5173/assets/service-worker.js'")]),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v(")")]),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v(":")]),e._v(" The script has an unsupported MIME type "),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v("(")]),t("span",{pre:!0,attrs:{class:"token string"}},[e._v("'text/html'")]),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v(")")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(".")]),e._v("\n")])])]),t("ul",[t("li",[e._v("可能原因: ServiceWorker 的注册路径错误或目标文件不存在。")]),e._v(" "),t("li",[e._v("解决方法:\n"),t("ol",[t("li",[e._v("检查 ServiceWorker 的注册路径。")]),e._v(" "),t("li",[e._v("检查目标文件是否存在。")]),e._v(" "),t("li",[e._v("检查服务器配置。")])])])])]),e._v(" "),t("li",[t("p",[e._v("浏览器强制刷新后， ServiceWorker 无法拦截请求")]),e._v(" "),t("ul",[t("li",[e._v("问题描述：参考 "),t("a",{attrs:{href:"https://developer.mozilla.org/en-US/docs/Web/API/ServiceWorkerContainer/controller",target:"_blank",rel:"noopener noreferrer"}},[e._v("MDN: ServiceWorkerContainer: controller property"),t("OutboundLink")],1),e._v(" 文档描述，当用户强制刷新（Shift + Refresh）页面后，service worker 会失去页面的控制权，并且 "),t("code",[e._v("navigator.serviceWorker.controller")]),e._v(" 属性为 null。")]),e._v(" "),t("li",[e._v("可能原因： SDK 的内置 "),t("code",[e._v("MessageWorker.js")]),e._v(" 已经自动处理这个问题，如果您的 ServiceWorker 代码没有复用 MessageWorker.js, 并且未处理此情况，则可能出现这个现象。")]),e._v(" "),t("li",[e._v("解决方法：\n"),t("ol",[t("li",[e._v("在成功注册 serviceWorker 后检查 "),t("code",[e._v("navigator.serviceWorker.controller")]),e._v(" 是否为 null。")]),e._v(" "),t("li",[e._v("如果为 null, 则通过 "),t("a",{attrs:{href:"https://developer.mozilla.org/en-US/docs/Web/API/ServiceWorkerRegistration",target:"_blank",rel:"noopener noreferrer"}},[e._v("registration"),t("OutboundLink")],1),e._v(".active.postMessage 方法向 ServiceWorker 发送消息， 比如我们发送的消息为： "),t("code",[e._v("{id: 'clientsClaim'}")]),e._v("。")]),e._v(" "),t("li",[e._v("在 ServiceWorker 上下文中监听此消息，并在收到消息后调用 "),t("code",[e._v("clients.claim()")]),e._v(" 方法。")])])])]),e._v(" "),t("p",[e._v("下面是一个简单的示例：")]),e._v(" "),t("p",[e._v("main.js:")]),e._v(" "),t("div",{staticClass:"language-js extra-class"},[t("pre",{pre:!0,attrs:{class:"language-js"}},[t("code",[t("span",{pre:!0,attrs:{class:"token keyword"}},[e._v("const")]),e._v(" registration "),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v("=")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token keyword"}},[e._v("await")]),e._v(" navigator"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(".")]),e._v("serviceWorker"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(".")]),t("span",{pre:!0,attrs:{class:"token function"}},[e._v("register")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("(")]),e._v("\n    "),t("span",{pre:!0,attrs:{class:"token string"}},[e._v('"service-worker.js"')]),e._v(" "),t("span",{pre:!0,attrs:{class:"token comment"}},[e._v("/* ... more options */")]),e._v("\n"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(")")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(";")]),e._v("\n"),t("span",{pre:!0,attrs:{class:"token keyword"}},[e._v("if")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("(")]),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v("!")]),e._v("navigator"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(".")]),e._v("serviceWorker"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(".")]),e._v("controller "),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v("&&")]),e._v(" registration"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(".")]),e._v("active"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(")")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("{")]),e._v("\n    "),t("span",{pre:!0,attrs:{class:"token keyword"}},[e._v("function")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token function"}},[e._v("onControllerChange")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("(")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(")")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("{")]),e._v("\n        navigator"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(".")]),e._v("serviceWorker"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(".")]),t("span",{pre:!0,attrs:{class:"token function"}},[e._v("removeEventListener")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("(")]),e._v("\n            "),t("span",{pre:!0,attrs:{class:"token string"}},[e._v('"controllerchange"')]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(",")]),e._v("\n            onControllerChange\n        "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(")")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(";")]),e._v("\n        "),t("span",{pre:!0,attrs:{class:"token keyword"}},[e._v("if")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("(")]),e._v("navigator"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(".")]),e._v("serviceWorker"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(".")]),e._v("controller"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(")")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("{")]),e._v("\n            "),t("span",{pre:!0,attrs:{class:"token function"}},[e._v("resolve")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("(")]),t("span",{pre:!0,attrs:{class:"token boolean"}},[e._v("true")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(")")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(";")]),e._v("\n        "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("}")]),e._v("\n    "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("}")]),e._v("\n    navigator"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(".")]),e._v("serviceWorker"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(".")]),t("span",{pre:!0,attrs:{class:"token function"}},[e._v("addEventListener")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("(")]),e._v("\n        "),t("span",{pre:!0,attrs:{class:"token string"}},[e._v('"controllerchange"')]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(",")]),e._v("\n        onControllerChange\n    "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(")")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(";")]),e._v("\n    registration"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(".")]),e._v("active"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(".")]),t("span",{pre:!0,attrs:{class:"token function"}},[e._v("postMessage")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("(")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("{")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token literal-property property"}},[e._v("id")]),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v(":")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token string"}},[e._v('"clientsClaim"')]),e._v(" "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("}")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(")")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(";")]),e._v("\n"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("}")]),e._v("\n"),t("span",{pre:!0,attrs:{class:"token keyword"}},[e._v("const")]),e._v(" pdfViewer "),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v("=")]),e._v("  "),t("span",{pre:!0,attrs:{class:"token keyword"}},[e._v("new")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token class-name"}},[e._v("PDFViewCtrl"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(".")]),e._v("PDFViewer")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("(")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("{")]),e._v("\n   "),t("span",{pre:!0,attrs:{class:"token literal-property property"}},[e._v("messageSyncServiceWorker")]),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v(":")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("{")]),e._v("\n       "),t("span",{pre:!0,attrs:{class:"token literal-property property"}},[e._v("registration")]),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v(":")]),e._v(" registration"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(",")]),e._v("\n   "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("}")]),e._v("\n"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("}")]),e._v("\n")])])]),t("p",[e._v("service-worker.js")]),e._v(" "),t("div",{staticClass:"language-js extra-class"},[t("pre",{pre:!0,attrs:{class:"language-js"}},[t("code",[t("span",{pre:!0,attrs:{class:"token comment"}},[e._v("// ......")]),e._v("\nself"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(".")]),t("span",{pre:!0,attrs:{class:"token function"}},[e._v("addEventListener")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("(")]),t("span",{pre:!0,attrs:{class:"token string"}},[e._v('"message"')]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(",")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("(")]),t("span",{pre:!0,attrs:{class:"token parameter"}},[e._v("e")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(")")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v("=>")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("{")]),e._v("\n    "),t("span",{pre:!0,attrs:{class:"token keyword"}},[e._v("if")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("(")]),e._v("e"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(".")]),e._v("data"),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v("?.")]),e._v("id "),t("span",{pre:!0,attrs:{class:"token operator"}},[e._v("===")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token string"}},[e._v('"clientsClaim"')]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(")")]),e._v(" "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("{")]),e._v("\n        "),t("span",{pre:!0,attrs:{class:"token comment"}},[e._v("// 将当前 service worker 设置为其 scope 内所有 clients 的 controller")]),e._v("\n        clients"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(".")]),t("span",{pre:!0,attrs:{class:"token function"}},[e._v("claim")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("(")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(")")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(";")]),e._v("\n    "),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("}")]),e._v("\n"),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v("}")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(")")]),t("span",{pre:!0,attrs:{class:"token punctuation"}},[e._v(";")]),e._v("\n")])])])])]),e._v(" "),t("h2",{attrs:{id:"serviceworker-的使用场景"}},[t("a",{staticClass:"header-anchor",attrs:{href:"#serviceworker-的使用场景"}},[e._v("#")]),e._v(" ServiceWorker 的使用场景")]),e._v(" "),t("p",[e._v("Foxit PDF SDK for Web 使用 ServiceWorker 来优化用户的交互体验并解决一些交互相关的问题。目前，ServiceWorker 已被用于处理访问本地字体授权, 填表功能和执行表单、动态 XFA 的一些 JavaScript 脚本的 UI。")])])}),[],!1,null,null,null);t.default=a.exports}}]);