(window.webpackJsonp=window.webpackJsonp||[]).push([[39],{367:function(t,e,a){"use strict";a.r(e);var n=a(14),s=Object(n.a)({},(function(){var t=this,e=t._self._c;return e("ContentSlotsDistributor",{attrs:{"slot-key":t.$parent.slotKey}},[e("h1",{attrs:{id:"action"}},[e("a",{staticClass:"header-anchor",attrs:{href:"#action"}},[t._v("#")]),t._v(" Action")]),t._v(" "),e("h2",{attrs:{id:"concept-overview"}},[e("a",{staticClass:"header-anchor",attrs:{href:"#concept-overview"}},[t._v("#")]),t._v(" Concept Overview")]),t._v(" "),e("p",[t._v('PDF "Action" is a type of instruction that can be automatically executed when specific events occur, such as opening a document, clicking a link, or interacting with a form. Actions can enable functionalities like page navigation, form submission, script execution, and file operations, significantly enhancing the interactivity and automation capabilities of PDFs.')]),t._v(" "),e("p",[t._v("Actions are divided into two main categories:")]),t._v(" "),e("ul",[e("li",[e("p",[e("strong",[t._v("Action")]),t._v(": Introduced in PDF 1.1. Actions can be bound to the "),e("strong",[t._v("A entry")]),t._v(" in the dictionary of objects such as annotations (e.g., Link, Screen, Widget), bookmarks (outline items), or the "),e("strong",[t._v("OpenAction entry")]),t._v(" in the document catalog. Actions are used to automatically execute specific operations when an object is activated (e.g., clicked, selected, or when a document is opened). These operations include jumping to a destination, launching an application, playing a sound, changing the appearance of an annotation, etc.")])]),t._v(" "),e("li",[e("p",[e("strong",[t._v("Additional Action")]),t._v(": Introduced in PDF 1.2. Additional actions can be bound to the "),e("strong",[t._v("AA entry")]),t._v(" in objects such as the document catalog, pages, annotations, or form widgets. Additional actions respond to various specific trigger events, such as entering, exiting, pressing, releasing, gaining/losing focus, changing field values, etc. Each event can have a designated action, enabling more fine-grained event-driven behavior.")])])]),t._v(" "),e("blockquote",[e("p",[t._v("⚠️ Note: The "),e("a",{attrs:{href:"" + location.origin + "/docs/API_Reference/html/"+"/class_action.html",target:"_blank",rel:"noopener noreferrer"}},[e("code",[t._v("Action")]),e("OutboundLink")],1),t._v(" class and its related subclasses have been deprecated. All operations related to Actions should now use the dedicated APIs provided by each object (such as Annot, Widget, PDFFormField, PDFDoc).")])]),t._v(" "),e("h2",{attrs:{id:"typical-use-cases"}},[e("a",{staticClass:"header-anchor",attrs:{href:"#typical-use-cases"}},[t._v("#")]),t._v(" Typical Use Cases")]),t._v(" "),e("ul",[e("li",[e("strong",[t._v("Page Navigation")]),t._v("：Navigate to a specific page or location by clicking a link or button (e.g., GoTo, GoToR, GoToE).")]),t._v(" "),e("li",[e("strong",[t._v("Form Interaction")]),t._v(": Include submitting forms (SubmitForm), resetting forms (ResetForm), importing data (ImportData), and hiding/showing fields (Hide).")]),t._v(" "),e("li",[e("strong",[t._v("Script Automation")]),t._v("：Automatically execute JavaScript scripts during specific events, such as field value changes, page opening, or document saving.")]),t._v(" "),e("li",[e("strong",[t._v("Multimedia and External Operations")]),t._v(": Launch external applications (Launch), open a URI (URI), and render multimedia content (Rendition).")])]),t._v(" "),e("h2",{attrs:{id:"supported-action-types"}},[e("a",{staticClass:"header-anchor",attrs:{href:"#supported-action-types"}},[t._v("#")]),t._v(" Supported Action Types")]),t._v(" "),e("table",[e("thead",[e("tr",[e("th",{staticStyle:{"text-align":"left"}},[t._v("Action Type")]),t._v(" "),e("th",{staticStyle:{"text-align":"left"}},[t._v("Description")]),t._v(" "),e("th",{staticStyle:{"text-align":"center"}},[t._v("Editable (UI)")]),t._v(" "),e("th",{staticStyle:{"text-align":"center"}},[t._v("Triggerable")]),t._v(" "),e("th",{staticStyle:{"text-align":"center"}},[t._v("API Support")])])]),t._v(" "),e("tbody",[e("tr",[e("td",{staticStyle:{"text-align":"left"}},[t._v("GoTo")]),t._v(" "),e("td",{staticStyle:{"text-align":"left"}},[t._v("Navigate to a specified page/location/zoom in the current document")]),t._v(" "),e("td",{staticStyle:{"text-align":"center"}},[t._v("Y")]),t._v(" "),e("td",{staticStyle:{"text-align":"center"}},[t._v("Y")]),t._v(" "),e("td",{staticStyle:{"text-align":"center"}},[t._v("Y")])]),t._v(" "),e("tr",[e("td",{staticStyle:{"text-align":"left"}},[t._v("GoToR")]),t._v(" "),e("td",{staticStyle:{"text-align":"left"}},[t._v("Navigate to a specified location in another PDF file (non-embedded file)")]),t._v(" "),e("td",{staticStyle:{"text-align":"center"}},[t._v("Y")]),t._v(" "),e("td",{staticStyle:{"text-align":"center"}},[t._v("N")]),t._v(" "),e("td",{staticStyle:{"text-align":"center"}},[t._v("Y")])]),t._v(" "),e("tr",[e("td",{staticStyle:{"text-align":"left"}},[t._v("GoToE")]),t._v(" "),e("td",{staticStyle:{"text-align":"left"}},[t._v("Navigate to a specified target location in a PDF file embedded within another PDF file")]),t._v(" "),e("td",{staticStyle:{"text-align":"center"}},[t._v("N")]),t._v(" "),e("td",{staticStyle:{"text-align":"center"}},[t._v("N")]),t._v(" "),e("td",{staticStyle:{"text-align":"center"}},[t._v("Y")])]),t._v(" "),e("tr",[e("td",{staticStyle:{"text-align":"left"}},[t._v("Hide")]),t._v(" "),e("td",{staticStyle:{"text-align":"left"}},[t._v("Hide or show specified form fields")]),t._v(" "),e("td",{staticStyle:{"text-align":"center"}},[t._v("Y")]),t._v(" "),e("td",{staticStyle:{"text-align":"center"}},[t._v("Y")]),t._v(" "),e("td",{staticStyle:{"text-align":"center"}},[t._v("Y")])]),t._v(" "),e("tr",[e("td",{staticStyle:{"text-align":"left"}},[t._v("ImportData")]),t._v(" "),e("td",{staticStyle:{"text-align":"left"}},[t._v("Import an FDF file into the PDF to update form fields")]),t._v(" "),e("td",{staticStyle:{"text-align":"center"}},[t._v("Y")]),t._v(" "),e("td",{staticStyle:{"text-align":"center"}},[t._v("N")]),t._v(" "),e("td",{staticStyle:{"text-align":"center"}},[t._v("Y")])]),t._v(" "),e("tr",[e("td",{staticStyle:{"text-align":"left"}},[t._v("JavaScript")]),t._v(" "),e("td",{staticStyle:{"text-align":"left"}},[t._v("Execute JavaScript scripts")]),t._v(" "),e("td",{staticStyle:{"text-align":"center"}},[t._v("Y")]),t._v(" "),e("td",{staticStyle:{"text-align":"center"}},[t._v("Y")]),t._v(" "),e("td",{staticStyle:{"text-align":"center"}},[t._v("Y")])]),t._v(" "),e("tr",[e("td",{staticStyle:{"text-align":"left"}},[t._v("Launch")]),t._v(" "),e("td",{staticStyle:{"text-align":"left"}},[t._v("Launch external applications, typically to open files")]),t._v(" "),e("td",{staticStyle:{"text-align":"center"}},[t._v("Y")]),t._v(" "),e("td",{staticStyle:{"text-align":"center"}},[t._v("N")]),t._v(" "),e("td",{staticStyle:{"text-align":"center"}},[t._v("Y")])]),t._v(" "),e("tr",[e("td",{staticStyle:{"text-align":"left"}},[t._v("ResetForm")]),t._v(" "),e("td",{staticStyle:{"text-align":"left"}},[t._v("Reset form fields to their default values")]),t._v(" "),e("td",{staticStyle:{"text-align":"center"}},[t._v("Y")]),t._v(" "),e("td",{staticStyle:{"text-align":"center"}},[t._v("Y")]),t._v(" "),e("td",{staticStyle:{"text-align":"center"}},[t._v("Y")])]),t._v(" "),e("tr",[e("td",{staticStyle:{"text-align":"left"}},[t._v("SubmitForm")]),t._v(" "),e("td",{staticStyle:{"text-align":"left"}},[t._v("Submit form data to a specified URL")]),t._v(" "),e("td",{staticStyle:{"text-align":"center"}},[t._v("Y")]),t._v(" "),e("td",{staticStyle:{"text-align":"center"}},[t._v("N")]),t._v(" "),e("td",{staticStyle:{"text-align":"center"}},[t._v("Y")])]),t._v(" "),e("tr",[e("td",{staticStyle:{"text-align":"left"}},[t._v("URI")]),t._v(" "),e("td",{staticStyle:{"text-align":"left"}},[t._v("Open a specified URI address")]),t._v(" "),e("td",{staticStyle:{"text-align":"center"}},[t._v("Y")]),t._v(" "),e("td",{staticStyle:{"text-align":"center"}},[t._v("N")]),t._v(" "),e("td",{staticStyle:{"text-align":"center"}},[t._v("Y")])]),t._v(" "),e("tr",[e("td",{staticStyle:{"text-align":"left"}},[t._v("Rendition")]),t._v(" "),e("td",{staticStyle:{"text-align":"left"}},[t._v("Multimedia rendering actions")]),t._v(" "),e("td",{staticStyle:{"text-align":"center"}},[t._v("N")]),t._v(" "),e("td",{staticStyle:{"text-align":"center"}},[t._v("Y")]),t._v(" "),e("td",{staticStyle:{"text-align":"center"}},[t._v("N")])])])]),t._v(" "),e("blockquote",[e("p",[t._v("For detailed action types and their data structures, please refer to the definitions of "),e("a",{attrs:{href:"" + location.origin + "/docs/API_Reference/html/"+"/group___viewer_actions_p_d_f.html#ga21d5e8f8cdaa838586b31007df0a950b",target:"_blank",rel:"noopener noreferrer"}},[t._v("ActionType"),e("OutboundLink")],1),t._v(" and "),e("a",{attrs:{href:"" + location.origin + "/docs/API_Reference/html/"+"/group___viewer_actions_p_d_f.html#ga6b2319b473e2f9529b2f424ac398aeaa",target:"_blank",rel:"noopener noreferrer"}},[t._v("ActionSpecification"),e("OutboundLink")],1),t._v(".")])]),t._v(" "),e("h2",{attrs:{id:"trigger-events"}},[e("a",{staticClass:"header-anchor",attrs:{href:"#trigger-events"}},[t._v("#")]),t._v(" Trigger Events")]),t._v(" "),e("p",[t._v("The execution of actions depends on trigger events, and different objects support different types of events. Common trigger events include:")]),t._v(" "),e("ul",[e("li",[t._v("Document-Level ("),e("a",{attrs:{href:"" + location.origin + "/docs/API_Reference/html/"+"/group___viewer_actions_p_d_f.html#ga36981f79c6ef681b0a56cb328c11de4f",target:"_blank",rel:"noopener noreferrer"}},[t._v("DocActionTriggerEvents"),e("OutboundLink")],1),t._v("): Events such as document closing, saving, or printing.")]),t._v(" "),e("li",[t._v("Page-Level ("),e("a",{attrs:{href:"" + location.origin + "/docs/API_Reference/html/"+"/group___viewer_actions_p_d_f.html#ga9ad389b6617bc33ef122c2841d8cabf2",target:"_blank",rel:"noopener noreferrer"}},[t._v("PageActionTriggerEvents"),e("OutboundLink")],1),t._v("): Events such as page opening or closing.")]),t._v(" "),e("li",[t._v("Annotation/Widget-Level ("),e("a",{attrs:{href:"" + location.origin + "/docs/API_Reference/html/"+"/group___viewer_actions_p_d_f.html#gae11eba3398848121746efcde1a0dc975",target:"_blank",rel:"noopener noreferrer"}},[t._v("AnnotActionTriggerEvents"),e("OutboundLink")],1),t._v("): Events such as mouse enter, exit, press, or release.")]),t._v(" "),e("li",[t._v("Form Field-Level ("),e("a",{attrs:{href:"" + location.origin + "/docs/API_Reference/html/"+"/group___viewer_actions_p_d_f.html#gade03ac8e31a467e372302e9f2926030f",target:"_blank",rel:"noopener noreferrer"}},[t._v("FieldActionTriggerEvents"),e("OutboundLink")],1),t._v("): Events such as typing, formatting, value changes, or recalculation.")])]),t._v(" "),e("h2",{attrs:{id:"action-data-structure"}},[e("a",{staticClass:"header-anchor",attrs:{href:"#action-data-structure"}},[t._v("#")]),t._v(" Action Data Structure")]),t._v(" "),e("ul",[e("li",[e("a",{attrs:{href:"" + location.origin + "/docs/API_Reference/html/"+"/group___viewer_actions_p_d_f.html#ga6b2319b473e2f9529b2f424ac398aeaa",target:"_blank",rel:"noopener noreferrer"}},[t._v("ActionSpecification"),e("OutboundLink")],1),t._v(": Describe the action type and its parameters (e.g., target for navigation, script content, etc.).")]),t._v(" "),e("li",[e("a",{attrs:{href:"" + location.origin + "/docs/API_Reference/html/"+"/group___viewer_actions_p_d_f.html#ga63d8aeb9070d8110f8231a5be19e02f9",target:"_blank",rel:"noopener noreferrer"}},[t._v("ActionHierarchy"),e("OutboundLink")],1),t._v(": Describe the hierarchical structure of actions, supporting nested sub-actions.")]),t._v(" "),e("li",[e("a",{attrs:{href:"" + location.origin + "/docs/API_Reference/html/"+"/group___viewer_actions_p_d_f.html#ga0dc65f302b3ed5030fa7c353f9e5b3f1",target:"_blank",rel:"noopener noreferrer"}},[t._v("ActionData"),e("OutboundLink")],1),t._v(": The data carrier for specific actions.")])]),t._v(" "),e("h2",{attrs:{id:"main-api-description"}},[e("a",{staticClass:"header-anchor",attrs:{href:"#main-api-description"}},[t._v("#")]),t._v(" Main API Description")]),t._v(" "),e("h3",{attrs:{id:"action-related-apis"}},[e("a",{staticClass:"header-anchor",attrs:{href:"#action-related-apis"}},[t._v("#")]),t._v(" Action Related APIs")]),t._v(" "),e("ul",[e("li",[e("code",[t._v("Annot.getAllActionData()")]),t._v(": Get all action data associated with an annotation, including both primary actions and additional actions.")]),t._v(" "),e("li",[e("code",[t._v("Annot.getActionData()")]),t._v(": Get the primary action data of an annotation.")]),t._v(" "),e("li",[e("code",[t._v("Annot.setAction(actionSpec)")]),t._v(": Set the primary action for an annotation.")]),t._v(" "),e("li",[e("code",[t._v("Annot.appendAction(actionSpec)")]),t._v(": Append a primary action to an annotation.")]),t._v(" "),e("li",[e("code",[t._v("Annot.updateAction(actionObjNumber, actionData)")]),t._v(": Update the primary action of an annotation.")]),t._v(" "),e("li",[e("code",[t._v("Annot.removeAction(actionObjNumber)")]),t._v(": Remove the primary action of an annotation.")]),t._v(" "),e("li",[e("code",[t._v("Annot.supportsAction()")]),t._v(": Check whether the current annotation type supports actions (supported types include: screen, link, sound, widget).")])]),t._v(" "),e("h3",{attrs:{id:"additional-action-related-apis"}},[e("a",{staticClass:"header-anchor",attrs:{href:"#additional-action-related-apis"}},[t._v("#")]),t._v(" Additional Action Related APIs")]),t._v(" "),e("ul",[e("li",[e("code",[t._v("getAdditionalAction")]),t._v(": Get the instance of additional actions.\n"),e("ul",[e("li",[e("code",[t._v("Widget.getAdditionalAction()")]),t._v(": Get the additional action instance for a form widget.")]),t._v(" "),e("li",[e("code",[t._v("PDFPage.getAdditionalAction()")]),t._v(": Get the additional action instance for a page.")]),t._v(" "),e("li",[e("code",[t._v("PDFFormField.getAdditionalAction()")]),t._v("：Get the additional action instance for a form field.")]),t._v(" "),e("li",[e("code",[t._v("PDFDoc.getAdditionalAction()")]),t._v(": Get the additional action instance for a document.")])])]),t._v(" "),e("li",[e("code",[t._v("AdditionalAction.setAction(trigger, actionSpec)")]),t._v(": Set an additional action for a specific event.")]),t._v(" "),e("li",[e("code",[t._v("AdditionalAction.addAction(trigger, actionSpec)")]),t._v(": Append an additional action to a specific event.")]),t._v(" "),e("li",[e("code",[t._v("AdditionalAction.updateActionData(trigger, actionObjNumber, actionData)")]),t._v(": Update the additional action for a specific event.")]),t._v(" "),e("li",[e("code",[t._v("AdditionalAction.removeAction(trigger, actionObjNumber)")]),t._v(": Remove the additional action for a specific event.")]),t._v(" "),e("li",[e("code",[t._v("AdditionalAction.getActions([triggers])")]),t._v(": Get the list of additional actions for the specified events.")])]),t._v(" "),e("h3",{attrs:{id:"document-level-action"}},[e("a",{staticClass:"header-anchor",attrs:{href:"#document-level-action"}},[t._v("#")]),t._v(" Document-Level Action")]),t._v(" "),e("ul",[e("li",[e("code",[t._v("PDFDoc.setOpenAction(actionType, actionData)")]),t._v(": Set an action to be automatically executed when the document is opened.")]),t._v(" "),e("li",[e("code",[t._v("PDFDoc.getOpenAction()")]),t._v(": Get the action set for document opening.")]),t._v(" "),e("li",[e("code",[t._v("PDFDoc.removeOpenAction()")]),t._v(": Remove the action set for document opening.")])]),t._v(" "),e("h2",{attrs:{id:"notes-on-using-actions"}},[e("a",{staticClass:"header-anchor",attrs:{href:"#notes-on-using-actions"}},[t._v("#")]),t._v(" Notes on Using Actions")]),t._v(" "),e("ul",[e("li",[e("p",[t._v("Actions are supported only by specific annotation types: screen, link, sound, and widget.")])]),t._v(" "),e("li",[e("p",[t._v("Additional actions are supported only by specific annotation types: screen and widget.")])]),t._v(" "),e("li",[e("p",[t._v("The trigger event types for additional actions must match the object type; otherwise, they will not work ("),e("a",{attrs:{href:"" + location.origin + "/docs/API_Reference/html/"+"/group___viewer_actions_p_d_f.html#gae11eba3398848121746efcde1a0dc975",target:"_blank",rel:"noopener noreferrer"}},[t._v("AnnotActionTriggerEvents"),e("OutboundLink")],1),t._v(", "),e("a",{attrs:{href:"" + location.origin + "/docs/API_Reference/html/"+"/group___viewer_actions_p_d_f.html#ga36981f79c6ef681b0a56cb328c11de4f",target:"_blank",rel:"noopener noreferrer"}},[t._v("DocActionTriggerEvents"),e("OutboundLink")],1),t._v(", "),e("a",{attrs:{href:"" + location.origin + "/docs/API_Reference/html/"+"/group___viewer_actions_p_d_f.html#gade03ac8e31a467e372302e9f2926030f",target:"_blank",rel:"noopener noreferrer"}},[t._v("FieldActionTriggerEvents"),e("OutboundLink")],1),t._v(", "),e("a",{attrs:{href:"" + location.origin + "/docs/API_Reference/html/"+"/group___viewer_actions_p_d_f.html#ga9ad389b6617bc33ef122c2841d8cabf2",target:"_blank",rel:"noopener noreferrer"}},[t._v("PageActionTriggerEvents"),e("OutboundLink")],1),t._v("). "),e("a",{attrs:{href:"" + location.origin + "/docs/API_Reference/html/"+"/group___viewer_actions_p_d_f.html#ga9ad389b6617bc33ef122c2841d8cabf2",target:"_blank",rel:"noopener noreferrer"}},[t._v("PageActionTriggerEvents"),e("OutboundLink")],1),t._v(": Applicable to pages.")])]),t._v(" "),e("li",[e("p",[t._v("Certain action types (such as GotoR, GoToE, and Rendition) are limited by the SDK's support and are either only supported for triggering or only for setting via the API.")])])]),t._v(" "),e("h2",{attrs:{id:"action-and-additional-action"}},[e("a",{staticClass:"header-anchor",attrs:{href:"#action-and-additional-action"}},[t._v("#")]),t._v(" Action and Additional Action")]),t._v(" "),e("h3",{attrs:{id:"action-2"}},[e("a",{staticClass:"header-anchor",attrs:{href:"#action-2"}},[t._v("#")]),t._v(" Action")]),t._v(" "),e("p",[e("strong",[t._v("Action")]),t._v(" is a core action mechanism in PDF, initially introduced in version 1.1 of the PDF specification. It is defined through the "),e("strong",[t._v("A entry")]),t._v(" (Action entry) of an object. Its main characteristics include:")]),t._v(" "),e("ul",[e("li",[e("strong",[t._v("Direct Binding")]),t._v(": Actions can be directly bound to the dictionary of annotations or bookmarks.")]),t._v(" "),e("li",[e("strong",[t._v("Single Trigger")]),t._v(': Actions are typically triggered when an object is "activated", such as clicking a link annotation or selecting a bookmark item.')]),t._v(" "),e("li",[e("strong",[t._v("Chained Execution")]),t._v(": Support building action chains through the "),e("code",[t._v("Next")]),t._v(" entry, enabling complex tree-like action sequences.")]),t._v(" "),e("li",[e("strong",[t._v("Document-Level Support")]),t._v(": The "),e("code",[t._v("OpenAction")]),t._v(" entry in the document catalog allows specifying actions to be executed when the document is opened.")])]),t._v(" "),e("h3",{attrs:{id:"additional-action"}},[e("a",{staticClass:"header-anchor",attrs:{href:"#additional-action"}},[t._v("#")]),t._v(" Additional Action")]),t._v(" "),e("p",[e("strong",[t._v("Additional Action")]),t._v(" is an extended action mechanism in PDF, initially introduced in version 1.2 of the PDF specification. It is defined through the "),e("strong",[t._v("AA entry")]),t._v(" (Additional Action entry) of an object. Its main characteristics include:")]),t._v(" "),e("ul",[e("li",[e("strong",[t._v("Event-Driven")]),t._v(': Actions are triggered by specific events (Trigger Events), rather than simple "activation".')]),t._v(" "),e("li",[e("strong",[t._v("Multi-Event Support")]),t._v(": A single object can bind different actions to different types of events.")]),t._v(" "),e("li",[e("strong",[t._v("Broad Applicability")]),t._v(": Support various object types, such as documents, pages, annotations, form widgets, and more.")]),t._v(" "),e("li",[e("strong",[t._v("Granular Control")]),t._v(": Support fine-grained event management, such as mouse enter/exit, gaining/losing focus, and similar interactions.")])]),t._v(" "),e("h3",{attrs:{id:"key-differences"}},[e("a",{staticClass:"header-anchor",attrs:{href:"#key-differences"}},[t._v("#")]),t._v(" Key Differences")]),t._v(" "),e("table",[e("thead",[e("tr",[e("th",{staticStyle:{"text-align":"left"}},[t._v("Feature")]),t._v(" "),e("th",{staticStyle:{"text-align":"left"}},[t._v("Action")]),t._v(" "),e("th",{staticStyle:{"text-align":"left"}},[t._v("Additional Action")])])]),t._v(" "),e("tbody",[e("tr",[e("td",{staticStyle:{"text-align":"left"}},[e("strong",[t._v("Introduced Version")])]),t._v(" "),e("td",{staticStyle:{"text-align":"left"}},[t._v("PDF 1.1")]),t._v(" "),e("td",{staticStyle:{"text-align":"left"}},[t._v("PDF 1.2")])]),t._v(" "),e("tr",[e("td",{staticStyle:{"text-align":"left"}},[e("strong",[t._v("Binding Method")])]),t._v(" "),e("td",{staticStyle:{"text-align":"left"}},[t._v("A entry")]),t._v(" "),e("td",{staticStyle:{"text-align":"left"}},[t._v("AA entry")])]),t._v(" "),e("tr",[e("td",{staticStyle:{"text-align":"left"}},[e("strong",[t._v("Trigger Mechanism")])]),t._v(" "),e("td",{staticStyle:{"text-align":"left"}},[t._v("Object activation (e.g., click)")]),t._v(" "),e("td",{staticStyle:{"text-align":"left"}},[t._v("Specific event-driven")])]),t._v(" "),e("tr",[e("td",{staticStyle:{"text-align":"left"}},[e("strong",[t._v("Event Types")])]),t._v(" "),e("td",{staticStyle:{"text-align":"left"}},[t._v("Single (activation)")]),t._v(" "),e("td",{staticStyle:{"text-align":"left"}},[t._v("Multiple (enter, exit, press, release, etc.)")])]),t._v(" "),e("tr",[e("td",{staticStyle:{"text-align":"left"}},[e("strong",[t._v("Applicable Objects")])]),t._v(" "),e("td",{staticStyle:{"text-align":"left"}},[t._v("Annotations, bookmarks, documents")]),t._v(" "),e("td",{staticStyle:{"text-align":"left"}},[t._v("Documents, pages, annotations, form widgets")])]),t._v(" "),e("tr",[e("td",{staticStyle:{"text-align":"left"}},[e("strong",[t._v("Complexity")])]),t._v(" "),e("td",{staticStyle:{"text-align":"left"}},[t._v("Relatively simple")]),t._v(" "),e("td",{staticStyle:{"text-align":"left"}},[t._v("More flexible and complex")])]),t._v(" "),e("tr",[e("td",{staticStyle:{"text-align":"left"}},[e("strong",[t._v("Typical Use Cases")])]),t._v(" "),e("td",{staticStyle:{"text-align":"left"}},[t._v("Page navigation, link clicks")]),t._v(" "),e("td",{staticStyle:{"text-align":"left"}},[t._v("Form validation, dynamic interactions, state changes")])])])]),t._v(" "),e("h3",{attrs:{id:"event-trigger-system"}},[e("a",{staticClass:"header-anchor",attrs:{href:"#event-trigger-system"}},[t._v("#")]),t._v(" Event Trigger System")]),t._v(" "),e("p",[t._v("The power of Additional Action lies in its diverse event trigger system. According to the "),e("code",[t._v("ActionTriggerEvents")]),t._v(" definition in Foxit PDF SDK for Web, the trigger events are mainly divided into the following four categories.")]),t._v(" "),e("h4",{attrs:{id:"document-level-events-docactiontriggerevents"}},[e("a",{staticClass:"header-anchor",attrs:{href:"#document-level-events-docactiontriggerevents"}},[t._v("#")]),t._v(" Document-Level Events (DocActionTriggerEvents)")]),t._v(" "),e("ul",[e("li",[e("strong",[t._v("DOC_WILL_CLOSE")]),t._v(": Trigger a JavaScript action before the document is closed.")]),t._v(" "),e("li",[e("strong",[t._v("DOC_WILL_SAVE")]),t._v(": Trigger a JavaScript action before the document is saved.")]),t._v(" "),e("li",[e("strong",[t._v("DOC_SAVED")]),t._v(": Trigger a JavaScript action after the document is saved.")]),t._v(" "),e("li",[e("strong",[t._v("DOC_WILL_PRINT")]),t._v(": Trigger a JavaScript action before the document is printed.")]),t._v(" "),e("li",[e("strong",[t._v("DOC_PRINTED")]),t._v(": Trigger a JavaScript action after the document is printed.")])]),t._v(" "),e("h4",{attrs:{id:"page-level-events-pageactiontriggerevents"}},[e("a",{staticClass:"header-anchor",attrs:{href:"#page-level-events-pageactiontriggerevents"}},[t._v("#")]),t._v(" Page-Level Events (PageActionTriggerEvents)")]),t._v(" "),e("ul",[e("li",[e("strong",[t._v("PAGE_OPENED")]),t._v(": Trigger an action when the page is opened.")]),t._v(" "),e("li",[e("strong",[t._v("PAGE_CLOSED")]),t._v(": Trigger an action when the page is closed.")])]),t._v(" "),e("h4",{attrs:{id:"annotation-widget-level-events-annotactiontriggerevents"}},[e("a",{staticClass:"header-anchor",attrs:{href:"#annotation-widget-level-events-annotactiontriggerevents"}},[t._v("#")]),t._v(" Annotation/Widget-Level Events (AnnotActionTriggerEvents)")]),t._v(" "),e("ul",[e("li",[e("strong",[t._v("ANNOT_CURSOR_ENTER")]),t._v(": Trigger an action when the cursor enters the annotation's active area.")]),t._v(" "),e("li",[e("strong",[t._v("ANNOT_CURSOR_EXIT")]),t._v(": Trigger an action when the cursor leaves the annotation's active area.")]),t._v(" "),e("li",[e("strong",[t._v("ANNOT_MOUSE_BUTTON_PRESSED")]),t._v(": Trigger an action when the mouse button is pressed within the annotation's active area.")]),t._v(" "),e("li",[e("strong",[t._v("ANNOT_MOUSE_BUTTON_RELEASED")]),t._v(": Trigger an action when the mouse button is released within the annotation's active area.")]),t._v(" "),e("li",[e("strong",[t._v("ANNOT_RECEIVE_INPUT_FOCUS")]),t._v(": Trigger an action when the annotation (Widget annotations only) receives input focus.")]),t._v(" "),e("li",[e("strong",[t._v("ANNOT_LOSE_INPUT_FOCUS")]),t._v(": Trigger an action when the annotation (Widget annotations only) loses input focus.")]),t._v(" "),e("li",[e("strong",[t._v("ANNOT_PAGE_OPENED")]),t._v(": Trigger an action when the page containing the annotation is opened (executed after "),e("code",[t._v("PAGE_OPENED")]),t._v(" and document open actions).")]),t._v(" "),e("li",[e("strong",[t._v("ANNOT_PAGE_CLOSED")]),t._v(": Trigger an action when the page containing the annotation is closed (executed after "),e("code",[t._v("PAGE_CLOSED")]),t._v(").")]),t._v(" "),e("li",[e("strong",[t._v("ANNOT_PAGE_VISIBLE")]),t._v(": Trigger an action when the page containing the annotation becomes visible in the viewer UI.")]),t._v(" "),e("li",[e("strong",[t._v("ANNOT_PAGE_INVISIBLE")]),t._v(": Trigger an action when the page containing the annotation becomes invisible in the viewer UI.")])]),t._v(" "),e("h4",{attrs:{id:"form-field-level-events-fieldactiontriggerevents"}},[e("a",{staticClass:"header-anchor",attrs:{href:"#form-field-level-events-fieldactiontriggerevents"}},[t._v("#")]),t._v(" Form Field-Level Events (FieldActionTriggerEvents)")]),t._v(" "),e("ul",[e("li",[e("p",[e("strong",[t._v("FIELD_KEY_STROKE")]),t._v(": Trigger a JavaScript action when a user types in a text field or combo box, or modifies the selection in a scrollable list box. This can be used to validate or modify keystrokes.")])]),t._v(" "),e("li",[e("p",[e("strong",[t._v("FIELD_WILL_FORMAT")]),t._v(": Trigger a JavaScript action before a field's value is formatted for display. This can be used to modify the field's value.")])]),t._v(" "),e("li",[e("p",[e("strong",[t._v("FIELD_VALUE_CHANGED")]),t._v(": Trigger a JavaScript action when the field value is changed. This can be used to validate the new value.")])]),t._v(" "),e("li",[e("p",[e("strong",[t._v("FIELD_RECALCULATE_VALUE")]),t._v(": Trigger a JavaScript action when the value of other fields changes, in order to recalculate the current field value. The calculation order can be determined using the "),e("code",[t._v("PDFForm.getFieldsInCalculationOrder")]),t._v(" function.")])])]),t._v(" "),e("h3",{attrs:{id:"practical-application-scenarios"}},[e("a",{staticClass:"header-anchor",attrs:{href:"#practical-application-scenarios"}},[t._v("#")]),t._v(" Practical Application Scenarios")]),t._v(" "),e("h4",{attrs:{id:"typical-applications-of-action"}},[e("a",{staticClass:"header-anchor",attrs:{href:"#typical-applications-of-action"}},[t._v("#")]),t._v(" Typical Applications of Action")]),t._v(" "),e("div",{staticClass:"language-javascript extra-class"},[e("pre",{pre:!0,attrs:{class:"language-javascript"}},[e("code",[e("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Set the hyperlink annotation's jump action")]),t._v("\nlinkAnnot"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),e("span",{pre:!0,attrs:{class:"token function"}},[t._v("setAction")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n    "),e("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("type")]),e("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),e("span",{pre:!0,attrs:{class:"token string"}},[t._v('"GoTo"')]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n    "),e("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("dest")]),e("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v(" "),e("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("page")]),e("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),e("span",{pre:!0,attrs:{class:"token number"}},[t._v("5")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" "),e("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("view")]),e("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),e("span",{pre:!0,attrs:{class:"token string"}},[t._v('"FitH"')]),t._v(" "),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n\n"),e("span",{pre:!0,attrs:{class:"token comment"}},[t._v("//  Set the document open action")]),t._v("\npdfDoc"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),e("span",{pre:!0,attrs:{class:"token function"}},[t._v("setOpenAction")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),e("span",{pre:!0,attrs:{class:"token constant"}},[t._v("PDF")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("actions"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("ActionType"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("javaScript"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" "),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n    "),e("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("script")]),e("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),e("span",{pre:!0,attrs:{class:"token string"}},[t._v("'app.alert(\"Welcome to this document!\");'")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n")])])]),e("h4",{attrs:{id:"typical-applications-of-additional-action"}},[e("a",{staticClass:"header-anchor",attrs:{href:"#typical-applications-of-additional-action"}},[t._v("#")]),t._v(" Typical Applications of Additional Action")]),t._v(" "),e("div",{staticClass:"language-javascript extra-class"},[e("pre",{pre:!0,attrs:{class:"language-javascript"}},[e("code",[e("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Validation when the form widget value changes")]),t._v("\n"),e("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" additionalAction "),e("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" formField"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),e("span",{pre:!0,attrs:{class:"token function"}},[t._v("getAdditionalAction")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\nadditionalAction"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),e("span",{pre:!0,attrs:{class:"token function"}},[t._v("setAction")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),e("span",{pre:!0,attrs:{class:"token constant"}},[t._v("PDF")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("actions"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("ActionTriggerEvents"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),e("span",{pre:!0,attrs:{class:"token constant"}},[t._v("FIELD_VALUE_CHANGED")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" "),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n    "),e("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("type")]),e("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),e("span",{pre:!0,attrs:{class:"token constant"}},[t._v("PDF")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("actions"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("ActionType"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("javaScript"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n    "),e("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("data")]),e("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),e("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("javascript")]),e("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),e("span",{pre:!0,attrs:{class:"token string"}},[t._v("'if (event.value < 0) { app.alert(\"The value cannot be negative\"); event.rc = false; }'")]),t._v("\n    "),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n\n"),e("span",{pre:!0,attrs:{class:"token comment"}},[t._v("//  Initialization action when the page opens")]),t._v("\n"),e("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" pageAdditionalAction "),e("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" pdfPage"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),e("span",{pre:!0,attrs:{class:"token function"}},[t._v("getAdditionalAction")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\npageAdditionalAction"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),e("span",{pre:!0,attrs:{class:"token function"}},[t._v("setAction")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),e("span",{pre:!0,attrs:{class:"token constant"}},[t._v("PDF")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("actions"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("ActionTriggerEvents"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),e("span",{pre:!0,attrs:{class:"token constant"}},[t._v("PAGE_OPENED")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" "),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n    "),e("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("type")]),e("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),e("span",{pre:!0,attrs:{class:"token constant"}},[t._v("PDF")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("actions"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("ActionType"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("javaScript"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n    "),e("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("data")]),e("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),e("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("javascript")]),e("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),e("span",{pre:!0,attrs:{class:"token string"}},[t._v("'console.log(\"The page has been opened\");'")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n    "),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n\n"),e("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Actions triggered when the cursor enters the active annotation area")]),t._v("\n"),e("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" annotAdditionalAction "),e("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" annotation"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),e("span",{pre:!0,attrs:{class:"token function"}},[t._v("getAdditionalAction")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\nannotAdditionalAction"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),e("span",{pre:!0,attrs:{class:"token function"}},[t._v("setAction")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),e("span",{pre:!0,attrs:{class:"token constant"}},[t._v("PDF")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("actions"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("ActionTriggerEvents"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),e("span",{pre:!0,attrs:{class:"token constant"}},[t._v("ANNOT_CURSOR_ENTER")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" "),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n    "),e("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("type")]),e("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),e("span",{pre:!0,attrs:{class:"token constant"}},[t._v("PDF")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("actions"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("ActionType"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("javaScript"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n    "),e("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("data")]),e("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),e("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("javascript")]),e("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),e("span",{pre:!0,attrs:{class:"token string"}},[t._v('"this.highlight = true;"')]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n    "),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n\n"),e("span",{pre:!0,attrs:{class:"token comment"}},[t._v("// Data validation before saving the document")]),t._v("\n"),e("span",{pre:!0,attrs:{class:"token keyword"}},[t._v("const")]),t._v(" docAdditionalAction "),e("span",{pre:!0,attrs:{class:"token operator"}},[t._v("=")]),t._v(" pdfDoc"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),e("span",{pre:!0,attrs:{class:"token function"}},[t._v("getAdditionalAction")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\ndocAdditionalAction"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),e("span",{pre:!0,attrs:{class:"token function"}},[t._v("setAction")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("(")]),e("span",{pre:!0,attrs:{class:"token constant"}},[t._v("PDF")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("actions"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("ActionTriggerEvents"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),e("span",{pre:!0,attrs:{class:"token constant"}},[t._v("DOC_WILL_SAVE")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v(" "),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n    "),e("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("type")]),e("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),e("span",{pre:!0,attrs:{class:"token constant"}},[t._v("PDF")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("actions"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("ActionType"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(".")]),t._v("javaScript"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n    "),e("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("data")]),e("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("{")]),t._v("\n        "),e("span",{pre:!0,attrs:{class:"token literal-property property"}},[t._v("javascript")]),e("span",{pre:!0,attrs:{class:"token operator"}},[t._v(":")]),t._v(" "),e("span",{pre:!0,attrs:{class:"token string"}},[t._v("'if (!validateFormData()) { event.rc = false; app.alert(\"Please complete the required information\"); }'")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(",")]),t._v("\n    "),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),t._v("\n"),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v("}")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(")")]),e("span",{pre:!0,attrs:{class:"token punctuation"}},[t._v(";")]),t._v("\n")])])])])}),[],!1,null,null,null);e.default=s.exports}}]);