/**
 * Copyright (C) 2003-2023, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdf.function.json;


import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class JSUtil {

     static Map<String, Object> parseJSONObject(JSONObject jsonObject) throws JSONException {
        Map<String, Object> objectMap = null;
        if (null != jsonObject) {
            objectMap = new HashMap<>();
            Iterator<String> keys = jsonObject.keys();
            while (keys.hasNext()) {
                String key = keys.next();
                Object object = jsonObject.opt(key);
                if (null != object) {
                    objectMap.put(key, parseValue(object));
                }
            }
        }
        return objectMap;
    }

    static Object parseValue(Object input) throws JSONException {
        Object output = null;
        if (null != input) {
            if (input instanceof JSONArray) {
                output = parseJSONArray((JSONArray) input);
            } else if (input instanceof JSONObject) {
                output = parseJSONObject((JSONObject) input);
            } else if (input instanceof String || input instanceof Boolean || input instanceof Integer) {
                output = input;
            }
        }
        return output;
    }

    static List<Object> parseJSONArray(JSONArray jsonArray) throws JSONException {
        List<Object> values = null;
        if (null != jsonArray) {
            values = new ArrayList<>();
            for (int i = 0; i < jsonArray.length(); i++) {
                Object itemObject = jsonArray.get(i);
                if (null != itemObject) {
                    values.add(parseValue(itemObject));
                }
            }
        }
        return values;
    }

}
