/**
 * Copyright (C) 2003-2023, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdf.function.json;


import com.foxit.sdk.PDFException;
import com.foxit.sdk.pdf.PDFDoc;
import com.foxit.sdk.pdf.annots.Annot;
import com.foxit.sdk.pdf.annots.Sound;
import com.foxit.sdk.pdf.objects.PDFObject;

import org.json.JSONException;
import org.json.JSONObject;

public class JSSound {
    public static JSONObject exportToJSON(PDFDoc doc, Annot annot) {
        JSONObject jsonObject = JSMarkupAnnot.exportToJSON(doc, annot);
        try {
            Sound sound = new Sound(annot);
            jsonObject.put("rate", sound.getSamplingRate());

            JSONObject raw = new JSONObject();
            jsonObject.put("raw", raw);
            PDFObject pdfObject = sound.getDict().getElement("Sound");
            if (pdfObject != null) {
                Object object = JSAnnotUtil.retriveDict(raw, pdfObject.getDirectObject());
                raw.put("Sound", object);
            }
        } catch (JSONException | PDFException e) {
            e.printStackTrace();
        }
        return jsonObject;
    }
}
