/**
 * Copyright (C) 2003-2023, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdf.function.json;


import com.foxit.sdk.PDFException;
import com.foxit.sdk.pdf.PDFDoc;
import com.foxit.sdk.pdf.annots.Annot;
import com.foxit.sdk.pdf.annots.DefaultAppearance;
import com.foxit.sdk.pdf.annots.QuadPoints;
import com.foxit.sdk.pdf.annots.QuadPointsArray;
import com.foxit.sdk.pdf.annots.Redact;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Locale;

public class JSRedact {
    public static JSONObject exportToJSON(PDFDoc doc, Annot annot) {
        JSONObject object = JSMarkupAnnot.exportToJSON(doc, annot);
        try {
            Redact redact = new Redact(annot);

            if (redact.getApplyFillColor() != 0) {
                String color = JSAnnotUtil.convertFromNumberToHex(redact.getApplyFillColor() & 0x00ffffff);
                object.put("interior-color", color);
                object.put("interiorColor", color);
            }

            QuadPointsArray quadPoints = redact.getQuadPoints();
            StringBuilder jsonQP = new StringBuilder();
            for (long i = 0; i < quadPoints.getSize(); i++) {
                QuadPoints quadPoint = quadPoints.getAt(i);
                jsonQP.append(quadPoint.getFirst().getX())
                        .append(",")
                        .append(quadPoint.getFirst().getY())
                        .append(",");
                jsonQP.append(quadPoint.getSecond().getX())
                        .append(",")
                        .append(quadPoint.getSecond().getY())
                        .append(",");
                jsonQP.append(quadPoint.getThird().getX())
                        .append(",")
                        .append(quadPoint.getThird().getY())
                        .append(",");
                jsonQP.append(quadPoint.getFourth().getX())
                        .append(",")
                        .append(quadPoint.getFourth().getY())
                        .append(",");
            }
            object.put("coords", jsonQP.substring(0, jsonQP.length() - 1));

            object.put("overlay-text", redact.getOverlayText());
            object.put("overlayText", redact.getOverlayText());

            DefaultAppearance defaultAppearance = redact.getDefaultAppearance();
            String DA = "";
            if (defaultAppearance.getFont() != null && !defaultAppearance.getFont().isEmpty()) {
                DA += "/" + defaultAppearance.getFont().getName() + " ";
            }
            DA += defaultAppearance.getText_size() + " Tf ";

            int[] rgba = JSAnnotUtil.convertFromNumberToRGBA(redact.getBorderColor());
            DA += String.format(Locale.getDefault(), "%.2f", (rgba[0] / 255f))
                    + " " + String.format(Locale.getDefault(), "%.2f", (rgba[1] / 255f))
                    + " " + String.format(Locale.getDefault(), "%.2f", (rgba[2] / 255f));
            object.put("defaultappearance", DA);

            object.put("fontColor", JSAnnotUtil.colorConvertor(defaultAppearance.getText_color() & 0x00ffffff));
            object.put("justification", redact.getOverlayTextAlignment());
        } catch (JSONException | PDFException e) {
            e.printStackTrace();
        }
        return object;
    }
}
