/**
 * Copyright (C) 2003-2023, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdf.function.json;


import android.text.TextUtils;

import com.foxit.sdk.PDFException;
import com.foxit.sdk.pdf.PDFDoc;
import com.foxit.sdk.pdf.annots.Annot;
import com.foxit.sdk.pdf.annots.Markup;
import com.foxit.sdk.pdf.objects.PDFDictionary;
import com.foxit.sdk.pdf.objects.PDFObject;

import org.json.JSONException;
import org.json.JSONObject;

public class JSMarkupAnnot {

    public static JSONObject exportToJSON(PDFDoc doc, Annot annot) {
        JSONObject object = JSAnnot.exportToJSON(annot);
        try {
            Markup markup = new Markup(annot);

            object.put("opacity", markup.getOpacity());
            object.put("creationdate", JSAnnotUtil.formatDocumentDate( markup.getCreationDateTime()));
            object.put("subject", markup.getSubject());
            object.put("title", markup.getTitle());
            String intent = markup.getIntent();
            if (!TextUtils.isEmpty(intent)) {
                object.put("IT", intent);
                object.put("intent", intent);
            }

            PDFDictionary dict = markup.getDict();
            String RT = null;
            String IRT = null;
            PDFObject IRTObj = dict.getElement("IRT");
            if (IRTObj != null) {
                IRTObj = IRTObj.getDict();
                int IRTNum = IRTObj.getObjNum();
                IRTObj = doc.getIndirectObject(IRTNum).getDict().getElement("NM");
                IRT = IRTObj.getWideString();

                PDFObject RTObj = dict.getElement("RT");
                if (!dict.hasKey("StateModel") && RTObj != null) {
                    RT = RTObj.getName();
                    RT = RT != null ? RT : "R";
                } else {
                    RT = "R";
                }
            }
            if (RT != null && IRT != null) {
                object.put("inreplyto", IRT);
                object.put("replyType", RT.toLowerCase());
            }

            if (markup.getPopup() != null && !markup.getPopup().isEmpty()) {
                JSONObject popupObject = JSPopup.exportToJSON(markup.getPopup());
                object.put("popup", popupObject);
            }
        } catch (PDFException | JSONException e) {
            e.printStackTrace();
        }
        return object;
    }


}
