/**
 * Copyright (C) 2003-2023, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdf.function.json;


import com.foxit.sdk.PDFException;
import com.foxit.sdk.pdf.PDFDoc;
import com.foxit.sdk.pdf.annots.Annot;
import com.foxit.sdk.pdf.annots.Line;

import org.json.JSONException;
import org.json.JSONObject;

public class JSLine {

    public static JSONObject exportToJSON(PDFDoc doc, Annot annot) {
        JSONObject object = JSMarkupAnnot.exportToJSON(doc, annot);
        try {
            Line line = new Line(annot);

            if (line.getStyleFillColor() != 0){
                String color = JSAnnotUtil.convertFromNumberToHex(line.getStyleFillColor() & 0x00ffffff);
                object.put("interior-color", color);
                object.put("interiorColor", color);
            }
            object.put("start", String.format("%s,%s",
                    line.getStartPoint().getX(), line.getStartPoint().getY()));
            object.put("end", String.format("%s,%s",
                    line.getEndPoint().getX(), line.getEndPoint().getY()));
            object.put("head", JSAnnotUtil.makeupEndingStyle(line.getLineStartStyle()));
            object.put("tail", JSAnnotUtil.makeupEndingStyle(line.getLineEndStyle()));
            object.put("leaderLength", line.getLeaderLineLength());
            object.put("leaderExtend", line.getLeaderLineExtensionLength());
            object.put("caption", line.hasCaption() ? "yes" : "no");
        } catch (JSONException | PDFException e) {
            e.printStackTrace();
        }
        return object;
    }
}
