/**
 * Copyright (C) 2003-2023, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdf.function.json;


import com.foxit.sdk.PDFException;
import com.foxit.sdk.common.fxcrt.RectF;
import com.foxit.sdk.pdf.PDFDoc;
import com.foxit.sdk.pdf.annots.Annot;
import com.foxit.sdk.pdf.annots.Caret;

import org.json.JSONException;
import org.json.JSONObject;

public class JSCaret {

    public static JSONObject exportToJSON(PDFDoc doc, Annot annot) {
        JSONObject object = JSMarkupAnnot.exportToJSON(doc, annot);
        try {
            Caret caret = new Caret(annot);
            RectF pdfRect = caret.getRect();
            RectF innerRect = caret.getInnerRect();
            String fringe = String.valueOf(innerRect.getLeft() - pdfRect.getLeft());
            fringe += ",";
            fringe += String.valueOf(innerRect.getBottom() - pdfRect.getBottom());
            fringe += ",";
            fringe += String.valueOf(pdfRect.getRight() - innerRect.getRight());
            fringe += ",";
            fringe += String.valueOf(pdfRect.getTop() - innerRect.getTop());
            object.put("fringe", fringe);

            object.remove("style");
            object.remove("width");
            object.remove("dashPhase");
            object.remove("intensity");
        } catch (PDFException | JSONException e) {
            e.printStackTrace();
        }
        return object;
    }
}
