/**
 * Copyright (C) 2003-2023, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdf.function.annotation;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;

import com.foxit.sdk.ActionCallback;
import com.foxit.sdk.ButtonItem;
import com.foxit.sdk.DialogDescriptionConfig;
import com.foxit.sdk.IdentityProperties;
import com.foxit.sdk.MediaPlayerCallback;
import com.foxit.sdk.MenuItemConfig;
import com.foxit.sdk.MenuItemEx;
import com.foxit.sdk.MenuItemExArray;
import com.foxit.sdk.MenuListArray;
import com.foxit.sdk.PlayerArgs;
import com.foxit.sdk.PrintParams;
import com.foxit.sdk.SOAPRequestProperties;
import com.foxit.sdk.SOAPResponseInfo;
import com.foxit.sdk.common.Constants;
import com.foxit.sdk.common.Range;
import com.foxit.sdk.common.WStringArray;
import com.foxit.sdk.common.fxcrt.PointF;
import com.foxit.sdk.common.fxcrt.RectF;
import com.foxit.sdk.pdf.PDFDoc;
import com.foxit.sdk.pdf.Signature;
import com.foxit.sdk.pdf.actions.Destination;

class CustomActionCallback extends ActionCallback {

    private String mVersion;

    CustomActionCallback(Context context) {
        try {
            PackageInfo pInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            mVersion = pInfo.versionName;
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void release() {

    }

    @Override
    public boolean invalidateRect(PDFDoc document, int page_index, RectF pdf_rect) {
        return false;
    }

    @Override
    public int getCurrentPage(PDFDoc document) {
        return 0;
    }

    @Override
    public void setCurrentPage(PDFDoc document, int page_index) {
    }

    @Override
    public void setCurrentPage(PDFDoc document, Destination destination) {
    }

    @Override
    public int getPageRotation(PDFDoc document, int page_index) {
        return Constants.e_Rotation0;
    }

    @Override
    public boolean setPageRotation(PDFDoc document, int page_index, int rotation) {
        return false;
    }

    @Override
    public boolean executeNamedAction(PDFDoc document, String named_action) {
        return false;
    }

    @Override
    public boolean setDocChangeMark(PDFDoc document, boolean change_mark) {
        return false;
    }

    @Override
    public boolean getDocChangeMark(PDFDoc document) {
        return false;
    }

    @Override
    public int getOpenedDocCount() {
        return 1;
    }

    @Override
    public PDFDoc getOpenedDoc(int index) {
        return null;
    }

    @Override
    public PDFDoc getCurrentDoc() {
        return null;
    }

    @Override
    public PDFDoc createBlankDoc() {
        return null;
    }

    @Override
    public void closeDoc(PDFDoc document, boolean is_prompt_to_save) {
    }

    @Override
    public PDFDoc openDoc(String file_path, String password) {
        return null;
    }

    @Override
    public boolean beep(int type) {
        return false;
    }

    @Override
    public String response(String question, String title, String default_value, String label, boolean is_password) {
        return null;
    }

    @Override
    public String getFilePath(PDFDoc document) {
        return null;
    }

    @Override
    public boolean isLocalFile(PDFDoc document) {
        return false;
    }

    @Override
    public String getAttachmentsFilePath(PDFDoc pdf_doc, String name) {
        return "";
    }

    @Override
    public String getExtractedEmbeddedFilePath(PDFDoc pdf_doc, String name) {
        return "";
    }

    @Override
    public boolean print(PDFDoc document, boolean is_ui, Range page_range, boolean is_silent, boolean is_shrunk_to_fit,
                         boolean is_printed_as_image, boolean is_reversed, boolean is_to_print_annots) {
        return false;
    }

    @Override
    public boolean print(PDFDoc document, PrintParams print_params) {
        return false;
    }

    @Override
    public boolean submitForm(PDFDoc document, byte[] form_data, String url, int file_format_type) {
        return false;
    }

    @Override
    public boolean launchURL(String url) {
        return false;
    }

    @Override
    public String browseFile() {
        return null;
    }

    @Override
    public String browseFile(boolean is_open_dialog, String file_format, String file_filter) {
        return null;
    }

    @Override
    public int getLanguage() {
        return e_LanguageCHS;
    }

    @Override
    public int alert(String msg, String title, int type, int icon) {
        return 0;
    }

    @Override
    public IdentityProperties getIdentityProperties() {
        return new IdentityProperties("foxitsoftware", "simple_demo@foxitsoftware.cn", "simple demo", "Simple", "", "", "", "");
    }

    @Override
    public boolean setIdentityProperties(IdentityProperties identity_properties) {
        return false;
    }

    @Override
    public String popupMenu(MenuListArray menus, boolean is_selected_item) {
        return null;
    }

    @Override
    public MenuItemEx popupMenuEx(MenuItemExArray menus, boolean is_selected_item) {
        return null;
    }

    @Override
    public String getAppInfo(int type) {
        String info = "";
        switch (type) {
            case e_AppInfoTypeFormsVersion:
                info = "7.3";
                break;
            case e_AppInfoTypeViewerType:
                info = "Exchange-Pro";
                break;
            case e_AppInfoTypeViewerVariation:
                info = "Full";
                break;
            case e_AppInfoTypeViewerVersion:
                info = "11.007";
                break;
            case e_AppInfoTypeAppVersion:
                info = mVersion;
                break;
            default:
        }
        return info;
    }

    @Override
    public boolean mailData(Object data, boolean is_ui, String to, String subject, String cc, String bcc, String message) {
        return false;
    }

    @Override
    public int verifySignature(PDFDoc document, Signature pdf_signature) {
        return Signature.e_StateUnknown;
    }

    @Override
    public String getUntitledBookmarkName() {
        return "";
    }

    @Override
    public WStringArray getPrinterNameList() {
        return new WStringArray();
    }

    @Override
    public boolean addToolButton(ButtonItem button_item) {
        return false;
    }

    @Override
    public boolean removeToolButtom(String button_name) {
        return false;
    }

    @Override
    public MenuListArray getMenuItemNameList() {
        return new MenuListArray();
    }

    @Override
    public boolean addMenuItem(MenuItemConfig menu_item_config, boolean is_prepend) {
        return false;
    }

    @Override
    public boolean addSubMenu(MenuItemConfig menu_item_config) {
        return false;
    }

    @Override
    public boolean showDialog(DialogDescriptionConfig dlg_config) {
        return false;
    }

    @Override
    public boolean getFullScreen() {
        return false;
    }

    @Override
    public void setFullScreen(boolean is_full_screen) {
    }

    @Override
    public void onFieldValueChanged(String field_name, int type, WStringArray value_before_changed, WStringArray value_after_changed) {
    }

    @Override
    public void updateLogicalLabel() {
    }

    @Override
    public int mailDoc(PDFDoc document, String to_address, String cc_address, String bcc_address, String subject, String message, boolean is_ui) {
        return -1;
    }

    @Override
    public String getTemporaryFileName(PDFDoc document, String file_suffix_name) {
        return "";
    }

    @Override
    public MediaPlayerCallback openMediaPlayer(PlayerArgs player_args) {
        return null;
    }

    @Override
    public String getTemporaryDirectory() {
        return "";
    }

    @Override
    public void scroll(PointF point) {
    }

    @Override
    public void selectPageNthWord(int page_index, int start_offset, int end_offset, boolean is_show_selection) {
    }

    @Override
    public PointF getMousePosition() {
        return new PointF();
    }

    @Override
    public RectF getPageWindowRect() {
        return new RectF();
    }

    @Override
    public int getLayoutMode() {
        return ActionCallback.e_LayoutModeContinuous;
    }

    @Override
    public void setLayoutMode(int layout_mode, boolean is_cover_mode) {
    }

    @Override
    public float getPageScale() {
        return 1.0f;
    }

    @Override
    public void setPageScale(int zoom_mode, Destination dest) {
    }

    @Override
    public int getPageZoomMode() {
        return Destination.e_ZoomFitBHorz;
    }

    @Override
    public SOAPResponseInfo soapRequest(SOAPRequestProperties request_params) {
        return null;
    }

    @Override
    public void enablePageLoop(boolean is_loop) {
    }

    @Override
    public boolean isPageLoop() {
        return false;
    }

    @Override
    public void setDefaultPageTransitionMode(String trans_type, String trans_di) {
    }

    @Override
    public boolean isCurrentDocOpenedInBrowser() {
        return false;
    }

    @Override
    public void postMessageToHtml(WStringArray message) {
    }

}
