/**
 * Copyright (C) 2003-2023, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdf.function;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.widget.Toast;

import com.foxit.pdf.function_demo.R;
import com.foxit.sdk.PDFException;
import com.foxit.sdk.common.Constants;
import com.foxit.sdk.common.Progressive;
import com.foxit.sdk.common.fxcrt.Matrix2D;
import com.foxit.sdk.pdf.PDFDoc;
import com.foxit.sdk.pdf.PDFPage;
import com.foxit.sdk.common.Renderer;

public class Render {
    private Context mContext;

    public Render(Context context) {
        mContext = context;
    }

    public void renderPage(int index) {
        String inputPath = Common.getFixFolder() + "FoxitBigPreview.pdf";
        String outputPath = String.format("%s_index_%d.jpg", Common.getOutputFilesFolder(Common.PDF_TO_IMAGE).concat("FoxitBigPreview"), index);

        PDFDoc doc = Common.loadPDFDoc(mContext, inputPath, null);
        if (doc == null) return;

        try {
            int pageCount = doc.getPageCount();
            if (index > pageCount || index < 0) {
                Toast.makeText(mContext, mContext.getString(R.string.fx_the_page_index_out_of_range), Toast.LENGTH_LONG).show();
                return;
            }

            PDFPage pdfPage = Common.loadPage(mContext, doc, index, PDFPage.e_ParsePageNormal);
            if (pdfPage == null || pdfPage.isEmpty()) {
                return;
            }

            //Create the bitmap and erase its background.
            Bitmap bitmap = Bitmap.createBitmap((int) pdfPage.getWidth(), (int) pdfPage.getHeight(), Bitmap.Config.RGB_565);
            bitmap.eraseColor(Color.WHITE);

            Matrix2D matrix = pdfPage.getDisplayMatrix(0, 0, (int)pdfPage.getWidth(), (int)pdfPage.getHeight(), Constants.e_Rotation0);
            Renderer renderer = new Renderer(bitmap,true);
            //Render the page to bitmap.
            Progressive progressive = renderer.startRender(pdfPage, matrix, null);
            int state = Progressive.e_ToBeContinued;
            while (state == Progressive.e_ToBeContinued) {
                state = progressive.resume();
            }

            if (state == Progressive.e_Error) {
                Toast.makeText(mContext, mContext.getString(R.string.fx_failed_to_render_the_page, index, ""), Toast.LENGTH_LONG).show();
                return;
            }

            //Save the render result to the jpeg image.
            if (!Common.saveImageFile(bitmap, Bitmap.CompressFormat.JPEG, outputPath)) {
                Toast.makeText(mContext, mContext.getString(R.string.fx_failed_to_save_image_file), Toast.LENGTH_LONG).show();
                return;
            }

            Toast.makeText(mContext, Common.getSuccessInfo(mContext, outputPath), Toast.LENGTH_LONG).show();
        } catch (PDFException e) {
            Toast.makeText(mContext, mContext.getString(R.string.fx_failed_to_render_the_page, index, e.getMessage()), Toast.LENGTH_LONG).show();
        }
    }
}
