/**
 * Copyright (C) 2003-2023, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdf.function;

import android.content.Context;
import android.widget.Toast;

import com.foxit.pdf.function_demo.R;
import com.foxit.sdk.PDFException;
import com.foxit.sdk.common.Image;
import com.foxit.sdk.common.Progressive;
import com.foxit.sdk.common.fxcrt.PointF;
import com.foxit.sdk.pdf.PDFDoc;
import com.foxit.sdk.pdf.PDFPage;

public class Image2Pdf {
    private Context mContext;

    public Image2Pdf(Context context) {
        this.mContext = context;
    }

    public void doImage2Pdf() {
        try {
            String inputPath = Common.getFixFolder() + "image/";
            String outputPath = Common.getOutputFilesFolder(Common.IMAGE_TO_PDF);
            {
                // Convert .bmp file to PDF document.
                String input_file = inputPath + "watermark.bmp";
                String output_file = outputPath + "watermark_bmp.pdf";
                image2PDF(input_file, output_file);
            }
            {
                // Convert .jpg file to PDF document.
                String input_file = inputPath + "image_samples.jpg";
                String output_file = outputPath + "image_samples_jpg.pdf";
                image2PDF(input_file, output_file);
            }
            {
                // Convert .tif file to PDF document.
                String input_file = inputPath + "TIF2Pages.tif";
                String output_file = outputPath + "TIF2Pages_tif.pdf";
                image2PDF(input_file, output_file);
            }
            {
                // Convert .gif file to PDF document.
                String input_file = inputPath + "image005.gif";
                String output_file = outputPath + "image005_gif.pdf";
                image2PDF(input_file, output_file);
            }
            Toast.makeText(mContext, Common.getSuccessInfo(mContext, outputPath), Toast.LENGTH_LONG).show();
        } catch (PDFException e) {
            Toast.makeText(mContext, mContext.getString(R.string.fx_image_to_pdf_failed, e.getMessage()), Toast.LENGTH_LONG).show();
        }
    }

    private void image2PDF(String input_file, String output_file) throws PDFException {
        Common.checkDirectoryAvailable(output_file.substring(0,output_file.lastIndexOf("/")));
        Image image = new Image(input_file);
        int count = image.getFrameCount();

        PDFDoc doc = new PDFDoc();
        for (int i = 0; i < count; i++) {
            PDFPage page = doc.insertPage(i, image.getWidth(), image.getHeight());
            Progressive progressive = page.startParse(PDFPage.e_ParsePageNormal, null, false);
            int state = Progressive.e_ToBeContinued;
            while (state == Progressive.e_ToBeContinued) {
                state = progressive.resume();
            }

            if (state == Progressive.e_Finished) {
                // Add image to page
                page.addImage(image, i, new PointF(0, 0), image.getWidth(), image.getHeight(), true);
            }
        }
        doc.saveAs(output_file, PDFDoc.e_SaveFlagNoOriginal);
    }
}
