/**
 * Copyright (C) 2003-2023, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.pdf.function;

import android.content.Context;
import android.util.Log;
import android.widget.Toast;

import com.foxit.pdf.function_demo.R;
import com.foxit.sdk.PDFException;
import com.foxit.sdk.common.WStringArray;
import com.foxit.sdk.pdf.Metadata;
import com.foxit.sdk.pdf.PDFDoc;

import java.io.File;
import java.io.FileWriter;

public class DocInfo {
    private Context mContext;

    public DocInfo(Context context) {
        mContext = context;
    }

    public void outputDocInfo() {
        String inputPath = Common.getFixFolder() + "FoxitBigPreview.pdf";
        String outputPath = Common.getOutputFilesFolder(Common.DOCINFO) + "FoxitBigPreview_docinfo.txt";
        PDFDoc doc = Common.loadPDFDoc(mContext, inputPath, null);
        if (doc == null) {
            return;
        }

        File txtFile = new File(outputPath);
        try {
            FileWriter fileWriter = new FileWriter(txtFile);

            //pageCount
            int pageCount = doc.getPageCount();
            fileWriter.write(String.format("Page Count: %d pages\r\n", pageCount));

            //title
            Metadata metadata = new Metadata(doc);

            String title = String.format("Title :%s\r\n", getMetadataValue("Title", metadata));
            //If there is no title info in the document, it uses the file name instead.
            if (title.equals("")) {
                title = Common.getFileNameWithoutExt(inputPath);
            }
            fileWriter.write(title);

            //author
            fileWriter.write(String.format("Author: %s\r\n", getMetadataValue("Author", metadata)));
            //subject
            fileWriter.write(String.format("Subject: %s\r\n", getMetadataValue("Subject", metadata)));
            //keywords
            fileWriter.write(String.format("Keywords: %s\r\n",getMetadataValue("Keywords", metadata)));

            fileWriter.flush();
            fileWriter.close();
        } catch (Exception e) {
            Toast.makeText(mContext, mContext.getString(R.string.fx_failed_to_export_doc_error, inputPath), Toast.LENGTH_LONG).show();
            return;
        }

        Toast.makeText(mContext, Common.getSuccessInfo(mContext, outputPath), Toast.LENGTH_LONG).show();
    }

    private String getMetadataValue(String key, Metadata metadata) {
        String value = "";
        try {
            WStringArray values  = metadata.getValues(key);
            if (values.getSize() > 0) {
                value = values.getAt(0);
            }
        } catch (PDFException e) {
            Log.e("DocInfo", "getMetadataValue exception" + e.getMessage());
        }
        return value;
    }
}
