/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.net.Uri;
import android.os.Environment;
import android.text.TextUtils;
import androidx.documentfile.provider.DocumentFile;

import com.foxit.home.R;
import com.foxit.pdfreader.MultiTabView;
import com.foxit.pdfreader.fragment.AppTabsManager;
import com.foxit.sdk.common.Constants;
import com.foxit.sdk.common.Library;
import com.foxit.uiextensions.controls.toolbar.IBaseItem;
import com.foxit.uiextensions.home.local.LocalModule;
import com.foxit.uiextensions.utils.AppDarkUtil;
import com.foxit.uiextensions.utils.AppFileUtil;
import com.foxit.uiextensions.utils.AppStorageManager;
import com.foxit.uiextensions.utils.UIToast;

import java.io.File;
import java.util.HashMap;

import static com.foxit.home.HomeFragment.REQUEST_SELECT_DEFAULT_FOLDER;

public class App {
    private static String sn = "sy+CQGL3lQTzjrOSMP6QAvO1rwFnud/CBdmix+C2mNOAUaEH/iWdVQ==";
    private static String key = "ezJvjlkmtGhz9DsCWrtpumK1AHewrp0kYOfoupgAzff+5pl3cJ0X7qAyKFiqyH0I/mwxlqRJydJZLp71xZ1+G0GQBgp2DDjTwjKsljIImW43DAykPfCkteACzXnAJtBlmKQLBWbb84HvmQyhcuvX1XJbBtOkmniJlt8SuGorH/OBaLn33OnBUG0KLJzrDWWHDOljpxcGsKgC1OthpmdmB/UTPY26dG0YcR24m1Z/DRnIxOGxKhG9pBWxAIBoTY2haZD63TjYOVxK2mCpNdnW2fWMMevPDq4+ZfxxeGGBsQ2GFW+E16I5iWJW4x6Y5XRpeeRhXbz++MlGn5nFjgL2trkqg2OkVDQ7T8fhau2dRuyoDfeRV5SGMlxd5Xn3VMjjZSmeFTHWxooHxNkEcyzHrgzk3IODkdahgqwMr8BbeENK1qZ2oHAbo2hK+W7hXtE1n2HZ4egX6/MXHY2flJ+2FaFf4uGJex5F7AYL21Uq4fCJZGN6DnqnVLyyLEal7vOpjx0MIH8Xj/nG32xKtZr2vCMQwSs/U90dzOIaZoeNLfSnQ0cFnicdn3jiEUsmjWcEx5GRoiOQfTYLeidvwGPHu46jBH7/VQLH7g7Kb8lD7BRai8wWGP5eEa1MS5SEMoVodI+lzuHh2zaHfxWgVcy7yvxCDoyQyP02D/2yFDbh1FcfFAjyQFWHtp92u1f9+sawyRYdJA/wULhSYtpq3265q0/5Wd0gOg7LGhn/Py3cni8tmc99UlDJA23lZICK+BnS4QMW32/dz4oZ4O+aLk+4asIwkuTJDUKmHyeQCpPVeWRdomLFBZV9xs11NHgjyhhLFHUOI5DTmWZGUxggzbnOVTsL+ibmx9QuIaxd6QZmjU1MvCiW9U0w7yhxitxW9hL4SIIERnU5KhEYkcft55n2WyDP2T5GXR/c+rt/NFOSysNRVVSScVe4NG275EhLATQpe1w78c7HQPzWopLqXDB/Haecex+jPpwq2lhLgAPRmiGscbIgnP+wKm/us/sdCHXz3HDfrdg+v6zCFzDbU+OL770jtANMrpwMHm9/HOub20re5PQIu9cNaHIjUIIpOpLpIolXtthzqE2Ch3TZ0o4Gf2UvGG4EqEvlzDEDkTcImUak73fq32lS+vMqmnRco0tWP65wmK8inNdr7HwgIszIwFHfFpGksJS3FI60U146GMGpdpcxgNJQdxDUD5nm7/yCOOlDs1U+70GfJRfNtBTUC114QrQ1hghlbsX0mRqgozC0qJ8sNujlZK1qqbs4xzRgcP7hdUwHY0Y8WF59NNu41E6Uu7Xm5niH+NY9apw=";
    private Context mContext;
    private int errCode = Constants.e_ErrSuccess;
    private static App INSTANCE = new App();

    public static App instance() {
        return INSTANCE;
    }

    private App() {
        errCode = Library.initialize(sn, key);
    }

    public boolean checkLicense() {
        switch (errCode) {
            case Constants.e_ErrSuccess:
                break;
            case Constants.e_ErrInvalidLicense:
                UIToast.getInstance(mContext).show(mContext.getString(R.string.fx_the_license_is_invalid));
                return false;
            default:
                UIToast.getInstance(mContext).show(mContext.getString(R.string.fx_failed_to_initialize_the_library));
                return false;
        }
        return true;
    }

    public void setApplicationContext(Context context) {
        mContext = context;
        AppDarkUtil.getInstance(mContext).setCurNightMode(mContext.getResources().getConfiguration().uiMode & Configuration.UI_MODE_NIGHT_MASK);
    }

    public Context getApplicationContext() {
        return mContext;
    }

    HashMap<String, LocalModule> mLocalModules = new HashMap<String, LocalModule>();

    public LocalModule getLocalModule(String filter) {
        if (mLocalModules.get(filter) == null) {
            LocalModule module = new LocalModule(mContext);
            module.loadModule();
            mLocalModules.put(filter, module);
        }
        return mLocalModules.get(filter);
    }

    public void onDestroy() {
        for (LocalModule module : mLocalModules.values()) {
            module.unloadModule();
        }

        mLocalModules.clear();
    }

    public void unloadLocalModule(String filter) {
        LocalModule module = mLocalModules.get(filter);
        if (module != null) {
            module.unloadModule();

            mLocalModules.remove(filter);
        }
    }

    HashMap<String, MultiTabView> mMultiTabViews = new HashMap<String, MultiTabView>();

    public MultiTabView getMultiTabView(String filter) {
        if (mMultiTabViews.get(filter) == null) {
            MultiTabView view = new MultiTabView();
            view.initialize();
            mMultiTabViews.put(filter, view);
        }
        return mMultiTabViews.get(filter);
    }

    boolean mIsMultiTab = false;

    public boolean isMultiTab() {
        return mIsMultiTab;
    }

    public void setMultiTabFlag(boolean isMultiTab) {
        mIsMultiTab = isMultiTab;
    }

    HashMap<String, AppTabsManager> mTabsManagers = new HashMap<String, AppTabsManager>();

    public AppTabsManager getTabsManager(String filter) {
        if (mTabsManagers.get(filter) == null) {
            AppTabsManager manager = new AppTabsManager();
            mTabsManagers.put(filter, manager);
        }
        return mTabsManagers.get(filter);
    }

    public void copyGuideFiles(LocalModule localModule) {
        if (Environment.getExternalStorageState().equals(Environment.MEDIA_MOUNTED)) {
            String curPath = AppStorageManager.getInstance(mContext).getDefaultFolder();
            if (!AppFileUtil.needScopedStorageAdaptation()){
                curPath = AppFileUtil.getDefaultDocumentDirectory();
                File file = new File(curPath);
                if (!file.exists()){
                    if (!file.mkdirs())
                        return;
                }
                File sampleFile = new File(curPath + File.separator + "Sample.pdf");
                if (!sampleFile.exists()) {
                    localModule.copyFileFromAssertsToTargetFile(sampleFile);
                }

                File guideFile = new File(curPath + File.separator + "complete_pdf_viewer_guide_android.pdf");
                if (!guideFile.exists()) {
                    localModule.copyFileFromAssertsToTargetFile(guideFile);
                }
            }else if (!TextUtils.isEmpty(curPath)){
                Uri uri = AppFileUtil.toDocumentUriFromPath(curPath);
                if (AppFileUtil.isDocumentTreeUri(uri)){
                    DocumentFile directory = AppStorageManager.getInstance(mContext).getExistingDocumentFile(uri);
                    if (directory == null)return;
                    String fileName = "Sample.pdf";
                    DocumentFile file = directory.findFile(fileName);
                    if (file == null){
                        file = directory.createFile(AppFileUtil.getMimeType(fileName), fileName);
                        localModule.copyFileFromAssertsToTargetFile(file);
                    }

                    fileName = "complete_pdf_viewer_guide_android.pdf";
                    file = directory.findFile(fileName);
                    if (file == null){
                        file = directory.createFile(AppFileUtil.getMimeType(fileName), fileName);
                        localModule.copyFileFromAssertsToTargetFile(file);
                    }
                }
                localModule.setCurrentPath(curPath);
            }
        }
    }

    HashMap<String, IBaseItem> mTabsButtons = new HashMap<String, IBaseItem>();

    public void setTabsButton(String filter, IBaseItem button) {
        mTabsButtons.put(filter, button);
    }

    public IBaseItem getTabsButton(String filter) {
        return mTabsButtons.get(filter);
    }

    public void onBack() {
        mTabsButtons.clear();
        mTabsManagers.clear();
        mMultiTabViews.clear();
    }

    public static final String FILTER_DEFAULT = "default_filter";

    public void selectDefaultFolderOrNot(Activity activity) {
        if (AppFileUtil.needScopedStorageAdaptation()){
            if (activity != null && TextUtils.isEmpty(AppStorageManager.getInstance(activity).getDefaultFolder())) {
                AppFileUtil.checkCallDocumentTreeUriPermission(activity, REQUEST_SELECT_DEFAULT_FOLDER,
                        Uri.parse(AppFileUtil.getExternalRootDocumentTreeUriPath()));
                UIToast.getInstance(activity).show(R.string.select_default_folder_toast_content);
            }
        }
    }
}
