/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.utils;


import com.foxit.sdk.pdf.annots.Annot;
import com.foxit.uiextensions.DocumentManager;

public class AnnotPermissionUtil {

    public static boolean canAddAnnot(DocumentManager dm) {
        return dm.withAddPermission();
    }

    public static boolean canModifyAnnot(DocumentManager dm, Annot annot) {
        return dm.withModifyPermission() && dm.withModifyPermission(annot);
    }

    public static boolean canDeleteAnnot(DocumentManager dm, Annot annot) {
        return dm.withDeletePermission() && dm.withDeletePermission(annot);
    }

    public static boolean canReplyAnnot(DocumentManager dm, Annot annot) {
        return dm.withReplyPermission(annot) && dm.withAddPermission();
    }

    public static boolean canFlattenAnnot(DocumentManager dm, Annot annot) {
        return dm.withFlattenPermission(annot) && dm.withModifyPermission() && dm.withDeletePermission();
    }

    public static boolean canEditabled(DocumentManager dm, Annot annot) {
        return !(AppAnnotUtil.isLocked(annot) || AppAnnotUtil.isReadOnly(annot)) && canModifyAnnot(dm, annot);
    }

}
