/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.theme;


import android.content.Context;

import com.foxit.uiextensions.R;
import com.foxit.uiextensions.utils.AppResource;
import com.foxit.uiextensions.utils.AppSharedPreferences;

import androidx.annotation.NonNull;


public class ThemeConfig implements IThemeConfig {
    private final String PREF_NAEM = "foxit_theme_preference";

    private static ThemeConfig instance;
    private AppSharedPreferences mSP;
    private IThemeAdapter mThemeAdapter;
    private Context mContext;
    private DynamicColorProvider accentColorProvider;

    private ThemeConfig(Context context) {
        mContext = context.getApplicationContext();
        mSP = AppSharedPreferences.getInstance(mContext);
    }

    public static ThemeConfig getInstance(Context context) {
        if (instance == null) {
            instance = new ThemeConfig(context);
        }
        return instance;
    }

    public void setAdapter(@NonNull IThemeAdapter adapter) {
        mThemeAdapter = adapter;
    }

    public IThemeAdapter getAdapter() {
        return mThemeAdapter;
    }

    private void notifyThemeChanged(String type, int color) {
        if (mThemeAdapter != null) {
            mThemeAdapter.notifyThemeChanged(type, color);
        }
    }

    @Override
    public void primaryColor(int color) {
        mSP.setInteger(PREF_NAEM, KEY_PRIMARY, color);
        notifyThemeChanged(KEY_PRIMARY, color);
    }

    @Override
    public void secondColor(int color) {
        mSP.setInteger(PREF_NAEM, KEY_SECOND, color);
        notifyThemeChanged(KEY_SECOND, color);
    }

    @Override
    public void b1(int color) {
        mSP.setInteger(PREF_NAEM, KEY_B1, color);
        notifyThemeChanged(KEY_B1, color);
    }

    @Override
    public void b2(int color) {
        mSP.setInteger(PREF_NAEM, KEY_B2, color);
        notifyThemeChanged(KEY_B2, color);
    }

    @Override
    public void p1(int color) {
        mSP.setInteger(PREF_NAEM, KEY_P1, color);
        notifyThemeChanged(KEY_P1, color);
    }

    @Override
    public void p2(int color) {
        mSP.setInteger(PREF_NAEM, KEY_P2, color);
        notifyThemeChanged(KEY_P2, color);
    }

    @Override
    public void t1(int color) {
        mSP.setInteger(PREF_NAEM, KEY_T1, color);
        notifyThemeChanged(KEY_T1, color);
    }

    @Override
    public void t2(int color) {
        mSP.setInteger(PREF_NAEM, KEY_T2, color);
        notifyThemeChanged(KEY_T2, color);
    }

    @Override
    public void t3(int color) {
        mSP.setInteger(PREF_NAEM, KEY_T3, color);
        notifyThemeChanged(KEY_T3, color);
    }

    @Override
    public void t4(int color) {
        mSP.setInteger(PREF_NAEM, KEY_T4, color);
        notifyThemeChanged(KEY_T4, color);
    }

    @Override
    public void t5(int color) {
        mSP.setInteger(PREF_NAEM, KEY_T5, color);
        notifyThemeChanged(KEY_T5, color);
    }

    @Override
    public void t6(int color) {
        mSP.setInteger(PREF_NAEM, KEY_T6, color);
        notifyThemeChanged(KEY_T6, color);
    }

    @Override
    public void i1(int color) {
        mSP.setInteger(PREF_NAEM, KEY_I1, color);
        notifyThemeChanged(KEY_I1, color);
    }

    @Override
    public void i2(int color) {
        mSP.setInteger(PREF_NAEM, KEY_I2, color);
        notifyThemeChanged(KEY_I2, color);
    }

    @Override
    public void i3(int color) {
        mSP.setInteger(PREF_NAEM, KEY_I3, color);
        notifyThemeChanged(KEY_I3, color);
    }

    @Override
    public int getPrimaryColor() {
        return mSP.getInteger(PREF_NAEM, KEY_PRIMARY, AppResource.getColor(mContext, R.color.main_color));
    }

    @Override
    public int getSecondColor() {
        return mSP.getInteger(PREF_NAEM, KEY_SECOND, AppResource.getColor(mContext, R.color.second_color));
    }

    @Override
    public int getB1() {
        return mSP.getInteger(PREF_NAEM, KEY_B1, AppResource.getColor(mContext, R.color.b1));
    }

    @Override
    public int getB2() {
        return mSP.getInteger(PREF_NAEM, KEY_B2, AppResource.getColor(mContext, R.color.b2));
    }

    @Override
    public int getP1() {
        return mSP.getInteger(PREF_NAEM, KEY_P1, AppResource.getColor(mContext, R.color.p1));
    }

    @Override
    public int getP2() {
        return mSP.getInteger(PREF_NAEM, KEY_P2, AppResource.getColor(mContext, R.color.p2));
    }

    @Override
    public int getT1() {
        return mSP.getInteger(PREF_NAEM, KEY_T1, AppResource.getColor(mContext, R.color.t1));
    }

    @Override
    public int getT2() {
        return mSP.getInteger(PREF_NAEM, KEY_T2, AppResource.getColor(mContext, R.color.t2));
    }

    @Override
    public int getT3() {
        return mSP.getInteger(PREF_NAEM, KEY_T3, AppResource.getColor(mContext, R.color.t3));
    }

    @Override
    public int getT4() {
        return mSP.getInteger(PREF_NAEM, KEY_T4, AppResource.getColor(mContext, R.color.t4));
    }

    @Override
    public int getT5() {
        return mSP.getInteger(PREF_NAEM, KEY_T5, AppResource.getColor(mContext, R.color.t5));
    }

    @Override
    public int getT6() {
        return mSP.getInteger(PREF_NAEM, KEY_T6, AppResource.getColor(mContext, R.color.t6));
    }

    @Override
    public int getI1() {
        return mSP.getInteger(PREF_NAEM, KEY_I1, AppResource.getColor(mContext, R.color.i1));
    }

    @Override
    public int getI2() {
        return mSP.getInteger(PREF_NAEM, KEY_I2, AppResource.getColor(mContext, R.color.i2));
    }

    @Override
    public int getI3() {
        return mSP.getInteger(PREF_NAEM, KEY_I3, AppResource.getColor(mContext, R.color.i3));
    }

    public void setAccentColorProvider(DynamicColorProvider provider) {
        this.accentColorProvider = provider;
    }

    public DynamicColorProvider getAccentColorProvider() {
        return accentColorProvider;
    }

}
