/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.theme;

import android.database.Observable;

public class ThemeChangeObservable extends Observable<IThemeChangeObserver> {
    public void notifyChanged(String type, int color) {
        synchronized (mObservers) {
            for (int i = mObservers.size() - 1; i >=0; i--) {
                mObservers.get(i).onThemeChanged(type, color);
            }
        }
    }
}
