/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.theme;

public interface IThemeAdapter {
    /**
     * Register a new observer to listen for theme changes.
     *
     * @param observer Observer to register
     *
     * @see #unregisterThemeChangeObserver(IThemeChangeObserver)
     */
    void registerThemeChangeObserver(IThemeChangeObserver observer);

    /**
     * Unregister an observer currently listening for theme changes.
     *
     * @param observer Observer to unregister
     *
     * @see #registerThemeChangeObserver(IThemeChangeObserver)
     */
    void unregisterThemeChangeObserver(IThemeChangeObserver observer);

    /**
     * Notify any registered observers that theme has changed.
     *
     * @param type The theme type
     * @param color The theme color will be changed
     */
    void notifyThemeChanged(String type, int color);
}
