/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.security.trustcertificate;


import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;

import com.foxit.sdk.PDFViewCtrl;
import com.foxit.uiextensions.Module;
import com.foxit.uiextensions.R;
import com.foxit.uiextensions.UIExtensionsManager;
import com.foxit.uiextensions.controls.propertybar.PropertyBar;
import com.foxit.uiextensions.controls.toolbar.IToolSupply;
import com.foxit.uiextensions.controls.toolbar.ToolConstants;
import com.foxit.uiextensions.controls.toolbar.ToolItemBean;
import com.foxit.uiextensions.controls.toolbar.ToolProperty;
import com.foxit.uiextensions.controls.toolbar.drag.UIToolBaseBar;
import com.foxit.uiextensions.controls.toolbar.impl.ToolSupplyBtnImpl;
import com.foxit.uiextensions.controls.toolbar.impl.ToolSupplyImpl;
import com.foxit.uiextensions.controls.toolbar.impl.UIColorItem;
import com.foxit.uiextensions.utils.AppResource;

public class TrustCertificateModule implements Module {

    private PDFViewCtrl mPDFViewCtrl;
    private Context mContext;
    private PDFViewCtrl.UIExtensionsManager mUiExtensionsManager;
    private TrustCertUtil mTrustCertUtil;
    private TrustCertificateListDialog mTrustedDialog;
    private int mNightMode = -1;

    public TrustCertificateModule(Context context, PDFViewCtrl pdfViewCtrl, UIExtensionsManager uiExtensionsManager) {
        this.mContext = context;
        mPDFViewCtrl = pdfViewCtrl;
        mUiExtensionsManager = uiExtensionsManager;
    }

    @Override
    public String getName() {
        return MODULE_NAME_TRUST_CERTIFICATE;
    }

    @Override
    public boolean loadModule() {
        mToolSupply = new TrustCertToolSupply(mContext, R.drawable.more_menu_certificate_protect);
        if (mUiExtensionsManager != null) {
            ((UIExtensionsManager) mUiExtensionsManager).registerModule(this);
            ((UIExtensionsManager) mUiExtensionsManager).registerConfigurationChangedListener(mConfigurationChangedListener);
            ((UIExtensionsManager) mUiExtensionsManager).getToolsManager().addToolItem(UIToolBaseBar.USAGE_TYPE_PROTECT, ToolConstants.ProtectTypeTrustCert, mToolSupply);
        }
        mNightMode = mContext.getResources().getConfiguration().uiMode & Configuration.UI_MODE_NIGHT_MASK;
        mTrustCertUtil = new TrustCertUtil(mContext, mPDFViewCtrl);
        return true;
    }

    private IToolSupply mToolSupply;
    class TrustCertToolSupply extends ToolSupplyBtnImpl {
        public TrustCertToolSupply(Context context, int ImgResId) {
            super(context, ImgResId);
        }
        @Override
        public ToolProperty createToolProperty(int toolType) {
            return null;
        }

        @Override
        public String getToolName(int toolType) {
            return AppResource.getString(mContext, R.string.menu_more_item_trust_certificate);
        }

        @Override
        public void onClick(ToolItemBean itemBean) {
            showTrustCertDialog();
        }

        @Override
        public void resetPropertyBar(ToolItemBean itemBean, PropertyBar.PropertyChangeListener propertyChangeListener) {

        }

        @Override
        public PropertyBar getPropertyBar() {
            return null;
        }
    };

    public TrustCertUtil getTrusetCertUtil() {
        return mTrustCertUtil;
    }

    @Override
    public boolean unloadModule() {
        if (mUiExtensionsManager != null) {
            ((UIExtensionsManager) mUiExtensionsManager).unregisterConfigurationChangedListener(mConfigurationChangedListener);
            ((UIExtensionsManager) mUiExtensionsManager).getToolsManager().removeToolItem(UIToolBaseBar.USAGE_TYPE_PROTECT, ToolConstants.ProtectTypeTrustCert, mToolSupply);
        }
        return true;
    }

    public void show() {
        showTrustCertDialog();
    }

    private void showTrustCertDialog() {
        if (mUiExtensionsManager == null)
            return;
        if (((UIExtensionsManager) mUiExtensionsManager).getDocumentManager().getCurrentAnnot() != null)
            ((UIExtensionsManager) mUiExtensionsManager).getDocumentManager().setCurrentAnnot(null);
        Activity activity = ((UIExtensionsManager) mUiExtensionsManager).getAttachedActivity();
        if (activity == null)
            return;
        if (mTrustedDialog == null) {
            mTrustedDialog = new TrustCertificateListDialog(activity, mPDFViewCtrl);
        }
        mTrustedDialog.loadData();
        mTrustedDialog.showDialog();
    }

    UIExtensionsManager.ConfigurationChangedListener mConfigurationChangedListener = new UIExtensionsManager.ConfigurationChangedListener() {
        @Override
        public void onConfigurationChanged(Configuration newConfig) {

            if (mNightMode != (newConfig.uiMode & Configuration.UI_MODE_NIGHT_MASK)) {
                mNightMode = newConfig.uiMode & Configuration.UI_MODE_NIGHT_MASK;
                if (mTrustedDialog != null) {
                    mTrustedDialog.dismiss();
                    mTrustedDialog = null;
                }
                if (mTrustCertUtil != null && mTrustCertUtil.getCertViewSupport() != null) {
                    mTrustCertUtil.getCertViewSupport().onConfigurationChanged(newConfig);
                }
                return;
            }

            if (mTrustCertUtil != null && mTrustCertUtil.getCertViewSupport() != null) {
                mTrustCertUtil.getCertViewSupport().onConfigurationChanged();
            }

            if (mTrustedDialog != null && mTrustedDialog.isShowing()) {
                mTrustedDialog.resetWH();
                mTrustedDialog.showDialog();
            }
        }
    };

    public void dismissDialog(){
        if (mTrustedDialog != null){
            mTrustedDialog.dismiss();
        }
        if (mTrustCertUtil != null && mTrustCertUtil.getCertViewSupport() != null) {
            mTrustCertUtil.getCertViewSupport().dismissPfxDialog();
        }
    }
}
