/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.security.standard;

import android.content.Context;
import android.content.res.Configuration;
import android.text.TextUtils;
import android.view.View;

import com.foxit.sdk.PDFException;
import com.foxit.sdk.PDFViewCtrl;
import com.foxit.sdk.common.Constants;
import com.foxit.sdk.pdf.PDFDoc;
import com.foxit.uiextensions.IPermissionProvider;
import com.foxit.uiextensions.Module;
import com.foxit.uiextensions.R;
import com.foxit.uiextensions.UIExtensionsManager;
import com.foxit.uiextensions.controls.dialog.UIDialog;
import com.foxit.uiextensions.controls.dialog.UITextEditDialog;
import com.foxit.uiextensions.controls.propertybar.PropertyBar;
import com.foxit.uiextensions.controls.toolbar.ToolConstants;
import com.foxit.uiextensions.controls.toolbar.ToolItemBean;
import com.foxit.uiextensions.controls.toolbar.ToolProperty;
import com.foxit.uiextensions.controls.toolbar.ToolbarItemConfig;
import com.foxit.uiextensions.controls.toolbar.drag.UIToolBaseBar;
import com.foxit.uiextensions.controls.toolbar.impl.ToolSupplyBtnImpl;
import com.foxit.uiextensions.event.DocEventListener;
import com.foxit.uiextensions.pdfreader.IStateChangeListener;
import com.foxit.uiextensions.pdfreader.impl.MainFrame;
import com.foxit.uiextensions.utils.AppResource;

import java.util.List;

public class PasswordModule implements Module {
    private PasswordSecurityHandler mSecurityHandler = null;
    private PasswordStandardSupport mSupport = null;

    private PDFViewCtrl mPdfViewCtrl;
    private Context mContext;
    private PDFViewCtrl.UIExtensionsManager mUiExtensionsManager;
    public PasswordModule(Context context, PDFViewCtrl pdfViewCtrl, PDFViewCtrl.UIExtensionsManager uiExtensionsManager) {
        mContext = context;
        mPdfViewCtrl = pdfViewCtrl;
        mUiExtensionsManager = uiExtensionsManager;
    }

    @Override
    public String getName() {
        return MODULE_NAME_PASSWORD;
    }

    @Override
    public boolean loadModule() {
        mToolSupply = new PassWDToolSupply(mContext, R.drawable.more_menu_file_encryption);
        mToolSupply_DE = new PassWDToolSupply_Remove(mContext, R.drawable.more_menu_remove_password);

        ((UIExtensionsManager) mUiExtensionsManager).getToolsManager().addToolItem(UIToolBaseBar.USAGE_TYPE_PROTECT, ToolConstants.ProtectTypeStandard, mToolSupply);
        ((UIExtensionsManager) mUiExtensionsManager).getToolsManager().addToolItem(UIToolBaseBar.USAGE_TYPE_PROTECT, ToolConstants.ProtectTypeStandRemove, mToolSupply_DE);

        if (mUiExtensionsManager != null && mUiExtensionsManager instanceof UIExtensionsManager) {
            ((UIExtensionsManager) mUiExtensionsManager).registerModule(this);
            ((UIExtensionsManager) mUiExtensionsManager).registerConfigurationChangedListener(mConfigurationChangedListener);
            ((UIExtensionsManager) mUiExtensionsManager).registerStateChangeListener(mStateChangedListener);

        }
        mSupport = new PasswordStandardSupport(mContext, mPdfViewCtrl);
        mSecurityHandler = new PasswordSecurityHandler(mSupport, mPdfViewCtrl);
        mPdfViewCtrl.registerDocEventListener(mDocumentEventListener);
        return true;
    }

    private PassWDToolSupply mToolSupply;
    class PassWDToolSupply extends ToolSupplyBtnImpl {

        public PassWDToolSupply(Context context, int ImgResId) {
            super(context, ImgResId);
        }

        @Override
        public void onClick(ToolItemBean itemBean) {
            onEncrypt();
        }

        @Override
        public void resetPropertyBar(ToolItemBean itemBean, PropertyBar.PropertyChangeListener propertyChangeListener) {

        }

        @Override
        public PropertyBar getPropertyBar() {
            return null;
        }

        @Override
        public ToolProperty createToolProperty(int toolType) {
            return null;
        }

        @Override
        public String getToolName(int toolType) {
            return AppResource.getString(mContext, R.string.menu_more_file_encryption);
        }

        };

        private PassWDToolSupply_Remove mToolSupply_DE;
        class PassWDToolSupply_Remove extends ToolSupplyBtnImpl {

        public PassWDToolSupply_Remove(Context context, int ImgResId) {
            super(context, ImgResId);
        }

        @Override
        public void onClick(ToolItemBean itemBean) {
            onDecrypt();
        }

        @Override
        public void resetPropertyBar(ToolItemBean itemBean, PropertyBar.PropertyChangeListener propertyChangeListener) {

        }

        @Override
        public PropertyBar getPropertyBar() {
            return null;
            }

         @Override
        public ToolProperty createToolProperty(int toolType) {
            return null;
            }

        @Override
        public String getToolName(int toolType) {
            return AppResource.getString(mContext, R.string.menu_more_item_remove_encrytion);
        }
    };

    @Override
    public boolean unloadModule() {
        mSupport = null;
        if (mUiExtensionsManager != null && mUiExtensionsManager instanceof UIExtensionsManager) {
            ((UIExtensionsManager) mUiExtensionsManager).unregisterConfigurationChangedListener(mConfigurationChangedListener);
            ((UIExtensionsManager) mUiExtensionsManager).unregisterStateChangeListener(mStateChangedListener);
        }
        mPdfViewCtrl.unregisterDocEventListener(mDocumentEventListener);
        return true;
    }
    private UIExtensionsManager.ConfigurationChangedListener mConfigurationChangedListener = new UIExtensionsManager.ConfigurationChangedListener() {
        @Override
        public void onConfigurationChanged(Configuration newConfig) {
            if(mSupport!=null){
                mSupport.onConfigurationChanged(newConfig);
            }

            if (mSwitchDialog != null && mSwitchDialog.isShowing()) {
                mSwitchDialog.setHeight(mSwitchDialog.getDialogHeight());
                mSwitchDialog.show();
            }

        }
    };
    private IStateChangeListener mStateChangedListener = new IStateChangeListener() {
        @Override
        public void onStateChanged(int oldState, int newState) {
            updateTooItemsState();
        }
    };

    public PasswordStandardSupport getPasswordSupport() {
        return mSupport;
    }

    public PasswordSecurityHandler getSecurityHandler() {
        return mSecurityHandler;
    }

    public void onEncrypt() {
    if (((UIExtensionsManager) mUiExtensionsManager).getPermissionProvider() != null) {
        ((UIExtensionsManager) mUiExtensionsManager).getPermissionProvider().checkPermission(
                        IPermissionProvider.FUNCTION_FILE_ENCRYPTION, new IPermissionProvider.IPermissionState() {
                            @Override
                            public void onState(int state) {
                                if (state == IPermissionProvider.PERMISSION_STATE_SHOW) {
                                    encryptFile();
                                }
                            }
                        }
                        );
        } else {
            encryptFile();
        }
    }

    private UITextEditDialog mSwitchDialog;
    private void encryptFile() {
        try {
            int type = mPdfViewCtrl.getDoc().getEncryptionType();
            if (type != PDFDoc.e_EncryptNone) {
                mSwitchDialog = new UITextEditDialog(((UIExtensionsManager) mUiExtensionsManager).getAttachedActivity(), UIDialog.NO_INPUT);
                mSwitchDialog.setTitle(AppResource.getString(mContext, R.string.rv_doc_encrypt_standard_switch_title));
                mSwitchDialog.getPromptTextView().setText(AppResource.getString(mContext, R.string.rv_doc_encrypt_standard_switch_content));
                mSwitchDialog.getCancelButton().setOnClickListener(new View.OnClickListener() {

                @Override
                public void onClick(View v) {
                    mSwitchDialog.dismiss();
                }
            });
            mSwitchDialog.getOKButton().setOnClickListener(new View.OnClickListener() {

                @Override
                public void onClick(View v) {
                    mSwitchDialog.dismiss();
                    if (mSupport != null) {
                        mSupport.passwordManager(PasswordConstants.OPERATOR_TYPE_CREATE);
                        }
                    }
                });
                mSwitchDialog.show();
            } else {
                if (mSupport != null) {
                    mSupport.passwordManager(PasswordConstants.OPERATOR_TYPE_CREATE);
                }
            }
        } catch (PDFException e) {
            e.printStackTrace();
        }
    }

    public void onDecrypt() {
        if (mSupport != null) {
            mSupport.passwordManager(PasswordConstants.OPERATOR_TYPE_REMOVE);
        }
    }

    private final PDFViewCtrl.IDocEventListener mDocumentEventListener = new DocEventListener() {

        @Override
        public void onDocOpened(PDFDoc document, int errCode) {
            if (errCode != Constants.e_ErrSuccess) {
                return;
            }

            if (mSwitchDialog != null){
                mSwitchDialog.dismiss();
            }

            updateTooItemsState();
        }

    };

    public void updateTooItemsState() {
        if (mPdfViewCtrl.getDoc() != null) {
            boolean isPPDF = false;
            try {
                String filePath = mPdfViewCtrl.getFilePath();
                if (!TextUtils.isEmpty(filePath)) {
                    isPPDF = filePath.endsWith(".ppdf");
                }
                UIExtensionsManager uiExtensionsManager = (UIExtensionsManager) mUiExtensionsManager;
                boolean passwd = (mPdfViewCtrl.getDoc().getEncryptionType() == PDFDoc.e_EncryptPassword);
                if (passwd && !isPPDF) {
                    uiExtensionsManager.getToolsManager().removeToolItem(UIToolBaseBar.USAGE_TYPE_PROTECT, ToolConstants.ProtectTypeStandard);
                    uiExtensionsManager.getToolsManager().addToolItem(UIToolBaseBar.USAGE_TYPE_PROTECT, ToolConstants.ProtectTypeStandRemove, mToolSupply_DE);
                } else {
                    uiExtensionsManager.getToolsManager().addToolItem(UIToolBaseBar.USAGE_TYPE_PROTECT, ToolConstants.ProtectTypeStandard, mToolSupply);
                    uiExtensionsManager.getToolsManager().removeToolItem(UIToolBaseBar.USAGE_TYPE_PROTECT, ToolConstants.ProtectTypeStandRemove);
                }



                boolean enable = getSecurityHandler().isAvailable() && !isPPDF;
                UIToolBaseBar protectToolbar =  uiExtensionsManager.getMainFrame().getToolbar(ToolbarItemConfig.ITEM_PROTECT_TAB);
                if (protectToolbar != null) {
                    List<ToolItemBean> items = protectToolbar.getToolItems().toolItems;
                    if (items != null) {
                        for (ToolItemBean item : items) {
                            if (item.type == ToolConstants.ProtectTypeStandard
                                    || item.type == ToolConstants.ProtectTypeStandRemove) {
                                item.toolItem.setEnable(enable);
                            } else if (item.type == ToolConstants.ProtectTypeRedaction) {
                                item.toolItem.setEnable(uiExtensionsManager.getDocumentManager().canAddAnnot()
                                        && uiExtensionsManager.isEnableModification());
                            }
                            if (item.type == ToolConstants.ProtectTypeStandard && passwd) {
                                item.type = ToolConstants.ProtectTypeStandRemove;
                                item.toolItem.setImageResource(R.drawable.more_menu_remove_password);
                                item.toolItem.setEnable(enable);
                            }
                            if (item.type == ToolConstants.ProtectTypeStandRemove && !passwd) {
                                item.type = ToolConstants.ProtectTypeStandard;
                                item.toolItem.setImageResource(R.drawable.more_menu_file_encryption);
                                item.toolItem.setEnable(enable);
                            }
                        }
                    }
                }
                ((MainFrame)uiExtensionsManager.getMainFrame()).resetToolbar(ToolbarItemConfig.ITEM_PROTECT_TAB);
                /*
                Because the data(toolItems) is saved in mHomeToolbar,
                this function is required to update the state, resetToolbar is then called.
                 */
                UIToolBaseBar homeToolbar =  uiExtensionsManager.getMainFrame().getToolbar(ToolbarItemConfig.ITEM_HOME_TAB);
                if (homeToolbar != null) {
                    List<ToolItemBean> items =homeToolbar.getToolItems().toolItems;
                    if (items != null) {
                        for (ToolItemBean item : items) {
                            if (item.type == ToolConstants.ProtectTypeStandard && passwd) {
                                item.type = ToolConstants.ProtectTypeStandRemove;
                                item.toolItem.setImageResource(R.drawable.more_menu_remove_password);
                                item.toolItem.setEnable(enable);
                            }
                            if (item.type == ToolConstants.ProtectTypeStandRemove && !passwd) {
                                item.type = ToolConstants.ProtectTypeStandard;
                                item.toolItem.setImageResource(R.drawable.more_menu_file_encryption);
                                item.toolItem.setEnable(enable);
                            }
                        }
                    }
                    ((MainFrame)uiExtensionsManager.getMainFrame()).resetToolbar(ToolbarItemConfig.ITEM_HOME_TAB);
                }

            } catch (PDFException e) {
                e.printStackTrace();
            }
        }
    }
}
