/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.security;

import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1StreamParser;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.PrincipalUtil;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

import java.io.IOException;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Vector;

import javax.security.auth.x500.X500Principal;

public class CertUtil {
    static {
        Security.addProvider(new BouncyCastleProvider());
    }

    public CertUtil() {
    }

    public static String getCommonName(X509Certificate cert) {
        try {
            X509Principal principal = PrincipalUtil.getSubjectX509Principal(cert);
            Vector vals = principal.getValues(X509Name.CN);
            String val = null;
            if (vals.size() > 0) {
                val = (String) vals.get(0);
            }

            return val;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }
    public static String getOrganizationName(X509Certificate cert) {
        try {
            X509Principal principal = PrincipalUtil.getSubjectX509Principal(cert);
            Vector vals = principal.getValues(X509Name.OU);
            String val = null;
            if (vals.size() > 0) {
                val = (String) vals.get(0);
            }

            return val;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public static String getEmailFromCert(X509Certificate cert) {
        String name = null;
        name = getRFC822Name(cert);
        if (name == null) {
            name = a(cert);
        }

        return name;
    }

    private static String a(X509Certificate cert) {
        try {
            String[] attrs = getAttributeFromSubject(cert, X509Name.E);
            return attrs != null && attrs.length > 0 ? attrs[0] : null;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String[] getAttributeFromSubject(X509Certificate cert, ASN1ObjectIdentifier asnObj) { //DERObjectIdentifier var1) {
        return getAttributeFromX500Principal(cert.getSubjectX500Principal(), asnObj);
    }

    public static String[] getAttributeFromX500Principal(X500Principal principal, ASN1ObjectIdentifier asnObj) {
        try {
            byte[] encoded = principal.getEncoded();
            ASN1Sequence asnSeq = (ASN1Sequence) (new ASN1InputStream(encoded)).readObject();
            X509Name xName = new X509Name(asnSeq);
            Vector xVal = xName.getValues(asnObj);
            if (xVal != null && xVal.size() > 0) {
                String[] attrs = new String[xVal.size()];

                for (int i = 0; i < attrs.length; ++i) {
                    attrs[i] = (String) xVal.get(i);
                }

                return attrs;
            } else {
                return new String[0];
            }
        } catch (Exception e) {
            return new String[0];
        }
    }

    public static String getRFC822Name(X509Certificate cert) {
        String name = null;
        try {
            byte[] extVal = cert.getExtensionValue("2.5.29.17");
            ASN1Object asnObj = fromByteArray(extVal);
            ASN1OctetString asnObjStr = DEROctetString.getInstance(asnObj);
            GeneralNames genNames = GeneralNames.getInstance((new ASN1StreamParser(asnObjStr.getOctets())).readObject().toASN1Primitive()); //.getDERObject());
            GeneralName genName = genNames.getNames()[0];
            if (genName.getTagNo() == 1) {
                name = genName.getName().toString();
            }

            return name;
        } catch (Exception var7) {
            var7.printStackTrace();
        }

        return null;
    }

    public static ASN1Object fromByteArray(byte[] data) throws IOException {
        ASN1InputStream aIn = new ASN1InputStream(data);

        try {
            return aIn.readObject();
        } catch (ClassCastException var3) {
            throw new IOException("cannot read object from stream");
        }
    }
}
