/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.pdfreader.tab;


import androidx.annotation.NonNull;
import androidx.recyclerview.widget.ItemTouchHelper;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.RecyclerView.ViewHolder;

public class TabMenuItemTouchHelper extends ItemTouchHelper.Callback {
    private final ItemTouchHelperCallback mHelperCallback;

    public TabMenuItemTouchHelper(ItemTouchHelperCallback helperCallback) {
        this.mHelperCallback = helperCallback;
    }

    @Override
    public int getMovementFlags(@NonNull RecyclerView recyclerView, @NonNull ViewHolder viewHolder) {
        return makeMovementFlags(ItemTouchHelper.UP | ItemTouchHelper.DOWN, 0);
    }

    @Override
    public boolean isLongPressDragEnabled() {
        return mHelperCallback.isLongPressDragEnabled();
    }

    @Override
    public boolean isItemViewSwipeEnabled() {
        return false;
    }

    @Override
    public boolean onMove(@NonNull RecyclerView recyclerView,
                          @NonNull ViewHolder viewHolder, @NonNull ViewHolder target) {
        if (viewHolder.getItemViewType() != TabConstants.Tab_Content) return false;

        return mHelperCallback.onMove(viewHolder,
                viewHolder.getAdapterPosition(), target.getAdapterPosition());
    }

    @Override
    public void onSwiped(@NonNull RecyclerView.ViewHolder viewHolder, int direction) {
    }

    @Override
    public void onSelectedChanged(RecyclerView.ViewHolder viewHolder, int actionState) {
        super.onSelectedChanged(viewHolder, actionState);
        if (actionState != ItemTouchHelper.ACTION_STATE_IDLE) {
            mHelperCallback.onMoveStart(viewHolder);
        }
    }

    @Override
    public void clearView(@NonNull RecyclerView recyclerView, @NonNull ViewHolder viewHolder) {
        super.clearView(recyclerView, viewHolder);
        if (!recyclerView.isComputingLayout()) {
            mHelperCallback.onMoveEnd(viewHolder);
        }
    }

    public interface ItemTouchHelperCallback {

        boolean isLongPressDragEnabled();

        void onMoveStart(RecyclerView.ViewHolder viewHolder);

        boolean onMove(RecyclerView.ViewHolder viewHolder, int fromPosition, int toPosition);

        void onMoveEnd(RecyclerView.ViewHolder viewHolder);
    }
}
