/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.pdfreader.impl;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Configuration;
import android.graphics.Color;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.TranslateAnimation;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.foxit.sdk.PDFViewCtrl;
import com.foxit.sdk.common.Constants;
import com.foxit.sdk.common.Renderer;
import com.foxit.sdk.pdf.PDFDoc;
import com.foxit.uiextensions.DocumentManager;
import com.foxit.uiextensions.IThemeEventListener;
import com.foxit.uiextensions.IUIInteractionEventListener;
import com.foxit.uiextensions.Module;
import com.foxit.uiextensions.R;
import com.foxit.uiextensions.ToolHandler;
import com.foxit.uiextensions.UIExtensionsManager;
import com.foxit.uiextensions.annots.ink.InkToolHandler;
import com.foxit.uiextensions.config.Config;
import com.foxit.uiextensions.controls.dialog.SimpleBottomWindow;
import com.foxit.uiextensions.controls.propertybar.IViewSettingsWindow;
import com.foxit.uiextensions.controls.propertybar.PropertyBar;
import com.foxit.uiextensions.controls.propertybar.imp.PropertyBarImpl;
import com.foxit.uiextensions.controls.propertybar.imp.ViewSettingsWindow;
import com.foxit.uiextensions.controls.toolbar.BaseBar;
import com.foxit.uiextensions.controls.toolbar.IBarsHandler;
import com.foxit.uiextensions.controls.toolbar.IBaseItem;
import com.foxit.uiextensions.controls.toolbar.IToolSupply;
import com.foxit.uiextensions.controls.toolbar.ToolConstants;
import com.foxit.uiextensions.controls.toolbar.ToolItemBean;
import com.foxit.uiextensions.controls.toolbar.ToolbarItemConfig;
import com.foxit.uiextensions.controls.toolbar.drag.CommentToolBar;
import com.foxit.uiextensions.controls.toolbar.drag.DrawingToolBar;
import com.foxit.uiextensions.controls.toolbar.drag.EditToolBar;
import com.foxit.uiextensions.controls.toolbar.drag.FillSignToolBar;
import com.foxit.uiextensions.controls.toolbar.drag.FormToolBar;
import com.foxit.uiextensions.controls.toolbar.drag.HomeToolBar;
import com.foxit.uiextensions.controls.toolbar.drag.ProtectToolBar;
import com.foxit.uiextensions.controls.toolbar.drag.UIDragToolBar;
import com.foxit.uiextensions.controls.toolbar.drag.UIToolBaseBar;
import com.foxit.uiextensions.controls.toolbar.drag.ViewToolBar;
import com.foxit.uiextensions.controls.toolbar.impl.BaseBarImpl;
import com.foxit.uiextensions.controls.toolbar.impl.BaseItemImpl;
import com.foxit.uiextensions.controls.toolbar.impl.BottomBarImpl;
import com.foxit.uiextensions.controls.toolbar.impl.TopBarImpl;
import com.foxit.uiextensions.modules.pagenavigation.LogicalPageHelper;
import com.foxit.uiextensions.modules.pagenavigation.PageNavigationModule;
import com.foxit.uiextensions.modules.panel.IPanelManager;
import com.foxit.uiextensions.modules.panel.PanelManager;
import com.foxit.uiextensions.modules.panel.bookmark.ReadingBookmarkModule;
import com.foxit.uiextensions.pdfreader.AddToolsBean;
import com.foxit.uiextensions.pdfreader.ILayoutChangeListener;
import com.foxit.uiextensions.pdfreader.ILifecycleEventListener;
import com.foxit.uiextensions.pdfreader.IMainFrame;
import com.foxit.uiextensions.pdfreader.IStateChangeListener;
import com.foxit.uiextensions.pdfreader.MainCenterItemBean;
import com.foxit.uiextensions.pdfreader.config.ReadStateConfig;
import com.foxit.uiextensions.pdfreader.tab.ITabRemovedListener;
import com.foxit.uiextensions.pdfreader.tab.ITabSelectedListener;
import com.foxit.uiextensions.pdfreader.tab.TabViewControl;
import com.foxit.uiextensions.theme.DynamicColorProvider;
import com.foxit.uiextensions.theme.ThemeConfig;
import com.foxit.uiextensions.theme.ThemeUtil;
import com.foxit.uiextensions.utils.AppDevice;
import com.foxit.uiextensions.utils.AppDisplay;
import com.foxit.uiextensions.utils.AppResource;
import com.foxit.uiextensions.utils.AppSharedPreferences;
import com.foxit.uiextensions.utils.AppUtil;
import com.foxit.uiextensions.utils.Event;
import com.foxit.uiextensions.utils.SystemUiHelper;
import com.foxit.uiextensions.utils.thread.AppThreadManager;

import java.util.ArrayList;
import java.util.List;

import androidx.core.content.ContextCompat;
import androidx.core.view.OnApplyWindowInsetsListener;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;


public class MainFrame implements IMainFrame {

    private int SHOW_ANIMATION_TAG = 100;
    private int HIDE_ANIMATION_TAG = 101;

    private int mPageColorMode;
    private Activity mAttachedActivity;
    private final Context mContext;
    private final Config mConfig;
    private int mThirdMaskCounter;

    private UIExtensionsManager mUiExtensionsManager;
    private ViewGroup mRootView;
    private PDFViewCtrl mViewCtrl;
    private PageNavigationModule mPageNavigationModule;

    private ViewGroup mDocViewerLayout;
    private final ViewGroup mTopBarContainer;
    private final ViewGroup mTopBarLayout;
    private final ViewGroup mTopAnnotBarLayout;
    private final ViewGroup mTopTitleBarLayout;
    private final ViewGroup mBottomBarLayout;
    private final ViewGroup mAnnotCustomTopBarLayout;
    private final ViewGroup mAnnotCustomBottomBarLayout;
    private ViewGroup mMaskView;

    private TopBarImpl mTopBar;
    private BottomBarImpl mBottomBar;
    private IViewSettingsWindow mViewSettingsWindow;
    private BaseBarImpl mAnnotCustomTopBar;
    private BaseBarImpl mAnnotCustomBottomBar;

    private TabViewControl mTabViewControl;
    private UIToolBaseBar mCurToolbar;
    private HomeToolBar mHomeToolbar;
    private UIToolBaseBar mEditToolbar;
    private UIToolBaseBar mCommentToolbar;
    private UIToolBaseBar mDrawingToolbar;
    private UIToolBaseBar mFormToolbar;
    private UIToolBaseBar mSignToolbar;
    private UIToolBaseBar mProtectToolbar;
    private UIDragToolBar mUIDragToolBar; //For dragging

    private AnimationSet mTopBarShowAnim;
    private AnimationSet mTopBarHideAnim;
    private AnimationSet mBottomBarShowAnim;
    private AnimationSet mBottomBarHideAnim;
    private AnimationSet mMaskShowAnim;
    private AnimationSet mMaskHideAnim;

    private PropertyBar mPropertyBar;

    private List<MainCenterItemBean> mCenterItemBeans;
    private ArrayList<View> mStateLayoutList;
    private boolean mIsShowTopToolbar = true;
    private boolean mIsShowBottomToolbar;
    private boolean mIsFullScreen = false;
    private boolean mShouldResetLayout = false;
    private int mLastOrientation;
    private boolean mOnMultiWindowModeChanged;

    private IPanelManager mPanelManager;
    private final RelativeLayout mPanelContainer;
    private final ViewGroup mFullScreenTopBar;
    private final ViewGroup mFullScreenBottomBar;
    private final View mFullScreenTopBarDivider;
    private boolean mIsSmallTopToolbarEnabled = true;
    private boolean mIsSmallBottomToolbarEnabled = true;

    private final List<ITabSelectedListener> mTabSelectedListener;
    private boolean mIsChangedPageLayoutByDoc = false;
    private int mLastPageLayout = PDFViewCtrl.PAGELAYOUTMODE_SINGLE;

    @SuppressLint("ClickableViewAccessibility")
    public MainFrame(Context context, Config config) {
        mLastOrientation = context.getResources().getConfiguration().orientation;
        mContext = context;
        mConfig = config;
        mRootView = (ViewGroup) View.inflate(mContext, R.layout.rd_main_frame, null);
        mMaskView = mRootView.findViewById(R.id.read_mask_ly);

        mPanelContainer = mRootView.findViewById(R.id.read_panel_view_ly);
        mPanelContainer.setOnTouchListener(new View.OnTouchListener() {
            @Override
            public boolean onTouch(View v, MotionEvent event) {
                return true;
            }
        });
        mDocViewerLayout = mRootView.findViewById(R.id.read_docview_ly);
        mBottomBarLayout = mRootView.findViewById(R.id.read_bottom_bar_ly);
        mFullScreenTopBar = mRootView.findViewById(R.id.read_fullscreen_top_bar);
        mFullScreenTopBarDivider = mRootView.findViewById(R.id.read_fullscreen_topbar_divider);
        mFullScreenBottomBar = mRootView.findViewById(R.id.read_fullscreen_bottom_bar);
        mFullScreenToolSetBarLayout = mRootView.findViewById(R.id.read_fullscreen_toolset_layout);
        mTopBarContainer = mRootView.findViewById(R.id.read_top_bar_container);
        mTopBarLayout = mRootView.findViewById(R.id.read_top_bar_ly);
        mTopAnnotBarLayout = mRootView.findViewById(R.id.read_top_annot_bar_ly); // drag tool bar
        mTopTitleBarLayout = mRootView.findViewById(R.id.read_top_doc_title_bar_ly);
        if (AppDisplay.isPad()) {
            RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
            lp.addRule(RelativeLayout.BELOW, mTopTitleBarLayout.getId());
            mPanelContainer.setLayoutParams(lp);
            mTopAnnotBarLayout.setVisibility(View.VISIBLE);
            mIsShowBottomToolbar = false;
            mBottomBarLayout.setVisibility(View.GONE);
        } else {
            mBottomBarLayout.setVisibility(View.VISIBLE);
            mIsShowBottomToolbar = true;
        }
        mAnnotCustomTopBarLayout = mRootView.findViewById(R.id.read_annot_custom_top_bar_ly);
        mAnnotCustomBottomBarLayout = mRootView.findViewById(R.id.read_annot_custom_bottom_bar_ly);

        mStateLayoutList = new ArrayList<>();
        mStateLayoutList.add(mTopBarContainer);
        mStateLayoutList.add(mBottomBarLayout);
        mStateLayoutList.add(mAnnotCustomTopBarLayout);
        mStateLayoutList.add(mAnnotCustomBottomBarLayout);

        mTabSelectedListener = new ArrayList<>();
        ViewCompat.setOnApplyWindowInsetsListener(mRootView, new OnApplyWindowInsetsListener() {
            @Override
            public WindowInsetsCompat onApplyWindowInsets(View v, WindowInsetsCompat windowInsets) {
                androidx.core.graphics.Insets insets;
                if (Build.VERSION.SDK_INT >= 30) {
                    insets = windowInsets.getInsets(WindowInsetsCompat.Type.systemBars() | WindowInsetsCompat.Type.displayCutout());
                } else {
                    insets = windowInsets.getInsets(WindowInsetsCompat.Type.displayCutout());
                }
                if (insets.top != 0) {
                    setFrameTopImmersiveColor(insets.top);
                }
                mRootView.setPadding(insets.left,
                        insets.top,
                        insets.right,
                        insets.bottom);

                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT_WATCH) {
                    final int childCount = mRootView.getChildCount();
                    for (int i = 0; i < childCount; i++) {
                        final View child = mRootView.getChildAt(i);
                        if (child != null) {
                            child.dispatchApplyWindowInsets(windowInsets.toWindowInsets());
                        }
                    }
                }
                return WindowInsetsCompat.CONSUMED;
            }
        });
    }

    public void init(UIExtensionsManager uiExtensionsManager) {
        mUiExtensionsManager = uiExtensionsManager;
        mViewCtrl = uiExtensionsManager.getPDFViewCtrl();
        mUiExtensionsManager.registerStateChangeListener(mStateChangeListener);
        mUiExtensionsManager.registerLayoutChangeListener(mLayoutChangeListener);
        mUiExtensionsManager.registerConfigurationChangedListener(mConfigurationChangedListener);
        mUiExtensionsManager.registerLifecycleListener(mLifecycleEventListener);
        mUiExtensionsManager.registerThemeEventListener(mThemeEventListener);

        mTopBar = new TopBarImpl(mContext);
        mTopBar.setShowSolidLine(false);
        mTopBar.setBackgroundColorProvider(new DynamicColorProvider() {
            @Override
            public int getColor(boolean isDarkMode) {
                return isDarkMode ? ContextCompat.getColor(mContext, R.color.ui_color_top_bar_main) : ThemeConfig.getInstance(mContext).getPrimaryColor();
            }
        });
        mTopBarLayout.setBackgroundColor(AppResource.getColor(mContext, R.color.ui_color_top_bar_main));

        mBottomBar = new BottomBarImpl(mContext);
        mBottomBar.setBackgroundColorProvider(new DynamicColorProvider() {
            @Override
            public int getColor(boolean isDarkMode) {
                return ThemeConfig.getInstance(mContext).getB2();
            }
        });
        mAnnotCustomTopBar = new TopBarImpl(mContext);
        mAnnotCustomBottomBar = new BottomBarImpl(mContext);

        mPropertyBar = new PropertyBarImpl(mContext, mUiExtensionsManager.getPDFViewCtrl());

        mBottomBar.setOrientation(BaseBar.HORIZONTAL, RelativeLayout.LayoutParams.MATCH_PARENT, AppResource.getDimensionPixelSize(mContext, R.dimen.ux_bottombar_height));
        if (AppDisplay.isPad()) {
            mBottomBar.setItemInterval(AppResource.getDimensionPixelSize(mContext, R.dimen.ux_bottombar_button_space_pad));
        } else {
            mBottomBar.setItemInterval(AppResource.getDimensionPixelSize(mContext, R.dimen.ux_bottombar_button_space_phone));
        }
        mBottomBar.setAutoCompressItemsInterval(true);

        mAnnotCustomTopBar.setOrientation(BaseBar.HORIZONTAL);
        mAnnotCustomTopBar.setInterceptTouch(false);
        mAnnotCustomBottomBar.setOrientation(BaseBar.HORIZONTAL, RelativeLayout.LayoutParams.MATCH_PARENT, AppResource.getDimensionPixelSize(mContext, R.dimen.ux_bottombar_height));
        mAnnotCustomBottomBar.setInterceptTouch(false);

        mTopBarLayout.addView(mTopBar.getContentView(), 0);
        mBottomBarLayout.addView(mBottomBar.getContentView());
        mAnnotCustomTopBarLayout.addView(mAnnotCustomTopBar.getContentView());
        mAnnotCustomTopBarLayout.setVisibility(View.GONE);
        mAnnotCustomBottomBarLayout.addView(mAnnotCustomBottomBar.getContentView());
        mAnnotCustomBottomBarLayout.setVisibility(View.GONE);

        mUIDragToolBar = new UIDragToolBar(mContext, mUiExtensionsManager);
        mUIDragToolBar.registerToolbarEventListener(mToolbarEventListener);

        mPanelManager = new PanelManager(mContext, mUiExtensionsManager, mRootView, mPanelContainer);
        mPanelManager.registerPanelEventListener(mPanelEventListener);

        initCenterItems();
        if (AppDisplay.isPad()) {
            initPadTopBar();
//            mViewSettingsWindow = getViewSettingsBar();
        } else {
            initPhoneTopBar();
            initBottomBarBtns();
            mViewSettingsWindow = new ViewSettingsWindow(mContext, mUiExtensionsManager.getPDFViewCtrl());
        }

        initAnimations();
        if (mConfig.uiSettings.fullscreen) {
            initFullScreenUI();
        }
    }

    @Override
    public void setPageBackgroundColor(int color) {
        if (mViewSettingsWindow != null) {
            if (AppDisplay.isPad()) {
                initPadSettingBar();
                ((ViewToolBar) mViewSettingsWindow).setPageBgColor(PropertyBar.PROPERTY_COLOR, color);
            } else {
                ((ViewSettingsWindow) mViewSettingsWindow).initView(mAttachedActivity);
                ((ViewSettingsWindow) mViewSettingsWindow).setPageBackgroundColor(color);
            }
        }
    }

    private TextView mFullScreenPageNumberItem;
    private View mFullScreenFavoriteItem;
    private View mFullScreenToolItem;
    private View mFullScreenMoreItem;

    private void initFullScreenUI() {
        View closeItem = mRootView.findViewById(R.id.read_fullscreen_close);
        if (closeItem != null) {
            closeItem.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    mUiExtensionsManager.onKeyDownCallback(mAttachedActivity, KeyEvent.KEYCODE_BACK, new KeyEvent(KeyEvent.ACTION_DOWN, KeyEvent.KEYCODE_BACK));
                    showToolbars();
                    mUiExtensionsManager.startHideToolbarsTimer();
                }
            });
        }

        mFullScreenMoreItem = mRootView.findViewById(R.id.read_fullscreen_more);
        mFullScreenMoreItem.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                IBaseItem moreItem = getTopToolbar().getItem(BaseBar.TB_Position.Position_RB, ToolbarItemConfig.ITEM_TOPBAR_MORE);
                if (moreItem != null) {
                    moreItem.getContentView().setTag(R.id.more_anchor_view_tag, v);
                    moreItem.performClick();
                    moreItem.getContentView().setTag(R.id.more_anchor_view_tag, null);
                }
            }
        });
        mFullScreenFavoriteItem = mRootView.findViewById(R.id.read_fullscreen_favorite);
        ThemeUtil.setTintList(mFullScreenFavoriteItem, ThemeUtil.getPrimaryIconColor(mContext));
        mFullScreenToolItem = mRootView.findViewById(R.id.read_fullscreen_tool);
        ThemeUtil.setTintList(mFullScreenToolItem, ThemeUtil.getPrimaryIconColor(mContext));
        mFullScreenPageNumberItem = mRootView.findViewById(R.id.read_fullscreen_page_number);
        mFullScreenPageNumberItem.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (AppUtil.isFastDoubleClick()) return;
                if (getPageNavigationModule() != null) {
                    getPageNavigationModule().showInputNumDialog();
                }
            }
        });
        mFullScreenFavoriteItem.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (mConfig.modules.isLoadReadingBookmark) {
                    IBaseItem item;
                    if (AppDisplay.isPad()) {
                        item = getTopToolbar().getItem(BaseBar.TB_Position.Position_RB, ToolbarItemConfig.ITEM_TOPBAR_BOOKMARK);
                    } else {
                        item = getBottomToolbar().getItem(BaseBar.TB_Position.Position_CENTER, ToolbarItemConfig.ITEM_BOTTOMBAR_BOOKMARK);
                    }
                    item.performClick();
                    v.setSelected(item.isSelected());
                }
            }
        });
        mFullScreenToolItem.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                showFullScreenToolSetBar(!v.isSelected());
            }
        });
    }

    public void updateFullScreenUI(boolean show) {
        if (mUiExtensionsManager.getPDFViewCtrl().getDoc() == null) return;
        if (!mConfig.uiSettings.fullscreen) return;

        mShowFullScreenUI = show;
        int curState = mUiExtensionsManager.getState();
        mFullScreenTopBar.setVisibility(show && curState != ReadStateConfig.STATE_COMPARE && mIsSmallTopToolbarEnabled ? View.VISIBLE : View.GONE);
        mFullScreenBottomBar.setVisibility(show && curState != ReadStateConfig.STATE_COMPARE && mIsSmallBottomToolbarEnabled ? View.VISIBLE : View.GONE);
        if (show) {
            boolean bookmarkVisible;
            if (AppDisplay.isPad()) {
                int visibility = mTopBar.getItemVisibility(BaseBar.TB_Position.Position_RB, ToolbarItemConfig.ITEM_TOPBAR_BOOKMARK);
                bookmarkVisible = visibility == View.VISIBLE;
            } else {
                int visibility = mBottomBar.getItemVisibility(BaseBar.TB_Position.Position_CENTER, ToolbarItemConfig.ITEM_BOTTOMBAR_BOOKMARK);
                bookmarkVisible = visibility == View.VISIBLE;
            }

            if (bookmarkVisible) {
                Module module = mUiExtensionsManager.getModuleByName(Module.MODULE_NAME_BOOKMARK);
                mFullScreenFavoriteItem.setVisibility(View.VISIBLE);
                mFullScreenFavoriteItem.setSelected(((ReadingBookmarkModule) module).isMarked(mUiExtensionsManager.getPDFViewCtrl().getCurrentPage()));
                boolean canAssemble = mUiExtensionsManager.getDocumentManager().canAssemble() && mUiExtensionsManager.isEnableModification();
                mFullScreenFavoriteItem.setEnabled(canAssemble && !mUiExtensionsManager.getPDFViewCtrl().isDynamicXFA());
            } else {
                mFullScreenFavoriteItem.setVisibility(View.GONE);
            }

            boolean isReflow = curState == ReadStateConfig.STATE_REFLOW || curState == ReadStateConfig.STATE_FILLSIGN;
            mFullScreenToolItem.setEnabled(mHomeToolbar != null && mHomeToolbar.getToolItems().toolItems.size() > 0 && !isReflow);
            updateFullScreenPageNumberText(mViewCtrl.getCurrentPage());

            int moreVisibility = getTopToolbar().getItemVisibility(BaseBar.TB_Position.Position_RB, ToolbarItemConfig.ITEM_TOPBAR_MORE);
            mFullScreenMoreItem.setVisibility(moreVisibility != -1 ? moreVisibility : View.GONE);
        } else {
            showFullScreenToolSetBar(false);
            if (mCurToolbar != null)
                mCurToolbar.setToolItems(mCurToolbar.getToolItems());
        }
    }

    public void asyncInitTaskFinished() {
        mTabViewControl.asynInitTaskFinished();
        mStateChangeListener.onStateChanged(mUiExtensionsManager.getState(), mUiExtensionsManager.getState());
    }

    public void release() {
        mTopBarShowAnim = null;
        mTopBarHideAnim = null;
        mBottomBarShowAnim = null;
        mBottomBarHideAnim = null;
        mMaskShowAnim = null;
        mMaskHideAnim = null;
        mTopBarContainer.setTag(SHOW_ANIMATION_TAG, null);
        mTopBarContainer.setTag(HIDE_ANIMATION_TAG, null);
        mBottomBarLayout.setTag(SHOW_ANIMATION_TAG, null);
        mBottomBarLayout.setTag(HIDE_ANIMATION_TAG, null);
        mAnnotCustomTopBarLayout.setTag(SHOW_ANIMATION_TAG, null);
        mAnnotCustomTopBarLayout.setTag(HIDE_ANIMATION_TAG, null);
        mAnnotCustomBottomBarLayout.setTag(SHOW_ANIMATION_TAG, null);
        mAnnotCustomBottomBarLayout.setTag(HIDE_ANIMATION_TAG, null);
        mMaskView.setTag(SHOW_ANIMATION_TAG, null);
        mMaskView.setTag(HIDE_ANIMATION_TAG, null);

        mMaskView = null;

        mTabViewControl.release();
        mDocViewerLayout.removeAllViews();
        mDocViewerLayout = null;
        mRootView.removeAllViews();
        mRootView = null;

        mStateLayoutList.clear();
        mStateLayoutList = null;

        mUiExtensionsManager.unregisterStateChangeListener(mStateChangeListener);
        mStateChangeListener = null;
        mUiExtensionsManager.unregisterLayoutChangeListener(mLayoutChangeListener);
        mLayoutChangeListener = null;
        mUiExtensionsManager.unregisterLifecycleListener(mLifecycleEventListener);
        mLifecycleEventListener = null;
        mUiExtensionsManager.unregisterThemeEventListener(mThemeEventListener);
        mThemeEventListener = null;
        mUiExtensionsManager.unregisterConfigurationChangedListener(mConfigurationChangedListener);
        mConfigurationChangedListener = null;
        mPanelManager.unregisterPanelEventListener(mPanelEventListener);
        mPanelEventListener = null;
        mPanelManager = null;
        mUIDragToolBar.unregisterToolbarEventListener(mToolbarEventListener);
        if (mFullScreenUIDragToolbar != null) {
            mFullScreenUIDragToolbar.unregisterToolbarEventListener(mToolbarEventListener);
            mFullScreenUIDragToolbar = null;
        }
        mToolbarEventListener = null;
        if (mViewSettingsWindow instanceof ViewSettingsWindow) {
            ((ViewSettingsWindow) mViewSettingsWindow).release();
        }
        mViewSettingsWindow = null;
        mFullScreenTopBar.removeAllViews();
        if (mTopBar != null)
            mTopBar.removeAllItems();
        mTopBar = null;
    }

    private boolean isLoadPanel() {
        return mConfig.modules.isLoadAnnotations
                || mConfig.modules.isLoadReadingBookmark
                || mConfig.modules.isLoadOutline
                || mConfig.modules.isLoadAttachment
                || mConfig.modules.isLoadSignature;
    }

    private void initBottomBarBtns() {
        if (isLoadPanel()) {

            IBaseItem panelItem = new BaseItemImpl(mContext, R.drawable.rd_bottom_bar_pannel);
            panelItem.setImageTintList(ThemeUtil.getPrimaryIconColor(getContext()));
            panelItem.setTag(ToolbarItemConfig.ITEM_BOTTOMBAR_LIST);
            panelItem.setId(R.id.id_bottom_bar_panel);
            panelItem.setOnClickListener(new View.OnClickListener() {

                @Override
                public void onClick(View v) {
                    if (mPanelManager != null) {
                        mUiExtensionsManager.triggerDismissMenuEvent();
                        mPanelManager.showPanel();
                    }
                    mUiExtensionsManager.onUIInteractElementClicked(IUIInteractionEventListener.Reading_Panel);
                }
            });
            mBottomBar.addView(panelItem, BaseBar.TB_Position.Position_CENTER);
        }


        IBaseItem settingItem = new BaseItemImpl(mContext, R.drawable.rd_bottom_bar_view);
        settingItem.setImageTintList(ThemeUtil.getPrimaryIconColor(getContext()));
        settingItem.setTag(ToolbarItemConfig.ITEM_BOTTOMBAR_VIEW);
        settingItem.setId(R.id.id_bottom_bar_view_setting);
        mBottomBar.addView(settingItem, BaseBar.TB_Position.Position_CENTER);
        settingItem.setOnClickListener(new View.OnClickListener() {

            @Override
            public void onClick(View v) {
                mUiExtensionsManager.stopHideToolbarsTimer();
                showSettingBar();
                mUiExtensionsManager.onUIInteractElementClicked(IUIInteractionEventListener.Reading_View);
            }
        });
    }

    private void initPhoneTopBar() {
        mTopBar.setStartMargin(AppResource.getDimensionPixelSize(mContext, R.dimen.ux_margin_4dp));
        //Topbar backButton
        IBaseItem backItem = new BaseItemImpl(mContext, R.drawable.rd_back_vector);
        backItem.setImageTintList(ThemeUtil.getTopBarIconColorStateList(mContext));
        backItem.setTag(ToolbarItemConfig.ITEM_TOPBAR_BACK);
        mTopBar.addView(backItem, BaseBar.TB_Position.Position_LT);
        backItem.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                mUiExtensionsManager.triggerDismissMenuEvent();
                if (mUiExtensionsManager.getBackEventListener() != null && mUiExtensionsManager.getBackEventListener().onBack()) {
                    return;
                }
                mUiExtensionsManager.backToPrevActivity();
            }
        });
    }

    private BaseItemImpl mPanelItem;

    private void initPadTopBar() {
        mTopBar.setStartMargin(AppResource.getDimensionPixelSize(mContext, R.dimen.ux_margin_4dp));
        IBaseItem backItem = new BaseItemImpl(mContext, R.drawable.rd_back_vector);
        backItem.setImageTintList(ThemeUtil.getTopBarIconColorStateList(mContext));
        backItem.setTag(ToolbarItemConfig.ITEM_TOPBAR_BACK);
        backItem.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                mUiExtensionsManager.triggerDismissMenuEvent();
                if (mUiExtensionsManager.getBackEventListener() != null && mUiExtensionsManager.getBackEventListener().onBack()) {
                    return;
                }
                mUiExtensionsManager.backToPrevActivity();
            }
        });
        mTopBar.addView(backItem, BaseBar.TB_Position.Position_LT);

        if (isLoadPanel()) {
            mPanelItem = new BaseItemImpl(mContext, R.drawable.toobar_panel_icon);
            mPanelItem.setImageTintList(ThemeUtil.getTopBarIconColorStateList(mContext));
            mPanelItem.setTag(ToolbarItemConfig.ITEM_TOPBAR_PANEL);
            mPanelItem.setBackgroundColorProvider(new DynamicColorProvider() {
                @Override
                public int getColor(boolean isDarkMode) {
                    if (ThemeConfig.getInstance(mContext).getAccentColorProvider() != null) {
                        return ThemeConfig.getInstance(mContext).getAccentColorProvider().getColor(isDarkMode);
                    } else {
                        return isDarkMode ? ThemeConfig.getInstance(mContext).getPrimaryColor() : ContextCompat.getColor(mContext, R.color.ui_color_center_layout_f4f4f4);
                    }
                }
            });

            mPanelItem.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    mUiExtensionsManager.onUIInteractElementClicked(IUIInteractionEventListener.Reading_Panel);
                    if (mPanelManager != null) {
                        if (mPanelManager.isShowingPanel()) {
                            mPanelManager.hidePanel();
                        } else {
                            if (mUiExtensionsManager.getState() == ReadStateConfig.STATE_PANZOOM)
                                mUiExtensionsManager.changeState(ReadStateConfig.STATE_NORMAL);
                            mUiExtensionsManager.triggerDismissMenuEvent();
                            if (mIsNeedRevertToolbarLayout = (mUIDragToolBar.getToolBarPosition() == UIDragToolBar.TOOLBAR_POS_LEFT)) {
                                mUIDragToolBar.setToolBarPosition(UIDragToolBar.TOOLBAR_POS_RIGHT);
                            }
                            mPanelManager.showPanel();
//                            updatePanel(false);
                        }
                    }
                }
            });
            mTopBar.addView(mPanelItem, BaseBar.TB_Position.Position_LT);
//            mPanelItem.setImageTextBackgroundResouce(R.color.ux_color_thumbnail_textview_current);
        }
    }

    private void initCenterItems() {
        mCenterItemBeans = new ArrayList<>();
        int[] types = {ToolbarItemConfig.ITEM_HOME_TAB,
                ToolbarItemConfig.ITEM_EDIT_TAB,
                ToolbarItemConfig.ITEM_COMMENT_TAB,
                ToolbarItemConfig.ITEM_DRAWING_TAB,
                ToolbarItemConfig.ITEM_VIEW_TAB,
                ToolbarItemConfig.ITEM_FORM_TAB,
                ToolbarItemConfig.ITEM_FILLSIGN_TAB};

        for (int type : types) {
            mCenterItemBeans.add(createCenterItemBean(type));
        }

        if (AppDisplay.isPad()) { // tab, only on Pad
            mCenterItemBeans.add(createCenterItemBean(ToolbarItemConfig.ITEM_PROTECT_TAB));
        }

        mTopBar.setMiddleButtonCenter(true);
        mTabViewControl = new TabViewControl(mContext, mUiExtensionsManager);
        mTabViewControl.addTabs(mCenterItemBeans);
        mTabViewControl.setTabSelectedListener(new ITabSelectedListener() {
            @Override
            public void onTabSelected(int tabId) {
                if (mUiExtensionsManager.getCurrentToolHandler() != null)
                    mUiExtensionsManager.setCurrentToolHandler(null);

                if (tabId == ToolbarItemConfig.ITEM_VIEW_TAB) { // pad
                    showSettingBar();
                    mUiExtensionsManager.onUIInteractElementClicked(IUIInteractionEventListener.Reading_ToolsTab_View);
                    if (mUiExtensionsManager.getState() == ReadStateConfig.STATE_FILLSIGN
                        //|| (IEditor.getEditor() != null && mUiExtensionsManager.getState() == ReadStateConfig.STATE_EDITOR)
                    ) {
                        mUiExtensionsManager.changeState(ReadStateConfig.STATE_NORMAL);
                    }
                } else if (tabId == ToolbarItemConfig.ITEM_HOME_TAB) {
                    if (mHomeToolbar == null) {
                        mHomeToolbar = HomeToolBar.newInstance(mContext, mUiExtensionsManager, mUIDragToolBar);
                        mHomeToolbar.setToolItems(getMainCenterItem(ToolbarItemConfig.ITEM_HOME_TAB));
                    }
                    mUiExtensionsManager.onUIInteractElementClicked(IUIInteractionEventListener.Reading_ToolsTab_Home);
                    setToolBar(mHomeToolbar);
                    if (mUiExtensionsManager.getState() == ReadStateConfig.STATE_FILLSIGN
                            //|| (IEditor.getEditor() != null && mUiExtensionsManager.getState() == ReadStateConfig.STATE_EDITOR)
                            || mUiExtensionsManager.getState() == ReadStateConfig.STATE_REFLOW
                    ) {
                        mUiExtensionsManager.changeState(ReadStateConfig.STATE_NORMAL);
                    }
                } else if (tabId == ToolbarItemConfig.ITEM_COMMENT_TAB) {
                    if (mCommentToolbar == null) {
                        mCommentToolbar = CommentToolBar.newInstance(mContext, mUiExtensionsManager, mUIDragToolBar);
                        mCommentToolbar.setToolItems(getMainCenterItem(ToolbarItemConfig.ITEM_COMMENT_TAB));
                        mCommentToolbar.setEnabled(mUiExtensionsManager.getDocumentManager().canAddAnnot()
                                && mUiExtensionsManager.getDocumentManager().withAddPermission()
                                && mUiExtensionsManager.isEnableModification());
                    }
                    mUiExtensionsManager.onUIInteractElementClicked(IUIInteractionEventListener.Reading_ToolsTab_Comment);
                    setToolBar(mCommentToolbar);

                    if (mUiExtensionsManager.getState() == ReadStateConfig.STATE_FILLSIGN
                            //|| (IEditor.getEditor() != null && mUiExtensionsManager.getState() == ReadStateConfig.STATE_EDITOR)
                            || mUiExtensionsManager.getState() == ReadStateConfig.STATE_REFLOW
                    ) {
                        mUiExtensionsManager.changeState(ReadStateConfig.STATE_NORMAL);
                    }
                } else if (tabId == ToolbarItemConfig.ITEM_EDIT_TAB) {
                    if (mEditToolbar == null) {
                        mEditToolbar = EditToolBar.newInstance(mContext, mUiExtensionsManager, mUIDragToolBar);
                        mEditToolbar.setToolItems(getMainCenterItem(ToolbarItemConfig.ITEM_EDIT_TAB));
                        mEditToolbar.setEnabled(mUiExtensionsManager.getDocumentManager().canEdit() && mUiExtensionsManager.isEnableModification());
                    }
                    mUiExtensionsManager.onUIInteractElementClicked(IUIInteractionEventListener.Reading_ToolsTab_Edit);
                    setToolBar(mEditToolbar);
                    if (mUiExtensionsManager.getState() == ReadStateConfig.STATE_FILLSIGN
                            || mUiExtensionsManager.getState() == ReadStateConfig.STATE_REFLOW) {
                        mUiExtensionsManager.changeState(ReadStateConfig.STATE_NORMAL);
                    }
                } else if (tabId == ToolbarItemConfig.ITEM_DRAWING_TAB) {
                    if (mDrawingToolbar == null) {
                        mDrawingToolbar = DrawingToolBar.newInstance(mContext, mUiExtensionsManager, mUIDragToolBar);
                        mDrawingToolbar.setToolItems(getMainCenterItem(ToolbarItemConfig.ITEM_DRAWING_TAB));
                        mDrawingToolbar.setEnabled(mUiExtensionsManager.getDocumentManager().canAddAnnot()
                                && mUiExtensionsManager.getDocumentManager().withAddPermission()
                                && mUiExtensionsManager.isEnableModification());
                    }
                    mUiExtensionsManager.onUIInteractElementClicked(IUIInteractionEventListener.Reading_ToolsTab_Drawing);
                    setToolBar(mDrawingToolbar);
                    if (mUiExtensionsManager.getState() == ReadStateConfig.STATE_FILLSIGN
                            //|| (IEditor.getEditor() != null && mUiExtensionsManager.getState() == ReadStateConfig.STATE_EDITOR)
                            || mUiExtensionsManager.getState() == ReadStateConfig.STATE_REFLOW
                    ) {
                        mUiExtensionsManager.changeState(ReadStateConfig.STATE_NORMAL);
                    }
                } else if (tabId == ToolbarItemConfig.ITEM_FORM_TAB) {
                    if (mFormToolbar == null) {
                        mFormToolbar = FormToolBar.newInstance(mContext, mUiExtensionsManager, mUIDragToolBar);
                        DocumentManager documentManager = mUiExtensionsManager.getDocumentManager();
                        mFormToolbar.setToolItems(getMainCenterItem(ToolbarItemConfig.ITEM_FORM_TAB));
                        mFormToolbar.setEnabled(!documentManager.isXFA()
                                && documentManager.canModifyForm() && !documentManager.isSign()
                                && mUiExtensionsManager.isEnableModification()
                                && documentManager.withAllPermission(null)
                                && documentManager.withAddPermission());
                    }
                    mUiExtensionsManager.onUIInteractElementClicked(IUIInteractionEventListener.Reading_ToolsTab_Form);
                    setToolBar(mFormToolbar);
                    if (mUiExtensionsManager.getState() == ReadStateConfig.STATE_FILLSIGN
                            //|| (IEditor.getEditor() != null && mUiExtensionsManager.getState() == ReadStateConfig.STATE_EDITOR)
                            || mUiExtensionsManager.getState() == ReadStateConfig.STATE_REFLOW
                    ) {
                        mUiExtensionsManager.changeState(ReadStateConfig.STATE_NORMAL);
                    }
                } else if (tabId == ToolbarItemConfig.ITEM_FILLSIGN_TAB) {
                    if (mSignToolbar == null) {
                        mSignToolbar = FillSignToolBar.newInstance(mContext, mUiExtensionsManager, mUIDragToolBar);
                        mSignToolbar.setToolItems(getMainCenterItem(ToolbarItemConfig.ITEM_FILLSIGN_TAB));
                        mSignToolbar.setEnabled(mUiExtensionsManager.getDocumentManager().canAddSignature()
                                && mUiExtensionsManager.isEnableModification()
                                && mUiExtensionsManager.getDocumentManager().canModifyContents());
                    }
                    mUiExtensionsManager.onUIInteractElementClicked(IUIInteractionEventListener.Reading_ToolsTab_FillSign);
                    setToolBar(mSignToolbar);
                    if (mUiExtensionsManager.getConfig().modules.isLoadFillSign || mUiExtensionsManager.getConfig().modules.isLoadSignature)
                        mUiExtensionsManager.changeState(ReadStateConfig.STATE_FILLSIGN);
                } else if (tabId == ToolbarItemConfig.ITEM_PROTECT_TAB) {
                    if (mProtectToolbar == null) {
                        mProtectToolbar = ProtectToolBar.newInstance(mContext, mUiExtensionsManager, mUIDragToolBar);
                        mProtectToolbar.setToolItems(getMainCenterItem(ToolbarItemConfig.ITEM_PROTECT_TAB));
                        mProtectToolbar.setEnabled(mUiExtensionsManager.isEnableModification());
                    }
//                    mUiExtensionsManager.onUIInteractElementClicked(IUIInteractionEventListener.Reading_ToolsTab_Protect);
                    setToolBar(mProtectToolbar);
                    if (mUiExtensionsManager.getState() == ReadStateConfig.STATE_FILLSIGN
                            || mUiExtensionsManager.getState() == ReadStateConfig.STATE_REFLOW) {
                        mUiExtensionsManager.changeState(ReadStateConfig.STATE_NORMAL);
                    }

                    onTabSelectedEvent(tabId);
                }
            }

            @Override
            public void onTabUnselected(int tabId) {
                onTabUnselectedEvent(tabId);
            }
        });

        mTabViewControl.setTabRemovedListener(new ITabRemovedListener() {
            @Override
            public void onTabRemoved(IBaseItem tabItem) {
                if (tabItem.isSelected() || mTabViewControl.getTabCount() == 0) {
                    mUiExtensionsManager.setCurrentToolHandler(null);

                    mUIDragToolBar.removeAllViews();
                    mTopAnnotBarLayout.removeAllViews();
                    mCurToolbar = null;
                    updateTopToolbarLayout(mUIDragToolBar.getToolBarPosition());

                    mTabViewControl.setCurrentTab(null);
                }
            }
        });
    }

    void initAnimations() {
        SHOW_ANIMATION_TAG = R.id.rd_show_animation_tag;
        HIDE_ANIMATION_TAG = R.id.rd_hide_animation_tag;

        if (mTopBarShowAnim == null) {
            mTopBarShowAnim = new AnimationSet(true);
            mTopBarHideAnim = new AnimationSet(true);
            mBottomBarShowAnim = new AnimationSet(true);
            mBottomBarHideAnim = new AnimationSet(true);
            mMaskShowAnim = new AnimationSet(true);
            mMaskHideAnim = new AnimationSet(true);
        }
        if (mTopBarShowAnim.getAnimations() != null && mTopBarShowAnim.getAnimations().size() > 0) {
            return;
        }
        if (mTopBarContainer.getHeight() == 0) {
            return;
        }
        // top bar
        TranslateAnimation anim = new TranslateAnimation(0, 0, -mTopBarLayout.getHeight(), 0);
        anim.setDuration(150);
        anim.setInterpolator(new AccelerateInterpolator());
        mTopBarShowAnim.addAnimation(anim);
        anim = new TranslateAnimation(0, 0, 0, -mTopBarLayout.getHeight());
        anim.setDuration(150);
        mTopBarHideAnim.addAnimation(anim);
        // bottom bar
        anim = new TranslateAnimation(0, 0, mBottomBarLayout.getHeight(), 0);
        anim.setDuration(150);
        mBottomBarShowAnim.addAnimation(anim);
        anim = new TranslateAnimation(0, 0, 0, mBottomBarLayout.getHeight());
        anim.setDuration(150);
        mBottomBarHideAnim.addAnimation(anim);
        // mask view
        AlphaAnimation alphaAnimation = new AlphaAnimation(0, 1);
        alphaAnimation.setDuration(200);
        mMaskShowAnim.addAnimation(alphaAnimation);
        alphaAnimation = new AlphaAnimation(1, 0);
        alphaAnimation.setDuration(200);
        mMaskHideAnim.addAnimation(alphaAnimation);

        mTopBarContainer.setTag(SHOW_ANIMATION_TAG, mTopBarShowAnim);
        mTopBarContainer.setTag(HIDE_ANIMATION_TAG, mTopBarHideAnim);
        mBottomBarLayout.setTag(SHOW_ANIMATION_TAG, mBottomBarShowAnim);
        mBottomBarLayout.setTag(HIDE_ANIMATION_TAG, mBottomBarHideAnim);
        mAnnotCustomTopBarLayout.setTag(SHOW_ANIMATION_TAG, mTopBarShowAnim);
        mAnnotCustomTopBarLayout.setTag(HIDE_ANIMATION_TAG, mTopBarHideAnim);
        mAnnotCustomBottomBarLayout.setTag(SHOW_ANIMATION_TAG, mBottomBarShowAnim);
        mAnnotCustomBottomBarLayout.setTag(HIDE_ANIMATION_TAG, mBottomBarHideAnim);
        mMaskView.setTag(SHOW_ANIMATION_TAG, mMaskShowAnim);
        mMaskView.setTag(HIDE_ANIMATION_TAG, mMaskHideAnim);
    }

    public void addDocView(View docView) {
        AppUtil.removeViewFromParent(docView);
        mDocViewerLayout.addView(docView);
    }

    @Override
    public RelativeLayout getContentView() {
        return (RelativeLayout) mRootView;
    }

    @Override
    public BaseBar getTopToolbar() {
        return mTopBar;
    }

    @Override
    public PropertyBar getPropertyBar() {
        return mPropertyBar;
    }

    @Override
    public BaseBar getBottomToolbar() {
        return mBottomBar;
    }

    @Override
    public BaseBar getCustomTopbar() {
        return mAnnotCustomTopBar;
    }

    @Override
    public BaseBar getCustomBottombar() {
        return mAnnotCustomBottomBar;
    }

    @Override
    public IPanelManager getPanelManager() {
        return mPanelManager;
    }

    @Override
    public void showToolbars() {
        mIsFullScreen = false;
        SystemUiHelper.getInstance().setFullScreen(false);
        mUiExtensionsManager.changeState(mUiExtensionsManager.getState());
        SystemUiHelper.getInstance().showSystemUI(mAttachedActivity);
        if (!SystemUiHelper.getInstance().isFullScreenMode(mAttachedActivity))
            mShouldResetLayout = true;
    }

    @Override
    public void hideToolbars() {
        mIsFullScreen = true;
        mUiExtensionsManager.changeState(mUiExtensionsManager.getState());
        if (isSupportFullScreen()){
            SystemUiHelper.getInstance().setFullScreen(true);
            SystemUiHelper.getInstance().hideSystemUI(mAttachedActivity);
        }
    }

    private boolean isSupportFullScreen() {
        int state = mUiExtensionsManager.getState();
        return state != ReadStateConfig.STATE_SEARCH;
    }

    @Override
    public boolean isToolbarsVisible() {
        return !mIsFullScreen;
    }

    @Override
    public IViewSettingsWindow getSettingWindow() {
        return mViewSettingsWindow;
    }

    private void rotateView() {
        int rotation = mUiExtensionsManager.getPDFViewCtrl().getViewRotation();
        rotation = (rotation + 1) % 4;

        mUiExtensionsManager.getPDFViewCtrl().rotateView(rotation);
        mUiExtensionsManager.getPDFViewCtrl().updatePagesLayout();
    }

    class SettingValueChangeListener implements IViewSettingsWindow.IValueChangeListener {
        //should be one of IViewSettingsWindow.TYPE_XXX
        private int type;

        public SettingValueChangeListener(int type) {
            this.type = type;
        }

        @Override
        public void onValueChanged(int type, Object value) {
            switch (type) {
                case IViewSettingsWindow.TYPE_SINGLE_PAGE:
                    final int pageLayoutMode = (Integer) value;
                    // reset page navigation view
                    PageNavigationModule pageNavigationModule = (PageNavigationModule) mUiExtensionsManager.getModuleByName(Module.MODULE_NAME_PAGENAV);
                    if (pageNavigationModule != null) {
                        pageNavigationModule.resetJumpView();
                    }
                    if (getPageNavigationModule() != null) {
                        getPageNavigationModule().resetJumpView();
                    }

                    ToolHandler toolHandler = mUiExtensionsManager.getCurrentToolHandler();
                    if (toolHandler instanceof InkToolHandler) {
                        ((InkToolHandler) toolHandler).reset();
                    } else {
                        mUiExtensionsManager.getPDFViewCtrl().setPageLayoutMode(pageLayoutMode);
                        mViewSettingsWindow.setProperty(IViewSettingsWindow.TYPE_SINGLE_PAGE, pageLayoutMode);
                    }
                    break;
                case IViewSettingsWindow.TYPE_RIGHT_TO_LEFT:
                    // reset page navigation view
                    PageNavigationModule pageNavModule = (PageNavigationModule) mUiExtensionsManager.getModuleByName(Module.MODULE_NAME_PAGENAV);
                    if (pageNavModule != null) {
                        pageNavModule.resetJumpView();
                    }
                    break;
                case IViewSettingsWindow.TYPE_DAY:
                    mPageColorMode = (Integer) value;
                    if (mPageColorMode == IViewSettingsWindow.DAY) {
                        mUiExtensionsManager.getPDFViewCtrl().setBackgroundColor(AppResource.getColor(mContext, R.color.ux_bg_color_docviewer));
                        //mUiExtensionsManager.getPDFViewCtrl().setNightMode(false);
                        mUiExtensionsManager.getPDFViewCtrl().setColorMode(Renderer.e_ColorModeNormal);

                        mFullScreenTopBar.setBackgroundColor(AppResource.getColor(mContext, R.color.b1));
                        mFullScreenTopBarDivider.setBackgroundColor(AppResource.getColor(mContext, R.color.p1));
                        mFullScreenBottomBar.setBackgroundColor(AppResource.getColor(mContext, R.color.b1));
                    } else if (mPageColorMode == IViewSettingsWindow.NIGHT) {
                        mUiExtensionsManager.getPDFViewCtrl().setBackgroundColor(Color.parseColor("#36404A"));
                        //mUiExtensionsManager.getPDFViewCtrl().setNightMode(true);
                        //if (mUiExtensionsManager.getNightColorMode() == UIExtensionsManager.NIGHTCOLORMODE_MAPPINGGRAY) {
                        //    mUiExtensionsManager.getPDFViewCtrl().setMappingModeForegroundColor(Color.argb(0xff, 0x9b, 0x9b, 0x9b));
                        //    mUiExtensionsManager.getPDFViewCtrl().setMappingModeBackgroundColor(Color.argb(0xff, 0x0a, 0x0a, 0x0a));
                        //    mUiExtensionsManager.getPDFViewCtrl().setColorMode(Renderer.e_ColorModeMappingGray);
                        //}
                        mUiExtensionsManager.getPDFViewCtrl().setMappingModeForegroundColor(IViewSettingsWindow.DEFAULT_NIGHT_FG_COLOR);
                        mUiExtensionsManager.getPDFViewCtrl().setMappingModeBackgroundColor(IViewSettingsWindow.DEFAULT_NIGHT_BG_COLOR);
                        mUiExtensionsManager.getPDFViewCtrl().setColorMode(
                                mUiExtensionsManager.getNightColorMode() == UIExtensionsManager.NIGHTCOLORMODE_MAPPINGGRAY
                                        ? Renderer.e_ColorModeMappingGray : Renderer.e_ColorModeMapping);

                        mFullScreenTopBar.setBackgroundColor(AppResource.getColor(mContext, R.color.night_bg_color));
                        mFullScreenTopBarDivider.setBackgroundColor(AppResource.getColor(mContext, R.color.night_divider_color));
                        mFullScreenBottomBar.setBackgroundColor(AppResource.getColor(mContext, R.color.night_bg_color));
                    } else {
                        mFullScreenTopBar.setBackgroundColor(AppResource.getColor(mContext, R.color.b1));
                        mFullScreenTopBarDivider.setBackgroundColor(AppResource.getColor(mContext, R.color.p1));
                        mFullScreenBottomBar.setBackgroundColor(AppResource.getColor(mContext, R.color.b1));
                    }
                    mViewSettingsWindow.setProperty(IViewSettingsWindow.TYPE_DAY, mPageColorMode);
                    break;
                case IViewSettingsWindow.TYPE_FIT_PAGE:
                case IViewSettingsWindow.TYPE_FIT_WIDTH:
                    int zoomMode = (Integer) value;
                    mUiExtensionsManager.getPDFViewCtrl().setZoomMode(zoomMode);
                    mViewSettingsWindow.setProperty(type, zoomMode);
                    break;
                case IViewSettingsWindow.TYPE_ROTATE_VIEW:
                    rotateView();
                    break;
                default:
                    break;
            }
        }

        @Override
        public int getType() {
            return this.type;
        }
    }

    void initPadSettingBar() {
        final IViewSettingsWindow settingsWindow = getSettingWindow();
        if (settingsWindow == null) return;
        mUiExtensionsManager.triggerDismissMenuEvent();
        settingsWindow.registerListener(new SettingValueChangeListener(IViewSettingsWindow.TYPE_SINGLE_PAGE));
        settingsWindow.registerListener(new SettingValueChangeListener(IViewSettingsWindow.TYPE_DAY));
        settingsWindow.registerListener(new SettingValueChangeListener(IViewSettingsWindow.TYPE_FIT_PAGE));
        settingsWindow.registerListener(new SettingValueChangeListener(IViewSettingsWindow.TYPE_FIT_WIDTH));
        settingsWindow.registerListener(new SettingValueChangeListener(IViewSettingsWindow.TYPE_ROTATE_VIEW));
        settingsWindow.registerListener(new SettingValueChangeListener(IViewSettingsWindow.TYPE_RIGHT_TO_LEFT));
        setToolBar((UIToolBaseBar) mViewSettingsWindow);

        mStateChangeListener.onStateChanged(mUiExtensionsManager.getState(), mUiExtensionsManager.getState());
        int pageLayoutMode = mUiExtensionsManager.getPDFViewCtrl().getPageLayoutMode();
        settingsWindow.setProperty(IViewSettingsWindow.TYPE_SINGLE_PAGE, pageLayoutMode);
        settingsWindow.setProperty(IViewSettingsWindow.TYPE_DAY, settingsWindow.getColorMode());
        settingsWindow.setProperty(IViewSettingsWindow.TYPE_RIGHT_TO_LEFT, mViewCtrl.getPageBinding());
        settingsWindow.setProperty(IViewSettingsWindow.TYPE_CROP, mViewCtrl.getCropMode() != PDFViewCtrl.CROPMODE_NONE);
        updateZoomModeSettings();
    }
    @SuppressLint("WrongConstant")
    void showSettingBar() {
        final IViewSettingsWindow settingsWindow = getSettingWindow();
        if (settingsWindow == null) return;
        mUiExtensionsManager.triggerDismissMenuEvent();
        settingsWindow.registerListener(new SettingValueChangeListener(IViewSettingsWindow.TYPE_SINGLE_PAGE));
        settingsWindow.registerListener(new SettingValueChangeListener(IViewSettingsWindow.TYPE_DAY));
        settingsWindow.registerListener(new SettingValueChangeListener(IViewSettingsWindow.TYPE_FIT_PAGE));
        settingsWindow.registerListener(new SettingValueChangeListener(IViewSettingsWindow.TYPE_FIT_WIDTH));
        settingsWindow.registerListener(new SettingValueChangeListener(IViewSettingsWindow.TYPE_ROTATE_VIEW));
        settingsWindow.registerListener(new SettingValueChangeListener(IViewSettingsWindow.TYPE_RIGHT_TO_LEFT));

        if (AppDisplay.isPad()) {
            setToolBar((UIToolBaseBar) mViewSettingsWindow);
        } else {
            if (settingsWindow instanceof ViewSettingsWindow) {
                if (settingsWindow.getContentView() == null) {
                    ((ViewSettingsWindow) settingsWindow).initView(mAttachedActivity);
                    resetPageLayout();
                }

                ((ViewSettingsWindow) settingsWindow).getPageColorWindow().setOnDismissListener(new DialogInterface.OnDismissListener() {
                    @Override
                    public void onDismiss(DialogInterface dialog) {
                        mStateChangeListener.onStateChanged(mUiExtensionsManager.getState(), mUiExtensionsManager.getState());
                        mUiExtensionsManager.startHideToolbarsTimer();
                    }
                });
            }
            settingsWindow.setOnDismissListener(new IViewSettingsWindow.OnDismissListener() {
                @Override
                public void onDismiss() {
                    if (!((ViewSettingsWindow) settingsWindow).getPageColorWindow().isShowing()) {
                        mStateChangeListener.onStateChanged(mUiExtensionsManager.getState(), mUiExtensionsManager.getState());
                        mUiExtensionsManager.startHideToolbarsTimer();
                    }
                }
            });
            settingsWindow.show();
        }

        mStateChangeListener.onStateChanged(mUiExtensionsManager.getState(), mUiExtensionsManager.getState());
        int pageLayoutMode = mUiExtensionsManager.getPDFViewCtrl().getPageLayoutMode();
        settingsWindow.setProperty(IViewSettingsWindow.TYPE_SINGLE_PAGE, pageLayoutMode);
        settingsWindow.setProperty(IViewSettingsWindow.TYPE_DAY, settingsWindow.getColorMode());
        settingsWindow.setProperty(IViewSettingsWindow.TYPE_RIGHT_TO_LEFT, mViewCtrl.getPageBinding());
        settingsWindow.setProperty(IViewSettingsWindow.TYPE_CROP, mViewCtrl.getCropMode() != PDFViewCtrl.CROPMODE_NONE);
        updateZoomModeSettings();
    }

    private void updateSettingBar() {
        if (AppDisplay.isPad()) {
            if (mViewSettingsWindow == null) return;
            if (mViewSettingsWindow instanceof ViewToolBar)
                ((ViewToolBar) mViewSettingsWindow).onLayoutChange();
        } else {
            if (mViewSettingsWindow == null || mViewSettingsWindow.getContentView() == null) return;
            if (mViewSettingsWindow.isShowing()) {
                mViewSettingsWindow.show();
            }
            SimpleBottomWindow window = ((ViewSettingsWindow) mViewSettingsWindow).getPageColorWindow();
            if (window != null && window.isShowing()) {
                window.show();
            }
        }
    }

    @Override
    public void hideSettingWindow() {
        if (!AppDisplay.isPad()) {
            if (mViewSettingsWindow != null && mViewSettingsWindow.getContentView() != null) {
                if (mViewSettingsWindow.isShowing()) {
                    mViewSettingsWindow.dismiss();
                }

                SimpleBottomWindow window = ((ViewSettingsWindow) mViewSettingsWindow).getPageColorWindow();
                if (window != null && window.isShowing()) {
                    window.dismiss();
                }
            }
        }
    }

    @Override
    public void showMaskView() {
        mThirdMaskCounter++;
        mStateChangeListener.onStateChanged(mUiExtensionsManager.getState(), mUiExtensionsManager.getState());
    }

    @Override
    public void hideMaskView() {
        mThirdMaskCounter--;
        if (mThirdMaskCounter < 0)
            mThirdMaskCounter = 0;
        mStateChangeListener.onStateChanged(mUiExtensionsManager.getState(), mUiExtensionsManager.getState());
    }

    public void resetMaskView() {
        updateFullScreenUI(false);
        hideSettingWindow();

        if (isMaskViewShowing()) {
            hideMaskView();
        }
        mThirdMaskCounter = 0;
    }

    @Override
    public boolean isMaskViewShowing() {
        return mMaskView.getVisibility() == View.VISIBLE
                || mThirdMaskCounter > 0;
    }

    @Override
    public int getMaskViewIndex() {
        int count = mRootView.getChildCount();
        View childView = null;
        for (int i = 0; i < count; i++) {
            childView = mRootView.getChildAt(i);
            if (childView.getId() == R.id.read_mask_ly)
                return i;
        }
        return 1;
    }

    @Override
    public void enableTopToolbar(boolean isEnabled) {
        if (mTopBarLayout != null) {
            if (isEnabled) {
                mIsShowTopToolbar = true;
                mTopBarLayout.setVisibility(View.VISIBLE);
                mTopAnnotBarLayout.setVisibility(View.VISIBLE);
            } else {
                mIsShowTopToolbar = false;
                mTopBarLayout.setVisibility(View.GONE);
                mTopAnnotBarLayout.setVisibility(View.GONE);
            }

        }
    }

    @Override
    public void enableBottomToolbar(boolean isEnabled) {
        if (AppDisplay.isPad()) return;

        if (mBottomBarLayout != null) {
            if (isEnabled) {
                mIsShowBottomToolbar = true;
                mBottomBarLayout.setVisibility(View.VISIBLE);
            } else {
                mIsShowBottomToolbar = false;
                mBottomBarLayout.setVisibility(View.GONE);
            }
        }
    }

    @Override
    public boolean isShowTopToolbar() {
        return mIsShowTopToolbar;
    }

    @Override
    public boolean isShowBottomToolbar() {
        return mIsShowBottomToolbar;
    }

    @Override
    public ViewGroup getTopActionView() {
        return mTopTitleBarLayout;
    }

    @Override
    public UIToolBaseBar getCurToolbar() {
        return mCurToolbar;
    }

    @Override
    public UIToolBaseBar getToolbar(int tabType) {
        if (tabType == ToolbarItemConfig.ITEM_HOME_TAB) {
            return mHomeToolbar;
        } else if (tabType == ToolbarItemConfig.ITEM_EDIT_TAB) {
            return mEditToolbar;
        } else if (tabType == ToolbarItemConfig.ITEM_COMMENT_TAB) {
            return mCommentToolbar;
        } else if (tabType == ToolbarItemConfig.ITEM_DRAWING_TAB) {
            return mDrawingToolbar;
        } else if (tabType == ToolbarItemConfig.ITEM_VIEW_TAB) {
            if (AppDisplay.isPad())
                return ((ViewToolBar) mViewSettingsWindow);
        } else if (tabType == ToolbarItemConfig.ITEM_FORM_TAB) {
            return mFormToolbar;
        } else if (tabType == ToolbarItemConfig.ITEM_FILLSIGN_TAB) {
            return mSignToolbar;
        } else if (tabType == ToolbarItemConfig.ITEM_PROTECT_TAB) {
            return mProtectToolbar;
        }

        return null;
    }

    public void resetToolbar(int tabType) {
        UIToolBaseBar toolbar = getToolbar(tabType);
        if (toolbar != null) {
            MainCenterItemBean centerItem = toolbar.getToolItems();
            if (tabType != ToolbarItemConfig.ITEM_HOME_TAB && tabType != ToolbarItemConfig.ITEM_PROTECT_TAB) // data saved in mHomeToolbar, don't reload by ToolItemsManage
                centerItem.toolItems = null;
            toolbar.setToolItems(centerItem);

        }
    }

    @Override
    public Activity getAttachedActivity() {
        return mAttachedActivity;
    }

    @Override
    public void setAttachedActivity(Activity act) {
        mAttachedActivity = act;
    }

    @Override
    public Context getContext() {
        return mContext;
    }

    private IPanelManager.OnPanelEventListener mPanelEventListener = new IPanelManager.OnPanelEventListener() {
        @Override
        public void onPanelOpened() {
            mUiExtensionsManager.stopHideToolbarsTimer();
            if (mPanelItem != null) {
                mPanelItem.setSelected(true);
                mPanelItem.setChecked(true);
            }
            showToolbars();
            if (!AppDisplay.isPad()) {
                mBottomBarLayout.setVisibility(View.GONE);

                int dragType = mUiExtensionsManager.getConfig().uiSettings.toolBarDragType;
                if (dragType == 1 || dragType == 3) {
                    mTopAnnotBarLayout.setVisibility(View.INVISIBLE);
                }
            } else {
                if (mUIDragToolBar.getToolBarPosition() == UIDragToolBar.TOOLBAR_POS_ANY)
                    mTopAnnotBarLayout.setVisibility(View.INVISIBLE);
            }
        }

        @Override
        public void onPanelClosed() {
            mUiExtensionsManager.startHideToolbarsTimer();
            if (mPanelItem != null) {
                mPanelItem.setSelected(false);
                mPanelItem.setChecked(false);
            }

            if (AppDisplay.isPad()) {
                if (mUIDragToolBar != null) {
                    if (mIsNeedRevertToolbarLayout) {
                        mUIDragToolBar.setToolBarPosition(UIDragToolBar.TOOLBAR_POS_LEFT);
                    }

                    if (mUIDragToolBar.getToolBarPosition() == UIDragToolBar.TOOLBAR_POS_ANY)
                        mTopAnnotBarLayout.setVisibility(View.VISIBLE);
                }
            } else {
                if (mUiExtensionsManager.getState() != ReadStateConfig.STATE_REFLOW) {
                    if (mIsShowBottomToolbar) {
                        mBottomBarLayout.setVisibility(View.VISIBLE);
                    }

                    int dragType = mUiExtensionsManager.getConfig().uiSettings.toolBarDragType;
                    if (dragType == 1 || dragType == 3) {
                        mTopAnnotBarLayout.setVisibility(View.VISIBLE);
                    }
                }
            }
        }
    };

    private boolean mIsFullScreenBeforeRedaction = false;

    private IStateChangeListener mStateChangeListener = new IStateChangeListener() {
        @Override
        public void onStateChanged(int oldState, int newState) {
            if (newState == ReadStateConfig.STATE_COMPARE) {
                mTopBarLayout.setVisibility(View.INVISIBLE);
                mBottomBarLayout.setVisibility(View.INVISIBLE);
                mFullScreenTopBar.setVisibility(View.INVISIBLE);
                mFullScreenBottomBar.setVisibility(View.INVISIBLE);
                mCurToolbar.setVisible(false);
            } else {
                if (newState != ReadStateConfig.STATE_REFLOW)
                    mTopTitleBarLayout.setVisibility(View.VISIBLE);

                if (mIsShowTopToolbar)
                    mTopBarLayout.setVisibility(View.VISIBLE);
                if (mIsShowBottomToolbar && !mPanelManager.isShowingPanel())
                    mBottomBarLayout.setVisibility(View.VISIBLE);
                if (mCurToolbar != null) {
                    mCurToolbar.setVisible(true);
                }
            }
            initAnimations();
            ArrayList<View> currentShowViews = new ArrayList<>();
            ArrayList<View> willShowViews = new ArrayList<>();
            for (View view : mStateLayoutList) {
                if (view.getVisibility() == View.VISIBLE) {
                    currentShowViews.add(view);
                }
            }
            switch (newState) {
                case ReadStateConfig.STATE_NORMAL:
                case ReadStateConfig.STATE_FILLSIGN:
                    if (isToolbarsVisible()) {
                        if (mIsFullScreenBeforeRedaction && oldState == ReadStateConfig.STATE_REDACT)
                            break;
                        willShowViews.add(mTopBarContainer);
                        if (mIsShowTopToolbar) {
                            if (mPanelManager.isShowingPanel()) {
                                if (AppDisplay.isPad()) {
                                    if (mUIDragToolBar.getToolBarPosition() == UIDragToolBar.TOOLBAR_POS_ANY) {
                                        mTopAnnotBarLayout.setVisibility(View.INVISIBLE);
                                    } else {
                                        mTopAnnotBarLayout.setVisibility(View.VISIBLE);
                                    }
                                }
                            } else {
                                mTopAnnotBarLayout.setVisibility(View.VISIBLE);
                            }
                        } else {
                            mTopAnnotBarLayout.setVisibility(View.INVISIBLE);
                        }

                        if (mIsShowBottomToolbar && !mPanelManager.isShowingPanel()) {
                            willShowViews.add(mBottomBarLayout);
                        }
                    }
                    break;
                case ReadStateConfig.STATE_REDACT:
                    if (oldState != ReadStateConfig.STATE_REDACT) {
                        mIsFullScreenBeforeRedaction = !isToolbarsVisible();
                    }
                    if (isToolbarsVisible()) {
                        willShowViews.add(mAnnotCustomTopBarLayout);
                        willShowViews.add(mAnnotCustomBottomBarLayout);
                    }
                    break;
                case ReadStateConfig.STATE_REFLOW:
                    if (!AppDisplay.isPad()) {
                        willShowViews.add(mTopBarContainer);
                        mTopBarLayout.setVisibility(View.GONE);
                        mTopAnnotBarLayout.setVisibility(View.GONE);
                        mBottomBarLayout.setVisibility(View.GONE);
                        mTopTitleBarLayout.setVisibility(View.GONE);
                    }
                case ReadStateConfig.STATE_SEARCH:
                case ReadStateConfig.STATE_PANZOOM:
                case ReadStateConfig.STATE_TTS:
                case ReadStateConfig.STATE_AUTOFLIP:
                    if (AppDisplay.isPad()) {
                        if (isToolbarsVisible()) {
                            if (mIsShowTopToolbar) {
                                willShowViews.add(mTopBarContainer);
                            }
                        }
                        break;
                    }
                default:
                    break;
            }
            for (View view : currentShowViews) {
                if (willShowViews.contains(view))
                    continue;
                if (newState == oldState && view.getTag(HIDE_ANIMATION_TAG) != null) {
                    if (view == mBottomBarLayout && (newState == ReadStateConfig.STATE_REFLOW
                            || newState == ReadStateConfig.STATE_PANZOOM
                            || newState == ReadStateConfig.STATE_TTS
                            || newState == ReadStateConfig.STATE_AUTOFLIP
                            || newState == ReadStateConfig.STATE_REDACT)) {
                        view.setVisibility(View.INVISIBLE);
                        continue;
                    }
                    view.startAnimation((AnimationSet) view.getTag(HIDE_ANIMATION_TAG));
                }
                view.setVisibility(View.INVISIBLE);
            }
            for (View view : willShowViews) {
                if (currentShowViews.contains(view))
                    continue;
                if (view.getTag(SHOW_ANIMATION_TAG) != null) {
                    view.startAnimation((Animation) view.getTag(SHOW_ANIMATION_TAG));
                }
                view.setVisibility(View.VISIBLE);
            }
            boolean isPad = AppDisplay.isPad();
            int topOffset = getTopBarHeight();
            int bottomOffset = isPad ? 0 : -getBottomBarHeight();
            topOffset = mIsShowTopToolbar ? topOffset : 0;
            bottomOffset = mIsShowBottomToolbar ? bottomOffset : 0;
            if (mConfig.uiSettings.fullscreen) {
                if (willShowViews.isEmpty()) {
                    topOffset = newState != ReadStateConfig.STATE_COMPARE && mIsSmallTopToolbarEnabled ? getViewRealHeight(mFullScreenTopBar) : 0;
                    bottomOffset = newState != ReadStateConfig.STATE_COMPARE && mIsSmallBottomToolbarEnabled ? -getViewRealHeight(mFullScreenBottomBar) : 0;
                }
                if (newState != ReadStateConfig.STATE_REDACT) {
                    if (AppDisplay.isPad()) {
                        if (newState != ReadStateConfig.STATE_SEARCH) {
                            if (isToolbarsVisible() && !mIsShowTopToolbar) {
                                updateFullScreenUI(false);
                            } else {
                                updateFullScreenUI(willShowViews.isEmpty());
                            }
                        } else {
                            updateFullScreenUI(false);
                        }
                    } else {
                        if (newState != ReadStateConfig.STATE_REFLOW
                                && newState != ReadStateConfig.STATE_PANZOOM
                                && newState != ReadStateConfig.STATE_TTS
                                && newState != ReadStateConfig.STATE_AUTOFLIP
                                && newState != ReadStateConfig.STATE_SEARCH) {
                            if (isToolbarsVisible() && !mIsShowTopToolbar && !mIsShowBottomToolbar) {
                                updateFullScreenUI(false);
                            } else {
                                updateFullScreenUI(willShowViews.isEmpty());
                            }

                        } else {
                            updateFullScreenUI(false);
                            mShowFullScreenUI = willShowViews.isEmpty();
                        }
                    }
                    if (newState == ReadStateConfig.STATE_SEARCH) {
                        topOffset = mAnnotCustomTopBarLayout.getHeight();
                        bottomOffset = 0;
                    }
                } else {
                    mShowFullScreenUI = willShowViews.isEmpty();
                    topOffset = mShowFullScreenUI ? 0 : mAnnotCustomTopBarLayout.getHeight();
                    bottomOffset = mShowFullScreenUI ? 0 : -mAnnotCustomBottomBarLayout.getHeight();
                    if (mShowFullScreenUI) {
                        mFullScreenTopBar.setVisibility(View.GONE);
                        mFullScreenBottomBar.setVisibility(mFullScreenTopBar.getVisibility());
                        showFullScreenToolSetBar(false);
                    }
                }
            }
            if (newState != ReadStateConfig.STATE_REFLOW && newState != ReadStateConfig.STATE_TTS
                    && newState != ReadStateConfig.STATE_AUTOFLIP && newState != ReadStateConfig.STATE_PANZOOM) {
                mViewCtrl.offsetScrollBoundary(0, topOffset, 0, bottomOffset);
            } else if (AppDisplay.isPad()) {
                mViewCtrl.offsetScrollBoundary(0, topOffset, 0, bottomOffset);
            }
//            boolean isSettingShow = false;
//            if (mViewSettingsWindow != null && !AppDisplay.isPad()) {
//                isSettingShow = mViewSettingsWindow.isShowing() || ((ViewSettingsWindow) mViewSettingsWindow).getPageColorWindow().isShowing();
//            }

//            if (isSettingShow
//                    || mThirdMaskCounter > 0) {
            if (mThirdMaskCounter > 0) {
                if (mMaskView.getVisibility() != View.VISIBLE) {
                    mRootView.removeView(mMaskView);
                    mRootView.addView(mMaskView, new ViewGroup.LayoutParams(
                            ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT));
                    mMaskView.setVisibility(View.VISIBLE);
                    if (mMaskView.getTag(SHOW_ANIMATION_TAG) != null) {
                        mMaskView.startAnimation((AnimationSet) mMaskView.getTag(SHOW_ANIMATION_TAG));
                    }
                }
            } else {
                if (mMaskView.getVisibility() != View.GONE) {
                    mMaskView.setVisibility(View.GONE);
                    if (mMaskView.getTag(HIDE_ANIMATION_TAG) != null) {
                        mMaskView.startAnimation((AnimationSet) mMaskView.getTag(HIDE_ANIMATION_TAG));
                    }
                }
            }
        }
    };

    private ILayoutChangeListener mLayoutChangeListener = new ILayoutChangeListener() {
        @Override
        public void onLayoutChange(View v, int newWidth, int newHeight, int oldWidth, int oldHeight) {
            if (newWidth != oldWidth || newHeight != oldHeight || mShouldResetLayout) {
                mShouldResetLayout = false;
                updateSettingBar();
                updateTopToolbarLayout(mUIDragToolBar.getToolBarPosition());
            }
        }
    };

    private UIExtensionsManager.ConfigurationChangedListener mConfigurationChangedListener = new UIExtensionsManager.ConfigurationChangedListener() {
        @Override
        public void onConfigurationChanged(Configuration newConfig) {
            int newOrientation = newConfig.orientation;
            boolean onMultiWindowModeChanged = false;
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
                onMultiWindowModeChanged = mAttachedActivity.isInMultiWindowMode();
            }

            if (AppDevice.isChromeOs(mAttachedActivity)
                    || newOrientation != mLastOrientation
                    || onMultiWindowModeChanged != mOnMultiWindowModeChanged) {
                mLastOrientation = newOrientation;
                mOnMultiWindowModeChanged = onMultiWindowModeChanged;

                mTabViewControl.updateLayout();
                AppThreadManager.getInstance().getMainThreadHandler().postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        if (mUIDragToolBar != null)
                            mUIDragToolBar.layoutToolbar();
                        if (mFullScreenUIDragToolbar != null && mFullScreenToolSetBarLayout.getVisibility() == View.VISIBLE)
                            mFullScreenUIDragToolbar.layoutToolbar();
                    }
                }, 300);

                if (AppDevice.isChromeOs(mAttachedActivity)) {
                    if (mViewSettingsWindow instanceof ViewToolBar)
                        ((ViewToolBar) mViewSettingsWindow).onConfigurationChanged();
                }
            }
        }
    };

    private ILifecycleEventListener mLifecycleEventListener = new LifecycleEventListener() {
        @Override
        public void onCreate(Activity act, Bundle savedInstanceState) {
            mFullScreenToolSetLocation = getFullScreenToolSetLocation();
        }

        @Override
        public void onPause(Activity act) {
            saveFullScreenToolSetLocation();
        }

        @Override
        public void onResume(Activity act) {
            super.onResume(act);
            if (isShowFullScreenUI()) {
                SystemUiHelper.getInstance().hideSystemUI(mAttachedActivity);
            }
        }

        @Override
        public void onHiddenChanged(boolean hidden) {
            if (hidden) {
                mUiExtensionsManager.stopHideToolbarsTimer();
            } else {
                showToolbars();
                mUiExtensionsManager.resetHideToolbarsTimer();
            }
        }

        @Override
        public void onStop(Activity act) {
            if (AppDisplay.isPad()) {
                if (mTabViewControl != null) {
                    mTabViewControl.dismissTabPop();
                }
            }
        }

        @Override
        public void onDestroy(Activity act) {
        }
    };

    private IThemeEventListener mThemeEventListener = new IThemeEventListener() {
        @Override
        public void onThemeColorChanged(String type, int color) {
            mUiExtensionsManager.triggerDismissMenuEvent();
            updateViewSettingTheme();
            updateTopBarTheme();
            onToolBarThemeColorChanged();
            refreshFullScreenViewState();

            if (mPanelManager instanceof PanelManager)
                ((PanelManager) mPanelManager).updateTheme();

            if (mPageColorMode == IViewSettingsWindow.NIGHT) {
                mUiExtensionsManager.getPDFViewCtrl().setBackgroundColor(Color.parseColor("#36404A"));
            } else {
                mUiExtensionsManager.getPDFViewCtrl().setBackgroundColor(AppResource.getColor(mContext, R.color.ux_bg_color_docviewer));
            }
        }
    };

    private void updateViewSettingTheme() {
        if (mViewSettingsWindow != null && mViewSettingsWindow.getContentView() != null) {
            mViewSettingsWindow = mViewSettingsWindow.updateTheme();
        }
    }

    private void updateTopBarTheme() {
        mTabViewControl.updateTheme();
        if (mPanelItem != null) {
           mPanelItem.updateBackgroundColor();
        }
        mTopBar.updateBackgroundColor();
        mBottomBar.setShowSolidLineColor(mContext.getResources().getColor(R.color.p1));
        mBottomBar.updateBackgroundColor();
        BaseBar.TB_Position[] positions = new BaseBar.TB_Position[]{BaseBar.TB_Position.Position_LT,
                BaseBar.TB_Position.Position_CENTER,
                BaseBar.TB_Position.Position_RB};
        for (BaseBar.TB_Position position : positions) {
            if (position != BaseBar.TB_Position.Position_CENTER) {
                int count = mTopBar.getItemsCount(position);
                for (int i = 0; i < count; i++) {
                    IBaseItem baseItem = mTopBar.getItemByIndex(position, i);
                    baseItem.setTextColor(ThemeUtil.getToolbarTextColor(mContext));
                    baseItem.setImageTintList(ThemeUtil.getTopBarIconColorStateList(mContext));
                }
            }

            int bottomCount = mBottomBar.getItemsCount(position);
            for (int i = 0; i < bottomCount; i++) {
                IBaseItem baseItem = mBottomBar.getItemByIndex(position, i);
                baseItem.setTextColor(ThemeUtil.getToolbarTextColor(mContext));
                baseItem.setImageTintList(ThemeUtil.getPrimaryIconColor(mContext));
            }
        }
    }

    private void onToolBarThemeColorChanged() {
        if (mHomeToolbar != null) {
            mHomeToolbar.onThemeColorChanged();
        }
        if (mFullScreenHomeToolbar != null) {
            mFullScreenHomeToolbar.onThemeColorChanged();
        }
        if (mCommentToolbar != null) {
            mCommentToolbar.onThemeColorChanged();
        }
        if (mDrawingToolbar != null) {
            mDrawingToolbar.onThemeColorChanged();
        }
        if (mEditToolbar != null) {
            mEditToolbar.onThemeColorChanged();
        }
        if (mFormToolbar != null) {
            mFormToolbar.onThemeColorChanged();
        }
        if (mSignToolbar != null) {
            mSignToolbar.onThemeColorChanged();
        }
        if (mProtectToolbar != null) {
            mProtectToolbar.onThemeColorChanged();
        }
    }

    public boolean removeBottomBar(IBarsHandler.BarName barName) {
        if (IBarsHandler.BarName.TOP_BAR.equals(barName)) {
            mTopBarLayout.removeAllViews();
            mIsShowTopToolbar = false;
            mTopBarLayout.setVisibility(View.GONE);
            return true;
        } else if (IBarsHandler.BarName.BOTTOM_BAR.equals(barName)) {
            mBottomBarLayout.removeAllViews();
            mIsShowBottomToolbar = false;
            mBottomBarLayout.setVisibility(View.GONE);
            return true;
        }
        return false;
    }

    public boolean addCustomToolBar(IBarsHandler.BarName barName, View view) {
        if (view == null) {
            return false;
        }
        int height;
        if (AppDisplay.isPad()) {
            height = mContext.getResources().getDimensionPixelOffset(R.dimen.ux_toolbar_height_pad);
        } else {
            height = mContext.getResources().getDimensionPixelOffset(R.dimen.ux_toolbar_height_phone);
        }
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, height);
        view.setLayoutParams(params);

        if (IBarsHandler.BarName.TOP_BAR.equals(barName)) {
            mTopBarLayout.removeAllViews();
            mIsShowTopToolbar = true;
            mTopBarLayout.setVisibility(View.VISIBLE);
            mTopBarLayout.addView(view, 0);
            return true;
        } else if (IBarsHandler.BarName.BOTTOM_BAR.equals(barName)) {
            mBottomBarLayout.removeAllViews();
            mIsShowBottomToolbar = true;
            mBottomBarLayout.setVisibility(View.VISIBLE);
            mBottomBarLayout.addView(view);
            return true;
        }
        return false;
    }

    public Animation getTopbarShowAnimation() {
        return mTopBarShowAnim;
    }

    public Animation getBottombarShowAnimation() {
        return mBottomBarShowAnim;
    }

    public Animation getTopbarHideAnimation() {
        return mTopBarHideAnim;
    }

    public Animation getBottombarHideAnimation() {
        return mBottomBarHideAnim;
    }

    @Override
    public void setCenterItems(List<MainCenterItemBean> items) {
        mTabViewControl.release();
        mTopBar.removeItems(BaseBar.TB_Position.Position_CENTER);
        if (items.isEmpty()) {
            mTopAnnotBarLayout.removeAllViews();
            mCurToolbar = null;
        }
        mCenterItemBeans = items;

        for (MainCenterItemBean itemBean : mCenterItemBeans) {
            if (itemBean.type == ToolbarItemConfig.ITEM_HOME_TAB) {
                if (mHomeToolbar != null)
                    mHomeToolbar.setToolItems(getMainCenterItem(ToolbarItemConfig.ITEM_HOME_TAB));
            } else if (itemBean.type == ToolbarItemConfig.ITEM_EDIT_TAB) {
                if (mEditToolbar != null)
                    mEditToolbar.setToolItems(getMainCenterItem(ToolbarItemConfig.ITEM_EDIT_TAB));
            } else if (itemBean.type == ToolbarItemConfig.ITEM_COMMENT_TAB) {
                if (mCommentToolbar != null) {
                    mCommentToolbar.setToolItems(getMainCenterItem(ToolbarItemConfig.ITEM_COMMENT_TAB));
                } else {
                    List<ToolItemBean> itemBeans = itemBean.toolItems;
                    if (itemBeans != null) {
                        for (ToolItemBean toolItemBean : itemBeans) {
                            IToolSupply toolSupply = mUiExtensionsManager.getToolsManager().getToolSupply(toolItemBean.type);
                            if (toolSupply == null) continue;

                            if(toolItemBean.type == ToolConstants.Highlight
                                    ||toolItemBean.type == ToolConstants.Strikeout
                                    ||toolItemBean.type == ToolConstants.Squiggly
                                    ||toolItemBean.type == ToolConstants.Underline){
                                toolSupply.setPropertyBar(toolItemBean.property);
                            }
                        }
                    }
                }
            } else if (itemBean.type == ToolbarItemConfig.ITEM_DRAWING_TAB) {
                if (mDrawingToolbar != null)
                    mDrawingToolbar.setToolItems(getMainCenterItem(ToolbarItemConfig.ITEM_DRAWING_TAB));
            } else if (itemBean.type == ToolbarItemConfig.ITEM_FORM_TAB) {
                if (mFormToolbar != null)
                    mFormToolbar.setToolItems(getMainCenterItem(ToolbarItemConfig.ITEM_FORM_TAB));
            } else if (itemBean.type == ToolbarItemConfig.ITEM_FILLSIGN_TAB) {
                if (mSignToolbar != null)
                    mSignToolbar.setToolItems(getMainCenterItem(ToolbarItemConfig.ITEM_FILLSIGN_TAB));
            }
        }
        mTabViewControl.addTabs(items);
        if (mHomeToolbar != null)
            mHomeToolbar.setToolItems(getMainCenterItem(ToolbarItemConfig.ITEM_HOME_TAB));
        if (mEditToolbar != null)
            mEditToolbar.setToolItems(getMainCenterItem(ToolbarItemConfig.ITEM_EDIT_TAB));
        if (mCommentToolbar != null)
            mCommentToolbar.setToolItems(getMainCenterItem(ToolbarItemConfig.ITEM_COMMENT_TAB));
        if (mDrawingToolbar != null)
            mDrawingToolbar.setToolItems(getMainCenterItem(ToolbarItemConfig.ITEM_DRAWING_TAB));
        if (mFormToolbar != null)
            mFormToolbar.setToolItems(getMainCenterItem(ToolbarItemConfig.ITEM_FORM_TAB));
        if (mSignToolbar != null)
            mSignToolbar.setToolItems(getMainCenterItem(ToolbarItemConfig.ITEM_FILLSIGN_TAB));
//        if (mViewSettingsWindow != null)
//            mViewSettingsWindow.setToolItems(getMainCenterItem(ToolbarItemConfig.ITEM_VIEW_TAB));
        if (mCurToolbar != null)
            setToolBar(mCurToolbar);
        if (mCurToolbar == mSignToolbar
                && mUiExtensionsManager.getState() != ReadStateConfig.STATE_FILLSIGN
                && mUiExtensionsManager.getState() != ReadStateConfig.STATE_COMPARE)
            mUiExtensionsManager.changeState(ReadStateConfig.STATE_FILLSIGN);

//        asynInitTaskFinished();
    }

    @Override
    public List<MainCenterItemBean> getCenterItems() {
        mTabViewControl.sortTabs(mCenterItemBeans);
        return mCenterItemBeans;
    }

    @Override
    public void setAddToolsProperty(final List<AddToolsBean> items) {
        if (mHomeToolbar != null) {
            AppThreadManager.getInstance().runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    mHomeToolbar.setAddToolsProperty(items);
                }
            });
        }
    }

    @Override
    public List<AddToolsBean> getAddToolsProperty() {
        if (mHomeToolbar != null)
            return mHomeToolbar.getAddToolsProperty();
        return null;
    }

    @Override
    public int getCurrentTab() {
        if (mTabViewControl.getCurrentTab() != null)
            return mTabViewControl.getCurrentTab().getTag();
        return ToolbarItemConfig.ITEM_HOME_TAB;
    }

    @Override
    public void setCurrentTab(int tabType) {
        mTabViewControl.setCurrentTab(tabType);
    }

    @Override
    public void removeTab(int tabType) {
        for (MainCenterItemBean item : mCenterItemBeans) {
            if (item.type == tabType) {
                mCenterItemBeans.remove(item);
                break;
            }
        }
        mTabViewControl.removeTab(tabType);
    }

    private boolean mIsShowingPanelOnDrawBegin = false;
    private boolean mIsNeedRevertToolbarLayout = false; // when show panel, tool bar is at left, The user don`t drag tool bar to the other position.
    private UIDragToolBar.IToolbarEventListener mToolbarEventListener = new UIDragToolBar.IToolbarEventListener() {
        int pos;

        @Override
        public void onToolbarDragEventBegin() {
            pos = mUIDragToolBar.getToolBarPosition();
            if (isShowFullScreenUI()) {
                mUiExtensionsManager.onUIInteractElementClicked(IUIInteractionEventListener.Reading_FullScreen_Toolbar_Drag);
            } else {
                mUiExtensionsManager.onUIInteractElementClicked(IUIInteractionEventListener.Reading_Toolbar_Drag);
            }
            if (mTopTitleBarLayout != null) {
                mTopTitleBarLayout.setVisibility(View.INVISIBLE);
            }
            if (mPanelManager.isShowingPanel()) {
                mIsShowingPanelOnDrawBegin = true;
                mPanelContainer.setVisibility(View.GONE);
            }
            mUiExtensionsManager.stopHideToolbarsTimer();
        }

        @Override
        public void onToolbarDragEventEnd() {
            if (mTopTitleBarLayout != null && mTopBarContainer != null && mTopBarContainer.getVisibility() == View.VISIBLE) {
                updateTopToolbarLayout(pos);
                mTopTitleBarLayout.setVisibility(View.VISIBLE);
                int topOffset;
                int bottomOffset;
                if (mUiExtensionsManager.getState() == ReadStateConfig.STATE_REDACT) {
                    topOffset = mShowFullScreenUI ? 0 : mAnnotCustomTopBarLayout.getHeight();
                    bottomOffset = mShowFullScreenUI ? 0 : -mAnnotCustomBottomBarLayout.getHeight();
                } else if (mUiExtensionsManager.getState() == ReadStateConfig.STATE_SEARCH) {
                    topOffset = mAnnotCustomTopBarLayout.getHeight();
                    bottomOffset = 0;
                } else {
                     topOffset = getTopBarHeight();
                     bottomOffset = AppDisplay.isPad() ? 0 : -getBottomBarHeight();
                }
                mViewCtrl.offsetScrollBoundary(0, topOffset, 0, bottomOffset);
                mViewCtrl.postPageContainer();
            }
            if (mIsShowingPanelOnDrawBegin) {
                if (pos != UIDragToolBar.TOOLBAR_POS_LEFT) {
                    mPanelContainer.setVisibility(View.VISIBLE);
                } else {
                    mPanelItem.setSelected(false);
                    mPanelItem.setChecked(false);
                }
                mIsShowingPanelOnDrawBegin = false;
            }
            mUiExtensionsManager.startHideToolbarsTimer();
        }

        @Override
        public void onToolbarPositionChanged(int oldPos, int newPos) {
            pos = newPos;
            mIsNeedRevertToolbarLayout = false;
        }
    };

    private void updateTopToolbarLayout(@UIDragToolBar.ToolbarPos int pos) {
        if (pos == UIDragToolBar.TOOLBAR_POS_TOP /*|| pos == UIDragToolBar.TOOLBAR_POS_BOTTOM*/) {
            if (mTopTitleBarLayout.getParent() == mTopBarContainer) {
                updateTopTitleBarLayoutParams();
                return;
            }
            mTopBarContainer.removeView(mTopTitleBarLayout);
            updateTopTitleBarLayoutParams();
            mTopBarContainer.addView(mTopTitleBarLayout);
        } else {
            mTopBarContainer.removeView(mTopAnnotBarLayout);
            mTopBarContainer.addView(mTopAnnotBarLayout);
            RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams) mTopTitleBarLayout.getLayoutParams();
            params.topMargin = getTopBarLayoutHeight();
            mTopTitleBarLayout.setLayoutParams(params);
        }
    }

    private void updateTopTitleBarLayoutParams() {
        if (!AppDisplay.isPad() && mUiExtensionsManager.getState() == ReadStateConfig.STATE_REFLOW) {
            mTopTitleBarLayout.setVisibility(View.GONE);
        } else {
            mTopTitleBarLayout.setVisibility(mTopBarContainer.getVisibility());
        }
        mTopBarContainer.post(new Runnable() {
            @Override
            public void run() {
                RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams) mTopTitleBarLayout.getLayoutParams();
                if (params != null) {
                    if (mTopAnnotBarLayout.getChildCount() == 0) {
                        params.topMargin = getTopBarLayoutHeight();
                    } else {
                        params.topMargin = getTopBarLayoutHeight() + mUIDragToolBar.getToolbarRealHeight();
                    }
                    mTopTitleBarLayout.setLayoutParams(params);
                }
            }
        });
    }

    @Override
    public void setToolBar(UIToolBaseBar toolBar) {
        mCurToolbar = toolBar;
        mUIDragToolBar.setToolBar(mCurToolbar);
        AppUtil.removeViewFromParent(mUIDragToolBar.getRootView()); // Optimize screen rotation speed
        mTopAnnotBarLayout.addView(mUIDragToolBar.getRootView()); // Optimize screen rotation speed
        updateTopToolbarLayout(mUIDragToolBar.getToolBarPosition());
    }

    private IViewSettingsWindow getViewSettingsBar() {
        if (mViewSettingsWindow == null) {
            if (mUIDragToolBar.getToolBarPosition() == UIDragToolBar.TOOLBAR_POS_TOP /*|| mUIDragToolBar.getToolBarPosition() == UIDragToolBar.TOOLBAR_POS_BOTTOM*/)
                mViewSettingsWindow = new ViewToolBar(mContext, BaseBar.HORIZONTAL, mUiExtensionsManager, mUIDragToolBar, getMainCenterItem(ToolbarItemConfig.ITEM_VIEW_TAB));
            else
                mViewSettingsWindow = new ViewToolBar(mContext, BaseBar.VERTICAL, mUiExtensionsManager, mUIDragToolBar, getMainCenterItem(ToolbarItemConfig.ITEM_VIEW_TAB));
            mViewSettingsWindow.setToolItems(getMainCenterItem(ToolbarItemConfig.ITEM_VIEW_TAB));
        }
        return mViewSettingsWindow;
    }

    @Override
    public UIDragToolBar getDragToolBar() {
        return mUIDragToolBar;
    }

    @Override
    public void setToolBarPosition(int position) {
        if (position == UIDragToolBar.TOOLBAR_POS_ANY) {
            int padding = AppResource.getDimensionPixelSize(mContext, R.dimen.ux_margin_48dp);
            mUIDragToolBar.setDraggableBoundaryInset(new Rect(0, 0, 0, AppDisplay.isPad() ? padding  : padding * 2));
        }
        mUIDragToolBar.setToolBarPosition(position);
    }

    @Override
    public int getToolBarPosition() {
        return mUIDragToolBar.getToolBarPosition();
    }

    private MainCenterItemBean getMainCenterItem(int type) {
        for (MainCenterItemBean itemBean : mCenterItemBeans) {
            if (itemBean.type == type)
                return itemBean;
        }
        return null;
    }

    private MainCenterItemBean createCenterItemBean(int type) {
        MainCenterItemBean itemBean = new MainCenterItemBean();
        itemBean.type = type;
        return itemBean;
    }

    public void updateZoomModeSettings() {
        if (mUiExtensionsManager.getState() == ReadStateConfig.STATE_REFLOW) return;

        if (getSettingWindow() != null) {
            int zoomMode = mUiExtensionsManager.getPDFViewCtrl().getZoomMode();
            if (zoomMode == PDFViewCtrl.ZOOMMODE_FITPAGE) {
                getSettingWindow().setProperty(IViewSettingsWindow.TYPE_FIT_PAGE, zoomMode);
            } else if (zoomMode == PDFViewCtrl.ZOOMMODE_FITWIDTH) {
                getSettingWindow().setProperty(IViewSettingsWindow.TYPE_FIT_WIDTH, zoomMode);
            } else if (mUiExtensionsManager.getState() != ReadStateConfig.STATE_REFLOW) {
                getSettingWindow().setProperty(IViewSettingsWindow.TYPE_FIT_WIDTH, zoomMode);
                getSettingWindow().setProperty(IViewSettingsWindow.TYPE_FIT_PAGE, zoomMode);
            }
        }
    }

    public int getTopBarHeight() {
        if (mUIDragToolBar.getToolBarPosition() == UIDragToolBar.TOOLBAR_POS_TOP
            /*|| mUIDragToolBar.getToolBarPosition() == UIDragToolBar.TOOLBAR_POS_BOTTOM*/) {
            return getTopBarLayoutHeight() + mUIDragToolBar.getToolbarRealHeight() + mTopTitleBarLayout.getHeight();
        } else {
            return getTopBarLayoutHeight() + mTopTitleBarLayout.getHeight();
        }
    }

    private int getTopBarLayoutHeight() {
        return Math.max(mTopBarLayout.getHeight(), AppResource.getDimensionPixelSize(mContext, R.dimen.ux_topbar_height));
    }

    public void onDocOpened(PDFDoc document, int errCode) {
        if (errCode == Constants.e_ErrSuccess) {
            if (mCurToolbar != null) {
                switch (mCurToolbar.getUsageType()) {
                    case UIToolBaseBar.USAGE_TYPE_HOME:
                        mUiExtensionsManager.onUIInteractElementClicked(IUIInteractionEventListener.Reading_ToolsTab_Home);
                        break;
                    case UIToolBaseBar.USAGE_TYPE_EDIT:
                        mUiExtensionsManager.onUIInteractElementClicked(IUIInteractionEventListener.Reading_ToolsTab_Edit);
                        break;
                    case UIToolBaseBar.USAGE_TYPE_COMMENT:
                        mUiExtensionsManager.onUIInteractElementClicked(IUIInteractionEventListener.Reading_ToolsTab_Comment);
                        break;
                    case UIToolBaseBar.USAGE_TYPE_DRAW:
                        mUiExtensionsManager.onUIInteractElementClicked(IUIInteractionEventListener.Reading_ToolsTab_Drawing);
                        break;
                    case UIToolBaseBar.USAGE_TYPE_VIEW:
                        mUiExtensionsManager.onUIInteractElementClicked(IUIInteractionEventListener.Reading_ToolsTab_View);
                        break;
                    case UIToolBaseBar.USAGE_TYPE_FORM:
                        mUiExtensionsManager.onUIInteractElementClicked(IUIInteractionEventListener.Reading_ToolsTab_Form);
                        break;
                    case UIToolBaseBar.USAGE_TYPE_SIGN:
                        mUiExtensionsManager.onUIInteractElementClicked(IUIInteractionEventListener.Reading_ToolsTab_FillSign);
                        break;
                    default:
                        break;
                }
                resetToolbarState();
            }
            resetPageLayout();

            if (!isShowFullScreenUI())
                showToolbars();
        }

        if (mPageColorMode == IViewSettingsWindow.NIGHT) {
            mUiExtensionsManager.getPDFViewCtrl().setBackgroundColor(Color.parseColor("#36404A"));
        } else {
            mUiExtensionsManager.getPDFViewCtrl().setBackgroundColor(AppResource.getColor(mContext, R.color.ux_bg_color_docviewer));
        }

        if (mCurToolbar instanceof HomeToolBar) {
            ((HomeToolBar) mCurToolbar).dismissAddToolsDialog();
        }

    }

    public void resetPageLayout() {
        try {
            if (mViewCtrl.getPageCount() == 1) {
                getViewSettingsBar().enableBar(IViewSettingsWindow.TYPE_FACING_PAGE, false);
                getViewSettingsBar().enableBar(IViewSettingsWindow.TYPE_COVER_PAGE, false);
                getViewSettingsBar().enableBar(IViewSettingsWindow.TYPE_CONTINUOUS_PAGE, false);
                getViewSettingsBar().enableBar(IViewSettingsWindow.TYPE_RIGHT_TO_LEFT, false);

//                mViewCtrl.setContinuous(false); //SDKRD-9040
                if (mViewCtrl.getPageLayoutMode() != PDFViewCtrl.PAGELAYOUTMODE_REFLOW) {
                    if (!mIsChangedPageLayoutByDoc) {
                        mIsChangedPageLayoutByDoc = true;
                        mLastPageLayout = mViewCtrl.getPageLayoutMode();
                    }
                    mViewCtrl.setPageLayoutMode(PDFViewCtrl.PAGELAYOUTMODE_SINGLE);
                }
            } else {
                if (mIsChangedPageLayoutByDoc) {
                    mIsChangedPageLayoutByDoc = false;
                    mViewCtrl.setPageLayoutMode(mLastPageLayout);
                    mLastPageLayout = mViewCtrl.getPageLayoutMode();
                }
                getViewSettingsBar().enableBar(IViewSettingsWindow.TYPE_FACING_PAGE, true);
                getViewSettingsBar().enableBar(IViewSettingsWindow.TYPE_COVER_PAGE, true);
                getViewSettingsBar().enableBar(IViewSettingsWindow.TYPE_CONTINUOUS_PAGE, true);
                getViewSettingsBar().enableBar(IViewSettingsWindow.TYPE_RIGHT_TO_LEFT, true);
            }
        } catch (Exception ignored) {
        }
    }

    private void resetToolbarState() {
        DocumentManager documentManager = mUiExtensionsManager.getDocumentManager();
        if (mFullScreenHomeToolbar != null)
            mFullScreenHomeToolbar.setEnabled(documentManager.canAddAnnot()
                    && documentManager.withAddPermission()
                    && mUiExtensionsManager.isEnableModification());
        if (mHomeToolbar != null)
            mHomeToolbar.setEnabled(documentManager.canAddAnnot()
                    && documentManager.withAddPermission()
                    && mUiExtensionsManager.isEnableModification());
        if (mEditToolbar != null)
            mEditToolbar.setEnabled(documentManager.canEdit() && mUiExtensionsManager.isEnableModification());
        if (mCommentToolbar != null)
            mCommentToolbar.setEnabled(documentManager.canAddAnnot()
                    && documentManager.withAddPermission()
                    && mUiExtensionsManager.isEnableModification());
        if (mDrawingToolbar != null)
            mDrawingToolbar.setEnabled(documentManager.canAddAnnot()
                    && documentManager.withAddPermission()
                    && mUiExtensionsManager.isEnableModification());
        if (mFormToolbar != null)
            mFormToolbar.setEnabled(!documentManager.isXFA()
                    && documentManager.canModifyForm() && !documentManager.isSign()
                    && mUiExtensionsManager.isEnableModification()
                    && documentManager.withAllPermission(null)
                    && documentManager.withAddPermission());
        if (mSignToolbar != null) {
            mSignToolbar.setEnabled(documentManager.canAddSignature()
                    && mUiExtensionsManager.isEnableModification()
                    && documentManager.canModifyContents());
        }
        if (AppDisplay.isPad())
            updateZoomModeSettings();

        if (mCurToolbar == mSignToolbar
                && mUiExtensionsManager.getState() != ReadStateConfig.STATE_FILLSIGN
                && mUiExtensionsManager.getState() != ReadStateConfig.STATE_COMPARE)
            mUiExtensionsManager.changeState(ReadStateConfig.STATE_FILLSIGN);
    }

    public int getBottomBarHeight() {
        int height = 0;
        if (mBottomBar != null && mBottomBar.getContentView() != null) {
            height += mBottomBar.getHeight();
        }
        return height;
    }

    private UIDragToolBar mFullScreenUIDragToolbar;
    private final ViewGroup mFullScreenToolSetBarLayout;
    private HomeToolBar mFullScreenHomeToolbar;

    public HomeToolBar getFullScreenHomeToolbar() {
        return mFullScreenHomeToolbar;
    }

    public boolean isShowFullScreenToolBar() {
        return mFullScreenToolItem != null && mFullScreenToolItem.isSelected();
    }

    private void showFullScreenToolSetBar(boolean show) {
        mFullScreenToolItem.setSelected(show);
        if (show) {
            if (mHomeToolbar == null) return;
            if (mFullScreenHomeToolbar == null) {
                mFullScreenUIDragToolbar = new UIDragToolBar(mContext, mUiExtensionsManager);
                mFullScreenUIDragToolbar.setAutoResizeHeight(true);
                mFullScreenUIDragToolbar.registerToolbarEventListener(mToolbarEventListener);
                mFullScreenUIDragToolbar.setDraggableBoundaryInset(
                        new Rect(0, AppResource.getDimensionPixelSize(mContext, R.dimen.ux_margin_20dp),
                                0, AppResource.getDimensionPixelSize(mContext, R.dimen.ux_margin_24dp)));
                mFullScreenUIDragToolbar.setToolBarPosition(UIDragToolBar.TOOLBAR_POS_ANY);
                mFullScreenHomeToolbar = HomeToolBar.newInstance(mContext, mUiExtensionsManager, mFullScreenUIDragToolbar);
                mFullScreenHomeToolbar.addDragItem();
                mFullScreenHomeToolbar.setInitWithAddItem(false);
                mFullScreenUIDragToolbar.setToolBar(mFullScreenHomeToolbar);
                if (mFullScreenToolSetBarLayout.indexOfChild(mFullScreenUIDragToolbar.getRootView()) == -1) // Optimize screen rotation speed
                    mFullScreenToolSetBarLayout.addView(mFullScreenUIDragToolbar.getRootView()); // Optimize screen rotation speed
                mFullScreenUIDragToolbar.setHorizontalHeight(mUIDragToolBar.getHorizontalHeight());
                mFullScreenUIDragToolbar.setVerticalWidth(mUIDragToolBar.getVerticalWidth());
            }
            mFullScreenHomeToolbar.setToolItems(mHomeToolbar.getToolItems());
            mFullScreenToolSetBarLayout.setVisibility(View.VISIBLE);
            mFullScreenUIDragToolbar.layoutToolbar();
            if (mFullScreenUIDragToolbar.getLayoutRect() == null && mFullScreenToolSetLocation != null) {
                mFullScreenUIDragToolbar.setLayoutRect(mFullScreenToolSetLocation);
            }
        } else {
            mFullScreenToolSetBarLayout.setVisibility(View.INVISIBLE);
        }
    }

    private boolean mShowFullScreenUI = false;

    public boolean isShowFullScreenUI() {
        return mShowFullScreenUI;
    }

    private Rect mFullScreenToolSetLocation;

    public Rect getFullScreenToolSetLocation() {
        Rect rect = null;
        String location = AppSharedPreferences.getInstance(mContext).getString("fullscreen_ui", "TOOL_SET_LOCATION", "");
        if (!TextUtils.isEmpty(location)) {
            String[] values = location.split(":");
            if (values.length == 4) {
                try {
                    int left = Integer.parseInt(values[0]);
                    int top = Integer.parseInt(values[1]);
                    int right = Integer.parseInt(values[2]);
                    int bottom = Integer.parseInt(values[3]);
                    rect = new Rect();
                    rect.set(left, top, right, bottom);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return rect;
    }

    private void saveFullScreenToolSetLocation() {
        Rect rect = null;
        if (mFullScreenToolSetBarLayout == null) return;
        View view = mFullScreenToolSetBarLayout.findViewById(R.id.rl_tool_bar_container);
        if (view != null) {
            rect = new Rect();
            view.getGlobalVisibleRect(rect);
        }
        if (rect == null) return;
        String location = rect.left + ":" +
                rect.top + ":" +
                rect.right + ":" +
                rect.bottom;
        AppSharedPreferences.getInstance(mContext).setString("fullscreen_ui", "TOOL_SET_LOCATION", location);
    }

    private void refreshFullScreenViewState() {
        if (!mConfig.uiSettings.fullscreen) return;
        int uiMode = mContext.getResources().getConfiguration().uiMode;
        boolean isDarkMode = (uiMode & Configuration.UI_MODE_NIGHT_MASK) == Configuration.UI_MODE_NIGHT_YES;
        if (mFullScreenTopBar != null) {
            mFullScreenTopBar.setBackgroundColor(ThemeConfig.getInstance(mContext).getB1());
            TextView currentTime = (mFullScreenTopBar.findViewById(R.id.read_fullscreen_current_time));
            currentTime.setTextColor(ThemeConfig.getInstance(mContext).getT2());
            setImageViewColorFilter(mFullScreenTopBar, new int[]{R.id.read_fullscreen_close, R.id.read_fullscreen_more}, isDarkMode ? ThemeConfig.getInstance(mContext).getI3() : -1);
            View divider = mFullScreenTopBar.getChildAt(mFullScreenTopBar.getChildCount() - 1);
            divider.setBackgroundColor(AppResource.getColor(mContext, R.color.p1));
        }
        if (mFullScreenBottomBar != null) {
            mFullScreenBottomBar.setBackgroundColor(ThemeConfig.getInstance(mContext).getB1());
            mFullScreenBottomBar.setBackgroundColor(AppResource.getColor(mContext, R.color.b1));
            ThemeUtil.setTintList(mFullScreenToolItem, ThemeUtil.getPrimaryIconColor(mContext));
            ThemeUtil.setTintList(mFullScreenFavoriteItem, ThemeUtil.getPrimaryIconColor(mContext));
            mFullScreenPageNumberItem.setTextColor(ThemeConfig.getInstance(mContext).getT3());
        }
        mUiExtensionsManager.getPDFViewCtrl().setBackgroundColor(AppResource.getColor(mContext, R.color.ux_bg_color_docviewer));
    }

    private void setImageViewColorFilter(View parent, int[] ids, int color) {
        if (parent == null || ids == null || ids.length == 0) return;
        ImageView imageView;
        for (int id : ids) {
            imageView = parent.findViewById(id);
            if (imageView != null) {
                if (color == -1) {
                    imageView.clearColorFilter();
                } else {
                    imageView.setColorFilter(color);
                }
            }
        }
    }

    public void updateFullScreenPageNumberText(int current) {
        if (mFullScreenPageNumberItem == null) return;
        StringBuilder numberTextBuilder = new StringBuilder();
        if (((mViewCtrl.getPageLayoutMode() == PDFViewCtrl.PAGELAYOUTMODE_FACING ||
                mViewCtrl.getPageLayoutMode() == PDFViewCtrl.PAGELAYOUTMODE_COVER) &&
                current < mViewCtrl.getPageCount() - 1 && current >= 0) ||
                (mViewCtrl.getPageLayoutMode() == PDFViewCtrl.PAGELAYOUTMODE_FACING && mViewCtrl.getPageCount() % 2 == 0)) {
            if (mViewCtrl.getPageLayoutMode() == PDFViewCtrl.PAGELAYOUTMODE_COVER && current == 0) {
                numberTextBuilder.append(current + 1);
            } else {
                if (current != 0 &&
                        (mViewCtrl.getPageLayoutMode() == PDFViewCtrl.PAGELAYOUTMODE_FACING && current % 2 != 0)
                        || (mViewCtrl.getPageLayoutMode() == PDFViewCtrl.PAGELAYOUTMODE_COVER && current % 2 == 0)) {
                    current = current - 1;
                }
                numberTextBuilder.append(current + 1).append(",").append(current + 2);
            }

        } else if (mViewCtrl.getPageLayoutMode() == PDFViewCtrl.PAGELAYOUTMODE_COVER && current == -1) {
            numberTextBuilder.append(current + 2);
        } else {
            numberTextBuilder.append(current + 1);
        }
        numberTextBuilder.append("/").append(mViewCtrl.getPageCount());
        if (LogicalPageHelper.getInstance().isSupportLogicalPage()) {
            String logicalPageLabel = LogicalPageHelper.getInstance().getLogicalPageNumber(current, mViewCtrl.getDoc());

            String logicalNumBuilder = logicalPageLabel +
                    "(" +
                    numberTextBuilder +
                    ")";
            mFullScreenPageNumberItem.setText(logicalNumBuilder);
        } else  {
            mFullScreenPageNumberItem.setText(numberTextBuilder.toString());
        }
    }

    @Override
    public void enableSmallTopToolbar(boolean isEnabled) {
        mIsSmallTopToolbarEnabled = isEnabled;
        if (mFullScreenTopBar != null) {
            mFullScreenTopBar.setVisibility(isEnabled ? View.VISIBLE : View.GONE);
        }
    }

    @Override
    public void enableSmallBottomToolbar(boolean isEnabled) {
        mIsSmallBottomToolbarEnabled = isEnabled;
        if (mFullScreenBottomBar != null) {
            mFullScreenBottomBar.setVisibility(isEnabled ? View.VISIBLE : View.GONE);
        }
    }

    @Override
    public boolean isSmallTopToolbarEnabled() {
        return mIsSmallTopToolbarEnabled;
    }

    @Override
    public boolean isSmallBottomToolbarEnabled() {
        return mIsSmallBottomToolbarEnabled;
    }

    @Override
    public void addTabSelectedListener(ITabSelectedListener tabSelectedListener) {
        mTabSelectedListener.add(tabSelectedListener);
    }

    @Override
    public void removeTabSelectedListener(ITabSelectedListener tabSelectedListener) {
        mTabSelectedListener.remove(tabSelectedListener);
    }

    private void onTabSelectedEvent(int tabId) {
        for (ITabSelectedListener listener : mTabSelectedListener) {
            listener.onTabSelected(tabId);
        }
    }

    private void onTabUnselectedEvent(int tabId) {
        for (ITabSelectedListener listener : mTabSelectedListener) {
            listener.onTabUnselected(tabId);
        }
    }

    private int getViewRealHeight(View view) {
        if (view != null) {
            int height = view.getHeight();
            if (height == 0 && view.getLayoutParams() != null)
                height = view.getLayoutParams().height;
            return height;
        }
        return 0;
    }

    public boolean canFullScreen() {
        return isSupportFullScreen()
                && isToolbarsVisible()
                && !mPanelManager.isShowingPanel()
                && !mTabViewControl.isShowingTabPop();
    }

    public void setDragToolbarHorizontalHeight(int height) {
        mUIDragToolBar.setHorizontalHeight(height);
        if (mFullScreenUIDragToolbar != null)
            mFullScreenUIDragToolbar.setHorizontalHeight(height);
    }

    public void setDragToolbarVerticalWidth(int width) {
        mUIDragToolBar.setVerticalWidth(width);
        if (mFullScreenUIDragToolbar != null)
            mFullScreenUIDragToolbar.setVerticalWidth(width);
    }

    private void setFrameTopImmersiveColor(int height){
        if (mRootView.getBackground() == null) {
            GradientDrawable statusBarBackground = new GradientDrawable();
            statusBarBackground.setColor(AppResource.getColor(mContext, R.color.ui_color_top_bar_main));
            Drawable[] layers = new Drawable[1];
            layers[0] = statusBarBackground;
            LayerDrawable layerDrawable = new LayerDrawable(layers);
            layerDrawable.setLayerInset(0, 0, 0, 0, height);
            mRootView.setBackground(layerDrawable);
        }
    }

    private PageNavigationModule getPageNavigationModule() {
        if (mPageNavigationModule == null) {
            mPageNavigationModule = (PageNavigationModule) mUiExtensionsManager.getModuleByName(Module.MODULE_NAME_PAGENAV);
        }
        return mPageNavigationModule;
    }
}
