/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.modules.thumbnail;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.provider.MediaStore;
import android.text.InputFilter;
import android.text.InputType;
import android.text.Spanned;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseArray;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.foxit.sdk.PDFException;
import com.foxit.sdk.PDFViewCtrl;
import com.foxit.sdk.common.Constants;
import com.foxit.sdk.pdf.PDFDoc;
import com.foxit.sdk.pdf.PDFPage;
import com.foxit.sdk.pdf.ReadingBookmark;
import com.foxit.uiextensions.IPermissionProvider;
import com.foxit.uiextensions.ISystemPermissionProvider;
import com.foxit.uiextensions.IThemeEventListener;
import com.foxit.uiextensions.Module;
import com.foxit.uiextensions.R;
import com.foxit.uiextensions.UIExtensionsManager;
import com.foxit.uiextensions.controls.BaseFragPagerAdapter;
import com.foxit.uiextensions.controls.dialog.AppDialogManager;
import com.foxit.uiextensions.controls.dialog.BaseDialogFragment;
import com.foxit.uiextensions.controls.dialog.FxProgressDialog;
import com.foxit.uiextensions.controls.dialog.MatchDialog;
import com.foxit.uiextensions.controls.dialog.UIDialog;
import com.foxit.uiextensions.controls.dialog.UIMatchDialog;
import com.foxit.uiextensions.controls.dialog.UIPopoverWin;
import com.foxit.uiextensions.controls.dialog.UITextEditDialog;
import com.foxit.uiextensions.controls.dialog.fileselect.UIFileSelectDialog;
import com.foxit.uiextensions.controls.dialog.fileselect.UIFolderSelectDialog;
import com.foxit.uiextensions.controls.dialog.sheetmenu.IActionMenu;
import com.foxit.uiextensions.controls.dialog.sheetmenu.UIActionMenu;
import com.foxit.uiextensions.controls.menu.IMenuGroup;
import com.foxit.uiextensions.controls.menu.IMenuItem;
import com.foxit.uiextensions.controls.menu.IMenuView;
import com.foxit.uiextensions.controls.menu.MenuViewImpl;
import com.foxit.uiextensions.controls.menu.MenuViewManager;
import com.foxit.uiextensions.controls.menu.action.IActionMenuPresenter;
import com.foxit.uiextensions.controls.menu.action.IMenuPresenter;
import com.foxit.uiextensions.controls.menu.action.UIMenuViewBuilder;
import com.foxit.uiextensions.controls.panel.PanelContentViewPage;
import com.foxit.uiextensions.controls.propertybar.imp.ColorPicker;
import com.foxit.uiextensions.controls.toolbar.BaseBar;
import com.foxit.uiextensions.controls.toolbar.IBaseItem;
import com.foxit.uiextensions.controls.toolbar.impl.BaseItemImpl;
import com.foxit.uiextensions.controls.toolbar.impl.TopBarImpl;
import com.foxit.uiextensions.event.PageEventListener;
import com.foxit.uiextensions.modules.pagenavigation.PageNavigationModule;
import com.foxit.uiextensions.modules.thumbnail.createpage.CreatePageBean;
import com.foxit.uiextensions.modules.thumbnail.createpage.PageColorAdapter;
import com.foxit.uiextensions.modules.thumbnail.createpage.PageStyleAdapter;
import com.foxit.uiextensions.modules.thumbnail.createpage.SelectListAdapter;
import com.foxit.uiextensions.pdfreader.config.ActRequestCode;
import com.foxit.uiextensions.pdfreader.impl.MainFrame;
import com.foxit.uiextensions.theme.ThemeConfig;
import com.foxit.uiextensions.theme.ThemeUtil;
import com.foxit.uiextensions.utils.AppDarkUtil;
import com.foxit.uiextensions.utils.AppDisplay;
import com.foxit.uiextensions.utils.AppFileUtil;
import com.foxit.uiextensions.utils.AppIntentUtil;
import com.foxit.uiextensions.utils.AppResource;
import com.foxit.uiextensions.utils.AppStorageManager;
import com.foxit.uiextensions.utils.AppUtil;
import com.foxit.uiextensions.utils.Event;
import com.foxit.uiextensions.utils.SystemUiHelper;
import com.foxit.uiextensions.utils.UIToast;
import com.foxit.uiextensions.utils.thread.AppThreadManager;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.core.content.FileProvider;
import androidx.core.widget.TextViewCompat;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager.widget.ViewPager;
import io.reactivex.Single;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;


public class ThumbnailSupport extends BaseDialogFragment implements IThumbnailSupport, IThemeEventListener {
    private final static int MAX_LOADING_PAGE_NUMBER = 20000;
    static final int ALL_TAB_POSITION = 0;
    static final int ANNOTTATED_TAB_POSITION = 1;
    static final int BOOKMARKED_TAB_POSITION = 2;

    private final static String TAG = ThumbnailSupport.class.getSimpleName();

    private static final String SAVED_IMAGE_DIR_PATH = Environment.getExternalStorageDirectory().getPath()
            + "/FoxitSDK/camera/";// Photo storage path

    //title bar
    private IBaseItem mDoneItem;
    private IBaseItem mEditItem;
    private IBaseItem mCloseItem;
    private IBaseItem mSelectAllItem;
    private IBaseItem mThumbnailTitle;

    //tool bar
    private IBaseItem mAddItem;
    private IBaseItem mDeleteItem;
    private IBaseItem mCopyItem;
    private IBaseItem mPasteItem;
    private IBaseItem mExtractItem;
    private IBaseItem mRotateLeftItem;
    private IBaseItem mRotateRightItem;
    private IBaseItem mShareItem;
    private IActionMenu mAddPageMenus;

    private Context mContext;
    private FragmentActivity mAttachActivity;
    private TopBarImpl mThumbnailTopBar;
    private PDFViewCtrl mPDFView;
    private UIExtensionsManager mUIExtensionsManager;
    private RelativeLayout mToolBar;
    private PanelContentViewPage mContentViewPager;
    private MenuViewManager mMenuViewManager;

    private UIFileSelectDialog mFileSelectDialog = null;
    private UIFolderSelectDialog mFolderSelectDialog = null;
    private UIMatchDialog mCreatePageDialog = null;
    private UIMatchDialog mPageSizeDialog = null;
    private UIMatchDialog mPageDirectionDialog = null;
    private UIMatchDialog mPageColorDialog = null;
    private UIMatchDialog mExtractPageDialog = null;

    private FxProgressDialog mProgressDialog = null;
    private CreatePageBean mInsertPageBean;
    private SelectListAdapter.ItemBean mLastSizeCheckedBean;
    private SelectListAdapter.ItemBean mLastDirectionCheckedBean;
    private SparseArray<String> mDirectionsArray;
    private SparseArray<String> mSizesArray;

    private ThumbnailFragment mAnnotatedFragment;
    private ThumbnailFragment mCurrentFragment;
    private List<ThumbnailFragment> mContentFragments;
    private List<ThumbnailItem> mAllItems;
    private List<ThumbnailItem> mAnnotatedItems;
    private List<ThumbnailItem> mBookmarkedItems;

    private Point mThumbnailSize;
    private String cameraPath;
    private int mCurrentTab = 0;
    private boolean mbEditMode = false;
    private boolean mbNeedRelayout = false;
    private boolean mbPasteState = false;
    private boolean mbManualSelected = false;
    private boolean mIsShowing = false;
    private boolean mShareItemVisible = false;
    View mDialogView;

    private TextView allTab;
    private TextView annotatedTab;
    private TextView bookmarkedTab;
    private BaseBar mThumbnailToolbar;

    private CompositeDisposable mCompositeDisposable;
    private Disposable mDisposable;
    private boolean mIsLoadingAnnotsAtThread;

    public PDFViewCtrl getPDFView() {
        return mPDFView;
    }

    public boolean isEditMode() {
        return mbEditMode;
    }

    public boolean isPasteState() {
        return mbPasteState;
    }

    public void init(PDFViewCtrl pdfViewCtrl, Context context) {
        mPDFView = pdfViewCtrl;
        mContext = context;
        mUIExtensionsManager = (UIExtensionsManager) pdfViewCtrl.getUIExtensionsManager();
        mMenuViewManager = mUIExtensionsManager.getMenuViewManager();
        mMenuViewManager.setMenuPresenter(MenuViewManager.POSITION_THUMBNAIL_ADD, mAddMenuViewPresenter);
    }

    public UIFileSelectDialog getFileSelectDialog() {
        if (mFileSelectDialog == null) {
            mFileSelectDialog = new UIFileSelectDialog(mAttachActivity);
            mFileSelectDialog.init(new FileFilter() {
                @Override
                public boolean accept(File pathname) {
                    return !(pathname.isHidden() || !AppFileUtil.canRead(pathname)) && !(pathname.isFile() && !pathname.getName().toLowerCase().endsWith(".pdf"));
                }
            }, true);
            mFileSelectDialog.setCanceledOnTouchOutside(true);
        } else {
            AppThreadManager.getInstance().getMainThreadHandler().post(new Runnable() {
                @Override
                public void run() {
                    mFileSelectDialog.notifyDataSetChanged();
                }
            });
        }
        return mFileSelectDialog;
    }

    public ThumbnailAdapter.ThumbViewHolder getViewHolderByItem(int tabPosition, ThumbnailItem item) {
        return mContentFragments.get(tabPosition).getViewHolderByItem(item);
    }

    public boolean isThumbnailItemVisible(int tabPosition, ThumbnailItem item) {
        return mContentFragments.get(tabPosition).isThumbnailItemVisible(item);
    }

    public UIFolderSelectDialog getFolderSelectDialog() {
        if (mFolderSelectDialog == null) {
            mFolderSelectDialog = new UIFolderSelectDialog(mAttachActivity);
            mFolderSelectDialog.setFileFilter(new FileFilter() {
                @Override
                public boolean accept(File pathname) {
                    return !(pathname.isHidden() || !AppFileUtil.canRead(pathname));
                }
            });
            mFolderSelectDialog.setTitle(AppResource.getString(mContext, R.string.fx_string_extract));
//            mFolderSelectDialog.setRightButtonText(AppResource.getString(mContext, R.string.fx_string_save));
            mFolderSelectDialog.setCanceledOnTouchOutside(true);
        }
        return mFolderSelectDialog;
    }

    public FxProgressDialog getProgressDialog() {
        if (mProgressDialog == null) {
            mProgressDialog = new FxProgressDialog(mAttachActivity, null, false);
        }
        return mProgressDialog;
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        int nightMode = newConfig.uiMode & Configuration.UI_MODE_NIGHT_MASK;
        if (AppDarkUtil.getInstance(mContext).isSystemModified(nightMode)) {
            return;
        }
        if (mFileSelectDialog != null && mFileSelectDialog.isShowing()) {
            mFileSelectDialog.resetWH();
            mFileSelectDialog.showDialog();
        }
        if (mFolderSelectDialog != null && mFolderSelectDialog.isShowing()) {
            mFolderSelectDialog.resetWH();
            mFolderSelectDialog.showDialog();
        }
        if (mCreatePageDialog != null) {
            mCreatePageDialog.resetWH();
            if (mCreatePageDialog.isShowing()) {
                mCreatePageDialog.showDialog();
            }
        }
        if (mPageSizeDialog != null) {
            mPageSizeDialog.resetWH();
            if (mPageSizeDialog.isShowing()) {
                mPageSizeDialog.showDialog();
            }
        }
        if (mPageDirectionDialog != null) {
            mPageDirectionDialog.resetWH();
            if (mPageDirectionDialog.isShowing()) {
                mPageDirectionDialog.showDialog();
            }
        }
        if (mPageColorDialog != null) {
            mPageColorDialog.resetWH();
            if (mPageColorDialog.isShowing()) {
                mPageColorDialog.showDialog();
            }
        }

        if (mExtractPageDialog != null) {
            mExtractPageDialog.resetWH();
            if (mExtractPageDialog.isShowing()) {
                mExtractPageDialog.showDialog();
            }
        }
        if (mSelectAllItem != null) {
            mSelectAllItem.setMaxWidth(AppDisplay.getActivityWidth() / 3 - AppDisplay.dp2px(16));
        }
        if (mAddPageMenus != null && mAddPageMenus.isShowing()) {
            AppThreadManager.getInstance().getMainThreadHandler().postDelayed(new Runnable() {
                @Override
                public void run() {
                    Rect rect = new Rect();
                    mAddItem.getContentView().getGlobalVisibleRect(rect);
                    if (SystemUiHelper.getInstance().isStatusBarShown(mAttachActivity))
                        rect.offset(0, SystemUiHelper.getInstance().getStatusBarHeight(mAttachActivity));
                    mAddPageMenus.show(mUIExtensionsManager.getRootView(), rect, UIPopoverWin.ARROW_TOP, 0);
                }
            }, 200);
        }
    }

    @Override
    protected View onCreateView(LayoutInflater inflater, ViewGroup container) {
        return initView(inflater, container);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (SystemUiHelper.getInstance().isFullScreenMode(getActivity())) {
            if (getDialog() != null && getDialog().getWindow() != null) {
                SystemUiHelper.getInstance().hideStatusBar(getDialog().getWindow());
            }
        }
    }

    @NonNull
    @Override
    protected PDFViewCtrl getPDFViewCtrl() {
        return mPDFView;
    }

    @Override
    protected void onLayoutChange(View v, int newWidth, int newHeight, int oldWidth, int oldHeight) {
        if (null != getDialog() && getDialog().isShowing()) {
            for (ThumbnailFragment fragment : mContentFragments) {
                fragment.onLayoutChange(v, newWidth, newHeight, oldWidth, oldHeight);
            }
        }
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == ActRequestCode.REQ_FILE_FROM_THUMB_SHARE) {
            mCurrentFragment.getAdapter().cleanCacheFolder();
        }
        if (resultCode == Activity.RESULT_OK) {
            final int lastPageCount = mPDFView.getPageCount();
            final ThumbnailAdapter adapter = mCurrentFragment.getAdapter();
            if (requestCode == ActRequestCode.REQ_FILE_FROM_BROWSER) {
                String path = AppFileUtil.getFilePathFromUri(mContext, data.getData());
                path = AppFileUtil.saveToScopedCache(path);
                boolean result = adapter.importPagesFromDCIM(adapter.getInsertIndex(), path);
                AppFileUtil.deleteScopedCacheFile(path);
                if (!result) {
                    try {
                        if (mPDFView.getDoc().isXFA()) {
                            Toast.makeText(getActivity(), AppResource.getString(mContext, R.string.xfa_not_supported_add_image_toast), Toast.LENGTH_LONG).show();
                        } else {
                            Toast.makeText(getActivity(), AppResource.getString(mContext, R.string.rv_page_import_error), Toast.LENGTH_LONG).show();
                        }
                    } catch (PDFException ee) {
                        ee.printStackTrace();
                    }
                } else {
                    if (lastPageCount == 1)
                        ((MainFrame) mUIExtensionsManager.getMainFrame()).resetPageLayout();
                    mUIExtensionsManager.getDocumentManager().setDocModified(true);
                    resetSelectAllItem(mCurrentFragment.getAdapter().isSelectedAll());
                }
                adapter.notifyDataSetChanged();
            } else if (requestCode == ActRequestCode.REQ_FILE_FROM_CAMERA) {
                if (AppFileUtil.needScopedStorageAdaptation()) {
                    cameraPath = AppFileUtil.getScopedCachePath(mContext, cameraPath);
                }
                boolean result = adapter.importPagesFromCamera(adapter.getInsertIndex(), cameraPath);
                if (!result) {
                    Log.e(TAG, "add new page fail...");
                    try {
                        if (mPDFView.getDoc().isXFA()) {
                            Toast.makeText(getActivity(), AppResource.getString(mContext, R.string.xfa_not_supported_add_image_toast), Toast.LENGTH_LONG).show();
                        } else {
                            Toast.makeText(getActivity(), AppResource.getString(mContext, R.string.rv_page_import_error), Toast.LENGTH_LONG).show();
                        }
                    } catch (PDFException ee) {
                        ee.printStackTrace();
                    }
                } else {
                    if (lastPageCount == 1)
                        ((MainFrame) mUIExtensionsManager.getMainFrame()).resetPageLayout();
                    mUIExtensionsManager.getDocumentManager().setDocModified(true);
                    resetSelectAllItem(mCurrentFragment.getAdapter().isSelectedAll());
                }
                adapter.notifyDataSetChanged();
            } else if (requestCode == ActRequestCode.REQ_FILE_FROM_VIDEO) {
                String path = AppFileUtil.getFilePathFromUri(mContext, data.getData());
                path = AppFileUtil.saveToScopedCache(path);
                adapter.importPagesFromVideo(adapter.getInsertIndex(), path, new Event.Callback() {
                    @Override
                    public void result(Event event, boolean success) {
                        if (success && lastPageCount == 1)
                            ((MainFrame) mUIExtensionsManager.getMainFrame()).resetPageLayout();
                        adapter.notifyDataSetChanged();
                        resetSelectAllItem(mCurrentFragment.getAdapter().isSelectedAll());
                    }
                });
                AppFileUtil.deleteScopedCacheFile(path);
            }
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (verifyPermissions(grantResults)) {
            if (requestCode == ActRequestCode.REQ_CAMERA_PERMISSION)
                startCamera();
            else if (requestCode == ActRequestCode.REQ_RECORD_VIDEO_PERMISSION) {
                startVideo();
            }
        } else {
            UIToast.getInstance(mContext).show(AppResource.getString(mContext, R.string.fx_permission_denied));
        }
    }

    private boolean verifyPermissions(int[] grantResults) {
        for (int grantResult : grantResults) {
            if (grantResult != PackageManager.PERMISSION_GRANTED) {
                return false;
            }
        }
        return true;
    }

    public void startCamera() {
        if (Build.VERSION.SDK_INT >= 23) {
            int permission = ContextCompat.checkSelfPermission(mContext, android.Manifest.permission.CAMERA);
            if (permission != PackageManager.PERMISSION_GRANTED) {
                if (mUIExtensionsManager.getSystemPermissionProvider() == null) {
                    requestPermissions(new String[]{android.Manifest.permission.CAMERA}, ActRequestCode.REQ_CAMERA_PERMISSION);
                } else {
                    mUIExtensionsManager.getSystemPermissionProvider().requestPermission(
                            true,
                            AppResource.getString(mContext, R.string.rv_page_present_thumbnail),
                            new String[]{android.Manifest.permission.CAMERA},
                            new ISystemPermissionProvider.IPermissionResult() {
                                @Override
                                public void onResult(boolean allowed) {
                                    if (allowed)
                                        requestPermissions(new String[]{android.Manifest.permission.CAMERA}, ActRequestCode.REQ_CAMERA_PERMISSION);
                                }
                            }
                    );
                }
                return;
            }
        }
        String state = Environment.getExternalStorageState();
        if (state.equals(Environment.MEDIA_MOUNTED)) {
            cameraPath = SAVED_IMAGE_DIR_PATH + System.currentTimeMillis() + ".png";

            Intent intent = new Intent();
            // set the action to open system camera.
            intent.setAction(MediaStore.ACTION_IMAGE_CAPTURE);
            Uri uri;
            if (!AppFileUtil.needScopedStorageAdaptation()) {
                String out_file_path = SAVED_IMAGE_DIR_PATH;
                File dir = new File(out_file_path);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                // file path 2 uri
                if (Build.VERSION.SDK_INT > 23) {//Build.VERSION_CODES.M
                    uri = FileProvider.getUriForFile(mContext, AppIntentUtil.getFileProviderName(mContext), new File(cameraPath));
                } else {
                    uri = Uri.fromFile(new File(cameraPath));
                }
            } else {
                cameraPath = AppStorageManager.getInstance(mContext).getDefaultFolder() + "/camera/"
                        + System.currentTimeMillis() + ".png";
                uri = AppFileUtil.toDocumentUriFromPath(cameraPath);
                AppFileUtil.createNewDocument(uri, false);
            }
            intent.putExtra(MediaStore.EXTRA_OUTPUT, uri);
            startActivityForResult(intent, ActRequestCode.REQ_FILE_FROM_CAMERA);
        } else {
            Toast.makeText(mContext, AppResource.getString(mContext, R.string.the_sdcard_not_exist),
                    Toast.LENGTH_LONG).show();
        }
    }

    private void startVideo() {
        if (Build.VERSION.SDK_INT >= 23) {
            int permissionCamera = ContextCompat.checkSelfPermission(mContext, android.Manifest.permission.CAMERA);
            int permissionRecord = ContextCompat.checkSelfPermission(mContext, android.Manifest.permission.RECORD_AUDIO);
            if (permissionCamera != PackageManager.PERMISSION_GRANTED || permissionRecord != PackageManager.PERMISSION_GRANTED) {
                if (mUIExtensionsManager.getSystemPermissionProvider() == null) {
                    requestPermissions(new String[]{android.Manifest.permission.CAMERA, android.Manifest.permission.RECORD_AUDIO}, ActRequestCode.REQ_RECORD_VIDEO_PERMISSION);
                } else {
                    mUIExtensionsManager.getSystemPermissionProvider().requestPermission(
                            true,
                            AppResource.getString(mContext, R.string.rv_page_present_thumbnail),
                            new String[]{android.Manifest.permission.CAMERA, android.Manifest.permission.RECORD_AUDIO},
                            new ISystemPermissionProvider.IPermissionResult() {
                                @Override
                                public void onResult(boolean allowed) {
                                    if (allowed)
                                        requestPermissions(new String[]{android.Manifest.permission.CAMERA, android.Manifest.permission.RECORD_AUDIO}, ActRequestCode.REQ_RECORD_VIDEO_PERMISSION);
                                }
                            }
                    );
                }
                return;
            }
        }

        Intent intent = new Intent(MediaStore.ACTION_VIDEO_CAPTURE);
        intent.putExtra(MediaStore.EXTRA_SIZE_LIMIT, 300 * 1024 * 1024);
        intent.putExtra(MediaStore.EXTRA_VIDEO_QUALITY, 0.5);
        if (intent.resolveActivity(mAttachActivity.getPackageManager()) != null)
            startActivityForResult(intent, ActRequestCode.REQ_FILE_FROM_VIDEO);
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        mIsShowing = true;

        int theme = R.style.ThumbnailDialogTheme;
        setStyle(STYLE_NO_TITLE, theme);
        mAttachActivity = this.getActivity();
        mContext = mAttachActivity.getApplicationContext();
        mPDFView.registerPageEventListener(mPageEventListener);
        mUIExtensionsManager.stopHideToolbarsTimer();
    }

    private void showToolbars() {
        if (SystemUiHelper.getInstance().isFullScreen()) {
            MainFrame mainFrame = (MainFrame) mUIExtensionsManager.getMainFrame();
            mainFrame.showToolbars();
        }
        mUIExtensionsManager.startHideToolbarsTimer();
    }

    @Override
    public void onDetach() {
        mIsShowing = false;
        if (mCompositeDisposable != null) {
            if (mDisposable != null) {
                mCompositeDisposable.remove(mDisposable);
                mDisposable = null;
            }
            mCompositeDisposable.clear();
            mCompositeDisposable = null;
        }

        for (ThumbnailFragment fragment : mContentFragments) {
            if (fragment.getAdapter() != null)
                fragment.getAdapter().release();
        }
        getProgressDialog().dismiss();
        mPDFView.unregisterPageEventListener(mPageEventListener);
        showToolbars();
        super.onDetach();
    }

    boolean isShowing() {
        return mIsShowing;
    }

    private void showAddPageMenu() {
        if (mAddPageMenus == null) {
            mAddPageMenus = UIActionMenu.newInstance(mAttachActivity);

            IActionMenuPresenter actionView = mMenuViewManager.getActionView(MenuViewManager.POSITION_THUMBNAIL_ADD);
            if (actionView != null) {
                UIMenuViewBuilder builder = actionView.getViewBuilder();
                mAddPageMenus.setContentView(builder.getContentView());
                builder.addCloseViewCallback(new UIMenuViewBuilder.ICloseViewCallback() {
                    @Override
                    public void onClosed() {
                        if (mAddPageMenus != null && mAddPageMenus.isShowing())
                            mAddPageMenus.dismiss();
                    }
                });
            } else {
                IMenuPresenter presenter = mMenuViewManager.getMenuPresenter(MenuViewManager.POSITION_THUMBNAIL_ADD);
                IMenuView addMenu;
                if (presenter == null) {
                    addMenu = mAddMenuViewPresenter.getMenuView();
                    mMenuViewManager.setMenuPresenter(MenuViewManager.POSITION_THUMBNAIL_ADD, mAddMenuViewPresenter);
                } else {
                    addMenu = presenter.getMenuView();
                }
                mAddPageMenus.setContentView(addMenu.getContentView());
            }
            if (AppDisplay.isPad())
                mAddPageMenus.setWidth(AppResource.getDimensionPixelSize(mContext, R.dimen.ux_pad_top_menu_width));
        }

        Rect rect = new Rect();
        mAddItem.getContentView().getGlobalVisibleRect(rect);
        if (SystemUiHelper.getInstance().isStatusBarShown(mAttachActivity))
            rect.offset(0, SystemUiHelper.getInstance().getStatusBarHeight(mAttachActivity));
        mAddPageMenus.show(mUIExtensionsManager.getRootView(), rect, UIPopoverWin.ARROW_TOP, 0);
    }

    private CreatePageBean getPageBean() {
        if (mInsertPageBean == null) {
            mInsertPageBean = new CreatePageBean();
        }
        return mInsertPageBean;
    }

    private View initCreatePageView() {
        mInsertPageBean = new CreatePageBean();
        View createPageView = View.inflate(mContext, R.layout.rd_thumnail_blank_page, null);
        //page type
        initPageTypeView(createPageView);
        //page counts
        initPageCounts(createPageView);
        //page size
        initPageSize(createPageView);
        //page color
        initPageColor(createPageView);
        //page direction
        initPageDirection(createPageView);
        return createPageView;
    }

    private void initPageTypeView(View rootView) {
        RecyclerView stylesPage = rootView.findViewById(R.id.thumbnail_create_page);
        LinearLayoutManager linearLayoutManager = new LinearLayoutManager(mContext, LinearLayoutManager.HORIZONTAL, false);
        stylesPage.setLayoutManager(linearLayoutManager);
        stylesPage.setItemAnimator(new DefaultItemAnimator());

        PageStyleAdapter styleAdapter = new PageStyleAdapter(mContext);
        styleAdapter.initData();
        stylesPage.setAdapter(styleAdapter);
        styleAdapter.setItemClickListener(new PageStyleAdapter.OnPageStyleItemClickListener() {
            @Override
            public void onItemClick(int type) {
                getPageBean().setPageStyle(type);
            }
        });
    }


    private void initPageCounts(View rootView) {
        RelativeLayout parentPageCounts = rootView.findViewById(R.id.rv_thumbnail_blank_page_counts);
        final TextView tvPageCounts = rootView.findViewById(R.id.tv_thumbnail_page_counts);
        tvPageCounts.setText(String.valueOf(getPageBean().getPageCounts()));
        parentPageCounts.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                final UITextEditDialog uiTextEditDialog = new UITextEditDialog(mAttachActivity);
                uiTextEditDialog.setTitle(AppResource.getString(mContext, R.string.createpdf_new_pagenum));
                uiTextEditDialog.getPromptTextView().setVisibility(View.GONE);
                uiTextEditDialog.getInputEditText().setText(String.valueOf(getPageBean().getPageCounts()));
                uiTextEditDialog.getInputEditText().setInputType(InputType.TYPE_CLASS_NUMBER);
                uiTextEditDialog.getInputEditText().setFilters(new InputFilter[]{new InputFilter() {
                    @Override
                    public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
                        try {
                            int input = Integer.parseInt(dest.toString() + source.toString());
                            if (isInRange(1, 100, input))
                                return null;
                            String str = AppResource.getString(mContext, R.string.rv_gotopage_error_toast)
                                    + " " + "(1-" + String.valueOf(100) + ")";
                            Toast.makeText(mContext, str, Toast.LENGTH_SHORT).show();
                        } catch (RuntimeException e) {
                            e.printStackTrace();
                        }
                        return "";
                    }

                    private boolean isInRange(int a, int b, int c) {
                        return c >= a && c <= b;
                    }
                }});
                uiTextEditDialog.getOKButton().setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        String counts = String.valueOf(uiTextEditDialog.getInputEditText().getText());
                        tvPageCounts.setText(counts);
                        getPageBean().setPageCounts(Integer.parseInt(counts));
                        uiTextEditDialog.dismiss();
                    }
                });
                AppUtil.showSoftInput(uiTextEditDialog.getInputEditText());
                uiTextEditDialog.show();
            }
        });
    }

    private void initPageSize(View rootView) {
        if (mSizesArray == null) {
            mSizesArray = new SparseArray<>();
            mSizesArray.put(PDFPage.e_SizeLetter, AppResource.getString(mContext, R.string.createpdf_new_pagesize_letter));
            mSizesArray.put(PDFPage.e_SizeA3, AppResource.getString(mContext, R.string.createpdf_new_pagesize_A3));
            mSizesArray.put(PDFPage.e_SizeA4, AppResource.getString(mContext, R.string.createpdf_new_pagesize_A4));
            mSizesArray.put(PDFPage.e_SizeLegal, AppResource.getString(mContext, R.string.createpdf_new_pagesize_legal));
            mSizesArray.put(CreatePageBean.e_SizeLedger, AppResource.getString(mContext, R.string.createpdf_new_pagesize_ledger));
        }

        RelativeLayout parentSize = rootView.findViewById(R.id.rv_thumbnail_blank_page_size);
        final TextView tvSize = rootView.findViewById(R.id.tv_thumbnail_page_size);
        tvSize.setText(mSizesArray.get(getPageBean().getPageSize()));
        parentSize.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                mPageSizeDialog = new UIMatchDialog(mAttachActivity);
                mPageSizeDialog.setContentView(getSizeListView());
                mPageSizeDialog.setTitle(AppResource.getString(mContext, R.string.createpdf_new_pagesize));
                mPageSizeDialog.setTitlePosition(BaseBar.TB_Position.Position_CENTER);
                mPageSizeDialog.setRightButtonVisible(View.VISIBLE);
                mPageSizeDialog.setStyle(MatchDialog.DLG_TITLE_STYLE_BG_DEFAULT);
                mPageSizeDialog.setBackButtonTintList(ThemeUtil.getItemIconColor(mContext));
                mPageSizeDialog.setListener(new MatchDialog.DialogListener() {
                    @Override
                    public void onResult(long btType) {
                    }

                    @Override
                    public void onBackClick() {
                    }

                    @Override
                    public void onTitleRightButtonClick() {
                        tvSize.setText(mLastSizeCheckedBean.itemName);

                        float width = CreatePageBean.PageSize.valueOf(mLastSizeCheckedBean.itemType).getWidth();
                        float height = CreatePageBean.PageSize.valueOf(mLastSizeCheckedBean.itemType).getHeight();
                        getPageBean().setWidth(width);
                        getPageBean().setHeight(height);
                        getPageBean().setPageSize(mLastSizeCheckedBean.itemType);

                        mPageSizeDialog.dismiss();
                    }
                });
                mPageSizeDialog.showDialog();
            }
        });
    }

    private void initPageColor(View rootView) {
        RelativeLayout parentColor = rootView.findViewById(R.id.rv_thumbnail_blank_page_color);
        final ImageView ivColor = rootView.findViewById(R.id.iv_create_page_color);
        ivColor.setColorFilter(getPageBean().getPageColor());
        parentColor.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                mPageColorDialog = new UIMatchDialog(mAttachActivity);
                mPageColorDialog.setContentView(getColorPicker());
                mPageColorDialog.setTitle(AppResource.getString(mContext, R.string.createpdf_new_pagecolor));
                mPageColorDialog.setTitlePosition(BaseBar.TB_Position.Position_CENTER);
                mPageColorDialog.setRightButtonVisible(View.VISIBLE);
                mPageColorDialog.setStyle(MatchDialog.DLG_TITLE_STYLE_BG_DEFAULT);
                mPageColorDialog.setBackButtonTintList(ThemeUtil.getItemIconColor(mContext));
                mPageColorDialog.setListener(new MatchDialog.DialogListener() {
                    @Override
                    public void onResult(long btType) {
                    }

                    @Override
                    public void onBackClick() {
                    }

                    @Override
                    public void onTitleRightButtonClick() {
                        ivColor.setColorFilter(mPageColor);
                        getPageBean().setPageColor(mPageColor);
                        mPageColorDialog.dismiss();
                    }
                });
                mPageColorDialog.showDialog();
            }
        });
    }

    private void initPageDirection(View rootView) {
        if (mDirectionsArray == null) {
            mDirectionsArray = new SparseArray<>();
            mDirectionsArray.put(Constants.e_Rotation0, AppResource.getString(mContext, R.string.createpdf_new_ori_partrait));
            mDirectionsArray.put(Constants.e_Rotation90, AppResource.getString(mContext, R.string.createpdf_new_ori_landspace));
        }
        RelativeLayout parentDirection = rootView.findViewById(R.id.rv_thumbnail_blank_page_direction);
        final TextView tvDirection = rootView.findViewById(R.id.tv_thumbnail_page_direction);
        tvDirection.setText(mDirectionsArray.get(getPageBean().getPageDirection()));
        parentDirection.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                mPageDirectionDialog = new UIMatchDialog(mAttachActivity);
                mPageDirectionDialog.setContentView(getDirectionView());
                mPageDirectionDialog.setTitle(AppResource.getString(mContext, R.string.createpdf_new_pageorientation));
                mPageDirectionDialog.setTitlePosition(BaseBar.TB_Position.Position_CENTER);
                mPageDirectionDialog.setRightButtonVisible(View.VISIBLE);
                mPageDirectionDialog.setBackButtonTintList(ThemeUtil.getItemIconColor(mContext));
                mPageDirectionDialog.setStyle(MatchDialog.DLG_TITLE_STYLE_BG_DEFAULT);
                mPageDirectionDialog.setListener(new MatchDialog.DialogListener() {
                    @Override
                    public void onResult(long btType) {
                    }

                    @Override
                    public void onBackClick() {
                    }

                    @Override
                    public void onTitleRightButtonClick() {
                        tvDirection.setText(mLastDirectionCheckedBean.itemName);
                        getPageBean().setPageDirection(mLastDirectionCheckedBean.itemType);
                        mPageDirectionDialog.dismiss();
                    }
                });
                mPageDirectionDialog.showDialog();
            }
        });
    }

    private View getSizeListView() {
        ListView lvPageSize = new ListView(mContext);
        lvPageSize.setLayoutParams(new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, LinearLayout.LayoutParams.MATCH_PARENT));
        lvPageSize.setCacheColorHint(mContext.getResources().getColor(R.color.ux_color_translucent));
        lvPageSize.setDivider(null);
        lvPageSize.setSelector(new ColorDrawable(mContext.getResources().getColor(R.color.ux_color_translucent)));

        List<SelectListAdapter.ItemBean> beanList = new ArrayList<>();
        beanList.add(new SelectListAdapter.ItemBean(AppResource.getString(mContext, R.string.createpdf_new_pagesize_letter), PDFPage.e_SizeLetter, false));
        beanList.add(new SelectListAdapter.ItemBean(AppResource.getString(mContext, R.string.createpdf_new_pagesize_A3), PDFPage.e_SizeA3, false));
        beanList.add(new SelectListAdapter.ItemBean(AppResource.getString(mContext, R.string.createpdf_new_pagesize_A4), PDFPage.e_SizeA4, false));
        beanList.add(new SelectListAdapter.ItemBean(AppResource.getString(mContext, R.string.createpdf_new_pagesize_legal), PDFPage.e_SizeLegal, false));
        beanList.add(new SelectListAdapter.ItemBean(AppResource.getString(mContext, R.string.createpdf_new_pagesize_ledger), CreatePageBean.e_SizeLedger, false));
        for (SelectListAdapter.ItemBean bean : beanList) {
            if (bean.itemType == getPageBean().getPageSize()) {
                bean.isChecked = true;
                mLastSizeCheckedBean = bean;
            } else {
                bean.isChecked = false;
            }
        }
        final SelectListAdapter listAdapter = new SelectListAdapter(mContext, beanList);
        lvPageSize.setAdapter(listAdapter);
        lvPageSize.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                SelectListAdapter.ItemBean itemBean = (SelectListAdapter.ItemBean) parent.getItemAtPosition(position);
                if (mLastSizeCheckedBean != itemBean) {
                    mLastSizeCheckedBean.isChecked = false;
                }
                itemBean.isChecked = true;
                mLastSizeCheckedBean = itemBean;
                listAdapter.notifyDataSetChanged();
            }
        });
        return lvPageSize;
    }

    private View getDirectionView() {
        ListView lvPageDirection = new ListView(mContext);
        lvPageDirection.setLayoutParams(new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, LinearLayout.LayoutParams.MATCH_PARENT));
        lvPageDirection.setCacheColorHint(mContext.getResources().getColor(R.color.ux_color_translucent));
        lvPageDirection.setDivider(null);
        lvPageDirection.setSelector(new ColorDrawable(mContext.getResources().getColor(R.color.ux_color_translucent)));

        List<SelectListAdapter.ItemBean> beanList = new ArrayList<>();
        beanList.add(new SelectListAdapter.ItemBean(AppResource.getString(mContext, R.string.createpdf_new_ori_partrait), Constants.e_Rotation0, false));
        beanList.add(new SelectListAdapter.ItemBean(AppResource.getString(mContext, R.string.createpdf_new_ori_landspace), Constants.e_Rotation90, false));
        for (SelectListAdapter.ItemBean bean : beanList) {
            if (bean.itemType == getPageBean().getPageDirection()) {
                bean.isChecked = true;
                mLastDirectionCheckedBean = bean;
            } else {
                bean.isChecked = false;
            }
        }

        final SelectListAdapter listAdapter = new SelectListAdapter(mContext, beanList);
        lvPageDirection.setAdapter(listAdapter);
        lvPageDirection.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                SelectListAdapter.ItemBean itemBean = (SelectListAdapter.ItemBean) parent.getItemAtPosition(position);
                if (mLastDirectionCheckedBean != itemBean) {
                    mLastDirectionCheckedBean.isChecked = false;
                }
                itemBean.isChecked = true;
                mLastDirectionCheckedBean = itemBean;
                listAdapter.notifyDataSetChanged();
            }
        });
        return lvPageDirection;
    }

    private int mPageColor;

    private View getColorPicker() {
        mPageColor = getPageBean().getPageColor();

        View view = View.inflate(mContext, R.layout.thumbnail_color_picker_layout, null);
        int width;
        int height;
        if (AppDisplay.isPad()) {
            width = AppDisplay.getDialogWidth() - AppDisplay.dp2px(100);
        } else {
            View rootView = mUIExtensionsManager.getRootView();
            int space = AppResource.getDimensionPixelSize(mContext, R.dimen.ux_margin_16dp);
            width = Math.min(rootView.getWidth(), rootView.getHeight()) - space * 2;
        }
        height = AppResource.getDimensionPixelSize(mContext, R.dimen.ux_color_picker_height);

        RecyclerView colorRecyclerView = view.findViewById(R.id.thumbnail_color_picker_listview);
        LinearLayoutManager linearLayoutManager = new LinearLayoutManager(mContext, LinearLayoutManager.HORIZONTAL, false);
        colorRecyclerView.setLayoutManager(linearLayoutManager);
        colorRecyclerView.setItemAnimator(new DefaultItemAnimator());
        LinearLayout.LayoutParams recyclerParams = (LinearLayout.LayoutParams) colorRecyclerView.getLayoutParams();
        recyclerParams.width = width;
        colorRecyclerView.setLayoutParams(recyclerParams);
        int space = (width
                - AppDisplay.dp2px(32 * 8)) / (8 * 2);
        colorRecyclerView.addItemDecoration(new PageColorItemDecoration(space));
        final PageColorAdapter colorAdapter = new PageColorAdapter(mContext);
        colorAdapter.initData();
        colorAdapter.setColor(mPageColor);
        colorAdapter.setItemClickListener(new PageColorAdapter.OnPageColorItemClickListener() {
            @Override
            public void onItemClick(int type, int color) {
                mPageColor = color;
            }
        });
        colorRecyclerView.setAdapter(colorAdapter);

        ColorPicker colorPicker = view.findViewById(R.id.thumbnail_color_picker_view);
        LinearLayout.LayoutParams colorParams = (LinearLayout.LayoutParams) colorPicker.getLayoutParams();
        colorParams.width = width;
        colorParams.height = height;
        colorPicker.setWidth(width);
        colorPicker.setHeight(height);
        colorPicker.setLayoutParams(colorParams);
        colorPicker.setColor(getPageBean().getPageColor());
        colorPicker.setOnColorChangedListener(new ColorPicker.OnColorChangedListener() {
            @Override
            public void onColorChanged(int color) {
                mPageColor = color;
                colorAdapter.setColor(color);
            }
        });
        return view;
    }

    //remove bitmap from cache.
    private final PDFViewCtrl.IPageEventListener mPageEventListener = new PageEventListener() {
        @Override
        public void onPagesRemoved(boolean success, int[] pageIndexes) {
            if (!success) {
                showTips(AppResource.getString(mContext, R.string.rv_page_remove_error));
                return;
            }

            int curPageIndex = mPDFView.getCurrentPage();
            for (final ThumbnailFragment fragment : mContentFragments) {
                ThumbnailAdapter adapter = fragment.getAdapter();
                List<ThumbnailItem> items = adapter.mThumbnailList;
                SparseArray<ThumbnailItem> selectedItems = adapter.mSelectedArray;
                selectedItems.clear();

                int thumbSize = 0;
                int tabPosition = fragment.getTabPosition();
                switch (tabPosition) {
                    case ALL_TAB_POSITION:
                        for (int i = 0; i < pageIndexes.length; i++) {
                            int position = pageIndexes[i] - i;
                            ThumbnailItem item = items.get(position);
                            adapter.updateCacheListInfo(item, false);
                            items.remove(item);
                        }

                        thumbSize = items.size();
                        adapter.mCurrentPage = Math.min(adapter.mCurrentPage, thumbSize - 1);
                        curPageIndex = adapter.mCurrentPage;
                        for (int i = 0; i < thumbSize; i++) {
                            ThumbnailItem item = items.get(i);
                            item.setPageIndex(i);
                            if (i == curPageIndex)
                                adapter.mCurPagePosition = i;
                            if (item.isSelected())
                                selectedItems.put(i, item);
                        }
                        break;
                    case ANNOTTATED_TAB_POSITION:
                    case BOOKMARKED_TAB_POSITION:
                        for (int i = 0; i < pageIndexes.length; i++) {
                            int pageIndex = pageIndexes[i] - i;
                            List<ThumbnailItem> invalidList = new ArrayList<>();
                            thumbSize = items.size();
                            for (int j = 0; j < thumbSize; j++) {
                                ThumbnailItem item = items.get(j);
                                if (item.getPageIndex() == pageIndex) {
                                    adapter.updateCacheListInfo(item, false);
                                    invalidList.add(item);
                                } else if (item.getPageIndex() > pageIndex) {
                                    item.setPageIndex(item.getPageIndex() - 1);
                                }
                            }

                            for (ThumbnailItem item : invalidList) {
                                items.remove(item);
                            }
                            invalidList.clear();
                        }

                        thumbSize = items.size();
                        adapter.mCurrentPage = curPageIndex;
                        for (int j = 0; j < thumbSize; j++) {
                            ThumbnailItem item = items.get(j);
                            if (item.getPageIndex() == curPageIndex)
                                adapter.mCurPagePosition = j;
                            if (item.isSelected())
                                selectedItems.put(j, item);
                        }
                        break;
                    default:
                        break;
                }

                mAttachActivity.runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        fragment.updateUIState();
                        fragment.notifyDataSetChanged();
                    }
                });
            }
            mbNeedRelayout = true;
            updateTopLayout(mCurrentFragment.getAdapter().isSelectedAll());
        }

        @Override
        public void onPageMoved(boolean success, int index, int dstIndex) {
            if (success) {
                for (ThumbnailFragment fragment : mContentFragments) {
                    if (mCurrentFragment != fragment) {
                        ThumbnailAdapter adapter = fragment.getAdapter();
                        List<ThumbnailItem> items = adapter.mThumbnailList;
                        SparseArray<ThumbnailItem> selectedItems = adapter.mSelectedArray;
                        selectedItems.clear();

                        int thumbSize = items.size();
                        int tabPosition = fragment.getTabPosition();
                        switch (tabPosition) {
                            case ALL_TAB_POSITION:
                                if (mCurrentFragment != fragment) {
                                    adapter.swapData(index, dstIndex);
                                }
                                for (int i = 0; i < thumbSize; i++) {
                                    ThumbnailItem item = items.get(i);
                                    item.setPageIndex(i);
                                    if (item.isSelected())
                                        selectedItems.put(i, item);
                                }
                                break;
                            case ANNOTTATED_TAB_POSITION:
                            case BOOKMARKED_TAB_POSITION:
                                for (int i = 0; i < thumbSize; i++) {
                                    ThumbnailItem item = items.get(i);
                                    if (index < dstIndex) {
                                        if (item.getPageIndex() <= dstIndex && item.getPageIndex() > index) {
                                            item.setPageIndex(item.getPageIndex() - 1);
                                        } else if (item.getPageIndex() == index) {
                                            item.setPageIndex(dstIndex);
                                        }
                                    } else {
                                        if (item.getPageIndex() >= dstIndex && item.getPageIndex() < index) {
                                            item.setPageIndex(item.getPageIndex() + 1);
                                        } else if (item.getPageIndex() == index) {
                                            item.setPageIndex(dstIndex);
                                        }
                                    }
                                }
                                Collections.sort(items);
                                for (int i = 0; i < thumbSize; i++) {
                                    ThumbnailItem item = items.get(i);
                                    if (item.isSelected())
                                        selectedItems.put(i, item);
                                }
                                break;
                            default:
                                break;
                        }
                    }
                }
                mbNeedRelayout = true;
            }
        }

        @Override
        public void onPagesRotated(boolean success, int[] pageIndexes, int rotation) {
            if (!success) {
                showTips(AppResource.getString(mContext, R.string.rv_page_rotate_error));
                return;
            }

            for (ThumbnailFragment fragment : mContentFragments) {
                ThumbnailAdapter adapter = fragment.getAdapter();
                List<ThumbnailItem> items = adapter.mThumbnailList;

                int tabPosition = fragment.getTabPosition();
                switch (tabPosition) {
                    case ALL_TAB_POSITION:
                        for (int pageIndex : pageIndexes) {
                            ThumbnailItem item = items.get(pageIndex);
                            if (mCurrentFragment != fragment)
                                item.setNeedCompute(true);
                            adapter.updateCacheListInfo(item, false);
                        }
                        break;
                    case ANNOTTATED_TAB_POSITION:
                    case BOOKMARKED_TAB_POSITION:
                        int size = items.size();
                        for (int pageIndex : pageIndexes) {
                            for (int i = 0; i < size; i++) {
                                ThumbnailItem item = items.get(i);
                                if (item.getPageIndex() == pageIndex) {
                                    if (mCurrentFragment != fragment)
                                        item.setNeedCompute(true);
                                    adapter.updateCacheListInfo(item, false);
                                }
                            }
                        }
                        break;
                    default:
                        break;
                }

                if (fragment != mCurrentFragment)
                    fragment.notifyDataSetChanged();
            }
            mbNeedRelayout = true;
        }

        @Override
        public void onPagesInserted(boolean success, int dstIndex, int[] range) {
            if (!success) {
                showTips(AppResource.getString(mContext, R.string.rv_page_import_error));
                return;
            }

            int tempPageIndex = dstIndex;
            List<ThumbnailItem> insertItems = new ArrayList<>();
            List<ThumbnailItem> insertAnnotatedItems = new ArrayList<>();
            try {
                if (range.length == 2 && range[range.length - 1] > 1) {
                    for (int i = 0; i < range.length / 2; i++) {
                        for (int index = range[2 * i]; index < range[2 * i + 1]; index++) {
                            ThumbnailItem item = new ThumbnailItem(tempPageIndex, getThumbnailBackgroundSize(), mPDFView);
                            Point size = item.getSize();
                            if (size.x == 0 || size.y == 0) continue;
                            insertItems.add(item);

                            PDFPage page = mPDFView.getDoc().getPage(tempPageIndex);
                            if (page == null || page.isEmpty()) continue;
                            if (page.getAnnotCount() > 0) {
                                ThumbnailItem annotatedItem = new ThumbnailItem(tempPageIndex, getThumbnailBackgroundSize(), mPDFView);
                                Point size1 = annotatedItem.getSize();
                                if (size1.x == 0 || size1.y == 0) continue;
                                insertAnnotatedItems.add(annotatedItem);
                            }
                            tempPageIndex++;
                        }
                    }
                } else {
                    for (int i = 0; i < range.length / 2; i++) {
                        ThumbnailItem item = new ThumbnailItem(tempPageIndex, getThumbnailBackgroundSize(), mPDFView);
                        Point size = item.getSize();
                        if (size.x == 0 || size.y == 0) continue;
                        insertItems.add(item);

                        PDFPage page = mPDFView.getDoc().getPage(tempPageIndex);
                        if (page == null || page.isEmpty()) continue;
                        if (page.getAnnotCount() > 0) {
                            ThumbnailItem annotatedItem = new ThumbnailItem(tempPageIndex, getThumbnailBackgroundSize(), mPDFView);
                            Point size1 = annotatedItem.getSize();
                            if (size1.x == 0 || size1.y == 0) continue;
                            insertAnnotatedItems.add(annotatedItem);
                        }
                        tempPageIndex++;
                    }
                }
            } catch (PDFException e) {
                e.printStackTrace();
            }

            int offsetIndex = 0;
            for (int i = 0; i < range.length / 2; i++) {
                offsetIndex += range[2 * i + 1];
            }
            for (final ThumbnailFragment fragment : mContentFragments) {
                ThumbnailAdapter adapter = fragment.getAdapter();
                List<ThumbnailItem> items = adapter.mThumbnailList;
                SparseArray<ThumbnailItem> selectedItems;

                int thumbSize = items.size();
                int tabPosition = fragment.getTabPosition();
                switch (tabPosition) {
                    case ALL_TAB_POSITION:
                        selectedItems = adapter.mSelectedArray;
                        selectedItems.clear();
                        for (int i = 0; i < thumbSize; i++) {
                            ThumbnailItem item = items.get(i);
                            if (item.getPageIndex() >= dstIndex) {
                                int pageIndex = item.getPageIndex() + offsetIndex;
                                item.setPageIndex(pageIndex);
                                if (item.isSelected())
                                    selectedItems.put(pageIndex, item);
                            } else {
                                if (item.isSelected())
                                    selectedItems.put(item.getPageIndex(), item);
                            }
                        }

                        items.addAll(dstIndex, insertItems);
                        break;
                    case ANNOTTATED_TAB_POSITION:
                        for (int i = 0; i < thumbSize; i++) {
                            ThumbnailItem item = items.get(i);
                            if (item.getPageIndex() >= dstIndex) {
                                item.setPageIndex(item.getPageIndex() + offsetIndex);
                            }
                        }
                        items.addAll(insertAnnotatedItems);

                        Collections.sort(items);
                        selectedItems = adapter.mSelectedArray;
                        selectedItems.clear();
                        for (int i = 0; i < thumbSize; i++) {
                            ThumbnailItem item = items.get(i);
                            if (item.isSelected())
                                selectedItems.put(i, item);
                        }
                        break;
                    case BOOKMARKED_TAB_POSITION:
                        for (int i = 0; i < thumbSize; i++) {
                            ThumbnailItem item = items.get(i);
                            if (item.getPageIndex() >= dstIndex) {
                                item.setPageIndex(item.getPageIndex() + offsetIndex);
                            }
                        }
                        break;
                    default:
                        break;
                }
                if (fragment != mCurrentFragment) {
                    mAttachActivity.runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            fragment.updateUIState();
                            fragment.notifyDataSetChanged();
                        }
                    });
                }
            }

            mbNeedRelayout = true;
            insertItems.clear();
            insertAnnotatedItems.clear();
        }

        private void showTips(final String tips) {
            mAttachActivity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    UIToast.getInstance(mContext).show(tips, Toast.LENGTH_LONG);
                }
            });
        }
    };

    private void updateTopLayout(final boolean selectedAll) {
        mAttachActivity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                setSelectViewMode(selectedAll);
            }
        });
    }

    public void refreshOtherTab() {
        mAttachActivity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                for (ThumbnailFragment fragment : mContentFragments) {
                    if (fragment != mCurrentFragment)
                        fragment.getAdapter().notifyDataSetChanged();
                }
            }
        });
    }

    @Override
    public boolean isSelectMode() {
        return false;
    }

    public void updateRecycleLayout() {
        if (mbNeedRelayout) {
            mPDFView.updatePagesLayout();
        }
    }

    private View initView(LayoutInflater inflater, ViewGroup container) {
        mDialogView = inflater.inflate(R.layout.rd_thumnail_dialog, container, false);

        RelativeLayout dialogTitle = mDialogView.findViewById(R.id.rd_viewmode_dialog_title_bar);
        mToolBar = mDialogView.findViewById(R.id.rd_viewmode_dialog_tool_bar);
        initViewPager(mDialogView);
        initTitleBar(dialogTitle);
        initToolBar(mToolBar);
        initTabView(mDialogView);
        initThumbnailDialog();
        return mDialogView;
    }

    private void initTitleBar(RelativeLayout dialogTitle) {
        mThumbnailTopBar = new TopBarImpl(mContext);
        mThumbnailTopBar.setStartMargin(AppResource.getDimensionPixelSize(mContext, R.dimen.ux_margin_16dp));
        mThumbnailTopBar.setEndMargin(AppResource.getDimensionPixelSize(mContext, R.dimen.ux_margin_16dp));
        mThumbnailTopBar.setMiddleButtonCenter(true);
        mThumbnailTopBar.setShowSolidLine(false);

        changeEditState(false);
        dialogTitle.removeAllViews();
        dialogTitle.addView(mThumbnailTopBar.getContentView());
    }

    private void initToolBar(RelativeLayout toolbar) {
        mThumbnailToolbar = new TopBarImpl(mContext);
        mThumbnailToolbar.setStartMargin(AppResource.getDimensionPixelSize(mContext, R.dimen.ux_margin_4dp));
        mThumbnailToolbar.setEndMargin(AppResource.getDimensionPixelSize(mContext, R.dimen.ux_margin_4dp));
        mThumbnailToolbar.setItemInterval(AppResource.getDimensionPixelSize(mContext, R.dimen.ux_margin_8dp));
        mThumbnailToolbar.setAutoCompressItemsInterval(true);

        mAddItem = new BaseItemImpl(mContext, R.drawable.thumbnail_add_page);
        mAddItem.setImageTintList(ThemeUtil.getPrimaryIconColor(mContext));
        mAddItem.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (AppUtil.isFastDoubleClick()) return;

                MenuViewManager.OnItemClickListener customCallback = mMenuViewManager.getActionCallback(MenuViewManager.POSITION_THUMBNAIL_ADD);
                if (customCallback != null && customCallback.onClick(v)) {
                    return;
                }
                showAddPageMenu();
            }
        });
        mRotateLeftItem = new BaseItemImpl(mContext, R.drawable.thumbnail_rotate_left);
        mRotateLeftItem.setImageTintList(ThemeUtil.getPrimaryIconColor(mContext));
        mRotateLeftItem.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                mCurrentFragment.getAdapter().rotateSelectedPages(false);
            }
        });
        mRotateRightItem = new BaseItemImpl(mContext, R.drawable.thumbnail_rotate_right);
        mRotateRightItem.setImageTintList(ThemeUtil.getPrimaryIconColor(mContext));
        mRotateRightItem.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                mCurrentFragment.getAdapter().rotateSelectedPages(true);
            }
        });
        mExtractItem = new BaseItemImpl(mContext, R.drawable.thumbnail_extract_page);
        mExtractItem.setImageTintList(ThemeUtil.getPrimaryIconColor(mContext));
        mExtractItem.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (AppUtil.isFastDoubleClick()) return;

                MenuViewManager.OnItemClickListener customCallback = mMenuViewManager.getActionCallback(MenuViewManager.POSITION_THUMBNAIL_EXTRACT);
                if (customCallback != null && customCallback.onClick(v)) {
                    return;
                }

                IActionMenuPresenter actionView = mMenuViewManager.getActionView(MenuViewManager.POSITION_THUMBNAIL_EXTRACT);
                if (actionView != null) {
                    UIMenuViewBuilder builder = actionView.getViewBuilder();
                    builder.addCloseViewCallback(new UIMenuViewBuilder.ICloseViewCallback() {
                        @Override
                        public void onClosed() {
                            if (mExtractPageDialog != null || mExtractPageDialog.isShowing())
                                mExtractPageDialog.dismiss();
                        }
                    });

                    mExtractPageDialog = new UIMatchDialog(mAttachActivity);
                    mExtractPageDialog.setContentView(builder.getContentView());
                    mExtractPageDialog.setTitleBarVisiable(false);
                    mExtractPageDialog.setBackgroundColor(ThemeConfig.getInstance(mContext).getB2());
                    mExtractPageDialog.setStyle(MatchDialog.DLG_TITLE_STYLE_BG_DEFAULT);
                    mExtractPageDialog.showDialog();
                } else {
                    mCurrentFragment.getAdapter().extractPages(null);
                }
            }
        });
        mCopyItem = new BaseItemImpl(mContext, R.drawable.thumbnail_copy_page);
        mCopyItem.setImageTintList(ThemeUtil.getPrimaryIconColor(mContext));
        mCopyItem.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (AppUtil.isFastDoubleClick()) return;

                mCurrentFragment.setCanPaste(true);
                mCopyItem.setEnable(false);
                mPasteItem.setEnable(true);
                mCurrentFragment.getAdapter().copyPages(new Event.Callback() {
                    @Override
                    public void result(Event event, boolean success) {
                        mCurrentFragment.setPageCopied(true);
                    }
                });
            }
        });
        mPasteItem = new BaseItemImpl(mContext, R.drawable.thumbnail_paste_page);
        mPasteItem.setImageTintList(ThemeUtil.getPrimaryIconColor(mContext));
        mPasteItem.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (AppUtil.isFastDoubleClick()) return;
                switchPasteState(true);
            }
        });
        mPasteItem.setEnable(false);
        mDeleteItem = new BaseItemImpl(mContext, R.drawable.thumbnail_delete_page);
        mDeleteItem.setImageTintList(ThemeUtil.getPrimaryIconColor(mContext));
        mDeleteItem.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (AppUtil.isFastDoubleClick()) return;
                showTipsDlg(mCurrentFragment.getAdapter().getSelectedItemCount() == mAllItems.size() ? REMOVE_ALL_PAGES_TIP : REMOVE_SOME_PAGES_TIP);
            }
        });
        mShareItem = new BaseItemImpl(mContext, R.drawable.thumbnail_share);
        mShareItem.setImageTintList(ThemeUtil.getPrimaryIconColor(mContext));
        mShareItem.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if (AppUtil.isFastDoubleClick()) return;
                mCurrentFragment.getAdapter().sharePages();
            }
        });
        mShareItem.getContentView().setVisibility(mShareItemVisible ? View.VISIBLE : View.GONE);

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q) {
            mAddItem.setForceDarkAllowed(false);
            mRotateLeftItem.setForceDarkAllowed(false);
            mRotateRightItem.setForceDarkAllowed(false);
            mExtractItem.setForceDarkAllowed(false);
            mCopyItem.setForceDarkAllowed(false);
            mPasteItem.setForceDarkAllowed(false);
            mDeleteItem.setForceDarkAllowed(false);
            mShareItem.setForceDarkAllowed(false);
        }
        mThumbnailToolbar.addView(mAddItem, BaseBar.TB_Position.Position_CENTER);
        mThumbnailToolbar.addView(mRotateLeftItem, BaseBar.TB_Position.Position_CENTER);
        mThumbnailToolbar.addView(mRotateRightItem, BaseBar.TB_Position.Position_CENTER);
        mThumbnailToolbar.addView(mExtractItem, BaseBar.TB_Position.Position_CENTER);
        mThumbnailToolbar.addView(mCopyItem, BaseBar.TB_Position.Position_CENTER);
        mThumbnailToolbar.addView(mPasteItem, BaseBar.TB_Position.Position_CENTER);
        mThumbnailToolbar.addView(mDeleteItem, BaseBar.TB_Position.Position_CENTER);
        mThumbnailToolbar.addView(mShareItem, BaseBar.TB_Position.Position_CENTER);

        toolbar.removeAllViews();
        toolbar.addView(mThumbnailToolbar.getContentView());
        toolbar.setVisibility(View.GONE);

        mAddItem.setId(R.id.id_at_ppo_toolbar_add);
        mRotateLeftItem.setId(R.id.id_at_ppo_toolbar_rotatel);
        mRotateRightItem.setId(R.id.id_at_ppo_toolbar_rotater);
        mExtractItem.setId(R.id.id_at_ppo_toolbar_extract);
        mCopyItem.setId(R.id.id_at_ppo_toolbar_copy);
        mPasteItem.setId(R.id.id_at_ppo_toolbar_paste);
        mDeleteItem.setId(R.id.id_at_ppo_toolbar_delete);
        mShareItem.setId(R.id.id_at_ppo_toolbar_share);
    }

    public void switchPasteState(boolean isPasteState) {
        mbPasteState = isPasteState;
        if (isPasteState) {
            annotatedTab.setEnabled(false);
            bookmarkedTab.setEnabled(false);

            mAddItem.setEnable(false);
            mRotateLeftItem.setEnable(false);
            mRotateRightItem.setEnable(false);
            mExtractItem.setEnable(false);
            mCopyItem.setEnable(false);
            mPasteItem.setEnable(false);
            mDeleteItem.setEnable(false);
            mSelectAllItem.setEnable(false);
            mShareItem.setEnable(false);

            mCurrentFragment.showPasteItem();
        } else {
            annotatedTab.setEnabled(true);
            bookmarkedTab.setEnabled(true);

            mRotateLeftItem.setEnable(true);
            mRotateRightItem.setEnable(true);
            mCopyItem.setEnable(true);
            mPasteItem.setEnable(true);
            mDeleteItem.setEnable(true);
            mExtractItem.setEnable(mUIExtensionsManager.getDocumentManager().canCopy());
            mAddItem.setEnable(mCurrentFragment.getTabPosition() == ALL_TAB_POSITION);
            mSelectAllItem.setEnable(mCurrentFragment.getAdapter().getItemCount() > 0);
            mShareItem.setEnable(mUIExtensionsManager.getDocumentManager().canCopy());

            mCurrentFragment.removePasteItem();
        }
    }

    private void initTabView(View contentView) {
        allTab = contentView.findViewById(R.id.thumbnail_all_tab);
        allTab.setText(AppResource.getString(mContext, R.string.thumbnail_tab_all));
        TextViewCompat.setAutoSizeTextTypeUniformWithConfiguration(allTab, 8, 14, 2, TypedValue.COMPLEX_UNIT_SP);
        annotatedTab = contentView.findViewById(R.id.thumbnail_annotated_tab);
        annotatedTab.setText(AppResource.getString(mContext, R.string.thumbnail_tab_Annotated));
        TextViewCompat.setAutoSizeTextTypeUniformWithConfiguration(annotatedTab, 8, 14, 2, TypedValue.COMPLEX_UNIT_SP);
        bookmarkedTab = contentView.findViewById(R.id.thumbnail_bookmarked_tab);
        bookmarkedTab.setText(AppResource.getString(mContext, R.string.thumbnail_tab_Bookmarked));
        TextViewCompat.setAutoSizeTextTypeUniformWithConfiguration(bookmarkedTab, 8, 14, 2, TypedValue.COMPLEX_UNIT_SP);

        allTab.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (allTab.isSelected()) return;

                mbManualSelected = true;
                allTab.setSelected(true);
                annotatedTab.setSelected(false);
                bookmarkedTab.setSelected(false);
                mContentViewPager.setCurrentItem(0, false);
            }
        });

        annotatedTab.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (annotatedTab.isSelected()) return;

                mbManualSelected = true;
                allTab.setSelected(false);
                annotatedTab.setSelected(true);
                bookmarkedTab.setSelected(false);
                mContentViewPager.setCurrentItem(1, false);
            }
        });

        bookmarkedTab.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (bookmarkedTab.isSelected()) return;

                mbManualSelected = true;
                allTab.setSelected(false);
                annotatedTab.setSelected(false);
                bookmarkedTab.setSelected(true);
                mContentViewPager.setCurrentItem(2, false);
            }
        });

        ThemeUtil.setBackgroundTintList(allTab, ThemeUtil.getTabTintList(mContext));
        ThemeUtil.setBackgroundTintList(annotatedTab, ThemeUtil.getTabTintList(mContext));
        ThemeUtil.setBackgroundTintList(bookmarkedTab, ThemeUtil.getTabTintList(mContext));

        if (mCurrentTab == 0) {
            allTab.setSelected(true);
            annotatedTab.setSelected(false);
            bookmarkedTab.setSelected(false);
        } else if (mCurrentTab == 1) {
            allTab.setSelected(false);
            annotatedTab.setSelected(true);
            bookmarkedTab.setSelected(false);
        } else {
            allTab.setSelected(false);
            annotatedTab.setSelected(false);
            bookmarkedTab.setSelected(true);
        }
    }

    private void initViewPager(View contentView) {
        mbManualSelected = false;

        mAllItems = new ArrayList<>();
        mAnnotatedItems = new ArrayList<>();
        mBookmarkedItems = new ArrayList<>();
        mContentFragments = new ArrayList<>();

        mContentViewPager = contentView.findViewById(R.id.thumbnail_content_viewpager);
        mContentViewPager.setScrollable(false);
        mContentViewPager.setOffscreenPageLimit(3);

        int all_curPagePostion = -1;
        int annotated_curPagePostion = -1;
        int bookmarked_curPagePostion = -1;
        try {
            final int pageCount = mPDFView.getPageCount();
            Point backgroundSize = getThumbnailBackgroundSize();
            PDFDoc doc = mPDFView.getDoc();

            List<Integer> bookmarkPageIndexs = new ArrayList<>();

            //Module bmModule = mUIExtensionsManager.getModuleByName(Module.MODULE_NAME_BOOKMARK);
            //if (bmModule != null) {
            int readingBookmarkCount = doc.getReadingBookmarkCount();
            for (int i = 0; i < readingBookmarkCount; i++) {
                ReadingBookmark bookmark = doc.getReadingBookmark(i);
                if (bookmark != null && !bookmark.isEmpty()) {
                    int pageIndex = bookmark.getPageIndex();
                    bookmarkPageIndexs.add(pageIndex);
                    ThumbnailItem thumbnailItem = new ThumbnailItem(pageIndex, backgroundSize, mPDFView);
                    thumbnailItem.setReadingBookmark(true);
                    mBookmarkedItems.add(thumbnailItem);

                    if (pageIndex == mPDFView.getCurrentPage())
                        bookmarked_curPagePostion = mBookmarkedItems.size() - 1;
                }
            }
            Collections.sort(mBookmarkedItems);
            //}

            if (pageCount > MAX_LOADING_PAGE_NUMBER) {
                for (int i = 0; i < pageCount; i++) {
                    ThumbnailItem allItem = new ThumbnailItem(i, backgroundSize, mPDFView);
                    if (bookmarkPageIndexs.size() > 0 && bookmarkPageIndexs.contains(i)) {
                        allItem.setReadingBookmark(true);
                    }
                    mAllItems.add(allItem);
                }

                mIsLoadingAnnotsAtThread = true;
                mDisposable = getAnnotList(bookmarkPageIndexs, new OnProgressCallback() {
                    @Override
                    public void onProgress(final int progress) {
                        AppThreadManager.getInstance().getMainThreadHandler().post(new Runnable() {
                            @Override
                            public void run() {
                                if (mAnnotatedFragment != null) {
                                    mAnnotatedFragment.setLoadingState(false);
                                    mAnnotatedFragment.setLoadingText(progress, pageCount);
                                }
                            }
                        });
                    }
                }).subscribeOn(Schedulers.io())
                        .observeOn(AndroidSchedulers.mainThread())
                        .subscribe(new Consumer<List<ThumbnailItem>>() {
                            @Override
                            public void accept(List<ThumbnailItem> annotList) throws Exception {
                                mIsLoadingAnnotsAtThread = false;
                                mAnnotatedItems.addAll(annotList);

                                int currentPagePosition = -1;
                                for (int i = 0; i < annotList.size(); i++) {
                                    ThumbnailItem item = annotList.get(i);
                                    if (item.getPageIndex() == mPDFView.getCurrentPage()) {
                                        currentPagePosition = i;
                                    }
                                }
                                if (mAnnotatedFragment != null) {
                                    mAnnotatedFragment.setLoadingState(false);
                                    mAnnotatedFragment.updateData(currentPagePosition, mAnnotatedItems);
                                }
                            }
                        }, new Consumer<Throwable>() {
                            @Override
                            public void accept(Throwable throwable) throws Exception {
                                mIsLoadingAnnotsAtThread = false;
                                if (mAnnotatedFragment != null) {
                                    mAnnotatedFragment.setLoadingState(false);
                                    mAnnotatedFragment.updateData(-1, mAnnotatedItems);
                                }
                            }
                        });

                if (mCompositeDisposable == null)
                    mCompositeDisposable = new CompositeDisposable();
                mCompositeDisposable.add(mDisposable);
            } else {
                mIsLoadingAnnotsAtThread = false;

                for (int i = 0; i < pageCount; i++) {
                    PDFPage page;
                    int pageIndex;
                    try {
                        page = doc.getPage(i);
                        pageIndex = page.getIndex();
                        ThumbnailItem allItem = new ThumbnailItem(pageIndex, backgroundSize, mPDFView);

                        boolean isBookmarked = bookmarkPageIndexs.contains(pageIndex);
                        allItem.setReadingBookmark(isBookmarked);
                        mAllItems.add(allItem);

                        if (page.getAnnotCount() > 0) {
                            ThumbnailItem annotatedItem = new ThumbnailItem(pageIndex, backgroundSize, mPDFView);
                            annotatedItem.setReadingBookmark(isBookmarked);
                            mAnnotatedItems.add(annotatedItem);
                            if (pageIndex == mPDFView.getCurrentPage())
                                annotated_curPagePostion = mAnnotatedItems.size() - 1;
                        }
                    }catch (PDFException e){
                        ThumbnailItem allItem = new ThumbnailItem(true, i, backgroundSize, mPDFView);
                        mAllItems.add(allItem);
                    }
                }
            }
        } catch (PDFException ignored) {
        }

        ThumbnailFragment allFragment = ThumbnailFragment.newInstance(ALL_TAB_POSITION, mPDFView.getCurrentPage(),
                this, mPDFView, mAllItems);
        mAnnotatedFragment = ThumbnailFragment.newInstance(ANNOTTATED_TAB_POSITION, annotated_curPagePostion,
                this, mPDFView, mAnnotatedItems);
        final ThumbnailFragment bookmarkedFragment = ThumbnailFragment.newInstance(BOOKMARKED_TAB_POSITION, bookmarked_curPagePostion,
                this, mPDFView, mBookmarkedItems);
        mContentFragments.add(allFragment);
        mAnnotatedFragment.setLoadingState(mIsLoadingAnnotsAtThread);
        mContentFragments.add(mAnnotatedFragment);
        mContentFragments.add(bookmarkedFragment);
        mCurrentFragment = allFragment;

        ThumbContentPagerAdapter adapter = new ThumbContentPagerAdapter(getChildFragmentManager(), mContentFragments);
        mContentViewPager.setAdapter(adapter);
        mContentViewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener() {
            @Override
            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            @Override
            public void onPageSelected(int position) {
                if (!mbManualSelected) {
                    allTab.performClick();
                } else {
                    mCurrentTab = position;
                    mCurrentFragment = mContentFragments.get(position);
                    if (ANNOTTATED_TAB_POSITION == mCurrentTab) {
                        mAnnotatedFragment.setMoveTo();

                    } else if (BOOKMARKED_TAB_POSITION == mCurrentTab) {
                        bookmarkedFragment.setMoveTo();
                    }

                    if (mbEditMode)
                        setSelectViewMode(mCurrentFragment.getAdapter().isSelectedAll());
                }
            }

            @Override
            public void onPageScrollStateChanged(int state) {
            }
        });
    }

    private Single<List<ThumbnailItem>> getAnnotList(final List<Integer> bookmarkIndexs, final OnProgressCallback progressCallback) {
        return Single.fromCallable(new Callable<List<ThumbnailItem>>() {
            @Override
            public List<ThumbnailItem> call() throws Exception {
                int pageCount = mPDFView.getPageCount();
                PDFDoc doc = mPDFView.getDoc();
                Point backgroundSize = getThumbnailBackgroundSize();

                List<ThumbnailItem> annotList = new ArrayList<>();
                for (int i = 0; i < pageCount; i++) {
                    if (mDisposable == null || mDisposable.isDisposed()) break;
                    PDFPage page;
                    int pageIndex;
                    try {
                        page = doc.getPage(i);
                        pageIndex = page.getIndex();
                        if (page.getAnnotCount() > 0) {
                            ThumbnailItem annotatedItem = new ThumbnailItem(pageIndex, backgroundSize, mPDFView);
                            annotatedItem.setReadingBookmark(bookmarkIndexs.contains(pageIndex));
                            annotList.add(annotatedItem);
                        }
                    } catch (PDFException e) {
                        continue;
                    }
                    if (progressCallback != null) {
                        progressCallback.onProgress(i);
                    }
                }
                return annotList;
            }
        });
    }

    private static class ThumbContentPagerAdapter extends BaseFragPagerAdapter<ThumbnailFragment> {
        public ThumbContentPagerAdapter(FragmentManager fm, List<ThumbnailFragment> fragments) {
            super(fm, fragments);
        }
    }

    private void initThumbnailDialog() {
        if (this.getDialog() != null) {
            this.getDialog().setOnKeyListener(new DialogInterface.OnKeyListener() {
                @Override
                public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                    if (event.getAction() == KeyEvent.ACTION_UP) {
                        if (keyCode == KeyEvent.KEYCODE_BACK) {
                            if (mbEditMode) {
                                changeEditState(false);
                            } else {
                                exitThumbnailDialog();

                                updateRecycleLayout();
                                PageNavigationModule module = (PageNavigationModule) mUIExtensionsManager.getModuleByName(Module.MODULE_NAME_PAGENAV);
                                if (module != null)
                                    module.resetJumpView();
                            }
                        }
                        return true;
                    }
                    return false;
                }

            });
        }
    }

    public void setSelectViewMode(boolean selectedAll) {
        if (isPasteState()) {
            mAddItem.setEnable(false);
            mRotateLeftItem.setEnable(false);
            mRotateRightItem.setEnable(false);
            mExtractItem.setEnable(false);
            mPasteItem.setEnable(false);
            mCopyItem.setEnable(false);
            mDeleteItem.setEnable(false);
            mShareItem.setEnable(false);
        } else {
            if (mCurrentFragment.getAdapter().getSelectedItemCount() == 0 || (mPDFView.isDynamicXFA())) {
                mRotateLeftItem.setEnable(false);
                mRotateRightItem.setEnable(false);
                mDeleteItem.setEnable(false);
                mExtractItem.setEnable(false);
                mCopyItem.setEnable(false);
                mShareItem.setEnable(false);
            } else {
                mRotateLeftItem.setEnable(true);
                mRotateRightItem.setEnable(true);
                mDeleteItem.setEnable(true);
                mExtractItem.setEnable(mUIExtensionsManager.getDocumentManager().canCopy());
                mCopyItem.setEnable(mCurrentFragment.getTabPosition() != BOOKMARKED_TAB_POSITION);
                //mCopyItem.setEnable(mCurrentFragment.getTabPosition() != BOOKMARKED_TAB_POSITION && !mCurrentFragment.isPageCopied());
                mShareItem.setEnable(mUIExtensionsManager.getDocumentManager().canCopy());
            }
            mPasteItem.setEnable(mCurrentFragment.canPaste() && mCurrentFragment.getTabPosition() != BOOKMARKED_TAB_POSITION);
            mAddItem.setEnable(mCurrentFragment.getTabPosition() == ALL_TAB_POSITION);
        }

        resetSelectAllItem(selectedAll);
        mThumbnailTitle.setText(AppResource.getString(mContext, R.string.fx_selected_count, mCurrentFragment.getAdapter().getSelectedItemCount()));
    }

    private void resetSelectAllItem(boolean selectedAll) {
        if (selectedAll)
            mSelectAllItem.setText(AppResource.getString(mContext, R.string.fx_string_deselect_all));
        else
            mSelectAllItem.setText(AppResource.getString(mContext, R.string.fx_string_select_all));
        mSelectAllItem.setEnable(mCurrentFragment.getAdapter().getItemCount() > 0);
    }

    void changeEditState(boolean isEditMode) {
        boolean canAssemble = mUIExtensionsManager.canAssemble() && mUIExtensionsManager.isEnableModification();
        mbEditMode = isEditMode && canAssemble;
        boolean isXFA = mPDFView.isDynamicXFA();
        if (isXFA) {
            mbEditMode = false;
            UIToast.getInstance(mContext).show(AppResource.getString(mContext, R.string.xfa_not_support_to_edit_toast));
        }
        mThumbnailTopBar.removeAllItems();
        if (mbEditMode) {
            mSelectAllItem = new BaseItemImpl(mContext);
            mSelectAllItem.setText(AppResource.getString(mContext, R.string.fx_string_select_all));
            mSelectAllItem.setTextColor(ThemeUtil.getPrimaryTextColor(mContext));
            mSelectAllItem.setTextSize(TypedValue.COMPLEX_UNIT_PX, AppResource.getDimensionPixelSize(mContext, R.dimen.ux_text_size_15sp));
            mSelectAllItem.setEllipsize(TextUtils.TruncateAt.END);
            mSelectAllItem.setMaxWidth(AppDisplay.getActivityWidth() / 3 - AppDisplay.dp2px(16));
            mSelectAllItem.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    boolean isSelectedAll = !mCurrentFragment.getAdapter().isSelectedAll();
                    mCurrentFragment.getAdapter().selectAll(isSelectedAll);
                    mCurrentFragment.setPageCopied(false);
                    setSelectViewMode(isSelectedAll);
                }
            });
            mThumbnailTopBar.addView(mSelectAllItem, BaseBar.TB_Position.Position_LT);
            if (mCurrentFragment.getAdapter().getItemCount() == 0)
                mSelectAllItem.setEnable(false);

            mThumbnailTitle = new BaseItemImpl(mContext);
            mThumbnailTitle.setTextColorResource(R.color.t4);
            mThumbnailTitle.setTextSize(TypedValue.COMPLEX_UNIT_PX, AppResource.getDimensionPixelSize(mContext, R.dimen.ux_text_size_16sp));
            mThumbnailTitle.setTypeface(Typeface.defaultFromStyle(Typeface.BOLD));
            mThumbnailTopBar.addView(mThumbnailTitle, BaseBar.TB_Position.Position_CENTER);

            mDoneItem = new BaseItemImpl(mContext);
            mDoneItem.setText(AppResource.getString(mContext, R.string.fx_string_done));
            mDoneItem.setTextColor(ThemeUtil.getPrimaryTextColor(mContext));
            mDoneItem.setTextSize(TypedValue.COMPLEX_UNIT_PX, AppResource.getDimensionPixelSize(mContext, R.dimen.ux_text_size_15sp));
            mDoneItem.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    changeEditState(false);
                }
            });
            mThumbnailTopBar.addView(mDoneItem, BaseBar.TB_Position.Position_RB);

            mToolBar.setVisibility(View.VISIBLE);
            setSelectViewMode(mCurrentFragment.getAdapter().isSelectedAll());

            for (ThumbnailFragment fragment : mContentFragments) {
                ThumbnailAdapter adapter = fragment.getAdapter();
                if (adapter != null) {
                    adapter.notifyDataSetChanged();
                }
            }
        } else {
            if (mbPasteState) {
                mbPasteState = false;
                if (annotatedTab != null)
                    annotatedTab.setEnabled(true);
                if (bookmarkedTab != null)
                    bookmarkedTab.setEnabled(true);
            }

            mCloseItem = new BaseItemImpl(mContext);
            mCloseItem.setText(AppResource.getString(mContext, R.string.fx_string_close));
            mCloseItem.setTextColor(ThemeUtil.getPrimaryTextColor(mContext));
            mCloseItem.setTextSize(TypedValue.COMPLEX_UNIT_PX, AppResource.getDimensionPixelSize(mContext, R.dimen.ux_text_size_15sp));
            mCloseItem.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    exitThumbnailDialog();
                    updateRecycleLayout();
                    PageNavigationModule module = (PageNavigationModule) mUIExtensionsManager.getModuleByName(Module.MODULE_NAME_PAGENAV);
                    if (module != null)
                        module.resetJumpView();
                }
            });
            mThumbnailTopBar.addView(mCloseItem, BaseBar.TB_Position.Position_LT);

            mThumbnailTitle = new BaseItemImpl(mContext);
            mThumbnailTitle.setTextColor(AppResource.getColor(mContext, R.color.t4));
            mThumbnailTitle.setTextSize(TypedValue.COMPLEX_UNIT_PX, AppResource.getDimensionPixelSize(mContext, R.dimen.ux_text_size_16sp));
            mThumbnailTitle.setTypeface(Typeface.defaultFromStyle(Typeface.BOLD));
            mThumbnailTitle.setText(AppResource.getString(mContext, R.string.rv_page_present_thumbnail));
            mThumbnailTopBar.addView(mThumbnailTitle, BaseBar.TB_Position.Position_CENTER);

            mToolBar.setVisibility(View.GONE);
            if (canAssemble && !isXFA) {
                mEditItem = new BaseItemImpl(mContext);
                mEditItem.setText(AppResource.getString(mContext, R.string.fx_string_edit));
                mEditItem.setTextColor(ThemeUtil.getPrimaryTextColor(mContext));
                mEditItem.setTextSize(TypedValue.COMPLEX_UNIT_PX, AppResource.getDimensionPixelSize(mContext, R.dimen.ux_text_size_15sp));
                mEditItem.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        if (mUIExtensionsManager.getPermissionProvider() != null) {
                            mUIExtensionsManager.getPermissionProvider().checkPermission(IPermissionProvider.FUNCTION_THUMBNAIL_EDIT,
                                    new IPermissionProvider.IPermissionState() {
                                        @Override
                                        public void onState(int state) {
                                            if (state == IPermissionProvider.PERMISSION_STATE_SHOW) {
                                                changeEditState(true);
                                            }
                                        }
                                    });
                        } else
                            changeEditState(true);
                    }
                });
                mThumbnailTopBar.addView(mEditItem, BaseBar.TB_Position.Position_RB);
            }

            for (ThumbnailFragment fragment : mContentFragments) {
                if (fragment != null) {
                    fragment.reset();
                }
            }
        }
    }

    protected final static int REMOVE_ALL_PAGES_TIP = 0;
    protected final static int REMOVE_SOME_PAGES_TIP = 1;

    void showTipsDlg(int removeType) {
        final UITextEditDialog dialog = new UITextEditDialog(mAttachActivity, UIDialog.NO_INPUT);
        dialog.setTitle(AppResource.getString(mContext, R.string.fx_string_delete));
        switch (removeType) {
            case REMOVE_ALL_PAGES_TIP:
                dialog.getCancelButton().setVisibility(View.GONE);
                dialog.getPromptTextView().setText(AppResource.getString(mContext, R.string.rv_page_delete_all_thumbnail));
                dialog.getOKButton().setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        dialog.dismiss();
                    }
                });
                break;
            case REMOVE_SOME_PAGES_TIP:
                dialog.getPromptTextView().setText(AppResource.getString(mContext, R.string.rv_page_delete_thumbnail));
                dialog.getCancelButton().setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        dialog.dismiss();
                    }
                });
                dialog.getOKButton().setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        mCurrentFragment.getAdapter().removeSelectedPages();
                        dialog.dismiss();
                    }
                });
                break;
            default:
                break;
        }
        dialog.show();
    }

    public void exitThumbnailDialog() {
        if (ThumbnailSupport.this.getDialog() != null) {
            AppDialogManager.getInstance().dismiss(getDialog());
        }
        AppDialogManager.getInstance().dismiss(this);
    }

    public Point getThumbnailBackgroundSize() {
        if (mThumbnailSize == null) {
            mThumbnailSize = AppUtil.getThumbnailBackgroundSize(mPDFView);
        }
        return mThumbnailSize;
    }

    private static class PageColorItemDecoration extends RecyclerView.ItemDecoration {

        private int spacing;

        public PageColorItemDecoration(int spacing) {
            this.spacing = spacing;
        }

        @Override
        public void getItemOffsets(@NonNull Rect outRect, @NonNull View view, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
            outRect.left = spacing;
            outRect.right = spacing;
        }
    }

    private IMenuPresenter mAddMenuViewPresenter = new IMenuPresenter() {
        @Override
        public IMenuView getMenuView() {
            return getAddMenu();
        }
    };

    private IMenuView mAddMenuView;

    private IMenuView getAddMenu() {
        if (mAddMenuView == null) {
            mAddMenuView = new MenuViewImpl(mContext);
            mAddMenuView.setTitleBarVisible(false);
            IMenuGroup addGroup = mAddMenuView.addGroup(AppResource.getString(mContext, R.string.createpdf_add_page_title));
            addGroup.setHeaderTitleColor(AppResource.getColor(mContext, R.color.t2));
            addGroup.setHeaderBackgroundColor(AppResource.getColor(mContext, R.color.b1));

            IMenuItem blankMenu = addGroup.addItem(AppResource.getDrawable(mContext, R.drawable.thumbnail_add_from_blank_page),
                    AppResource.getString(mContext, R.string.add_from_blank_page));
            blankMenu.setOnMenuItemClickListener(new IMenuItem.OnMenuItemClickListener() {
                @Override
                public void onClick(IMenuItem item) {
                    mAddPageMenus.dismiss();
                    mCreatePageDialog = new UIMatchDialog(mAttachActivity);
                    mCreatePageDialog.setContentView(initCreatePageView());
                    mCreatePageDialog.setBackButtonStyle(MatchDialog.TEXT_BACK);
                    mCreatePageDialog.setRightButtonVisible(View.VISIBLE);
                    mCreatePageDialog.setTitle(AppResource.getString(mContext, R.string.createpdf_add_page_title));
                    mCreatePageDialog.setTitlePosition(BaseBar.TB_Position.Position_CENTER);
                    mCreatePageDialog.setStyle(MatchDialog.DLG_TITLE_STYLE_BG_DEFAULT);
                    mCreatePageDialog.setListener(new MatchDialog.DialogListener() {
                        @Override
                        public void onResult(long btType) {
                        }

                        @Override
                        public void onBackClick() {
                        }

                        @Override
                        public void onTitleRightButtonClick() {
                            mCurrentFragment.getAdapter().insertPage(mCurrentFragment.getAdapter().getInsertIndex(),
                                    getPageBean(),
                                    new Event.Callback() {
                                        @Override
                                        public void result(Event event, boolean success) {
                                            if (success)
                                                resetSelectAllItem(mCurrentFragment.getAdapter().isSelectedAll());
                                        }
                                    });
                            mCreatePageDialog.dismiss();
                        }
                    });
                    mCreatePageDialog.showDialog();
                }
            });
            IMenuItem galleryMenu = addGroup.addItem(AppResource.getDrawable(mContext, R.drawable.thumbnail_add_from_image),
                    AppResource.getString(mContext, R.string.add_from_image));
            galleryMenu.setOnMenuItemClickListener(new IMenuItem.OnMenuItemClickListener() {
                @Override
                public void onClick(IMenuItem item) {
                    mAddPageMenus.dismiss();
                    Intent intent = new Intent(Intent.ACTION_PICK);
                    intent.setDataAndType(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, "image/*");
                    startActivityForResult(intent, ActRequestCode.REQ_FILE_FROM_BROWSER);
                }
            });
            IMenuItem cameraMenu = addGroup.addItem(AppResource.getDrawable(mContext, R.drawable.thumbnail_add_from_camera),
                    AppResource.getString(mContext, R.string.add_from_camera));
            cameraMenu.setOnMenuItemClickListener(new IMenuItem.OnMenuItemClickListener() {
                @Override
                public void onClick(IMenuItem item) {
                    mAddPageMenus.dismiss();
                    startCamera();
                }
            });
            IMenuItem importMenu = addGroup.addItem(AppResource.getDrawable(mContext, R.drawable.thumbnail_add_from_import),
                    AppResource.getString(mContext, R.string.add_from_import));
            importMenu.setOnMenuItemClickListener(new IMenuItem.OnMenuItemClickListener() {
                @Override
                public void onClick(IMenuItem item) {
                    mAddPageMenus.dismiss();
                    mAddItem.setClickable(false);
                    mCurrentFragment.getAdapter().importPagesFromSpecialFile(mCurrentFragment.getAdapter().getInsertIndex()
                            , new DialogInterface.OnShowListener() {
                                @Override
                                public void onShow(DialogInterface dialog) {
                                    mAddItem.setClickable(true);
                                }
                            }
                            , new Event.Callback() {
                                @Override
                                public void result(Event event, boolean success) {
                                    if (success)
                                        resetSelectAllItem(mCurrentFragment.getAdapter().isSelectedAll());
                                }
                            });
                }
            });

            mAddMenuView.addClosedListener(new IMenuView.OnClosedListener() {
                @Override
                public void onClosed() {
                    mAddPageMenus.dismiss();
                }
            });
        }


//        IMenuItem videoMenu = addGroup.addItem(AppResource.getDrawable(mContext,  R.drawable.thumbnail_add_from_video),
//                AppResource.getString(mContext, R.string.add_from_video));
//        videoMenu.setOnMenuItemClickListener(new IMenuItem.OnMenuItemClickListener() {
//            @Override
//            public void onClick(IMenuItem item) {
//                mAddPageMenus.dismiss();
//                        startVideo();
//            }
//        });
        return mAddMenuView;
    }


    @Override
    public void onThemeColorChanged(String type, int color) {
        if (mThumbnailTopBar != null) {
            mThumbnailTopBar.setBackgroundColor(ThemeConfig.getInstance(mContext).getB2());
        }
        if (mThumbnailToolbar != null && mThumbnailToolbar instanceof TopBarImpl) {
            mThumbnailTitle.setTextColorResource(R.color.t4);
            mThumbnailToolbar.setBackgroundColor(ThemeConfig.getInstance(mContext).getB2());
            ((TopBarImpl) mThumbnailToolbar).setShowSolidLineColor(AppResource.getColor(mContext, R.color.p1));
        }
        if (mDoneItem != null) {
            mDoneItem.setTextColor(ThemeUtil.getPrimaryTextColor(mContext));
        }
        if (mEditItem != null) {
            mEditItem.setTextColor(ThemeUtil.getPrimaryTextColor(mContext));
        }
        if (mCloseItem != null) {
            mCloseItem.setTextColor(ThemeUtil.getPrimaryTextColor(mContext));
        }
        if (mSelectAllItem != null) {
            mSelectAllItem.setTextColor(ThemeUtil.getPrimaryTextColor(mContext));
        }
        if (mAddItem != null) {
            mAddItem.setImageTintList(ThemeUtil.getPrimaryIconColor(mContext));
        }
        if (mDeleteItem != null) {
            mDeleteItem.setImageTintList(ThemeUtil.getPrimaryIconColor(mContext));
        }
        if (mCopyItem != null) {
            mCopyItem.setImageTintList(ThemeUtil.getPrimaryIconColor(mContext));
        }
        if (mPasteItem != null) {
            mPasteItem.setImageTintList(ThemeUtil.getPrimaryIconColor(mContext));
        }
        if (mExtractItem != null) {
            mExtractItem.setImageTintList(ThemeUtil.getPrimaryIconColor(mContext));
        }
        if (mRotateLeftItem != null) {
            mRotateLeftItem.setImageTintList(ThemeUtil.getPrimaryIconColor(mContext));
        }
        if (mRotateRightItem != null) {
            mRotateRightItem.setImageTintList(ThemeUtil.getPrimaryIconColor(mContext));
        }
        if (mAddPageMenus != null) {
            mAddPageMenus.dismiss();
            mAddPageMenus = null;
        }
        if (mShareItem != null) {
            mShareItem.setImageTintList(ThemeUtil.getPrimaryIconColor(mContext));
        }

        if (mDialogView != null) {
            mDialogView.setBackgroundColor(AppResource.getColor(mContext, R.color.b1));
            allTab.setTextColor(AppResource.getColor(mContext, R.color.tab_text_selector));
            allTab.setBackground(AppResource.getDrawable(mContext, R.drawable.thumbnail_left_tab_bg));
            annotatedTab.setTextColor(AppResource.getColor(mContext, R.color.tab_text_selector));
            annotatedTab.setBackground(AppResource.getDrawable(mContext, R.drawable.thumbnail_center_tab_bg));
            bookmarkedTab.setTextColor(AppResource.getColor(mContext, R.color.tab_text_selector));
            bookmarkedTab.setBackground(AppResource.getDrawable(mContext, R.drawable.thumbnail_right_tab_bg));
        }
        if (mCreatePageDialog != null) {
            mCreatePageDialog.dismiss();
            mCreatePageDialog = null;
        }
        if (mExtractPageDialog != null) {
            mExtractPageDialog.dismiss();
            mExtractPageDialog = null;
        }

        if (mFileSelectDialog != null) {
            mFileSelectDialog.dismiss();
            mFileSelectDialog = null;
        }
        if (mPageColorDialog != null) {
            mPageColorDialog.dismiss();
            mPageColorDialog = null;
        }
        if (mPageDirectionDialog != null) {
            mPageDirectionDialog.dismiss();
            mPageDirectionDialog = null;
        }
        if (mPageSizeDialog != null) {
            mPageSizeDialog.dismiss();
            mPageSizeDialog = null;
        }
        if (mProgressDialog != null) {
            mProgressDialog.dismiss();
            mProgressDialog = null;
        }
    }


    public void importDocument(String path, String password, Event.Callback callback) {
        if (mCurrentFragment == null) return;
        ThumbnailAdapter adapter = mCurrentFragment.getAdapter();
        adapter.importDocument(adapter.getInsertIndex(), path, password, callback);
    }

    public void extractPages(Event.Callback callback) {
        if (mCurrentFragment == null) return;
        ThumbnailAdapter adapter = mCurrentFragment.getAdapter();
        adapter.extractPages(callback);
    }

    public List<Integer> getSelectedPageIndexes() {
        if (mCurrentFragment == null) return null;
        List<Integer> selectedPages = new ArrayList<>();
        ThumbnailAdapter adapter = mCurrentFragment.getAdapter();
        SparseArray<ThumbnailItem> selectedItems = adapter.mSelectedArray;
        int size = selectedItems.size();
        for (int i = 0; i < size; i++) {
            int index = selectedItems.valueAt(i).getPageIndex();
            selectedPages.add(index);
        }
        return selectedPages;
    }

    void updateTheme() {
        if (mMenuViewManager == null) return;

        IMenuPresenter presenter = mMenuViewManager.getMenuPresenter(MenuViewManager.POSITION_THUMBNAIL_ADD);
        if (presenter != null) {
            IMenuView addMenu = presenter.getMenuView();
            if (addMenu instanceof MenuViewImpl) {
                ((MenuViewImpl) addMenu).setDarkModeColor();

                for (int i = 0; i < addMenu.getGroups().size(); i++) {
                    IMenuGroup menuGroup = addMenu.getGroupAt(i);
                    if (menuGroup != null) {
                        menuGroup.setHeaderTitleColor(AppResource.getColor(mContext, R.color.t2));
                        menuGroup.setHeaderBackgroundColor(AppResource.getColor(mContext, R.color.b1));
                    }
                }
            }
        }
        if (mAddPageMenus instanceof UIActionMenu)
            ((UIActionMenu) mAddPageMenus).setDarkModeColor();
    }

    protected void setShareItemVisible(boolean visible) {
        mShareItemVisible = visible;
    }

    private interface OnProgressCallback {
        void onProgress(int progress);
    }

    @Override
    public void onDismiss(@NonNull DialogInterface dialog) {
        super.onDismiss(dialog);
        mMenuViewManager.setMenuPresenter(MenuViewManager.POSITION_THUMBNAIL_ADD, null);
    }
}
