/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.modules.signature.appearance;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;

import com.foxit.sdk.PDFViewCtrl;
import com.foxit.uiextensions.R;
import com.foxit.uiextensions.UIExtensionsManager;
import com.foxit.uiextensions.browser.adapter.SuperAdapter;
import com.foxit.uiextensions.browser.adapter.viewholder.SuperViewHolder;
import com.foxit.uiextensions.modules.panel.bean.BaseBean;

import java.util.List;

public class SignatureTitleAdapter extends SuperAdapter<SignatureTitleBean> {
    private Context mContext;
    private UIExtensionsManager mUIExtensionsManager;
    private OnItemClickCallback mOnItemClickCallback;
    private List<SignatureTitleBean> mTitleList;
    public int mOldSelectorPosition = -1;

    public SignatureTitleAdapter(Context context, PDFViewCtrl pdfViewCtrl) {
        super(context);
        mContext = context;
        mUIExtensionsManager = (UIExtensionsManager) pdfViewCtrl.getUIExtensionsManager();
    }

    void setTitleList(List<SignatureTitleBean> titleList) {
        mTitleList = titleList;
        for (int i = 0; i < mTitleList.size(); i++) {
            if (mTitleList.get(i).isSelect()) {
                mOldSelectorPosition = i;
            }
        }
    }

    List<SignatureTitleBean> getTitleList() {
        return mTitleList;
    }

    @Override
    public void notifyUpdateData() {
        notifyDataSetChanged();
    }

    @Override
    public SignatureTitleBean getDataItem(int position) {
        return mTitleList.get(position);
    }

    @NonNull
    @Override
    public SuperViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int i) {
        return new SignatureTitleHolder(LayoutInflater.from(getContext()).inflate(R.layout.sign_appearance_title_item, parent, false));
    }

    @Override
    public int getItemCount() {
        return mTitleList.size();
    }

    class SignatureTitleHolder extends SuperViewHolder {
        private RelativeLayout mTitleRl;
        private ImageView mTitleSelectIv;
        private TextView mTitleTv;
        private ImageView mTitleMore;

        public SignatureTitleHolder(View itemView) {
            super(itemView);
            mTitleRl = itemView.findViewById(R.id.sign_appearance_title_item_rl);
            mTitleSelectIv = itemView.findViewById(R.id.sign_appearance_title_item_selector);
            mTitleMore = itemView.findViewById(R.id.sign_appearance_title_item_more);
            mTitleTv = itemView.findViewById(R.id.sign_appearance_title_item_text);
            mTitleRl.setOnClickListener(this);
            mTitleMore.setOnClickListener(this);
        }

        @Override
        public void bind(BaseBean data, int position) {
            SignatureTitleBean titleBean = (SignatureTitleBean) data;
            if (titleBean.isSelect()) {
                mTitleSelectIv.setVisibility(View.VISIBLE);
            } else {
                mTitleSelectIv.setVisibility(View.INVISIBLE);
            }
            String standardStyle = "appearance_standard_style";
            if (standardStyle.equals(titleBean.getName())) {
                standardStyle = mContext.getApplicationContext().getString(R.string.appearance_standard_style);
                mTitleMore.setVisibility(View.INVISIBLE);
            } else {
                standardStyle = titleBean.getName();
                mTitleMore.setVisibility(View.VISIBLE);
            }
            mTitleTv.setText(standardStyle);

        }

        @Override
        public void onClick(View v) {
            int id = v.getId();
            int position = getAdapterPosition();
            SignatureTitleBean item = mTitleList.get(position);
            if (id == R.id.sign_appearance_title_item_rl) {
                if (mOnItemClickCallback != null) {
                    if (mOldSelectorPosition != -1) {
                        mTitleList.get(mOldSelectorPosition).setSelect(false);
                    }
                    mTitleList.get(position).setSelect(true);
                    mOldSelectorPosition = position;
                    mOnItemClickCallback.onItemClick(position, item);
                    notifyUpdateData();
                }
            }else if (id == R.id.sign_appearance_title_item_more){
                mOnItemClickCallback.onItemMoreClick(position,item,v);
            }
        }
    }

    void setOnItemClickCallback(OnItemClickCallback callback) {
        mOnItemClickCallback = callback;
    }

    interface OnItemClickCallback {
        void onItemClick(int position, SignatureTitleBean item);
        void onItemMoreClick(int position, SignatureTitleBean item,View view);
    }
}
