/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.modules.signature.appearance;

import android.content.Context;
import android.content.res.ColorStateList;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;

import com.foxit.sdk.PDFViewCtrl;
import com.foxit.uiextensions.IThemeEventListener;
import com.foxit.uiextensions.R;
import com.foxit.uiextensions.UIExtensionsManager;
import com.foxit.uiextensions.controls.dialog.UIMatchDialog;
import com.foxit.uiextensions.controls.toolbar.BaseBar;
import com.foxit.uiextensions.theme.ThemeConfig;
import com.foxit.uiextensions.theme.ThemeUtil;
import com.foxit.uiextensions.utils.AppResource;

public class SignatureAppearanceLocationDialog extends UIMatchDialog {
    private Context mContext;
    private ViewGroup mParent;
    private PDFViewCtrl mPdfViewCtrl;
    private UIExtensionsManager mUIExtensionsManager;
    private ViewGroup mContentView;
    private ISignSwitchLocationCallback mSignSwitchLocationCallback;

    private RelativeLayout mSignLocationRL;
    private LinearLayout mSignLocationLl;
    private ImageView mSignLocationSwitchIv;
    private EditText mSignLocationEt;
    private boolean mIsOpen = false;
    private String mLocation = "";

    public SignatureAppearanceLocationDialog(Context context,
                                             ViewGroup parent,
                                             PDFViewCtrl pdfViewCtrl,
                                             boolean locationOpen,
                                             String location) {
        super(context);
        mContext = context.getApplicationContext();
        mParent = parent;
        mPdfViewCtrl = pdfViewCtrl;
        mUIExtensionsManager = (UIExtensionsManager) mPdfViewCtrl.getUIExtensionsManager();
        mIsOpen = locationOpen;
        mLocation = location;
        initStyle();
        initView();

        setOnDLDismissListener(new DismissListener() {
            @Override
            public void onDismiss() {
                mUIExtensionsManager.unregisterThemeEventListener(mThemeColorChangedListener);
            }
        });
    }

    @Override
    public void onBackPressed() {
        mSignSwitchLocationCallback.switchLocation(mIsOpen, mSignLocationEt.getText().toString());
        dismiss();
    }

    private void initStyle() {
        setBackButtonTintList(ThemeUtil.getItemIconColor(mContext));
        setTitle(AppResource.getString(mContext, R.string.appearance_location));
        setTitlePosition(BaseBar.TB_Position.Position_CENTER);
        setStyle(DLG_TITLE_STYLE_BG_DEFAULT);
        setListener(new DialogListener() {
            @Override
            public void onResult(long btType) {

            }

            @Override
            public void onBackClick() {
                mSignSwitchLocationCallback.switchLocation(mIsOpen, mSignLocationEt.getText().toString());
            }

            @Override
            public void onTitleRightButtonClick() {
            }
        });
    }

    private void initView() {
        mContentView = (ViewGroup) View.inflate(mContext, R.layout.sign_appearance_location_layout, null);
        mSignLocationRL = mContentView.findViewById(R.id.sign_appearance_location_rl);
        mSignLocationSwitchIv = mContentView.findViewById(R.id.sign_appearance_location_switch);
        mSignLocationLl = mContentView.findViewById(R.id.sign_appearance_location_content_ll);
        mSignLocationEt = mContentView.findViewById(R.id.sign_appearance_location_et);
        setContentView(mContentView);
        ThemeUtil.setBackgroundTintList(mSignLocationRL, getSelectedButtonColorStateList());
        mSignLocationRL.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                mIsOpen = !mIsOpen;
                if (mIsOpen) {
                    setSelectedButtonState(true, mSignLocationRL, mSignLocationSwitchIv);
                    mSignLocationLl.setVisibility(View.VISIBLE);
                } else {
                    setSelectedButtonState(false, mSignLocationRL, mSignLocationSwitchIv);
                    mSignLocationLl.setVisibility(View.GONE);
                }

            }
        });

    }

    public void loadData() {
        mUIExtensionsManager.registerThemeEventListener(mThemeColorChangedListener);

        if (mIsOpen) {
            setSelectedButtonState(true, mSignLocationRL, mSignLocationSwitchIv);
            mSignLocationLl.setVisibility(View.VISIBLE);
        } else {
            setSelectedButtonState(false, mSignLocationRL, mSignLocationSwitchIv);
            mSignLocationLl.setVisibility(View.GONE);
        }
        mSignLocationEt.setText(mLocation);

    }

    private IThemeEventListener mThemeColorChangedListener = new IThemeEventListener() {
        @Override
        public void onThemeColorChanged(String type, int color) {
            dismiss();
        }
    };

    public void setSwitchLocation(ISignSwitchLocationCallback signSwitchLocationCallback) {
        mSignSwitchLocationCallback = signSwitchLocationCallback;
    }

    public interface ISignSwitchLocationCallback {
        void switchLocation(boolean open, String location);
    }

    private void setSelectedButtonState(boolean isSelected, RelativeLayout switchLayout, ImageView switchIcon) {
        if (switchLayout == null || switchIcon == null) return;
        switchLayout.setSelected(isSelected);
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams) switchIcon.getLayoutParams();
        if (params == null) return;
        params.removeRule(isSelected ? RelativeLayout.ALIGN_PARENT_LEFT : RelativeLayout.ALIGN_PARENT_RIGHT);
        params.addRule(isSelected ? RelativeLayout.ALIGN_PARENT_RIGHT : RelativeLayout.ALIGN_PARENT_LEFT, RelativeLayout.TRUE);
        switchIcon.setLayoutParams(params);
    }

    private ColorStateList getSelectedButtonColorStateList() {
        int disabled = AppResource.getColor(mContext, R.color.p1);
        int selected = ThemeConfig.getInstance(mContext).getPrimaryColor();
        int normal = AppResource.getColor(mContext, R.color.p1);
        return AppResource.createColorStateList(selected, disabled, normal);
    }
}
