/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.modules.signature;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.Nullable;

import com.foxit.sdk.PDFViewCtrl;


class SignatureViewController {
    private SignatureFragment.SignatureInkCallback mPSICallback;

    private SignatureViewGroup mViewGroup;
    private SignatureDrawView mDrawView;
    private Context mContext;
    private ViewGroup mParent;
    private PDFViewCtrl mPdfViewCtrl;
    private int mWidth;
    private int mHeight;
    private boolean mOnMoving;
    private SignatureFragment.SignatureInkCallback mInkCallback;

    public SignatureViewController(Context context, ViewGroup parent, PDFViewCtrl pdfViewCtrl, SignatureFragment.SignatureInkCallback callback) {
        mPSICallback = callback;
        mContext = context;
        mParent = parent;
        mPdfViewCtrl = pdfViewCtrl;
        mInkCallback = callback;
        mViewGroup = new SignatureViewGroup(mContext);
        mDrawView = new SignatureDrawView(mContext, parent, pdfViewCtrl);
        mDrawView.setOnDrawListener(mDrawListener);
        mDrawView.setInkCallback(mInkCallback);
    }

    SignatureDrawView drawView() {
        if (mDrawView == null) {
            mDrawView = new SignatureDrawView(mContext, mParent, mPdfViewCtrl);
            mDrawView.setOnDrawListener(mDrawListener);
            mDrawView.setInkCallback(mInkCallback);
        }
        return mDrawView;
    }

    public void init(int width, int height) {
        mWidth = width;
        mHeight = height;
        mViewGroup.init(mWidth, mHeight);
        drawView().init(width, height, "");
        mViewGroup.addView(mDrawView.getView());
    }

    public void init(int width, int height, SignatureInkItem inkItem) {
        mWidth = width;
        mHeight = height;
        mViewGroup.init(mWidth, mHeight);
        drawView().init(width, height, inkItem);
        mViewGroup.addView(mDrawView.getView());
    }

    public void reDraw(int width, int height){
        mWidth = width;
        mHeight = height;
        mViewGroup.init(mWidth, mHeight);
        drawView().reDraw(width, height);
    }

    public void unInit() {
        if (mViewGroup.getChildCount() > 0) {
            mViewGroup.removeAllViews();
        }
        mDrawView.unInit();
        mDrawView = null;
        mViewGroup = null;
    }

    public View getView() {
        return mViewGroup;
    }

    SignatureDrawView.OnDrawListener mDrawListener = new SignatureDrawView.OnDrawListener() {


        @Override
        public void result(SignatureInkItem inkItem) {
            if (mPSICallback != null) {
                mPSICallback.onSuccess(true,inkItem);
            }
        }

        @Override
        public void onBackPressed() {
            if (mPSICallback != null) {
                mPSICallback.onBackPressed();
            }
        }

        @Override
        public void moveToTemplate() {
            mOnMoving = true;
            mViewGroup.moveToTop(new SignatureViewGroup.IMoveCallBack() {

                @Override
                public void onStop() {
                    mOnMoving = false;
                }

                @Override
                public void onStart() {
                }
            });
        }

        @Override
        public boolean canDraw() {
            return !mOnMoving;
        }
    };

    public void setIsFromSignatureField(boolean isFromSignatureField) {
        if (mDrawView != null)
            mDrawView.setIsFromSignatureField(isFromSignatureField);
    }

    public void setActivity(Activity activity, SignatureFragment fragment) {
        if (mDrawView != null)
            mDrawView.setActivity(activity, fragment);
    }

    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        if (mDrawView != null)
            mDrawView.onActivityResult(requestCode, resultCode, data);
    }

    public Bitmap getSignatureBitmap() {
        if (mDrawView != null)
            return mDrawView.getBitmap();
        return null;
    }

    void updateTheme() {
        if (mDrawView != null)
            mDrawView.updateTheme();
    }

}
