/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.modules.panel.outline;


import com.foxit.sdk.pdf.Bookmark;
import com.foxit.uiextensions.modules.panel.bean.BaseBean;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

class OutlineNode extends BaseBean {
    OutlineNode mParent;
    List<OutlineNode> mChildren;

    boolean mIsLeaf;
    boolean mIsExpanded;
    String mId;
    String mPid;
    int mLevel;

    Bookmark mBookmark;
    String mTitle;
    int mPageIndex;
    float mX;
    float mY;
    int mPosition;

    public OutlineNode() {
        mBookmark = null;
        mParent = null;
        mTitle = null;
        mPageIndex = -1;
        mX = 0;
        mY = 0;
        mLevel = -1;
        mIsLeaf = true;
        mChildren = new ArrayList<>();
        mIsExpanded = false;
        mPosition = -1;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        OutlineNode that = (OutlineNode) o;
        return Objects.equals(mId, that.mId);
    }
}
