/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.modules.panel.bean;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * The file attachment panel list's data model.
 *
 * @see BaseBean
 */
public class FileBean extends BaseBean implements Parcelable {
    private String title;
    private String name;
    private String date;
    private String size;
    private String desc;
    private String filePath;
    private String uuid;
    private int pageIndex;
    private boolean showLabel;
    private boolean canDelete;
    private boolean canComment;
    private boolean canFlatten;

    public FileBean(){}

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDate() {
        return date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getSize() {
        return size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getFilePath() {
        return filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getUuid() {
        return uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex;
    }

    public int getPageIndex() {
        return pageIndex;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCanDelete(boolean canDelete) {
        this.canDelete = canDelete;
    }

    public boolean canDelete() {
        return canDelete;
    }

    public boolean canComment() {
        return canComment;
    }

    public void setCanComment(boolean canComment) {
        this.canComment = canComment;
    }

    public void setShowLable(boolean showLabel) {
        this.showLabel = showLabel;
    }

    public boolean isShowLabel() {
        return showLabel;
    }

    public boolean canFlatten() {
        return canFlatten;
    }

    public void setCanFlatten(boolean canFlatten) {
        this.canFlatten = canFlatten;
    }

    private boolean withModificationPermission;
    private boolean withDeletePermission;

    public boolean isWithModificationPermission() {
        return withModificationPermission;
    }

    public void setWithModificationPermission(boolean withModificationPermission) {
        this.withModificationPermission = withModificationPermission;
    }

    public boolean isWithDeletePermission() {
        return withDeletePermission;
    }

    public void setWithDeletePermission(boolean withDeletePermission) {
        this.withDeletePermission = withDeletePermission;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(title);
        dest.writeString(date);
        dest.writeString(size);
        dest.writeString(desc);
        dest.writeInt(getFlag());
        dest.writeString(filePath);
        dest.writeString(uuid);
        dest.writeString(name);
        dest.writeBooleanArray(new boolean[] {showLabel});
        dest.writeBooleanArray(new boolean[] {canDelete});
        dest.writeBooleanArray(new boolean[] {canComment});
        dest.writeBooleanArray(new boolean[] {canFlatten});
        dest.writeBooleanArray(new boolean[] {withModificationPermission});
        dest.writeBooleanArray(new boolean[] {withDeletePermission});
    }

    public static final Parcelable.Creator<FileBean> CREATOR = new Parcelable.Creator<FileBean>(){

        @Override
        public FileBean createFromParcel(Parcel source) {
            FileBean item =  new FileBean();
            item.setTitle(source.readString());
            item.setDate(source.readString());
            item.setSize(source.readString());
            item.setDesc(source.readString());
            item.setFlag(source.readInt());
            item.setFilePath(source.readString());
            item.setUuid(source.readString());
            item.setName(source.readString());
            boolean[] val = new boolean[1];
            source.readBooleanArray(val);
            item.setShowLable(val[0]);
            boolean[] va2 = new boolean[1];
            source.readBooleanArray(va2);
            item.setCanDelete(va2[0]);
            boolean[] va3 = new boolean[1];
            source.readBooleanArray(va3);
            item.setCanComment(va3[0]);
            boolean[] va4 = new boolean[1];
            source.readBooleanArray(va4);
            item.setCanFlatten(va4[0]);
            boolean[] va5 = new  boolean[1];
            source.readBooleanArray(va5);
            item.setWithModificationPermission(va5[0]);
            boolean[] va6 = new  boolean[1];
            source.readBooleanArray(va6);
            item.setWithDeletePermission(va6[0]);
            return item;
        }

        @Override
        public FileBean[] newArray(int size) {
            return new FileBean[0];
        }
    };

}
