/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.modules.pagenavigation;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.PointF;
import android.graphics.Rect;
import android.text.Editable;
import android.text.InputType;
import android.text.TextWatcher;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.core.view.OnApplyWindowInsetsListener;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;

import com.foxit.sdk.PDFViewCtrl;
import com.foxit.uiextensions.IThemeEventListener;
import com.foxit.uiextensions.R;
import com.foxit.uiextensions.UIExtensionsManager;
import com.foxit.uiextensions.controls.dialog.UITextEditDialog;
import com.foxit.uiextensions.controls.toolbar.drag.UIDragToolBar;
import com.foxit.uiextensions.pdfreader.config.ReadStateConfig;
import com.foxit.uiextensions.pdfreader.impl.MainFrame;
import com.foxit.uiextensions.theme.ThemeConfig;
import com.foxit.uiextensions.theme.ThemeUtil;
import com.foxit.uiextensions.utils.AppDevice;
import com.foxit.uiextensions.utils.AppDisplay;
import com.foxit.uiextensions.utils.AppKeyboardUtil;
import com.foxit.uiextensions.utils.AppResource;
import com.foxit.uiextensions.utils.SystemUiHelper;

import java.math.BigDecimal;


public class PageNavigationBar {

    private RelativeLayout mBarNumView;
    private ImageView mBarImage;
//    private TextView mBar_Num;
//    private View mBar_line;

//    private View mToastView;
//    private TextView mToastNum;
//    private TextView mToastTotal;

    private int mPaddingRight;
    private int mPaddingBottom;
    private int mPaddingLeft;
    private int mPaddingTop;

    private PointF mBar_start;
    private PointF mBar_end;
    private PointF mPosition;
    private float mBar_length;
    private int mBar_Max;

    private final float LINE_WIDTH_DP = 0.5f;
    private final int NUMVIEW_H_DP = 31;//48;
    private final int NUMVIEW_W_DP = 39;//34;
    private final int PADDING = 8;
    int NUMView_Width = 0;
    int NUMView_height = 0;
    int VIEW_CUT = 0;
    private View mJumpView;
    private Context mContext;
    private PDFViewCtrl mPdfViewCtrl;
    private UIExtensionsManager mUIExtensionsManager;
    private int mPos = UIDragToolBar.TOOLBAR_POS_TOP;

    public PageNavigationBar(Context context, PDFViewCtrl pdfViewCtrl, View jumpView) {
        mContext = context;
        mPdfViewCtrl = pdfViewCtrl;
        mUIExtensionsManager = (UIExtensionsManager) pdfViewCtrl.getUIExtensionsManager();
        mBar_start = new PointF();
        mBar_end = new PointF();
        mPosition = new PointF();
        mDownPoint = new PointF();

        mJumpView = jumpView;
//        VIEW_CUT = AppDisplay.getInstance(context).dp2px(8);
        mLastReadState = ReadStateConfig.STATE_NORMAL;
        initialize();

    }

    public void resetOnViewStyle() {
        //sing page, continue
        destroy();
        initialize();
        int pagenum = mPdfViewCtrl.getCurrentPage() + 1;
        NumViewMoveTo(getPositionByNum(pagenum));
    }

    public void reset() {
        //
        if (mbDragging) return;
        layout();

        int pagenum = mPdfViewCtrl.getCurrentPage() + 1;
        NumViewMoveTo(getPositionByNum(pagenum));
//        setNum(pagenum);
    }

    public void destroy() {
        if (mBarNumView == null) return;
        ViewGroup readView = mUIExtensionsManager.getMainFrame().getContentView();
//        readView.removeView(mBar_line);
        readView.removeView(mBarNumView);
//        readView.removeView(mToastView);
        mUIExtensionsManager.unregisterThemeEventListener(mThemeEventListener);
    }

//    private void setNum(int num) {
//        mBar_Num.setText(String.valueOf(num));
//
//    }

    int readViewH;
    int readViewW;
    Rect rootViewVisibleRect;

    private void initialize() {
        mPreNum = 0;
        //direction
        if (mUIExtensionsManager.getState() == ReadStateConfig.STATE_REFLOW ||
                mPdfViewCtrl.isContinuous()) {
            mCurPosId = 3;
        } else {
            mCurPosId = 1;
        }

        //init:
        // padding
        mPaddingTop = AppDisplay.dp2px(PADDING);
        mPaddingLeft = AppDisplay.dp2px(PADDING);
        mPaddingBottom = AppDisplay.dp2px(PADDING);
        mPaddingRight = AppDisplay.dp2px(PADDING);

        readViewH = mUIExtensionsManager.getMainFrame().getContentView().getHeight();
        readViewW = mUIExtensionsManager.getMainFrame().getContentView().getWidth();
        rootViewVisibleRect = new Rect();
        mUIExtensionsManager.getContentView().getGlobalVisibleRect(rootViewVisibleRect);

        int topBar_Height = 0;
        int bottomBar_Height = 0;
        int parent_padding = 0;
        MainFrame mainFrame = (MainFrame) mUIExtensionsManager.getMainFrame();
        topBar_Height = mainFrame.getTopBarHeight();
        int state = mUIExtensionsManager.getState();
        UIExtensionsManager extensionsManager = (UIExtensionsManager) mPdfViewCtrl.getUIExtensionsManager();
        boolean readState = state == ReadStateConfig.STATE_REFLOW
                || state == ReadStateConfig.STATE_PANZOOM
                || state == ReadStateConfig.STATE_TTS
                || state == ReadStateConfig.STATE_AUTOFLIP
                || state == ReadStateConfig.STATE_REDACT;

        if (extensionsManager.getMainFrame().isToolbarsVisible()) {
            if (AppDisplay.isPad()) {
                bottomBar_Height = 0;
            } else {
                if (!mainFrame.isShowTopToolbar()) {
                    if (readState) {
                        topBar_Height = AppResource.getDimensionPixelSize(mContext, R.dimen.ux_topbar_height);
                    } else {
                        topBar_Height = 0;
                    }
                } else {
                    if (readState) {
                        topBar_Height -= mainFrame.getDragToolBar().getToolbarRealHeight();
                    }
                }
                if (!mainFrame.isShowBottomToolbar()) {
                    if (readState) {
                        bottomBar_Height = AppResource.getDimensionPixelSize(mContext, R.dimen.ux_tab_height);
                    } else {
                        bottomBar_Height = 0;
                    }
                } else {
                    bottomBar_Height = AppResource.getDimensionPixelSize(mContext, R.dimen.ui_bottombar_height);
                }
            }

            ViewGroup parent = (ViewGroup) mUIExtensionsManager.getMainFrame().getContentView();
            parent_padding = parent.getPaddingBottom() + parent.getPaddingTop();
        } else {
            topBar_Height = extensionsManager.getConfig().uiSettings.fullscreen && mainFrame.isSmallTopToolbarEnabled() ? AppResource.getDimensionPixelSize(mContext, R.dimen.ux_margin_20dp) : 0;
            bottomBar_Height = extensionsManager.getConfig().uiSettings.fullscreen && mainFrame.isSmallBottomToolbarEnabled() ? AppResource.getDimensionPixelSize(mContext, R.dimen.ux_margin_20dp) : 0;
            if (!AppDisplay.isPad()) {
                if (readState) {
                    topBar_Height = 0;
                    bottomBar_Height = 0;
                }

            } else {
                if (state == ReadStateConfig.STATE_REDACT) {
                    bottomBar_Height = 0;
                }
            }
        }
        if (state == ReadStateConfig.STATE_COMPARE) {
            bottomBar_Height = 0;
        }
        int viewHeight = readViewH - topBar_Height - bottomBar_Height;
        int viewWidth = readViewW;

        if (mCurPosId > 1) {
            //continuious layout
            NUMView_Width = AppDisplay.dp2px(NUMVIEW_H_DP) - VIEW_CUT;
            NUMView_height = AppDisplay.dp2px(NUMVIEW_W_DP);

            mBar_length = viewHeight - mPaddingTop - mPaddingBottom;
            mBar_start.x = viewWidth - NUMView_Width - mPaddingRight;
            mBar_start.y = topBar_Height + mPaddingTop;
            mBar_end.x = mBar_start.x;
            mBar_end.y = mBar_start.y + mBar_length - NUMView_height;
            if (AppDisplay.isPad() && mPos == UIDragToolBar.TOOLBAR_POS_RIGHT) {
                mBar_start.x = mPaddingLeft;
                mBar_end.x = mBar_start.x;
            }
        } else {
            //single layout
            NUMView_Width = AppDisplay.dp2px(NUMVIEW_W_DP);
            NUMView_height = AppDisplay.dp2px(NUMVIEW_H_DP) - VIEW_CUT;
            mBar_length = viewWidth - mPaddingLeft - mPaddingRight;
            mBar_start.x = mPaddingLeft;
            mBar_start.y = readViewH - bottomBar_Height - NUMView_height - mPaddingBottom - parent_padding;
            mBar_end.x = mPaddingLeft + mBar_length - NUMView_Width;
            mBar_end.y = mBar_start.y;

        }

        //Bar View
        mBarNumView = new RelativeLayout(mContext);
        mBarNumView.setId(R.id.rd_pagenavigationbar_num);
        mBarNumView.setLayoutParams(new RelativeLayout.LayoutParams(NUMView_Width, NUMView_height));
        ViewCompat.setOnApplyWindowInsetsListener(mBarNumView, new OnApplyWindowInsetsListener() {
            @Override
            public WindowInsetsCompat onApplyWindowInsets(View v, WindowInsetsCompat insets) {
                layout();
                return WindowInsetsCompat.CONSUMED;
            }
        });

        mBarImage = new ImageView(mContext);
//        mBar_line = new LinearLayout(mContext);
        if (mCurPosId > 1) {
            if (mCurPosId == 2) {
                mBarNumView.setBackgroundResource(R.drawable.page_num_background_v);
            } else {
                mBarNumView.setBackgroundResource(R.drawable.page_num_background_v);
            }
            mBarImage.setImageResource(R.drawable.page_num_btn_v);
//            mBar_Num = new TextView(App.instance().getApplicationContext());
//            mBar_line.setLayoutParams(new LinearLayout.LayoutParams(App.instance().getDisplay().dp2px(LINE_WIDTH_DP), (int)mBar_length));
        } else {
            mBarNumView.setBackgroundResource(R.drawable.page_num_background_h); // TODO: 2021/2/1
//            mBar_Num = new UIRotateTextView(App.instance().getApplicationContext());
//            mBar_line.setLayoutParams(new LinearLayout.LayoutParams((int)mBar_length, App.instance().getDisplay().dp2px(LINE_WIDTH_DP)));
            mBarImage.setImageResource(R.drawable.page_num_btn_h);
        }


        int primaryColor = ThemeConfig.getInstance(mContext).getPrimaryColor();
        ThemeUtil.setTintList(mBarImage, ColorStateList.valueOf(primaryColor));
        int b2 = ThemeConfig.getInstance(mContext).getB2();
        ThemeUtil.setTintList(mBarNumView, ColorStateList.valueOf(b2));
        mBarNumView.addView(mBarImage);
//        mBar_Num.setLayoutParams(new RelativeLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT));
//        mBar_Num.setGravity(Gravity.CENTER);
//        mBar_Num.setLines(1);
//        mBar_Num.setEllipsize(TextUtils.TruncateAt.END);
////        mBar_Num.setPadding(App.instance().getDisplay().dp2px(8), 0, 0, 0);
//        mBar_Num.setTextColor(AppResource.getColor("ui_color_toolbar", R.color.ui_color_text));
//        setNum(App.instance().getRead().getDocViewer().getCurrentPageIndex() + 1);
//        mBarNumView.addView(mBar_Num);
//        mBar_line.setBackgroundColor(AppResource.getColor("ui_color_grey_ffbfbfbf", R.color.ui_color_page_nb_line));
//
//        //Toast View
//        mToastView = View.inflate(App.instance().getApplicationContext(), R.layout._70000_pagenum_toast, null);
//        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(App.instance().getDisplay().dp2px(84), App.instance().getDisplay().dp2px(76));
//        lp.addRule(RelativeLayout.CENTER_IN_PARENT);
//        mToastView.setLayoutParams(lp);
//        mToastNum = mToastView.findViewById(R.id.pagenum_toast_number);
//        mToastTotal = mToastView.findViewById(R.id.pagenum_toast_total);
//        mToastView.setVisibility(View.GONE);

        //set view
//        if (mCurPosId > 1) {
//            mBar_line.setX(mBar_start.x + NUMView_Width / 3 * 2);
//            mBar_line.setY(mBar_start.y);
//        } else {
//            mBar_line.setX(mBar_start.x);
//            mBar_line.setY(mBar_start.y + NUMView_height / 3 * 2);
//        }

        mBarNumView.setX(mPdfViewCtrl.getPageBinding() == PDFViewCtrl.LEFT_EDGE ? mBar_start.x : mBar_end.x);
        mBarNumView.setY(mBar_start.y);
        if (mPdfViewCtrl.getPageCount() > 1) {
            ViewGroup readView = mUIExtensionsManager.getMainFrame().getContentView();
//            if (GuideMaskView.getInstance().isVisible()) {
//                int index = readView.indexOfChild(GuideMaskView.getInstance().getRootView());
//                readView.addView(mBar_line, index -1);
//                readView.addView(mBarNumView, index -1);
//                readView.addView(mToastView, index -1);
//            } else {
//                readView.addView(mBar_line);
            if (mUIExtensionsManager.getMainFrame().isMaskViewShowing()) {
                readView.addView(mBarNumView, mUIExtensionsManager.getMainFrame().getMaskViewIndex() - 1);
            } else {
                readView.addView(mBarNumView);
            }

//                readView.addView(mToastView);
//            }

//            mBar_line.setVisibility(View.GONE);
        }

        //init status
        countGraduation();
        mBarNumView.setOnTouchListener(mTouchListener);
//        mToastTotal.setText(String.valueOf(App.instance().getRead().getDocViewer().getDocument().getPageCount()));
        mUIExtensionsManager.registerThemeEventListener(mThemeEventListener);
    }

    private int mPadNavigationBarHeight;

    private boolean isPadNavigationBarShow() {
        mPadNavigationBarHeight = AppDisplay.getActivityWidth() - readViewW; //AppDisplay.getRawScreenWidth() - readViewW; for Chrome OS
        if (mPadNavigationBarHeight > 0) return true;

        mPadNavigationBarHeight = AppDisplay.getActivityHeight() - readViewH; //AppDisplay.getRawScreenHeight() - readViewH; for Chrome OS
        if (mPadNavigationBarHeight > 0) return true;

        return false;
    }

    protected void layout() {
        ViewGroup readView = mUIExtensionsManager.getMainFrame().getContentView();
        if (readView.getHeight() > readView.getWidth()) {
            readViewH = readView.getHeight();
            readViewW = readView.getWidth();
        } else {
            readViewW = readView.getHeight();
            readViewH = readView.getWidth();
        }
        if (AppDisplay.isPad() && isPadNavigationBarShow() &&
                !AppDevice.isChromeOs(mUIExtensionsManager.getAttachedActivity())) {
            readViewW += mPadNavigationBarHeight;
            readViewH -= mPadNavigationBarHeight;
        }

        if (mPdfViewCtrl.hasPrevView() || mPdfViewCtrl.hasNextView()) {
            mPaddingBottom = AppDisplay.dp2px(30 + 15 * 2);
            mPaddingRight = AppDisplay.dp2px(70 + 14 * 2);
        } else {
            mPaddingBottom = AppDisplay.dp2px(PADDING);
            mPaddingRight = AppDisplay.dp2px(PADDING);
        }
        mPaddingTop = AppDisplay.dp2px(PADDING);
        mPaddingLeft = AppDisplay.dp2px(PADDING);


        int topBar_Height = 0;
        int bottomBar_Height = 0;
        int parent_padding = 0;
        MainFrame mainFrame = (MainFrame) mUIExtensionsManager.getMainFrame();
        topBar_Height = mainFrame.getTopBarHeight();
        UIExtensionsManager extensionsManager = (UIExtensionsManager) mPdfViewCtrl.getUIExtensionsManager();
        int state = mUIExtensionsManager.getState();
        boolean readState = state == ReadStateConfig.STATE_REFLOW
                || state == ReadStateConfig.STATE_PANZOOM
                || state == ReadStateConfig.STATE_TTS
                || state == ReadStateConfig.STATE_AUTOFLIP
                || state == ReadStateConfig.STATE_REDACT;
        if (extensionsManager.getMainFrame().isToolbarsVisible()) {
            if (AppDisplay.isPad()) {
                bottomBar_Height = 0;
            } else {
                if (!mainFrame.isShowTopToolbar()) {
                    if (readState) {
                        topBar_Height = AppResource.getDimensionPixelSize(mContext, R.dimen.ux_topbar_height);
                    } else {
                        topBar_Height = 0;
                    }
                } else {
                    if (readState) {
                        topBar_Height -= mainFrame.getDragToolBar().getToolbarRealHeight();
                    }
                }
                if (!mainFrame.isShowBottomToolbar()) {
                    if (readState) {
                        bottomBar_Height = AppResource.getDimensionPixelSize(mContext, R.dimen.ux_tab_height);
                    } else {
                        bottomBar_Height = 0;
                    }

                } else {
                    bottomBar_Height = AppResource.getDimensionPixelSize(mContext, R.dimen.ui_bottombar_height);
                }

            }

            ViewGroup parent = (ViewGroup) mUIExtensionsManager.getMainFrame().getContentView();
            parent_padding = parent.getPaddingBottom() + parent.getPaddingTop();
        } else {
            topBar_Height = extensionsManager.getConfig().uiSettings.fullscreen ? AppResource.getDimensionPixelSize(mContext, R.dimen.ux_margin_20dp) : 0;
            bottomBar_Height = extensionsManager.getConfig().uiSettings.fullscreen ? AppResource.getDimensionPixelSize(mContext, R.dimen.ux_margin_20dp) : 0;
            if (!AppDisplay.isPad()) {
                if (readState) {
                    topBar_Height = 0;
                    bottomBar_Height = 0;
                }

            } else {
                if (state == ReadStateConfig.STATE_REDACT) {
                    bottomBar_Height = 0;
                }
            }
        }
        if (state == ReadStateConfig.STATE_COMPARE) {
            bottomBar_Height = 0;
        }


        int viewHeight = readViewH - topBar_Height - bottomBar_Height;
        int viewWidth = readViewW;
//        readView.removeView(mBar_line);
//        mBar_line = new LinearLayout(App.instance().getApplicationContext());
        if (mCurPosId > 1) {
            NUMView_Width = AppDisplay.dp2px(NUMVIEW_H_DP) - VIEW_CUT;
            NUMView_height = AppDisplay.dp2px(NUMVIEW_W_DP);
            if (mCurPosId == 2) {
                mBar_start.x = mPaddingLeft;
                mBar_end.x = mBar_start.x;
            } else {
                mBar_start.x = viewWidth - NUMView_Width - mPaddingRight;
                mBar_end.x = mBar_start.x;
            }
            if (AppDisplay.isPad() && mPos == UIDragToolBar.TOOLBAR_POS_RIGHT) {
                mBar_start.x = mPaddingLeft;
                mBar_end.x = mBar_start.x;
            }
            mBar_length = viewHeight - mPaddingTop - mPaddingBottom;
            mBar_start.y = topBar_Height + mPaddingTop;
            mBar_end.y = mBar_start.y + mBar_length - NUMView_height;

//            mBar_line.setLayoutParams(new LinearLayout.LayoutParams(App.instance().getDisplay().dp2px(LINE_WIDTH_DP), (int)mBar_length));
        } else {
            NUMView_Width = AppDisplay.dp2px(NUMVIEW_W_DP);
            NUMView_height = AppDisplay.dp2px(NUMVIEW_H_DP) - VIEW_CUT;

            mBar_length = viewWidth - mPaddingLeft - mPaddingRight;
            mBar_start.x = mPaddingLeft;
            mBar_start.y = readViewH - bottomBar_Height - NUMView_height - mPaddingBottom - parent_padding;
            mBar_end.x = mPaddingLeft + mBar_length - NUMView_Width;
            mBar_end.y = mBar_start.y;
//            mBar_line.setLayoutParams(new LinearLayout.LayoutParams((int)mBar_length, App.instance().getDisplay().dp2px(LINE_WIDTH_DP)));
        }
//        readView.addView(mBar_line, readView.indexOfChild(mBarNumView) -1);
//        mBar_line.setBackgroundColor(AppResource.getColor("ui_color_grey_ffbfbfbf", R.color.ui_color_page_nb_line));
//        mBar_line.setVisibility(View.GONE);

        //set view
//        if (mCurPosId > 1) {
//            if (mCurPosId == 2)
//                mBar_line.setX(mBar_start.x + NUMView_Width / 3);
//            else
//                mBar_line.setX(mBar_start.x + NUMView_Width / 3 * 2);
//            mBar_line.setY(mBar_start.y);
//        } else {
//            mBar_line.setX(mBar_start.x);
//            mBar_line.setY(mBar_start.y + NUMView_height / 3 * 2);
//        }

        mBarNumView.setX(mPdfViewCtrl.getPageBinding() == PDFViewCtrl.LEFT_EDGE ? mBar_start.x : mBar_end.x);
        mBarNumView.setY(mBar_start.y);

        countGraduation();
//        mToastTotal.setText(String.valueOf(App.instance().getRead().getDocViewer().getDocument().getPageCount()));
    }

    public int getPageBottomHeight() {
        if (mCurPosId > 1) {
            return mBarNumView.getWidth();
        } else {
            return mBarNumView.getHeight();
        }
    }

    /*
                0
             2     3       mCurPosId;
                1
    */
    public int mCurPosId;

    public void update(int oldPos, int newPos) {
        if (!AppDisplay.isPad()) return;
        int bottomBar_Height = AppResource.getDimensionPixelSize(mContext, R.dimen.ui_bottombar_height);
//        int toolbarPos = App.instance().getSP().getInteger(AppSetting.SHARED_PREFERENCE_ANNOTATION, UIAnnotToolbar.SP_BAR_POSITION, 1);

        if (newPos != 1 && mCurPosId == 1) {
            // to bottom
            mBar_start.y = readViewH - NUMView_height;
            mBar_end.y = mBar_start.y;
//            mBar_line.setY(mBar_start.y + NUMView_height / 3 * 2);
            mBarNumView.setY(mBar_start.y);
            float tmp = readViewH - mJumpView.getHeight();
            mJumpView.setY(tmp);

        } else if (newPos == 1 && mCurPosId == 1) {
            // up bottom bar
            mBar_start.y = readViewH - bottomBar_Height - NUMView_height;
            mBar_end.y = mBar_start.y;
//            mBar_line.setY(mBar_start.y + NUMView_height / 3 * 2);
            mBarNumView.setY(mBar_start.y);
            float tmp = readViewH - bottomBar_Height - mJumpView.getHeight();
//            mJumpView.setY(tmp);

        } else if (newPos == 1 && mCurPosId > 1) {
            float tmp = readViewH - bottomBar_Height - mJumpView.getHeight();
            mJumpView.setY(tmp);

        } else if (newPos == 2 && mCurPosId == 2) {
            // to right side
            mBar_start.x = readViewW - NUMView_Width;
            mBar_end.x = mBar_start.x;
//            mBar_line.setX(mBar_start.x + NUMView_Width / 3 * 2);
            mBarNumView.setX(mBar_start.x);
            mCurPosId = 3;
            mBarNumView.setBackgroundResource(R.drawable.page_number_v);
        } else if (newPos == 3 && mCurPosId == 3) {
            // to left side
            mBar_start.x = 0;
            mBar_end.x = mBar_start.x;
//            mBar_line.setX(mBar_start.x + NUMView_Width / 3);
            mBarNumView.setX(mBar_start.x);
            mCurPosId = 2;
            mBarNumView.setBackgroundResource(R.drawable.page_number_v);
        }
    }

    private boolean mbDragging;
    private PointF mDownPoint;
    private float Movetmp;
    private float starttmp;
    private int Numtmp;
    private float Postmp;
    private float mOffsetX;
    private int startNum;
    private float lastPositionY = 0;

    private View.OnTouchListener mTouchListener = new View.OnTouchListener() {
        @Override
        public boolean onTouch(View view, MotionEvent event) {

            switch (event.getAction()) {
                case MotionEvent.ACTION_DOWN:
                    mUIExtensionsManager.stopHideToolbarsTimer();
                    mbDragging = false;
                    mOffsetX = mPdfViewCtrl.getOffset().x;
                    mDownPoint.set(event.getRawX(), event.getRawY());
                    startNum = mPdfViewCtrl.getCurrentPage();
                    break;

                case MotionEvent.ACTION_MOVE:
                    mbDragging = true;
//                    mBar_line.setVisibility(View.VISIBLE);
                    mPosition.x = event.getRawX();
                    mPosition.y = event.getRawY();
                    if (Math.abs(mDownPoint.x - mPosition.x) < 4) return true;

                    Movetmp = checkBorder();
                    NumViewMoveTo(Movetmp);
                    if (mCurPosId > 1 && mGraduation > 0) {
                        float distance = lastPositionY - mPosition.y;
                        if (Math.abs(distance) > 0) {
                            len = Movetmp - mBar_start.y;
                            numf = len / mGraduation;
                            posNum = (int) numf;

                            if (mPdfViewCtrl.isPageVisible(posNum)) {
                                float pageHeight = mPdfViewCtrl.getPageViewHeight(posNum);
                                float scrollY = distance / mGraduation * pageHeight;
                                mPdfViewCtrl.scrollView(0, -scrollY);
                            } else {
                                Numtmp = getNumAndPos(Movetmp);
                                mPdfViewCtrl.gotoPosition(Numtmp - 1, -mOffsetX, Postmp);
                            }
                        }
                    } else {
                        Numtmp = getNumByPosition(Movetmp);
                        int currentPage = mPdfViewCtrl.getCurrentPage();
                        if (Numtmp != currentPage) {
                            PointF devPt = new PointF(0, 0);
                            PointF viewPt = new PointF();
                            mPdfViewCtrl.convertDisplayViewPtToPageViewPt(devPt, viewPt, currentPage);

                            mPdfViewCtrl.gotoPage(Numtmp - 1, viewPt.x, viewPt.y);
                        }
//                        mToastNum.setText(String.valueOf(Numtmp));
//                        mToastView.setVisibility(View.VISIBLE);
//                        gotoPage(Numtmp);
                    }

                    lastPositionY = mPosition.y;
                    break;

                case MotionEvent.ACTION_UP:
                    mUIExtensionsManager.startHideToolbarsTimer();
//                    mBar_line.setVisibility(View.GONE);
                    if (!mbDragging || Math.abs(mDownPoint.x - mPosition.x) < 4) {
                        mbDragging = false;
//                        showInputNumDialog();
//                        mToastView.setVisibility(View.GONE);
                        return true;
                    }
                    if (mCurPosId > 1 && mGraduation > 0) {
                        //don't move
//                        gotoPagePos(startNum);
                    } else {
//                        gotoPage(startNum);
                        NumViewMoveTo(getPositionByNum(mPdfViewCtrl.getCurrentPage() + 1));
                    }
//                    mToastView.setVisibility(View.GONE);
                    mbDragging = false;
                    break;
            }
            return true;
        }
    };

    private float checkBorder() {
        if (mCurPosId > 1) {
            if (mPosition.y - rootViewVisibleRect.top <= mBar_start.y) {
                return mBar_start.y;
            } else if (mPosition.y - rootViewVisibleRect.top >= mBar_end.y) {
                return mBar_end.y;
            } else {
                return mPosition.y - rootViewVisibleRect.top;
            }
        } else {
            if (mPosition.x - rootViewVisibleRect.left <= mBar_start.x) {
                return mBar_start.x;
            } else if (mPosition.x - rootViewVisibleRect.left >= mBar_end.x) {
                return mBar_end.x;
            } else {
                return mPosition.x - -rootViewVisibleRect.left;
            }
        }
    }

    private void NumViewMoveTo(float position) {
        if (mCurPosId > 1) {
            mBarNumView.setY(position);
        } else {
            mBarNumView.setX(position);
        }
    }

    private float mGraduation;
    private float mHalfPageBarLength;

    private void countGraduation() {
        float counts = 1;
        float length = mBar_length;

        counts = mPdfViewCtrl.getPageCount();
        length -= NUMView_Width;

        if (counts == 1) {
            mGraduation = 1;
        } else {

//            if (mCurPosId > 1)
//                counts -= 0.5;
            if ((counts - 1) > length) {
                mGraduation = -((counts - 1) / length);
            } else {
                mGraduation = length / (counts - 1);
                mHalfPageBarLength = (float) (mGraduation * 0.5);
            }
        }

    }

    private float getPositionByNum(int pageNum) {
        if (pageNum == mPdfViewCtrl.getPageCount()) {
            if (mCurPosId > 1) {
                return mBar_end.y;
            } else {
                return mPdfViewCtrl.getPageBinding() == PDFViewCtrl.LEFT_EDGE ? mBar_end.x : mBar_start.x;
            }
        }

        if (pageNum == 1) {
            if (mCurPosId > 1) {
                return mBar_start.y;
            } else {
                return mPdfViewCtrl.getPageBinding() == PDFViewCtrl.LEFT_EDGE ? mBar_start.x : mBar_end.x;
            }
        }

        float length = 0;
        if (mGraduation > 0) {
            if (mCurPosId > 1 || mPdfViewCtrl.getPageBinding() == PDFViewCtrl.LEFT_EDGE) {
                length = (pageNum - 1) * mGraduation;
                if (mPdfViewCtrl.getPageLayoutMode() == PDFViewCtrl.PAGELAYOUTMODE_COVER) {
                    length = (pageNum) * mGraduation;
                }
            } else {
                length = (mPdfViewCtrl.getPageCount() - pageNum) * mGraduation;
                if (mPdfViewCtrl.getPageLayoutMode() == PDFViewCtrl.PAGELAYOUTMODE_COVER) {
                    length = (mPdfViewCtrl.getPageCount() - (pageNum + 1)) * mGraduation;
                }
            }
        } else {
            length = (pageNum / Math.abs(mGraduation));
        }

        if (mCurPosId > 1) {
            return Math.min(mBar_start.y + length, mBar_end.y);
        } else {
            return Math.min(mBar_start.x + length, mBar_end.x);
        }
    }

    float len;
    int num;
    int pageCount;
    int mend;
    float numf;

    private int getNumByPosition(float pos) {
        pageCount = mPdfViewCtrl.getPageCount();

        if (mGraduation > 0) {
            if (mGraduation > 20) mend = 1;
            else mend = 0;

            if (mCurPosId > 1) {
                if (pos == mBar_start.y) return 1;
                else if (pos == mBar_end.y)
                    return pageCount;
                else {
                    len = pos - mBar_start.y;
                    num = (int) (len / mGraduation + mend);
                }

            } else {
                if (mPdfViewCtrl.getPageBinding() == PDFViewCtrl.LEFT_EDGE) {
                    if (pos == mBar_start.x)
                        return 1;
                    else if (pos == mBar_end.x)
                        return pageCount;
                    else {
                        len = pos - mBar_start.x;
                        num = (int) (len / mGraduation + mend);
                    }
                } else {
                    if (pos == mBar_start.x) {
                        return pageCount;
                    } else if (pos == mBar_end.x) {
                        return 1;
                    } else {
                        len = pos - mBar_start.x;
                        java.text.DecimalFormat df = new java.text.DecimalFormat("0.00");
                        String numStr = df.format(len / mGraduation);
                        String[] nums = numStr.split("\\.");
                        int num1 = Integer.parseInt(nums[0]);
                        num = pageCount - num1;

                        int num2 = Integer.parseInt(nums[1]); // If the remainder is greater than 50, it means that the slide is more than half and switches to the pre page.
                        if (num2 > 50) {
                            num = Math.max(0, num - 1);
                        }
                    }
                }
            }

        } else {
            if (mCurPosId > 1) {
                if (pos == mBar_start.y)
                    return 1;
                else if (pos == mBar_end.y)
                    return pageCount;
                else {
                    len = pos - mBar_start.y;
                    num = (int) (len * Math.abs(mGraduation));
                }
            } else {
                if (mPdfViewCtrl.getPageBinding() == PDFViewCtrl.LEFT_EDGE) {
                    if (pos == mBar_start.x)
                        return 1;
                    else if (pos == mBar_end.x)
                        return pageCount;
                    else {
                        len = pos - mBar_start.x;
                        num = (int) (len * Math.abs(mGraduation));
                    }
                } else {
                    if (pos == mBar_start.x) {
                        return pageCount;
                    } else if (pos == mBar_end.x) {
                        return 1;
                    } else {
                        len = pos - mBar_start.x;
                        java.text.DecimalFormat df = new java.text.DecimalFormat("0.00");
                        String numStr = df.format(len / mGraduation);
                        String[] nums = numStr.split("\\.");
                        int num1 = Integer.parseInt(nums[0]);
                        num = pageCount - num1;

                        int num2 = Integer.parseInt(nums[1]); // If the remainder is greater than 50, it means that the slide is more than half and switches to the pre page.
                        if (num2 > 50) {
                            num = Math.max(0, num - 1);
                        }
                    }
                }
            }
        }

        if (num > pageCount) {
            return pageCount;
        }
        return num;
    }

    //page Num. and  page Pos  ------- pageView -> Continue
    int posNum;
    float layoutHeight;

    private int getNumAndPos(float barPos) {
        Postmp = 0;
        if (barPos == mBar_start.y) return 1;
        else if (barPos == mBar_end.y)
            return mPdfViewCtrl.getPageCount();
        else {
            len = barPos - mBar_start.y;
            if (len >= mHalfPageBarLength)
                len += mHalfPageBarLength;
            numf = len / mGraduation;
            posNum = (int) numf;

            layoutHeight = mUIExtensionsManager.getMainFrame().getContentView().getHeight();

            if (mPdfViewCtrl.isPageVisible(posNum)) {
                if (posNum == 0)
                    Postmp = (numf - posNum) * mPdfViewCtrl.getPageViewHeight(posNum) + layoutHeight / 2;
                else
                    Postmp = (numf - posNum) * mPdfViewCtrl.getPageViewHeight(posNum);
                Postmp = Postmp - layoutHeight / 2;
            } else {
                float pvHeight = 279;//mPdfViewCtrl.getDefaultPageHeight(posNum); //TODO
                if (posNum == 0)
                    Postmp = (numf - posNum) * pvHeight + layoutHeight / 2;
                else
                    Postmp = (numf - posNum) * pvHeight;
                Postmp = Postmp - layoutHeight / 2;
            }
        }

        return posNum + 1;
    }

    public void onCurrentPageChanged(int pageNum) {
        if (mbDragging) return;

        NumViewMoveTo(getPositionByNum(pageNum));
//        setNum(pagenum);
    }

    private float Ypos;
    private float barPos;

    public void onPageScrolled(int index) {
        if (mbDragging) return;
//                App.instance().getRead().getDocViewer().getReadingStatus().mY));
        if (mCurPosId > 1 && mGraduation > 0) {
            Ypos = mPdfViewCtrl.getOffset().y;
            layoutHeight = mUIExtensionsManager.getMainFrame().getContentView().getHeight();
//            IDV_PageView pv = App.instance().getRead().getDocViewer().getPageView(index);
            Ypos = layoutHeight / 2 - Ypos;
            if (divideBigDecimal(Ypos, mPdfViewCtrl.getPageViewHeight(index), 2) < 0.6 && index == 0) {
                barPos = mBar_start.y;
            } else {
                numf = divideBigDecimal(Ypos, mPdfViewCtrl.getPageViewHeight(index), 2) + index;

                len = numf * mGraduation;
                barPos = len + mBar_start.y;
                if (index == 0) {
                    barPos = mBar_start.y;
                }
                if (barPos <= mBar_start.y) {
                    barPos = mBar_start.y;
                } else if (barPos >= mBar_end.y) {
                    barPos = mBar_end.y;
                }

            }
            NumViewMoveTo(barPos);
        }

    }

    private float divideBigDecimal(float v1, float v2, int scale) {
        if (v1 == 0 || v2 == 0) {
            return 0;
        }
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.divide(b2, scale, BigDecimal.ROUND_HALF_UP).floatValue();
    }

    public boolean isFullWidth() {
        return mPaddingRight == AppDisplay.dp2px(10);
    }

    private int mPreNum;

    private void gotoPage(int pagenum) {
        if (mPreNum != pagenum) {
            mPreNum = pagenum;
            mPdfViewCtrl.addNodePage(mPreNum);
//            setNum(pagenum);
        }
    }

    private void gotoPagePos(int pagenum) {
        mPdfViewCtrl.addNodePage(pagenum);
//        setNum(pagenum);
    }

    public void show() {
        if (SystemUiHelper.getInstance().isFullScreen()) return;
        if (mPageNavBarVisible) {
            mBarNumView.setVisibility(View.VISIBLE);
        }
    }

    public void hide() {
        mBarNumView.setVisibility(View.GONE);
//        mBar_line.setVisibility(View.GONE);
//        mToastView.setVisibility(View.GONE);
    }

    public boolean isVisible() {
        return mBarNumView.getVisibility() == View.VISIBLE;
    }

    public void setLayoutVisible(boolean visible) {
        ViewGroup readView = mUIExtensionsManager.getMainFrame().getContentView();
//        if (visible) {
//            if (GuideMaskView.getInstance().isVisible()) {
//                int index = readView.indexOfChild(GuideMaskView.getInstance().getRootView());
//                readView.addView(mBar_line, index -1);
//                readView.addView(mBarNumView, index -1);
//                readView.addView(mToastView, index -1);
//            } else {
//                readView.addView(mBar_line);

        readView.addView(mBarNumView);
//        readView.addView(mBarNumView);
//                readView.addView(mToastView);
//            }
//        } else {
//            readView.removeView(mBar_line);
//            readView.removeView(mBarNumView);
//            readView.removeView(mToastView);
//        }

    }

    private void showInputNumDialog() {
        final UITextEditDialog dialog = new UITextEditDialog(mUIExtensionsManager.getAttachedActivity());
        dialog.setTitle(AppResource.getString(mContext, R.string.rd_gotopage_toolbar_go));
        final TextView PromptText = dialog.getPromptTextView();
        final EditText editText = dialog.getInputEditText();
        final View okButton = dialog.getOKButton();
        String entet_str = AppResource.getString(mContext, R.string.rv_gotopage_error_toast) +
                " (" + (mPdfViewCtrl.getCurrentPage() + 1) + "/" + mPdfViewCtrl.getPageCount() + ")";

        editText.setInputType(InputType.TYPE_CLASS_NUMBER);
        editText.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

            }

            @Override
            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                if (!editText.getText().toString().trim().equals("")) {
                    int number = Integer.valueOf(editText.getText().toString());
                    if (0 < number && number <= mPdfViewCtrl.getPageCount()) {
                        okButton.setEnabled(true);
                    } else {
//                        int count = App.instance().getRead().getDocViewer().getDocument().getPageCount();
//                        String str = AppResource.getString(App.instance().getAppActivity(),
//                                "rv_gotopage_error_toast", R.string.rv_gotopage_error_toast)
//                                + " " + "(1-" + String.valueOf(count) + ")";
//                        PromptText.setText(str);
                        editText.selectAll();
                        okButton.setEnabled(false);
                    }
                }

            }

            @Override
            public void afterTextChanged(Editable editable) {

            }
        });

        dialog.getCancelButton().setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                dialog.dismiss();
            }
        });

        okButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                int number = Integer.parseInt(editText.getText().toString());
                mPdfViewCtrl.gotoPage(number - 1, 0, 0);
                dialog.dismiss();
            }
        });


        PromptText.setText(entet_str);
        dialog.getOKButton().setEnabled(false);
        dialog.show();
//        AppKeyboardUtil.showSoftInput(editText);
        AppKeyboardUtil.showInputMethodWindow(mContext, editText);

    }

//    private void needReset() {
//        RD_PageNumberJump pageNumberJump = (RD_PageNumberJump) App.instance().getModuleByName(AppModuleConfig.MODULE_NAME_PAGENUMBERJUMP);
//        pageNumberJump.checkJumpLayout();
//    }

    private int mLastReadState;

    public void onChangeReadMode() {
        if (!AppDisplay.isPad()) return;
        if (mLastReadState == mUIExtensionsManager.getState())
            return;

        int toolbarPos = 1;//App.instance().getSP().getInteger(AppSetting.SHARED_PREFERENCE_ANNOTATION, UIAnnotToolbar.SP_BAR_POSITION, 1);
        mLastReadState = ReadStateConfig.STATE_NORMAL;
        if (mCurPosId == 2) {
            update(0, 2);
        }

        if (mCurPosId == 1)
            update(0, 1);

//        float tmp = readViewH - AppResource.getDimension(mContext, R.dimen.ui_bottombar_height) - mJumpView.getHeight();
//        mJumpView.setY(tmp);
    }

    private final IThemeEventListener mThemeEventListener = new IThemeEventListener() {
        @Override
        public void onThemeColorChanged(String type, int color) {
            if (mBarImage != null) {
                int primaryColor = ThemeConfig.getInstance(mContext).getPrimaryColor();
                ThemeUtil.setTintList(mBarImage, ColorStateList.valueOf(primaryColor));
            }

            if (mBarNumView != null) {
                int b2 = ThemeConfig.getInstance(mContext).getB2();
                ThemeUtil.setTintList(mBarNumView, ColorStateList.valueOf(b2));
            }
        }
    };

    private boolean mPageNavBarVisible = true;

    void setVisible(boolean visible) {
        mPageNavBarVisible = visible;
    }

    public void setPadPos(int pos) {
        mPos = pos;
    }

}
