/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.modules.pagenavigation;


import com.foxit.sdk.PDFException;
import com.foxit.sdk.pdf.PDFDoc;
import com.foxit.sdk.pdf.PageLabels;

public class LogicalPageHelper {

    private static LogicalPageHelper instance;

    private boolean mSupportLogicalPage = false;

    private LogicalPageHelper() {
    }

    public static LogicalPageHelper getInstance() {
        if (instance == null)
            instance = new LogicalPageHelper();
        return instance;
    }

    public boolean isSupportLogicalPage() {
        return mSupportLogicalPage;
    }

    public void setSupportLogicalPage(boolean support) {
        mSupportLogicalPage = support;
    }

    public String getLogicalPageNumber(int pageIndex, PageLabels pageLabels) {
        try {
            return pageLabels.getPageLabelTitle(pageIndex);
        } catch (PDFException e) {
            e.printStackTrace();
        }
        return pageIndex + "";
    }

    public String getLogicalPageNumber(int pageIndex, PDFDoc doc) {
        try {
            PageLabels pageLabels = new PageLabels(doc);
            String title = pageLabels.getPageLabelTitle(pageIndex);
            pageLabels.delete();
            return title;
        } catch (PDFException e) {
            e.printStackTrace();
        }
        return pageIndex + "";
    }

    public void release() {
        mSupportLogicalPage = false;
    }

}
