/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.event;


import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

import androidx.annotation.IntDef;

public interface IUISaveasEventListener {
    int SAVE_BY_SIGNATURE = 0;

    @IntDef({
            SAVE_BY_SIGNATURE
    })
    @Retention(RetentionPolicy.SOURCE)
    public @interface SaveasEventType {
    }

    boolean isAvailablePath(String path);

    void saveasBegin(String path);

    void saveasFinished(boolean success, String path);

    boolean shouldReOpenDoc(String path);

    @SaveasEventType int getEventType();
}
