/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.controls.toolbar.tabmenu;

import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Configuration;
import android.view.View;

import com.foxit.uiextensions.IThemeEventListener;
import com.foxit.uiextensions.R;
import com.foxit.uiextensions.UIExtensionsManager;
import com.foxit.uiextensions.controls.dialog.UIMatchDialog;
import com.foxit.uiextensions.controls.toolbar.BaseBar;
import com.foxit.uiextensions.controls.toolbar.ToolItemBean;
import com.foxit.uiextensions.controls.toolbar.ToolbarItemConfig;
import com.foxit.uiextensions.controls.toolbar.drag.UIToolBaseBar;
import com.foxit.uiextensions.pdfreader.IMainFrame;
import com.foxit.uiextensions.utils.AppResource;

import java.util.List;

import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.ItemTouchHelper;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

public class SortToolsDialog extends UIMatchDialog {

    private Context mContext;
    private UIExtensionsManager mUiExtensionsManager;
    private SortToolsAdapter mAdapter;
    private List<ToolItemBean> mToolList;
    private int mType = 0;

    public SortToolsDialog(Context context, UIExtensionsManager uiExtensionsManager, int type) {
        super(context);
        mContext = context.getApplicationContext();;
        mUiExtensionsManager = uiExtensionsManager;
        mType = type;
        initStyle();
        initView();

        setOnShowListener(new OnShowListener() {
            @Override
            public void onShow(DialogInterface dialog) {
                mUiExtensionsManager.stopHideToolbarsTimer();
                mUiExtensionsManager.registerConfigurationChangedListener(configurationChangedListener);
            }
        });
        setOnDLDismissListener(new DismissListener() {
            @Override
            public void onDismiss() {
                if(mAdapter.mUpdateMove) {
                    IMainFrame mainFrame = mUiExtensionsManager.getMainFrame();
                    UIToolBaseBar curToolbar = mainFrame.getCurToolbar();
                    if (curToolbar != null) {
                        curToolbar.setToolItems(curToolbar.getToolItems());
                    }

                    if (!mainFrame.isToolbarsVisible()) {
                        mUiExtensionsManager.getMainFrame().showToolbars();
                    }
                    mAdapter.mUpdateMove = false;
                }
                mUiExtensionsManager.startHideToolbarsTimer();
                mUiExtensionsManager.unregisterThemeEventListener(mThemeColorChangedListener);
                mUiExtensionsManager.unregisterConfigurationChangedListener(configurationChangedListener);
            }
        });
    }

    public void setData(List<ToolItemBean> toolList) {
        mToolList = toolList;
        mAdapter.setData(mToolList);
        mAdapter.notifyUpdateData();
    }

    public  void setViewNight(boolean isNight){
        mAdapter.setViewNight(isNight);
    }

    public boolean getViewNight(){
        return  mAdapter.mIsNight;
    }

    private void initStyle(){
        setBackButtonStyle(TEXT_BACK);
        setBackButtonText(AppResource.getString(mContext, R.string.fx_string_close));
        String title = "";

        if (mType == ToolbarItemConfig.ITEM_EDIT_TAB) {
            title = AppResource.getString(mContext, R.string.fx_string_edit);
        }else if (mType == ToolbarItemConfig.ITEM_COMMENT_TAB) {
            title = AppResource.getString(mContext, R.string.fx_string_comment);
        } else if (mType == ToolbarItemConfig.ITEM_DRAWING_TAB) {
            title = AppResource.getString(mContext, R.string.mt_drawing);
        } else if (mType == ToolbarItemConfig.ITEM_VIEW_TAB) {
            title = AppResource.getString(mContext, R.string.rd_bar_setting);
        } else if (mType == ToolbarItemConfig.ITEM_FORM_TAB) {
            title = AppResource.getString(mContext, R.string.menu_more_group_form);
        } else if (mType == ToolbarItemConfig.ITEM_FILLSIGN_TAB) {
            title = AppResource.getString(mContext, R.string.fx_topbar_fillsign);
        } else if (mType == ToolbarItemConfig.ITEM_PROTECT_TAB) {
            title = AppResource.getString(mContext, R.string.menu_more_group_protect);
        } else if (mType == ToolbarItemConfig.ITEM_ESIGN_TAB) {
            title = AppResource.getString(mContext, R.string.esign_top_menu_title);
        }
        setTitle(title);
        setTitlePosition(BaseBar.TB_Position.Position_CENTER);
//        setRightButtonVisible(View.VISIBLE);
        setStyle(DLG_TITLE_STYLE_BG_DEFAULT);
        setListener(new DialogListener() {
            @Override
            public void onResult(long btType) {
            }

            @Override
            public void onBackClick() {

            }

            @Override
            public void onTitleRightButtonClick() {

            }
        });
    }

    private  void initView(){
        View tabMenuView = View.inflate(mContext, R.layout.sort_tools_dialog, null);
        RecyclerView recyclerView = tabMenuView.findViewById(R.id.sort_tools_rv);
        mAdapter = new SortToolsAdapter(mContext,mUiExtensionsManager,mType);
        recyclerView.setAdapter(mAdapter);
        setContentView(tabMenuView);
        LinearLayoutManager linearLayoutManager = new LinearLayoutManager(mContext, LinearLayoutManager.VERTICAL, false);
        recyclerView.setLayoutManager(linearLayoutManager);
        recyclerView.setItemAnimator(new DefaultItemAnimator());
        ItemTouchHelper.Callback callback = new SortToolsItemTouchHelper(mAdapter);
        ItemTouchHelper itemTouchHelper = new ItemTouchHelper(callback);
        itemTouchHelper.attachToRecyclerView(recyclerView);
    }



    private IThemeEventListener mThemeColorChangedListener = new IThemeEventListener() {
        @Override
        public void onThemeColorChanged(String type, int color) {
            dismiss();
        }
    };

    private final UIExtensionsManager.ConfigurationChangedListener configurationChangedListener = new UIExtensionsManager.ConfigurationChangedListener() {
        @Override
        public void onConfigurationChanged(Configuration newConfig) {
            if (isShowing()) {
                resetWH();
                showDialog();
            }
        }
    };
}
