/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.controls.toolbar.tabmenu;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.foxit.uiextensions.R;
import com.foxit.uiextensions.UIExtensionsManager;
import com.foxit.uiextensions.browser.adapter.SuperAdapter;
import com.foxit.uiextensions.browser.adapter.viewholder.SuperViewHolder;
import com.foxit.uiextensions.controls.toolbar.IToolSupply;
import com.foxit.uiextensions.controls.toolbar.ToolConstants;
import com.foxit.uiextensions.controls.toolbar.ToolItemBean;
import com.foxit.uiextensions.controls.toolbar.ToolbarItemConfig;
import com.foxit.uiextensions.controls.toolbar.impl.ToolSupplyBtnImpl;
import com.foxit.uiextensions.controls.toolbar.impl.ToolSupplyImpl;
import com.foxit.uiextensions.modules.panel.bean.BaseBean;
import com.foxit.uiextensions.theme.ThemeUtil;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;


class SortToolsAdapter extends SuperAdapter<ToolItemBean>
        implements SortToolsItemTouchHelper.ItemTouchHelperCallback {

    private UIExtensionsManager mUIExtensionsManager;
    private List<ToolItemBean> mToolList = new ArrayList<>();
    private Context mContext;
    private boolean mIsLongPressDragEnabled = true;
    private int mType = 0;
    private int mMoveStartPosition = 0;
    private int mMoveEndPosition = 0;
    protected boolean mUpdateMove = false;
    protected   boolean mIsNight = false;
    public SortToolsAdapter(Context context, UIExtensionsManager uiExtensionsManager,int type) {
        super(context);
        mContext = context;
        mUIExtensionsManager = uiExtensionsManager;
        mType = type;
    }

    protected void setViewNight(boolean isNight){
        mIsNight = isNight;
    }

    protected  void setData(List<ToolItemBean> toolList){
        mToolList = toolList;
    }

    @Override
    public void notifyUpdateData() {
        notifyDataSetChanged();
    }

    @Override
    public ToolItemBean getDataItem(int position) {
        return mToolList.get(position);
    }

    @NonNull
    @Override
    public SuperViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(getContext()).inflate(R.layout.top_bar_tab_menu_content, parent, false);
        return new ContentItemViewHolder(view);
    }

    @Override
    public int getItemCount() {
        return mToolList.size();
    }

    @Override
    public boolean isLongPressDragEnabled() {
        return mIsLongPressDragEnabled;
    }

    @Override
    public void onMoveStart(RecyclerView.ViewHolder viewHolder) {
        viewHolder.itemView.setScaleX(1.05f);
        viewHolder.itemView.setScaleY(1.05f);
        mMoveStartPosition = viewHolder.getAdapterPosition();

    }

    @Override
    public boolean onMove(RecyclerView.ViewHolder viewHolder, int fromPosition, int toPosition) {
        Collections.swap(mToolList, fromPosition, toPosition);
        notifyItemMoved(fromPosition, toPosition);
        return true;
    }

    @Override
    public void onMoveEnd(RecyclerView.ViewHolder viewHolder) {
        viewHolder.itemView.setScaleX(1.0f);
        viewHolder.itemView.setScaleY(1.0f);
        mMoveEndPosition = viewHolder.getAdapterPosition();
        if(mMoveStartPosition != mMoveEndPosition){
            mUpdateMove =true;
        }
    }

    class ContentItemViewHolder extends SuperViewHolder {

        private final TextView mItemDetailTv;
        private final ImageView mItemIconView;

        public ContentItemViewHolder(View itemView) {
            super(itemView);
            mItemDetailTv = itemView.findViewById(R.id.tab_item_content_text);
            mItemIconView = itemView.findViewById(R.id.tab_item_content_icon);
            itemView.findViewById(R.id.tab_item_content_ll).setOnClickListener(this);
        }

        @Override
        public void bind(BaseBean data, int position) {
            ToolItemBean itemBean = (ToolItemBean) data;
            int resId = 0;
            int iconId = 0;
            if(mType == ToolbarItemConfig.ITEM_VIEW_TAB) {
                resId = getViewToolName(itemBean.type);
                iconId = getViewToolIcon(itemBean.type);
                if(resId !=0 && iconId !=0){
                    mItemDetailTv.setText(resId);
                    mItemIconView.setImageResource(iconId);
                    ThemeUtil.setTintList(mItemIconView, ThemeUtil.getListIconColor(getContext()));
                    ThemeUtil.setTintList(mItemDetailTv, ThemeUtil.getListTextColor(getContext()));
                }
//            }else if (mType == ToolbarItemConfig.ITEM_PROTECT_TAB){
//                final IToolSupply toolSupply = mUIExtensionsManager.getToolsManager().getToolSupply(itemBean.type);
//                if (toolSupply instanceof  ToolSupplyBtnImpl) {
//                    String toolName= ((ToolSupplyBtnImpl) toolSupply).getToolName(itemBean.type);
//                    iconId = ((ToolSupplyBtnImpl) toolSupply).getColorItem().getImageResId();
//                    if(toolName !=null && iconId !=0) {
//                        mItemDetailTv.setText(toolName);
//                        mItemIconView.setImageResource(iconId);
//                        ThemeUtil.setTintList(mItemIconView, ThemeUtil.getListIconColor(getContext()));
//                        ThemeUtil.setTintList(mItemDetailTv, ThemeUtil.getListTextColor(getContext()));
//                    }
//                }
            }else if (mType == ToolbarItemConfig.ITEM_ESIGN_TAB){
                final IToolSupply toolSupply = mUIExtensionsManager.getToolsManager().getToolSupply(itemBean.type);
                if (toolSupply instanceof ToolSupplyImpl) {
                    String toolName= ((ToolSupplyImpl) toolSupply).getToolName(itemBean.type);
                    iconId = ((ToolSupplyImpl) toolSupply).getToolBackgroundResource(itemBean.type);
                    if(toolName !=null && iconId !=0) {
                        mItemDetailTv.setText(toolName);
                        mItemIconView.setImageResource(iconId);
                        ThemeUtil.setTintList(mItemIconView, ThemeUtil.getListIconColor(getContext()));
                        ThemeUtil.setTintList(mItemDetailTv, ThemeUtil.getListTextColor(getContext()));
                    }
                }
            }else{
                resId = mUIExtensionsManager.getToolsManager().getToolStrId(itemBean.type);
                iconId = mUIExtensionsManager.getToolsManager().getToolIcon(itemBean.type);
                if(resId !=0 && iconId !=0){
                    mItemDetailTv.setText(resId);
                    mItemIconView.setImageResource(iconId);
                    ThemeUtil.setTintList(mItemIconView, ThemeUtil.getListIconColor(getContext()));
                    ThemeUtil.setTintList(mItemDetailTv, ThemeUtil.getListTextColor(getContext()));
                }
            }
        }

        @Override
        public void onClick(View v) {

        }
    }
    private int getViewToolIcon(int type) {
        int iconId = 0;
        if(type == ToolConstants.TypeSinglePage){
            iconId = R.drawable.view_setting_page_setting_pad;
        }else if(type == ToolConstants.TypeDay){
            if(mIsNight){
                iconId = R.drawable.view_setting_night_ipad;
            }else{
                iconId = R.drawable.view_setting_day_ipad;
            }
        }else if(type == ToolConstants.TypePageColor){
            iconId = R.drawable.view_setting_page_color_ipad;
        }else if(type == ToolConstants.TypeFitPage){
            iconId = R.drawable.view_settings_fit_page;
        }else if(type == ToolConstants.TypeFitWidth){
            iconId = R.drawable.view_settings_fit_width;
        }else if(type == ToolConstants.TypeReflow){
            iconId = R.drawable.view_settings_reflow;
        }else if(type == ToolConstants.TypeCrop){
            iconId = R.drawable.view_settings_crop;
        }else if(type == ToolConstants.TypeTts){
            iconId = R.drawable.view_settings_speak;
        }else if(type == ToolConstants.TypeAutoFlip){
            iconId = R.drawable.view_settings_auto_flip;
        }else if(type == ToolConstants.TypeRotateView){
            iconId = R.drawable.view_settings_rotate;
        }else if(type == ToolConstants.TypePanZoom){
            iconId = R.drawable.view_settings_pan_zoom;
        }
        return  iconId;
    }
    private int getViewToolName(int type){
        int resId = 0;
        if(type == ToolConstants.TypeSinglePage){
            resId = R.string.bottom_bar_view_setting;
        }else if(type == ToolConstants.TypeDay){
            if(mIsNight){
                resId = R.string.ml_day_night;
            }else{
                resId = R.string.view_day_mode;
            }
        }else if(type == ToolConstants.TypePageColor){
            resId = R.string.view_setting_page_color;
        }else if(type == ToolConstants.TypeFitPage){
            resId = R.string.rd_fitpage_topbar_title;
        }else if(type == ToolConstants.TypeFitWidth){
            resId = R.string.rd_fitwidth_topbar_title;
        }else if(type == ToolConstants.TypeReflow){
            resId = R.string.rd_reflow_topbar_title;
        }else if(type == ToolConstants.TypeCrop){
            resId = R.string.rd_crop_topbar_title;
        }else if(type == ToolConstants.TypeTts){
            resId = R.string.rd_tts_speak;
        }else if(type == ToolConstants.TypeAutoFlip){
            resId = R.string.view_setting_auto_flip;
        }else if(type == ToolConstants.TypeRotateView){
            resId = R.string.rd_rotateview_topbar_title;
        }else if(type == ToolConstants.TypePanZoom){
            resId = R.string.rd_panzoom_topbar_title;
        }
        return  resId;
    }
}
