/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.controls.toolbar.impl;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;

import com.foxit.uiextensions.R;
import com.foxit.uiextensions.controls.toolbar.IBaseItem;
import com.foxit.uiextensions.utils.AppDisplay;
import com.foxit.uiextensions.utils.AppResource;
import com.foxit.uiextensions.utils.AppUtil;

import java.util.ArrayList;
import java.util.List;

public class TopBarImpl extends BaseBarImpl {
    private LinearLayout mTopBarRealRootLayout = null;

    private IBaseItem mExpandItem;
    private boolean mShowSolidLine = true;
    protected int mBarHeight = 56;
    protected int mSolidLineHeight = 1;
    View solidLine;

    public TopBarImpl(Context context) {
        super(context, HORIZONTAL);

        initDimens();
        initOrientation(HORIZONTAL, ViewGroup.LayoutParams.MATCH_PARENT, mBarHeight);
    }

    @Override
    public View getContentView() {
        if (mOrientation == HORIZONTAL && mTopBarRealRootLayout == null && mShowSolidLine) {
            mTopBarRealRootLayout = new LinearLayout(mRootLayout.getContext());
            mTopBarRealRootLayout.setOrientation(LinearLayout.VERTICAL);
            mTopBarRealRootLayout.addView(mRootLayout);

            solidLine = new View(mRootLayout.getContext());
            solidLine.setBackgroundColor(AppResource.getColor(mContext, R.color.p1));
            mTopBarRealRootLayout.addView(solidLine);
            solidLine.getLayoutParams().width = ViewGroup.LayoutParams.MATCH_PARENT;
            solidLine.getLayoutParams().height = dip2px_fromDimens(mSolidLineHeight);
        }
        if (mOrientation == HORIZONTAL && mTopBarRealRootLayout != null && mShowSolidLine) {
            return mTopBarRealRootLayout;
        } else {
            return mRootLayout;
        }
    }

    public void setShowSolidLineColor(int color) {
        if (solidLine != null) {
            solidLine.setBackgroundColor(color);
        }
    }

    public void setShowSolidLine(boolean show) {
        mShowSolidLine = show;
    }

    @Override
    public void setVisible(boolean visible) {
        int visibility = 0;
        if (visible) {
            visibility = View.VISIBLE;
        } else {
            visibility = View.INVISIBLE;
        }
        if (mOrientation == HORIZONTAL && mTopBarRealRootLayout != null)
            mTopBarRealRootLayout.setVisibility(visibility);
        else
            mRootLayout.setVisibility(visibility);
    }

    private void initDimens() {
        try {
            mBarHeight = AppResource.getDimensionPixelSize(mContext, R.dimen.ux_topbar_height);//used dp2px
        } catch (Exception e) {
            mBarHeight = dip2px(mBarHeight);
        }
        try {
            mSolidLineHeight = AppResource.getDimensionPixelSize(mContext, R.dimen.ux_list_divider_height);//used dp2px
        } catch (Exception e) {
            mSolidLineHeight = dip2px(mSolidLineHeight);
        }
    }

    @Override
    public boolean addView(IBaseItem item, TB_Position position) {
        boolean success = super.addView(item, position);
        updateTabLayout();
        return success;
    }

    @Override
    public boolean addView(IBaseItem item, TB_Position position, int index) {
        boolean success = super.addView(item, position, index);
        if(!AppDisplay.isPad() && mAddTabItemHandler!=null){
            mAddTabItemHandler.addTabItemHandler();
        }
        updateTabLayout();

        return success;
    }

    public boolean addTabItem(IBaseItem item) {
        mCenter_Items.add(item);
        mCenterLayout.setVisibility(View.VISIBLE);

        int index = -1;
        if (mExpandItem != null) {
            index = mCenterLayout.indexOfChild(mExpandItem.getContentView());
        }

        AppUtil.removeViewFromParent(item.getContentView());
        if (index != -1) {
            mCenterLayout.addView(item.getContentView(), index, mCenterItemLayoutParams);
        } else {
            mCenterLayout.addView(item.getContentView(), mCenterItemLayoutParams);
        }
        boolean overflow = updateTabLayout();
        return !overflow;
    }

    public void resetTabLayout(List<IBaseItem> onToolItems) {
        for (int i = 0; i < mCenter_Items.size(); i++) {
            mCenterLayout.removeView(mCenter_Items.get(i).getContentView());
        }
        mCenter_Items.clear();
        for (int i = 0; i < onToolItems.size(); i++) {
            boolean ret = addTabItem(onToolItems.get(i));
            if (!ret)
                break;
        }
    }

    private boolean updateTabLayout() {
        if (!AppDisplay.isPad()) return true;

        boolean isLayoutOverlap = isLayoutOverlap();
        boolean overflow = false;
        while (isLayoutOverlap) {
            if (mCenter_Items.size() == 0) break;

            IBaseItem removeItem = mCenter_Items.get(mCenter_Items.size() - 1);
            mCenter_Items.remove(removeItem);
            mCenterLayout.removeView(removeItem.getContentView());

            isLayoutOverlap = isLayoutOverlap();
            overflow = true;
        }
        return overflow;
    }

    public void moveTabItem(int movePosition, IBaseItem item) {
        if (mCenter_Items.contains(item)) {
            mCenter_Items.remove(item);
            mCenterLayout.removeView(item.getContentView());
            mCenter_Items.add(movePosition, item);
            mCenterLayout.addView(item.getContentView(), movePosition, mCenterItemLayoutParams);
        }
    }

    public boolean addTabItem(int index, IBaseItem item) {
        if (index <= mCenter_Items.size()) {
            mCenter_Items.add(index, item);
            AppUtil.removeViewFromParent(item.getContentView());
            mCenterLayout.addView(item.getContentView(), index, mCenterItemLayoutParams);
            boolean overflow = updateTabLayout();
            return !overflow;
        }
        return true;
    }

    public boolean containsTabItam(IBaseItem tabItem) {
        return mCenter_Items.contains(tabItem);
    }

    public void removeTabItem(IBaseItem item) {
        mCenter_Items.remove(item);
        mCenterLayout.removeView(item.getContentView());
    }

    public IBaseItem addExpandItem() {
        mCenterLayout.setVisibility(View.VISIBLE);
        mExpandItem = new BaseItemImpl(mContext, R.drawable.top_pop_expand_icon);
        mCenterLayout.addView(mExpandItem.getContentView(), mLastItemLayoutParams);
        return mExpandItem;
    }

    public boolean isLayoutOverlap() {
        int xSpec = View.MeasureSpec.makeMeasureSpec(0, View.MeasureSpec.UNSPECIFIED);
        int ySpec = View.MeasureSpec.makeMeasureSpec(0, View.MeasureSpec.UNSPECIFIED);

        mLTLayout.measure(xSpec, ySpec);
        mCenterLayout.measure(xSpec, ySpec);
        mRBLayout.measure(xSpec, ySpec);

        int widthL = mLTLayout.getMeasuredWidth();
        int widthC = mCenterLayout.getMeasuredWidth();
        int widthR = mRBLayout.getMeasuredWidth();
        int leftSpace = AppResource.getDimensionPixelSize(mContext, R.dimen.ux_pad_center_marginleft);
        int rightSpace = AppResource.getDimensionPixelSize(mContext, R.dimen.ux_pad_center_marginright);

        int activityWidth = AppDisplay.getActivityWidth(); // AppDisplay.getRawScreenWidth()  for Chrome OS
        boolean isLeftLayoutOverlap = (getStartMargin() + widthL + widthC / 2 + leftSpace) > activityWidth / 2;
        boolean isRightLayoutOverlap = (getEndMargin() + widthR + widthC / 2 + rightSpace) > activityWidth / 2;
        return isLeftLayoutOverlap || isRightLayoutOverlap;
    }

    public  int getLeftWidth(){
        return mLTLayout.getWidth();
    }
    public  int getRightWidth(){
        return mRBLayout.getWidth();
    }
    public  LinearLayout getCenterLayout(){
        return  mCenterLayout;
    }

    public  AddTabItemHandler mAddTabItemHandler;
    public  void setAddTabItemHandler(AddTabItemHandler addTabItemHandler){
        mAddTabItemHandler = addTabItemHandler;
    }

    public interface AddTabItemHandler {
        void addTabItemHandler();
    }
}
