/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.controls.toolbar.impl;


import android.content.Context;

import com.foxit.uiextensions.R;
import com.foxit.uiextensions.controls.toolbar.IToolSupply;
import com.foxit.uiextensions.controls.toolbar.TBUtils;
import com.foxit.uiextensions.controls.toolbar.ToolConstants;
import com.foxit.uiextensions.controls.toolbar.ToolItemsManager;
import com.foxit.uiextensions.controls.toolbar.ToolProperty;
import com.foxit.uiextensions.controls.toolbar.UIToolView;
import com.foxit.uiextensions.theme.ThemeUtil;
import com.foxit.uiextensions.utils.AppResource;
import com.foxit.uiextensions.utils.AppSharedPreferences;
import com.foxit.uiextensions.utils.AppUtil;

import androidx.annotation.DrawableRes;

public abstract class ToolSupplyImpl implements IToolSupply {

    private Context mContext;

    public ToolSupplyImpl(Context context) {
        mContext = context;
    }

    @Override
    public UIColorItem createToolItem(int toolType, boolean onlyImage) {
        int bgIcon = getToolBackgroundResource(toolType);

        UIColorItem colorItem = null;
        String str = AppUtil.getToolbarItemString(mContext, toolType);
        if (!AppUtil.isEmpty(str) && !onlyImage) {
            colorItem = new UIColorItem(mContext);
            colorItem.setImageResource(bgIcon);
            colorItem.setImageTintList(ThemeUtil.getTextDesImageColorStateList(mContext));
            colorItem.setText(str);
            colorItem.setTextColor(ThemeUtil.getTextDesTextColorStateList(mContext));
        } else {
            UIToolView toolView = new UIToolView(mContext);
            if (bgIcon != 0)
                toolView.setFillBackgroundResource(bgIcon);
            toolView.setBackgroundColorFilter(AppResource.getColor(mContext, R.color.i3));
            int scrIcon = getToolForegroundResource(toolType);
            if (scrIcon != 0)
                toolView.setFillForegroundResource(scrIcon);
            toolView.setForceDarkAllowed(false);
            colorItem = new UIColorItem(mContext, toolView);
        }
        colorItem.setTag(toolType);
        colorItem.setForceDarkAllowed(false);
        return colorItem;
    }

    @Override
    public ToolProperty createProperty(int toolType, int properType) {
        ToolProperty property;
        if (properType == ToolConstants.ADD_TOOLS_PROP) {
            String data = AppSharedPreferences.getInstance(mContext)
                    .getString(ToolItemsManager.CUSTOM_TOOLS_PREF_NAME, getToolName(toolType), null);
            if (AppUtil.isEmpty(data))
                property = createToolProperty(toolType);
            else
                property = TBUtils.str2ToolProp(data);
        } else {
            property = createToolProperty(toolType);
        }
        return property;
    }

    @Override
    public void setPropertyBar(ToolProperty property) {

    }

    @DrawableRes
    public abstract int getToolBackgroundResource(int toolType);

    @DrawableRes
    public abstract int getToolForegroundResource(int toolType);

    public abstract ToolProperty createToolProperty(int toolType);

    public abstract String getToolName(int toolType);

}
