/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.controls.toolbar.impl;

import android.content.Context;

import com.foxit.uiextensions.controls.toolbar.IToolSupply;
import com.foxit.uiextensions.controls.toolbar.TBUtils;
import com.foxit.uiextensions.controls.toolbar.ToolConstants;
import com.foxit.uiextensions.controls.toolbar.ToolItemsManager;
import com.foxit.uiextensions.controls.toolbar.ToolProperty;
import com.foxit.uiextensions.theme.ThemeUtil;
import com.foxit.uiextensions.utils.AppSharedPreferences;
import com.foxit.uiextensions.utils.AppUtil;

public abstract class ToolSupplyBtnImpl implements IToolSupply {

    private Context mContext;
    private int mBtnImageResId;
    private UIColorItem colorItem;

    public ToolSupplyBtnImpl(Context context, int ImgResId) {
        mContext = context;
        mBtnImageResId = ImgResId;
    }

    @Override
    public UIColorItem createToolItem(int toolType, boolean onlyImage) {
        if (onlyImage) {
            colorItem = new UIColorItem(mContext, mBtnImageResId);
            colorItem.setImageTintList(ThemeUtil.getPrimaryIconColor(mContext));
        } else {
            String str = AppUtil.getToolbarItemString(mContext, toolType);
            colorItem = new UIColorItem(mContext);
            colorItem.setImageResource(mBtnImageResId);
            colorItem.setImageTintList(ThemeUtil.getTextDesImageColorStateList(mContext));
            colorItem.setText(str);
            colorItem.setTextColor(ThemeUtil.getTextDesTextColorStateList(mContext));
        }
        colorItem.setTag(toolType);
        colorItem.setForceDarkAllowed(false);
        return colorItem;
    }

    public UIColorItem getColorItem() {
        return colorItem;
    }

    @Override
    public ToolProperty createProperty(int toolType, int properType) {
        ToolProperty property;
        if (properType == ToolConstants.ADD_TOOLS_PROP) {
            String data = AppSharedPreferences.getInstance(mContext)
                    .getString(ToolItemsManager.CUSTOM_TOOLS_PREF_NAME, getToolName(toolType), null);
            if (AppUtil.isEmpty(data))
                property = createToolProperty(toolType);
            else
                property = TBUtils.str2ToolProp(data);
        } else {
            property = createToolProperty(toolType);
        }
        return property;
    }

    @Override
    public void setPropertyBar(ToolProperty property) {

    }

    public abstract ToolProperty createToolProperty(int toolType);

    public abstract String getToolName(int toolType);

}
