/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.controls.toolbar.impl;


import com.foxit.uiextensions.controls.toolbar.ITabActionToolbar;
import com.foxit.uiextensions.controls.toolbar.drag.UIDragToolBar;
import com.foxit.uiextensions.pdfreader.impl.MainFrame;
import com.foxit.uiextensions.theme.DynamicColorProvider;

class TabActionToolbarImpl implements ITabActionToolbar {

    private final MainFrame mMainFrame;

    public TabActionToolbarImpl(MainFrame mainFrame) {
        mMainFrame = mainFrame;
    }

    @Override
    public void setHorizontalHeight(int height) {
        mMainFrame.setDragToolbarHorizontalHeight(height);
    }

    @Override
    public void setVerticalWidth(int width) {
        mMainFrame.setDragToolbarVerticalWidth(width);
    }

    @Override
    public void setBackgroundColor(int color) {
        this.setBackgroundColor(color, color);
    }

    @Override
    public void setBackgroundColor(int lightColor, int darkColor) {
        UIDragToolBar tabToolbar = mMainFrame.getDragToolBar();
        if (tabToolbar != null) {
            tabToolbar.setBackgroundColorProvider(new DynamicColorProvider() {
                @Override
                public int getColor(boolean isDarkMode) {
                    return isDarkMode ? darkColor : lightColor;
                }
            });
        }
    }

}
