/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.controls.toolbar.impl;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;

import com.foxit.uiextensions.R;
import com.foxit.uiextensions.utils.AppResource;

public class BottomBarImpl extends BaseBarImpl {
    private LinearLayout mBottomBarRealRootLayout = null;
    protected int mSolidLineHeight = 1;
    private View solidLine;

    public BottomBarImpl(Context context) {
        super(context, HORIZONTAL);
        initDimens();
    }

    @Override
    public View getContentView() {
        if (mOrientation == HORIZONTAL && mBottomBarRealRootLayout == null) {
            mBottomBarRealRootLayout = new LinearLayout(mRootLayout.getContext());
            mBottomBarRealRootLayout.setOrientation(LinearLayout.VERTICAL);

            solidLine = new View(mRootLayout.getContext());
            solidLine.setBackgroundColor(mRootLayout.getContext().getResources().getColor(R.color.p1));
            mBottomBarRealRootLayout.addView(solidLine);
            solidLine.getLayoutParams().width = ViewGroup.LayoutParams.MATCH_PARENT;
            solidLine.getLayoutParams().height = dip2px_fromDimens(mSolidLineHeight);

            mBottomBarRealRootLayout.addView(mRootLayout);
        }

        if (mOrientation == HORIZONTAL && mBottomBarRealRootLayout != null) {
            return mBottomBarRealRootLayout;
        } else {
            return mRootLayout;
        }
    }

    public void setShowSolidLineColor(int color) {
        if(solidLine!=null) {
            solidLine.setBackgroundColor(color);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        int visibility = 0;
        if (visible) {
            visibility = View.VISIBLE;
        } else {
            visibility = View.INVISIBLE;
        }
        if (mOrientation == HORIZONTAL && mBottomBarRealRootLayout != null)
            mBottomBarRealRootLayout.setVisibility(visibility);
        else
            mRootLayout.setVisibility(visibility);
    }

    private void initDimens() {
        try {
            mSolidLineHeight = AppResource.getDimensionPixelSize(mContext, R.dimen.ux_list_divider_height);
        } catch (Exception e) {
            mSolidLineHeight = dip2px(mSolidLineHeight);
        }
    }

}
