/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.controls.toolbar.drag.addtools;


import android.content.Context;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;

import com.foxit.uiextensions.R;
import com.foxit.uiextensions.annots.common.UIFillView;
import com.foxit.uiextensions.browser.adapter.SuperAdapter;
import com.foxit.uiextensions.browser.adapter.viewholder.SuperViewHolder;
import com.foxit.uiextensions.controls.toolbar.ToolItemBean;
import com.foxit.uiextensions.controls.toolbar.UIToolView;
import com.foxit.uiextensions.controls.toolbar.impl.UIColorItem;
import com.foxit.uiextensions.modules.panel.bean.BaseBean;
import com.foxit.uiextensions.theme.ThemeUtil;
import com.foxit.uiextensions.utils.AppResource;
import com.foxit.uiextensions.utils.AppUtil;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import androidx.annotation.NonNull;

public class AddedToolsAdapter extends SuperAdapter<ToolItemBean> implements AddedToolsTouchHelper.ItemTouchCallback {

    private List<ToolItemBean> mAddedTools;
    private Context mContext;

    public AddedToolsAdapter(Context context) {
        super(context);
        mAddedTools = new ArrayList<>();
        mContext = context;
    }

    void setTools(List<ToolItemBean> itemBeans) {
        mAddedTools = itemBeans;
    }

    List<ToolItemBean> getTools() {
        return mAddedTools;
    }

    @Override
    public void notifyUpdateData() {
        notifyDataSetChanged();
    }

    @Override
    public ToolItemBean getDataItem(int position) {
        return mAddedTools.get(position);
    }

    @NonNull
    @Override
    public SuperViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new AddedToolsViewHolder(LayoutInflater.from(getContext())
                .inflate(R.layout.added_toos_item_layout, parent, false));
    }

    @Override
    public int getItemCount() {
        return mAddedTools.size();
    }

    @Override
    public void onMove(int fromPosition, int toPosition) {
        if (fromPosition < toPosition) {
            for (int i = fromPosition; i < toPosition; i++) {
                swap(i, i + 1);
            }
        } else {
            for (int i = fromPosition; i > toPosition; i--) {
                swap(i, i - 1);
            }
        }
        notifyItemMoved(fromPosition, toPosition);
        if (mOnItemClickListener != null) {
            mOnItemClickListener.onMove();
        }
    }


    private void swap(int dst, int src) {
        Collections.swap(mAddedTools, dst, src);
    }

    class AddedToolsViewHolder extends SuperViewHolder {
        private View mContentView;
        private ImageView mIvDelete;
        private UIFillView mToolsIcon;

        public AddedToolsViewHolder(View itemView) {
            super(itemView);
            mContentView = itemView.findViewById(R.id.rela_added_tools);
            mToolsIcon = itemView.findViewById(R.id.added_tool_icon_view);
            mIvDelete = itemView.findViewById(R.id.added_tool_iv_delete);
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q) {
                mIvDelete.setForceDarkAllowed(false);
            }
            mContentView.setOnClickListener(this);
        }

        @Override
        public void bind(BaseBean data, int position) {
            ToolItemBean itemBean = (ToolItemBean) data;

            if (((UIColorItem) itemBean.toolItem).getCustomView() != null) {
                UIToolView toolView = (UIToolView) ((UIColorItem) itemBean.toolItem).getCustomView();
                mToolsIcon.setBorderResource(toolView.getFillBackgroundResource());
                mToolsIcon.setFillResource(toolView.getFillForegroundResource());
            } else {
                mToolsIcon.setFillResource(((UIColorItem) itemBean.toolItem).getImageResId());
            }
            if (itemBean.property != null)
                mToolsIcon.setFillColorFilter(itemBean.property.color);
            else
                mToolsIcon.setFillColorFilter(AppResource.getColor(getContext(), R.color.ux_color_translucent));

            if (AppUtil.isDarkMode(mContext)) {
                mIvDelete.setImageResource(R.drawable.dark_add_toos_remove_added);
            } else {
                mIvDelete.setImageResource(R.drawable.add_toos_remove_added);
            }
        }

        @Override
        public void onClick(View v) {
            if (v.getId() == R.id.rela_added_tools) {
                int position = getAdapterPosition();
                if (position == -1) return;
                mAddedTools.remove(position);
                notifyItemRemoved(position);

                if (mOnItemClickListener != null) {
                    mOnItemClickListener.onItemClick(position, v);
                }
            }
        }
    }

    private OnItemClickListener mOnItemClickListener;

    void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        mOnItemClickListener = onItemClickListener;
    }

    interface OnItemClickListener {
        void onItemClick(int position, View view);
        void onMove();
    }


}
