/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.controls.toolbar.drag.addtools;


import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;

import com.foxit.uiextensions.R;
import com.foxit.uiextensions.annots.common.UIFillView;
import com.foxit.uiextensions.annots.stamp.StampUtil;
import com.foxit.uiextensions.browser.adapter.SuperAdapter;
import com.foxit.uiextensions.browser.adapter.viewholder.SuperViewHolder;
import com.foxit.uiextensions.controls.toolbar.ToolConstants;
import com.foxit.uiextensions.controls.toolbar.ToolItemBean;
import com.foxit.uiextensions.controls.toolbar.ToolProperty;
import com.foxit.uiextensions.controls.toolbar.UIToolView;
import com.foxit.uiextensions.controls.toolbar.impl.UIColorItem;
import com.foxit.uiextensions.modules.panel.bean.BaseBean;
import com.foxit.uiextensions.utils.AppResource;

import java.util.ArrayList;
import java.util.List;

class AddToolsAdapter extends SuperAdapter<ToolItemBean> {
    static final int OPER_ADD_TOOL = 0;
    static final int OPER_SHOW_PROPERTY = 1;
    private List<Integer> mIdList = new ArrayList<>();

    private List<ToolItemBean> mTools;
    private OnItemClickListener mItemClickListener;
    private Context mContext;
    public AddToolsAdapter(Context context) {
        super(context);
        mContext=context;
        mTools = new ArrayList<>();
    }

    void setTools(List<ToolItemBean> tools) {
        mTools = tools;
    }
    void setIdsList(List<Integer> idList ) {
        mIdList = idList;
    }

    @Override
    public void notifyUpdateData() {
        notifyDataSetChanged();
    }

    @Override
    public ToolItemBean getDataItem(int position) {
        return mTools.get(position);
    }

    @NonNull
    @Override
    public SuperViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ToolsViewHolder(LayoutInflater.from(getContext())
                .inflate(R.layout.add_tools_item_layout, parent, false));
    }

    @Override
    public int getItemCount() {
        return mTools.size();
    }

    class ToolsViewHolder extends SuperViewHolder {
        private TextView mToolNameTv;
        private ImageView mToolIconIv;
        private UIFillView mToolColorIv;
        private ImageView mAddToolIv;
        private View mDividerView;

        public ToolsViewHolder(View itemView) {
            super(itemView);
            mToolNameTv = itemView.findViewById(R.id.add_tool_name_tv);
            mToolIconIv = itemView.findViewById(R.id.add_tool_icon_iv);
            mToolColorIv = itemView.findViewById(R.id.add_tool_color_iv);
            mDividerView = itemView.findViewById(R.id.add_tool_divider);
            mAddToolIv = itemView.findViewById(R.id.add_tool_iv);
            mToolIconIv.setColorFilter(mContext.getResources().getColor(R.color.i3));
            mAddToolIv.setColorFilter(mContext.getResources().getColor(R.color.i3));

            mToolColorIv.setOnClickListener(this);
            mAddToolIv.setOnClickListener(this);
        }

        @Override
        public void bind(BaseBean data, int position) {
            ToolItemBean itemBean = (ToolItemBean) data;
            ToolProperty property = itemBean.property;
            UIToolView toolView = (UIToolView) ((UIColorItem) itemBean.toolItem).getCustomView();
            if (property != null) {
                mDividerView.setVisibility(View.VISIBLE);
                mToolColorIv.setVisibility(View.VISIBLE);
                mToolColorIv.setForceDarkAllowed(false);

                if (property.type == ToolConstants.Stamp) {
                    mToolColorIv.setFillDrawale(null);
                    mToolColorIv.setBorderWidth(0);
                    mToolColorIv.setBorderResource(StampUtil.getStampIconThumbnail(property.style));
                    mToolColorIv.setFillColorFilter(R.color.ux_color_translucent);
                } else {
                    mToolColorIv.setFillResource(R.drawable.annot_prop_circle_border_bg);
                    mToolColorIv.setBorderResource(R.drawable.annot_prop_circle_border_bg);
                    mToolColorIv.setBorderWidth(AppResource.getDimensionPixelSize(getContext(), R.dimen.ux_item_border_unselected_width));
                    if (toolView != null)
                        mToolColorIv.setFillColorFilter(toolView.getFillColor());
                }
            } else {
                mDividerView.setVisibility(View.GONE);
                mToolColorIv.setVisibility(View.GONE);
            }
            if (toolView != null)
                mToolIconIv.setImageResource(toolView.getFillBackgroundResource());
            else
                mToolIconIv.setImageDrawable((itemBean.toolItem).getImageDrawable());
            mToolNameTv.setText(itemBean.name);
            mAddToolIv.setId(itemBean.type);
            if(mIdList.size()>0){
                mAddToolIv.setId(mIdList.get(position));
            }
            mAddToolIv.setTag("add_tool");
        }

        @Override
        public void onClick(View v) {
            int id = v.getId();
            int position = getAdapterPosition();
            ToolItemBean itemBean = mTools.get(position);

            if ("add_tool".equals(v.getTag())) {
                if (mItemClickListener != null)
                    mItemClickListener.onItemClick(OPER_ADD_TOOL, position, v, itemBean);
            }
            if (id == R.id.add_tool_color_iv) {
                if (mItemClickListener != null)
                    mItemClickListener.onItemClick(OPER_SHOW_PROPERTY, position, v, itemBean);
            }
        }
    }

    void setOnItemClickListener(OnItemClickListener itemClickListener) {
        mItemClickListener = itemClickListener;
    }

    interface OnItemClickListener {
        void onItemClick(int type, int postion, View view, ToolItemBean itemBean);
    }

}
