/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.controls.toolbar.drag;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;

import com.foxit.uiextensions.Module;
import com.foxit.uiextensions.UIExtensionsManager;
import com.foxit.uiextensions.controls.toolbar.BaseBar;
import com.foxit.uiextensions.controls.toolbar.IBaseItem;
import com.foxit.uiextensions.controls.toolbar.ToolConstants;
import com.foxit.uiextensions.controls.toolbar.ToolItemBean;
import com.foxit.uiextensions.controls.toolbar.ToolbarItemConfig;
import com.foxit.uiextensions.controls.toolbar.tabmenu.SortToolsDialog;
import com.foxit.uiextensions.security.standard.PasswordModule;

import java.util.List;

public class ProtectToolBar extends UIHSToolBar {
    private SortToolsDialog mDialog;
    public static ProtectToolBar newInstance(Context context, UIExtensionsManager uiExtensionsManager, UIDragToolBar uiToolbar) {
        ProtectToolBar toolbar;
        if (uiToolbar.getToolBarPosition() == UIDragToolBar.TOOLBAR_POS_TOP
                /*|| uiToolbar.getToolBarPosition() == UIDragToolBar.TOOLBAR_POS_BOTTOM*/)
            toolbar = new ProtectToolBar(context, BaseBar.HORIZONTAL, uiExtensionsManager, uiToolbar);
        else
            toolbar = new ProtectToolBar(context, BaseBar.VERTICAL, uiExtensionsManager, uiToolbar);
        return toolbar;
    }

    public ProtectToolBar(Context context, UIExtensionsManager uiExtensionsManager, UIDragToolBar uiToolbar) {
        this(context, UIToolBaseBar.HORIZONTAL, uiExtensionsManager, uiToolbar);
    }

    public ProtectToolBar(Context context, int orientation,UIExtensionsManager uiExtensionsManager, UIDragToolBar uiToolbar) {
        super(context, orientation, uiExtensionsManager, uiToolbar);
    }


    @Override
    public void addOptionItems(List<ToolItemBean> toolList) {
        super.addOptionItems(toolList);
        setDividerItemVisible(false);
        setUndoItemVisiable(false);
        setRedoItemVisiable(false);
        initSortItemView(toolList);
    }
    private void initSortItemView(final List<ToolItemBean> toolList) {
        setSortItemPosition(TB_Position.Position_RB);
        mSortItem.setOnItemClickListener(new IBaseItem.OnItemClickListener() {
            @Override
            public void onClick(IBaseItem item, View v) {
                if(mDialog ==null) {
                    mDialog = new SortToolsDialog(mUIExtensionsManager.getAttachedActivity(), mUIExtensionsManager, ToolbarItemConfig.ITEM_PROTECT_TAB);
                }
                mDialog.setData(toolList);
                mDialog.showDialog();
            }
        });
    }

    @Override
    public void setEnabled(boolean enabled) {
        mEnabled = enabled;
        for (int i = 0; i < mToolsList.size(); i++) {
            ToolItemBean toolItemBean = mToolsList.get(i);
            if (toolItemBean.itemStyle == ToolItemBean.DEFAULT_STYLE) {
                IBaseItem item = toolItemBean.toolItem;
                if (item == null) continue;

                int type = item.getTag();
                if (type == ToolConstants.ProtectTypeStandard
                        || type == ToolConstants.ProtectTypeStandRemove) {
                    String filePath = mUIExtensionsManager.getPDFViewCtrl().getFilePath();
                    boolean isPPDF = false;
                    if (!TextUtils.isEmpty(filePath)) {
                        isPPDF = filePath.endsWith(".ppdf");
                    }
                    boolean isAvailable = false;
                    PasswordModule passwordModule = (PasswordModule) mUIExtensionsManager.getModuleByName(Module.MODULE_NAME_PASSWORD);
                    if (passwordModule != null){
                        isAvailable = passwordModule.getSecurityHandler().isAvailable();
                    }
                    item.setEnable(isAvailable && !isPPDF);
                } else if (type == ToolConstants.ProtectTypeRedaction) {
                    item.setEnable(mUIExtensionsManager.getDocumentManager().canAddAnnot()
                            && mUIExtensionsManager.isEnableModification());
                } else if (type == ToolConstants.ProtectTypeTrustCert) {
                    item.setEnable(true);
                } else {
                    item.setEnable(enabled);
                }
            }
        }
    }

    @Override
    public int getUsageType() {
        return USAGE_TYPE_PROTECT;
    }
}
