/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.controls.toolbar.drag;


import android.content.Context;
import android.view.View;

import com.foxit.uiextensions.UIExtensionsManager;
import com.foxit.uiextensions.controls.toolbar.BaseBar;
import com.foxit.uiextensions.controls.toolbar.IBaseItem;
import com.foxit.uiextensions.controls.toolbar.ToolConstants;
import com.foxit.uiextensions.controls.toolbar.ToolItemBean;
import com.foxit.uiextensions.controls.toolbar.ToolbarItemConfig;
import com.foxit.uiextensions.controls.toolbar.tabmenu.SortToolsDialog;
import com.foxit.uiextensions.utils.AppDisplay;

import java.util.List;

public class FillSignToolBar extends UIHSToolBar {
    private SortToolsDialog mDialog;
    public static FillSignToolBar newInstance(Context context, UIExtensionsManager uiExtensionsManager, UIDragToolBar uiToolbar) {
        FillSignToolBar homeToolbar;
        if (uiToolbar.getToolBarPosition() == UIDragToolBar.TOOLBAR_POS_TOP
                /*|| uiToolbar.getToolBarPosition() == UIDragToolBar.TOOLBAR_POS_BOTTOM*/)
            homeToolbar = new FillSignToolBar(context, BaseBar.HORIZONTAL, uiExtensionsManager, uiToolbar);
        else
            homeToolbar = new FillSignToolBar(context, BaseBar.VERTICAL, uiExtensionsManager, uiToolbar);
        return homeToolbar;
    }

    public FillSignToolBar(Context context, UIExtensionsManager uiExtensionsManager, UIDragToolBar uiToolbar) {
        super(context, uiExtensionsManager, uiToolbar);
    }

    public FillSignToolBar(Context context, int orientation, UIExtensionsManager uiExtensionsManager, UIDragToolBar uiToolbar) {
        super(context, orientation, false, uiExtensionsManager, uiToolbar);
    }

    @Override
    public void addOptionItems(List<ToolItemBean> toolList) {
        super.addOptionItems(toolList);
        setDividerItemVisible(true);
        setUndoItemVisiable(true);
        if (AppDisplay.isPad()) {
            setRedoItemVisiable(true);
        }
        initSortItemView(toolList);
    }
    private void initSortItemView(final List<ToolItemBean> toolList) {
        setSortItemPosition(TB_Position.Position_RB);
        mSortItem.setOnItemClickListener(new IBaseItem.OnItemClickListener() {
            @Override
            public void onClick(IBaseItem item, View v) {
                if(mDialog ==null) {
                    mDialog = new SortToolsDialog(mUIExtensionsManager.getAttachedActivity(), mUIExtensionsManager, ToolbarItemConfig.ITEM_FILLSIGN_TAB);
                }
                mDialog.setData(toolList);
                mDialog.showDialog();
            }
        });

    }

    @Override
    public int getUsageType() {
        return USAGE_TYPE_SIGN;
    }

    @Override
    public void setEnabled(boolean enabled) {
        mEnabled = enabled;
        for (int i = 0; i < mToolsList.size(); i++) {
            ToolItemBean toolItemBean = mToolsList.get(i);
            if (toolItemBean.itemStyle == ToolItemBean.DEFAULT_STYLE) {
                IBaseItem toolItem = toolItemBean.toolItem;
                if (toolItem != null) {
                    if (toolItem.getTag() == ToolConstants.DigitalSignature) {
                        toolItem.setEnable(mUiExtensionsManager.getDocumentManager().canAddSignature()
                                && mUIExtensionsManager.isEnableModification()
                                && mUiExtensionsManager.getDocumentManager().withAllPermission(null));
                    } else {
                        toolItem.setEnable(enabled);
                    }
                }
            }
        }
    }

}
