/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.controls.toolbar;


import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.Gravity;
import android.widget.FrameLayout;
import android.widget.ImageView;

import com.foxit.uiextensions.R;
import com.foxit.uiextensions.annots.common.UIFillView;
import com.foxit.uiextensions.utils.AppDisplay;
import com.foxit.uiextensions.utils.AppResource;

import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;

public class UIToolView extends FrameLayout {

    private int mSrcIcon;
    private int mFillColor;

    private UIFillView mFillView;
    private ImageView mSelectedBgView;

    public UIToolView(Context context) {
        this(context, null);
    }

    public UIToolView(Context context, AttributeSet attrs) {
        super(context, attrs);
        initUIToolView(context);
    }

    private void initUIToolView(Context context){
        mSelectedBgView = new ImageView(context);
        FrameLayout.LayoutParams selectedParams = new FrameLayout.LayoutParams(
               AppDisplay.dp2px(30),
                AppDisplay.dp2px(30));
        selectedParams.gravity = Gravity.CENTER;
        addView(mSelectedBgView, selectedParams);
        mSelectedBgView.setBackgroundResource(R.drawable.tool_view_select_bg);

        mFillView = new UIFillView(context);
        FrameLayout.LayoutParams fillParams = new FrameLayout.LayoutParams(
                LayoutParams.WRAP_CONTENT,
                LayoutParams.WRAP_CONTENT);
        fillParams.gravity = Gravity.CENTER;
        addView(mFillView, fillParams);
    }

    public void setFillBackgroundResource(@DrawableRes int resId) {
        if (mFillView != null) {
            mFillView.setBorderResource(resId);
        }
    }

    public int getFillBackgroundResource() {
        if (mFillView != null)
            return mFillView.getBorderResource();
        return -1;
    }

    public void setBackgroundColorFilter(int color) {
        if (mFillView != null)
            mFillView.setBorderColor(color);
    }

    @Override
    public void setForceDarkAllowed(boolean allow) {
        if (Build.VERSION.SDK_INT >= 29) {// 29 == Build.VERSION_CODES.Q
            super.setForceDarkAllowed(allow);
            if (mFillView != null)
                mFillView.setForceDarkAllowed(allow);
        }
    }

    public void setFillForegroundResource(@DrawableRes int resId) {
        mSrcIcon = resId;
        if (mFillView != null) {
            mFillView.setFillResource(resId);
        }
    }

    public int getFillForegroundResource() {
        return mSrcIcon;
    }

    public void setFillColor(@ColorInt int color) {
        mFillColor = color;
        if (mFillView != null) {
            mFillView.setFillColorFilter(color);
        }
    }

    public int getFillColor() {
        return mFillColor;
    }

    @Override
    public void setSelected(boolean selected) {
        super.setSelected(selected);
        mSelectedBgView.setSelected(selected);
        mFillView.setSelected(selected);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        mFillView.setEnabled(enabled);
    }

    public void updateTheme() {
        setBackgroundColorFilter(AppResource.getColor(getContext(), R.color.i3));
        mSelectedBgView.setBackground(AppResource.getDrawable(getContext(), R.drawable.tool_view_select_bg));
    }

    public void setSelectBgColor(int resId){
        mSelectedBgView.setBackground(AppResource.getDrawable(getContext(), resId));
    }

}
