/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.controls.toolbar;


import com.foxit.uiextensions.R;
import com.foxit.uiextensions.config.JsonConstants;
import com.foxit.uiextensions.controls.toolbar.drag.UIToolBaseBar;
import com.foxit.uiextensions.utils.AppResource;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class ToolItemsManager {
    public static final String CUSTOM_TOOLS_PREF_NAME = "custom_tools_pref";

    private final ConcurrentHashMap<Integer, List<Integer>> mToolItems;
    private final ConcurrentHashMap<Integer, IToolSupply> mToolSupplys;

    public ToolItemsManager() {
        mToolSupplys = new ConcurrentHashMap<>();
        mToolItems = new ConcurrentHashMap<>();
    }

    public void addToolItem(@UIToolBaseBar.UsageType int position, @ToolConstants.ToolType int type, IToolSupply toolSupply) {
        List<Integer> items = mToolItems.get(position);
        if (items == null) {
            items = new ArrayList<>();
            mToolItems.put(position, items);
        }
        if (!items.contains(type))
            items.add(type);
        mToolSupplys.put(type, toolSupply);
    }

    public void addToolItem(@UIToolBaseBar.UsageType int position, @ToolConstants.ToolType int type) {
        List<Integer> items = mToolItems.get(position);
        if (items == null) {
            items = new ArrayList<>();
            mToolItems.put(position, items);
        }
        if (!items.contains(type))
            items.add(type);
    }

    public void addMultipleToolItem(@UIToolBaseBar.UsageType int position, @ToolConstants.ToolType int type) {
        List<Integer> items = mToolItems.get(position);
        if (items == null) {
            items = new ArrayList<>();
            mToolItems.put(position, items);
        }
        items.add(type);
    }

    public void addToolItems(@UIToolBaseBar.UsageType int position, @ToolConstants.ToolType List<Integer> types) {
        for (int type : types) {
            addToolItem(position, type);
        }
    }

    // TODO-ZFY: RELOAD TOOLBAR
    public void removeToolItem(@UIToolBaseBar.UsageType int position, @ToolConstants.ToolType int type, IToolSupply toolSupply) {
        List<Integer> items = mToolItems.get(position);
        if (items == null) {
            return;
        }
        if (items.contains(type))
            items.remove((Integer) type);
        if (mToolSupplys.get(type) != null)
            mToolSupplys.remove(type);
    }

    public void removeToolItem(@UIToolBaseBar.UsageType int position, @ToolConstants.ToolType int type) {
        List<Integer> items = mToolItems.get(position);
        if (items == null) {
            return;
        }
        if (items.contains(type))
            items.remove((Integer) type);
    }


    public void replaceToolItems(@UIToolBaseBar.UsageType int position, @ToolConstants.ToolType List<Integer> types) {
        List<Integer> items = mToolItems.get(position);
        if (items == null) {
            items = new ArrayList<>();
            mToolItems.put(position, items);
        } else {
            items.clear();
        }
        items.addAll(types);
    }

    @ToolConstants.ToolType
    public List<Integer> getToolItems(@UIToolBaseBar.UsageType int position) {
        return mToolItems.get(position);
    }

    public IToolSupply getToolSupply(@ToolConstants.ToolType int type) {
        return mToolSupplys.get(type);
    }

    public void clear() {
        mToolItems.clear();
        mToolSupplys.clear();
    }

    public int getToolIcon(@ToolConstants.ToolType int type) {
        int iconId = 0;
        if (ToolConstants.Text == type) {
            iconId = R.drawable.comment_tool_typewriter_bg;
        } else if (ToolConstants.Image == type) {
            iconId = R.drawable.edit_tool_image;
        } else if (ToolConstants.Audio == type) {
            iconId = R.drawable.edit_tool_audio;
        } else if (ToolConstants.Video == type) {
            iconId = R.drawable.edit_tool_video;
        } else if (ToolConstants.Link == type) {
            iconId = R.drawable.edit_tool_link;
        } else if (ToolConstants.Note == type) {
            iconId = R.drawable.comment_tool_note_bg;
        } else if (ToolConstants.Attachments == type) {
            iconId = R.drawable.comment_tool_attachment_bg;
        } else if (ToolConstants.Stamp == type) {
            iconId = R.drawable.comment_tool_stamp_bg;
        } else if (ToolConstants.Typewriter == type) {
            iconId = R.drawable.comment_tool_typewriter_bg;
        } else if (ToolConstants.Textbox == type) {
            iconId = R.drawable.comment_tool_textbox_bg;
        } else if (ToolConstants.Callout == type) {
            iconId = R.drawable.comment_tool_callout_bg;
        } else if (ToolConstants.Highlight == type) {
            iconId = R.drawable.comment_tool_highlight_bg;
        } else if (ToolConstants.Underline == type) {
            iconId = R.drawable.comment_tool_underline_bg;
        } else if (ToolConstants.Squiggly == type) {
            iconId = R.drawable.comment_tool_squiggly_bg;
        } else if (ToolConstants.Strikeout == type) {
            iconId = R.drawable.comment_tool_strikeout_bg;
        } else if (ToolConstants.Replace_Text == type) {
            iconId = R.drawable.comment_tool_replace_text_bg;
        } else if (ToolConstants.Insert_Text == type) {
            iconId = R.drawable.comment_tool_insert_text_bg;
        } else if (ToolConstants.Area_Highlight == type) {
            iconId = R.drawable.comment_tool_area_highlight_bg;
        } else if (ToolConstants.Measure == type) {
            iconId = R.drawable.comment_tool_line_measure_bg;
        } else if (ToolConstants.Image_Annotation == type) {
            iconId = R.drawable.comment_tool_image_bg;
        } else if (ToolConstants.Pencil == type) {
            iconId = R.drawable.drawing_tool_pencil_bg;
        } else if (ToolConstants.Highlighter == type) {
            iconId = R.drawable.drawing_tool_highlighter_bg;
        } else if (ToolConstants.Eraser == type) {
            iconId = R.drawable.drawing_tool_eraser;
        } else if (ToolConstants.Rectangle == type) {
            iconId = R.drawable.drawing_tool_square;
        } else if (ToolConstants.Oval == type) {
            iconId = R.drawable.drawing_tool_oval;
        } else if (ToolConstants.Line == type) {
            iconId = R.drawable.drawing_tool_line;
        } else if (ToolConstants.Arrow == type) {
            iconId = R.drawable.drawing_tool_line_arrow;
        } else if (ToolConstants.Polygon == type) {
            iconId = R.drawable.drawing_tool_polygon;
        } else if (ToolConstants.PolyLine == type) {
            iconId = R.drawable.drawing_tool_polygonline;
        } else if (ToolConstants.Cloud == type) {
            iconId = R.drawable.drawing_tool_polygon_cloud;
        } else if (ToolConstants.TextField == type) {
            iconId = R.drawable.form_tool_textfield;
        } else if (ToolConstants.CheckBox == type) {
            iconId = R.drawable.form_tool_checkbox;
        } else if (ToolConstants.RadioButton == type) {
            iconId = R.drawable.form_tool_radiobutton;
        } else if (ToolConstants.ComboBox == type) {
            iconId = R.drawable.form_tool_combobox;
        } else if (ToolConstants.ListBox == type) {
            iconId = R.drawable.form_tool_listbox;
        } else if (ToolConstants.SignatureField == type) {
            iconId = R.drawable.form_tool_sign;
        } else if (ToolConstants.ImageField == type) {
            iconId = R.drawable.form_tool_image;
        } else if (ToolConstants.FillSignTypeText == type) {
            iconId = R.drawable.fillsign_tool_text;
        } else if (ToolConstants.FillSignTypeComboText == type) {
            iconId = R.drawable.fillsign_tool_combotext;
        } else if (ToolConstants.FillSignTypeProFile == type) {
            iconId = R.drawable.fillsign_tool_profile;
        } else if (ToolConstants.FillSignTypeCheckMark == type) {
            iconId = R.drawable.fillsign_tool_checkmark;
        } else if (ToolConstants.FillSignTypeCrossMark == type) {
            iconId = R.drawable.fillsign_tool_crossmark;
        } else if (ToolConstants.FillSignTypeDot == type) {
            iconId = R.drawable.fillsign_tool_dot;
        } else if (ToolConstants.FillSignTypeLine == type) {
            iconId = R.drawable.fillsign_tool_line;
        } else if (ToolConstants.FillSignTypeRectangle == type) {
            iconId = R.drawable.fillsign_tool_rect;
        } else if (ToolConstants.DigitalSignature == type) {
            iconId = R.drawable.fillsign_tool_sign;
        } else if (ToolConstants.ProtectTypeRedaction == type) {
            iconId = R.drawable.more_menu_redaction;
        } else if (ToolConstants.ProtectTypeStandard == type) {
            iconId = R.drawable.more_menu_file_encryption;
        } else if (ToolConstants.ProtectTypeTrustCert == type) {
            iconId = R.drawable.more_menu_certificate_protect;
        } else if (ToolConstants.ProtectTypeStandRemove == type) {
            iconId = R.drawable.more_menu_remove_password;
        } else if (ToolConstants.ProtectTypeCert == type) {
            iconId = R.drawable.more_menu_cert_protect;
        } else if (ToolConstants.ProtectTypeCertRemove == type) {
            iconId = R.drawable.more_menu_remove_password;
        } else if (ToolConstants.ProtectTypeRMS == type) {
            iconId = R.drawable.more_menu_rms_protect;
        } else if (ToolConstants.ProtectTypeAIP == type) {
            iconId = R.drawable.more_menu_aip_protect;
        }
        return iconId;
    }

    public String getToolName(@ToolConstants.ToolType int type) {
        String name = "";
        if (ToolConstants.Text == type) {
            name = JsonConstants.TYPE_TEXT;
        } else if (ToolConstants.Image == type) {
            name = JsonConstants.TYPE_IMAGE_OBJECT;
        } else if (ToolConstants.Audio == type) {
            name = JsonConstants.TYPE_AUDIO;
        } else if (ToolConstants.Video == type) {
            name = JsonConstants.TYPE_VIDEO;
        } else if (ToolConstants.Link == type) {
            name = JsonConstants.TYPE_LINK;
        } else if (ToolConstants.Note == type) {
            name = JsonConstants.TYPE_NOTE;
        } else if (ToolConstants.Attachments == type) {
            name = JsonConstants.TYPE_ATTACHMENT;
        } else if (ToolConstants.Stamp == type) {
            name = JsonConstants.TYPE_STAMP;
        } else if (ToolConstants.Typewriter == type) {
            name = JsonConstants.TYPE_TYPEWRITER;
        } else if (ToolConstants.Textbox == type) {
            name = JsonConstants.TYPE_TEXTBOX;
        } else if (ToolConstants.Callout == type) {
            name = JsonConstants.TYPE_CALLOUT;
        } else if (ToolConstants.Highlight == type) {
            name = JsonConstants.TYPE_HIGHLIGHT;
        }  else if (ToolConstants.Area_Highlight == type) {
            name = JsonConstants.TYPE_AREA_HIGHLIGHT;
        } else if (ToolConstants.Underline == type) {
            name = JsonConstants.TYPE_UNDERLINE;
        } else if (ToolConstants.Squiggly == type) {
            name = JsonConstants.TYPE_SQUIGGLY;
        } else if (ToolConstants.Strikeout == type) {
            name = JsonConstants.TYPE_STRIKEOUT;
        } else if (ToolConstants.Replace_Text == type) {
            name = JsonConstants.TYPE_REPLACE;
        } else if (ToolConstants.Insert_Text == type) {
            name = JsonConstants.TYPE_CARET;
        }else if (ToolConstants.Measure == type) {
            name = JsonConstants.TYPE_LINEDIMENSION;
        } else if (ToolConstants.Image_Annotation == type) {
            name = JsonConstants.TYPE_SCREEN_IMAGE;
        } else if (ToolConstants.Pencil == type) {
            name = JsonConstants.TYPE_INK;
        } else if (ToolConstants.Highlighter == type) {
            name = JsonConstants.TYPE_HIGHLIGHTER;
        } else if (ToolConstants.Eraser == type) {
            name = JsonConstants.TYPE_ERASER;
        } else if (ToolConstants.Rectangle == type) {
            name = JsonConstants.TYPE_SQUARE;
        } else if (ToolConstants.Oval == type) {
            name = JsonConstants.TYPE_CIRCLE;
        } else if (ToolConstants.Line == type) {
            name = JsonConstants.TYPE_LINE;
        } else if (ToolConstants.Arrow == type) {
            name = JsonConstants.TYPE_LINEARROW;
        } else if (ToolConstants.Polygon == type) {
            name = JsonConstants.TYPE_POLYGON;
        } else if (ToolConstants.PolyLine == type) {
            name = JsonConstants.TYPE_POLYLINE;
        } else if (ToolConstants.Cloud == type) {
            name = JsonConstants.TYPE_POLYGONCLOUD;
        } else if (ToolConstants.TextField == type) {
            name = JsonConstants.TYPE_TEXTFIELD;
        } else if (ToolConstants.CheckBox == type) {
            name = JsonConstants.TYPE_CHECKBOX;
        } else if (ToolConstants.RadioButton == type) {
            name = JsonConstants.TYPE_RADIOBUTTON;
        } else if (ToolConstants.ComboBox == type) {
            name = JsonConstants.TYPE_COMBOBOX;
        } else if (ToolConstants.ListBox == type) {
            name = JsonConstants.TYPE_LISTBOX;
        } else if (ToolConstants.SignatureField == type) {
            name = JsonConstants.TYPE_SIGNATURE;
        } else if (ToolConstants.ImageField == type) {
            name = JsonConstants.TYPE_IMAGE_FIELD;
        }
        return name;
    }

    public int getToolStrId(@ToolConstants.ToolType int type) {
        int resId = 0;
        if (ToolConstants.Text == type) {
            resId = R.string.edit_tool_text_type;
        } else if (ToolConstants.Image == type) {
            resId = R.string.screen_annot_image;
        } else if (ToolConstants.Audio == type) {
            resId = R.string.screen_annot_audio;
        } else if (ToolConstants.Video == type) {
            resId = R.string.screen_annot_video;
        } else if (ToolConstants.Link == type) {
            resId = R.string.edit_tool_link_type;
        } else if (ToolConstants.Note == type) {
            resId = R.string.fx_string_note;
        } else if (ToolConstants.Attachments == type) {
            resId = R.string.rv_panel_title_attachment;
        } else if (ToolConstants.Stamp == type) {
            resId = R.string.annot_tool_display_name_stamp;
        } else if (ToolConstants.Typewriter == type) {
            resId = R.string.annot_tool_display_name_typewrite;
        } else if (ToolConstants.Textbox == type) {
            resId = R.string.annot_tool_display_name_textbox;
        } else if (ToolConstants.Callout == type) {
            resId = R.string.annot_tool_display_name_callout;
        } else if (ToolConstants.Highlight == type) {
            resId = R.string.fx_string_highlight;
        } else if (ToolConstants.Underline == type) {
            resId = R.string.fx_string_underline;
        } else if (ToolConstants.Squiggly == type) {
            resId = R.string.fx_string_squiggly;
        } else if (ToolConstants.Strikeout == type) {
            resId = R.string.fx_string_strikeout;
        } else if (ToolConstants.Replace_Text == type) {
            resId = R.string.fx_string_replace_text;
        } else if (ToolConstants.Insert_Text == type) {
            resId = R.string.fx_string_insert_text;
        } else if (ToolConstants.Area_Highlight == type) {
            resId = R.string.fx_string_area_highlight;
        } else if (ToolConstants.Measure == type) {
            resId = R.string.fx_distance;
        } else if (ToolConstants.Image_Annotation == type) {
            resId = R.string.comment_tool_image_type;
        } else if (ToolConstants.Pencil == type) {
            resId = R.string.fx_string_pencil;
        } else if (ToolConstants.Highlighter == type) {
            resId = R.string.drawing_tool_highlighter_type;
        } else if (ToolConstants.Eraser == type) {
            resId = R.string.fx_string_eraser;
        } else if (ToolConstants.Rectangle == type) {
            resId = R.string.fx_string_rectangle;
        } else if (ToolConstants.Oval == type) {
            resId = R.string.fx_string_oval;
        } else if (ToolConstants.Line == type) {
            resId = R.string.fx_string_line;
        } else if (ToolConstants.Arrow == type) {
            resId = R.string.fx_string_arrow;
        } else if (ToolConstants.Polygon == type) {
            resId = R.string.fx_string_polygon;
        } else if (ToolConstants.PolyLine == type) {
            resId = R.string.fx_string_polyLine;
        } else if (ToolConstants.Cloud == type) {
            resId = R.string.drawing_tool_cloud_type;
        } else if (ToolConstants.TextField == type) {
            resId = R.string.form_tool_text_type;
        } else if (ToolConstants.CheckBox == type) {
            resId = R.string.form_tool_check_type;
        } else if (ToolConstants.RadioButton == type) {
            resId = R.string.form_tool_radio_type;
        } else if (ToolConstants.ComboBox == type) {
            resId = R.string.form_tool_combo_type;
        } else if (ToolConstants.ListBox == type) {
            resId = R.string.form_tool_list_type;
        } else if (ToolConstants.SignatureField == type) {
            resId = R.string.form_tool_signature_type;
        } else if (ToolConstants.ImageField == type) {
            resId = R.string.form_tool_image_type;
        } else if (ToolConstants.FillSignTypeText == type) {
            resId = R.string.fx_string_add_text;
        } else if (ToolConstants.FillSignTypeComboText == type) {
            resId = R.string.fill_sign_tool_comb_field_type;
        } else if (ToolConstants.FillSignTypeProFile == type) {
            resId = R.string.fillsign_profile_title;
        } else if (ToolConstants.FillSignTypeCheckMark == type) {
            resId = R.string.fill_sign_tool_add_checkmark_type;
        } else if (ToolConstants.FillSignTypeCrossMark == type) {
            resId = R.string.fill_sign_tool_addx_type;
        } else if (ToolConstants.FillSignTypeDot == type) {
            resId = R.string.fill_sign_tool_add_not_type;
        } else if (ToolConstants.FillSignTypeLine == type) {
            resId = R.string.fill_sign_tool_add_line_type;
        } else if (ToolConstants.FillSignTypeRectangle == type) {
            resId = R.string.fill_sign_tool_add_rounded_rectangle_type;
        } else if (ToolConstants.DigitalSignature == type) {
            resId = R.string.sg_signer_title;
        } else if (ToolConstants.ProtectTypeRedaction == type) {
            resId = R.string.fx_string_redaction;
        } else if (ToolConstants.ProtectTypeStandard == type) {
            resId = R.string.menu_more_file_encryption;
        } else if (ToolConstants.ProtectTypeTrustCert == type) {
            resId = R.string.menu_more_item_trust_certificate;
        } else if (ToolConstants.ProtectTypeStandRemove == type) {
            resId = R.string.menu_more_item_remove_encrytion;
        } else if (ToolConstants.ProtectTypeCert == type) {
            resId = R.string.menu_more_item_cert_protect;
        } else if (ToolConstants.ProtectTypeCertRemove == type) {
            resId = R.string.menu_more_item_remove_encrytion;
        } else if (ToolConstants.ProtectTypeRMS == type) {
            resId = R.string.menu_more_item_rms;
        } else if (ToolConstants.ProtectTypeAIP == type) {
            resId = R.string.menu_more_item_aip;
        }
        return resId;
    }
}
