/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.controls.toolbar;

/**
 * The toolbar under the tab, the toolbar content of different tabs is also different,
 * and this toolbar can be dragged on the pad.
 */
public interface ITabActionToolbar {

    /**
     * Set the height of toolbar when it is at the top or bottom of the screen (Minimum height: 48dip).
     *
     * @param height The height of toolbar when it is at the top or bottom of the screen, a fixed size in pixels.
     */
    void setHorizontalHeight(int height);

    /**
     * Set the width of toolbar when it is at the left or right of the screen (Minimum width: 48dip).
     *
     * @param width The width of toolbar when it is at the left or right of the screen, a fixed size in pixels.
     */
    void setVerticalWidth(int width);

    /**
     * Sets the background color for the tab toolbar.
     *
     * @param color   the color of the background.
     */
    void setBackgroundColor(int color);

    /**
     * Sets the background color for the tab toolbar. supporting both light and dark mode.
     * This method allows different background colors to be set depending on whether the system is in light or dark mode.
     *
     * @param lightColor the background color to be used in light mode.
     * @param darkColor the background color to be used in dark mode.
     */
    void setBackgroundColor(int lightColor, int darkColor);
}
