/**
 * Copyright (C) 2003-2025, Foxit Software Inc..
 * All Rights Reserved.
 * <p>
 * http://www.foxitsoftware.com
 * <p>
 * The following code is copyrighted and is the proprietary of Foxit Software Inc.. It is not allowed to
 * distribute any parts of Foxit PDF SDK to third party or public without permission unless an agreement
 * is signed between Foxit Software Inc. and customers to explicitly grant customers permissions.
 * Review legal.txt for additional license and legal information.
 */
package com.foxit.uiextensions.controls.propertybar.imp;


import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;

import com.foxit.uiextensions.R;
import com.foxit.uiextensions.theme.ThemeUtil;

import java.util.List;

class ShapeListAdapter extends BaseAdapter {

    private Context mContext;
    private List<ShapeItemInfo> mItemInfos;

    ShapeListAdapter(Context context, List<ShapeItemInfo> items) {
        this.mContext = context;
        this.mItemInfos = items;
    }

    List<ShapeItemInfo> getItemInfos() {
        return mItemInfos;
    }

    @Override
    public int getCount() {
        return mItemInfos.size();
    }

    @Override
    public Object getItem(int position) {
        return mItemInfos.get(position);
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder;
        if (convertView == null) {
            holder = new ViewHolder();
            convertView = LayoutInflater.from(mContext).inflate(R.layout.pb_shape_list_item, null, false);

            holder.pb_shape_icon = convertView.findViewById(R.id.pb_shape_icon);
            holder.pb_shape_name = convertView.findViewById(R.id.pb_shape_name);
            holder.pb_shape_checked = convertView.findViewById(R.id.pb_shape_checked);
            convertView.setTag(holder);
        } else {
            holder = (ViewHolder) convertView.getTag();
        }

        ShapeItemInfo itemInfo = mItemInfos.get(position);
        if (itemInfo.iconId > 0) {
            holder.pb_shape_icon.setVisibility(View.VISIBLE);
            holder.pb_shape_icon.setImageResource(itemInfo.iconId);
        } else {
            holder.pb_shape_icon.setVisibility(View.GONE);
        }
        holder.pb_shape_name.setText(itemInfo.name);
        holder.pb_shape_checked.setSelected(itemInfo.isChecked);
        holder.pb_shape_checked.setVisibility(itemInfo.isChecked ? View.VISIBLE : View.GONE);
        ThemeUtil.setTintList(holder.pb_shape_checked, ThemeUtil.getPrimaryIconColor(mContext));
        ThemeUtil.setTintList(holder.pb_shape_icon, ThemeUtil.getEnableIconColor(mContext));
        return convertView;
    }

    private static class ViewHolder {
        private ImageView pb_shape_icon;
        private TextView pb_shape_name;
        private ImageView pb_shape_checked;
    }

    static class ShapeItemInfo {
        int type;
        float value;

        int iconId;
        String name;
        boolean isChecked;
    }
}
